import numpy as np
import pandas as pd
import cv2
import matplotlib.pyplot as plt

def plot_trajectory_from_tvec_and_rvec(rvecs_path, tvecs_path):
    # semicolon separated, 3 values per line
    rvecs = pd.read_csv("/home/tom/Documents/UT/thesis/git_repos/monocular-visual-odometry/build/kuup_8_rotation.csv", delimiter=";", header=None).values
    tvecs = pd.read_csv("/home/tom/Documents/UT/thesis/git_repos/monocular-visual-odometry/build/kuup_8_translation.csv", delimiter=";", header=None).values

    trajectory = []
    current_position = np.zeros((3, 1))
    current_rotation = np.eye(3)

    # Calculate path
    for rvec, tvec in zip(rvecs, tvecs):
        rvec = np.array(rvec).reshape(3, 1)
        tvec = np.array(tvec).reshape(3, 1)

        R, _ = cv2.Rodrigues(rvec)

        current_position += current_rotation @ tvec

        current_rotation = current_rotation @ R

        trajectory.append(current_position.flatten())


    trajectory = np.array(trajectory)

    # Plot graph
    fig = plt.figure()
    ax = fig.add_subplot(111, projection='3d')
    ax.plot(trajectory[:, 2], trajectory[:, 1], trajectory[:, 0], marker='o')
    ax.view_init(elev=90, azim=0)
    ax.set_title("VO Trajectory from rvec/tvec")
    ax.set_xlabel("X")
    ax.set_ylabel("Y")
    ax.set_zlabel("Z")

    plt.show()


def plot_trajectory_from_global_pos(csv_path):
    positions = pd.read_csv(csv_path, delimiter=";", header=None).values
    #print(positions)

    # Plot trajectory
    fig = plt.figure()
    ax = fig.add_subplot(111, projection='3d')
    ax.plot(positions[:, 0], positions[:, 1], positions[:, 2], marker='o', label="Camera Path")
    ax.view_init(elev=90, azim=-90) 
    ax.set_xlabel('X')
    ax.set_ylabel('Y')
    ax.set_zlabel('Z')
    ax.set_title('VO Trajectory')
    ax.legend()
    plt.show()

if __name__ == "__main__":
    # plot_trajectory_from_tvec_and_rvec(
    #     "/home/tom/Documents/UT/thesis/git_repos/monocular-visual-odometry/build/kuup_L_translation.csv",
    #     "/home/tom/Documents/UT/thesis/git_repos/monocular-visual-odometry/build/kuup_L_rotation.csv"
    #     )
    plot_trajectory_from_global_pos("/home/tom/Documents/UT/thesis/git_repos/monocular-visual-odometry/build/kuup_8_positions.csv")