#pragma once

#include <opencv2/opencv.hpp>
#include <opencv2/core.hpp>
#include <opencv2/features2d.hpp> 

#include <variant>
#include <sstream>
#include <string>

// std::variant<FAST_CPU_config, SIFT_CPU_config, SURF_CPU_config, ORB_CPU_config, AKAZE_CPU_config, FAST_GPU_config, ORB_GPU_config> detector_config;

/////////////////////
// These are the default configurations for all of the used feature detectors
/////////////////////

// https://docs.opencv.org/4.11.0/d7/d60/classcv_1_1SIFT.html
struct SIFT_CPU_config {
    int nfeatures = 0; // 
    int nOctaveLayers = 3;
    double contrastThreshold = 0.04;
    double edgeThreshold = 10;
    double sigma = 1.6;
    //bool enable_precise_upscale = false;
};


// https://docs.opencv.org/4.11.0/d5/df7/classcv_1_1xfeatures2d_1_1SURF.html
struct SURF_CPU_config {
    double hessianThreshold = 100;
	int nOctaves = 4;
	int nOctaveLayers = 3;
	bool extended = false;
	bool upright = false;
};


// https://docs.opencv.org/4.11.0/db/d95/classcv_1_1ORB.html
struct ORB_CPU_config {
    int nfeatures = 500;
    float scaleFactor = 1.2f;
    int nlevels = 8;
    int edgeThreshold = 31;
    int firstLevel = 0;
    int WTA_K = 2;
    cv::ORB::ScoreType scoreType = cv::ORB::HARRIS_SCORE;
    int patchSize = 31;
    int fastThreshold = 20;
};


// https://docs.opencv.org/4.10.0/d8/d30/classcv_1_1AKAZE.html
struct AKAZE_CPU_config {
    cv::AKAZE::DescriptorType descriptor_type = cv::AKAZE::DESCRIPTOR_MLDB;
    int descriptor_size = 0;
    int descriptor_channels = 3;
    float threshold = 0.001f;
    int nOctaves = 4;
    int nOctaveLayers = 4;
    cv::KAZE::DiffusivityType diffusivity = cv::KAZE::DIFF_PM_G2;
    int max_points = -1;
};

// https://docs.opencv.org/4.11.0/da/d44/classcv_1_1cuda_1_1ORB.html
struct ORB_GPU_config {
    int nfeatures = 500;
    float scaleFactor = 1.2f;
    int nlevels = 8;
    int edgeThreshold = 31;
    int firstLevel = 0;
    int WTA_K = 2;
    int scoreType = cv::ORB::HARRIS_SCORE;
    int patchSize = 31;
    int fastThreshold = 20;
    bool blurForDescriptor = false;
};


using detector_config = std::variant<SIFT_CPU_config, SURF_CPU_config, ORB_CPU_config, AKAZE_CPU_config, ORB_GPU_config>;

std::string get_parameters_string(const detector_config &config);