/**
 * @file cmd.h
 * @brief Service. Processes incomind and outcoming command packets.
 *
 * RX: Parses CMD arguments and sends data to the required service (e.g. "MS" -> movement service)
 * TX: Transmits data, generated by other service (e.g. "ODOM").
 *
 * @author Leonid Tšigrinski (leonid.tsigrinski@gmail.com)
 * @copyright Copyright (c) 2023 Tartu Ülikool
 */

#ifndef CMD_H
#define CMD_H

#include <stdint.h>

#include "usbif.h"

extern uint16_t last_packet_length;
extern uint8_t last_packet[USBIF_BUFFER_SIZE];

void cmd_init(void);
void cmd_handleUsbData(uint8_t *ptr_data, uint16_t lenght);
void cmd_handleSCResponse(char *data);

#endif