#include "headers.h"

HighColorToolBar::HighColorToolBar(UINT wi, UINT he, UINT nu, UINT nor, UINT dis, UINT ho, UINT colorm)
{
	BackgroundColor.rgbtBlue=191; //replaces gray (191, 191  191)...
	BackgroundColor.rgbtGreen=191;
	BackgroundColor.rgbtRed=191;
	this->img_width=wi;
	this->img_heigth=he;
	this->num_images=nu;
	this->normal=nor;
	if (dis!=NULL)
		this->disabled=dis;
	else
		this->disabled=NULL;
	if (ho!=NULL)
		this->hot=ho;
	else
		this->hot=NULL;
	if (colorm==ILC_COLOR8 || colorm==ILC_COLOR16 || colorm==ILC_COLOR24 || colorm==ILC_COLOR32)
		this->colormask=colorm;
	else this->colormask=ILC_COLOR8;
}

bool HighColorToolBar::Create(CToolBar &bar)
{

	CToolBarCtrl &barctrl = bar.GetToolBarCtrl(); // gets parentcontrol

	if (!MakeImageList(normal, normallist)) return false; // makes imagelist for each, which is not NULL
	barctrl.SetImageList(&normallist);
	if (this->disabled!=NULL)
	{
		if (!MakeImageList(disabled, disabledlist)) return false;
		barctrl.SetDisabledImageList(&disabledlist);
	}
	if (this->hot!=NULL)
	{
		if (!MakeImageList(hot, hotlist)) return false;
		barctrl.SetHotImageList(&hotlist);
	}
	return true;
}

bool HighColorToolBar::ReplaceBackgroundColor(CBitmap &bm)
{
	BITMAP bmInfo;
	if (!bm.GetBitmap(&bmInfo))
		return false;

	const UINT numPixels(bmInfo.bmHeight*bmInfo.bmWidth);
	DIBSECTION db; //struct, which holds some information about bitmap
	bm.GetObject(sizeof(DIBSECTION), &db);
	RGBTRIPLE *pixels = reinterpret_cast<RGBTRIPLE*>(db.dsBm.bmBits);
	//const COLORREF SysColor(::GetSysColor(COLOR_BTNFACE)); //system button color
	//const RGBTRIPLE userBackColor = {GetBValue(SysColor), GetGValue(SysColor), GetRValue(SysColor)};
		//for changig to specified system color like COLOR_BTNFACE
	const RGBTRIPLE userBackColor = {192, 192, 192}; // because some colors are 191191191, then we'll change them
	for (unsigned int i=0; i<numPixels; i++)
	{
		if (pixels[i].rgbtBlue==BackgroundColor.rgbtBlue && pixels[i].rgbtGreen == BackgroundColor.rgbtGreen
			&& pixels[i].rgbtRed==BackgroundColor.rgbtRed)
			pixels[i]=userBackColor;
	}
	return true;
}

bool HighColorToolBar::MakeImageList(UINT BitMapId, CImageList &imglist)
{
	CBitmap bitm; // bitmap variable;
	//Attaches bitmap to the bitm object. Reason for using LoadImage is that it is independent of the system (whatever bits values)
	if (!bitm.Attach(::LoadImage(::AfxFindResourceHandle(MAKEINTRESOURCE(BitMapId), RT_BITMAP), MAKEINTRESOURCE(BitMapId), IMAGE_BITMAP, 0, 0, (LR_DEFAULTSIZE | LR_CREATEDIBSECTION))))
		return false;
	if (!ReplaceBackgroundColor(bitm))// replace specified color with user button color
		return false;
	if (!imglist.Create(img_width, img_heigth, colormask|ILC_MASK, num_images, 1)) // creates imagelist - and adds mask..  for black color
		return false;
	if (imglist.Add(&bitm, RGB(192, 192, 192))!=0) // attaches bitmap to the list, makes 192,192,192 black
		return false;
	return true;
}

