#define MAX_ALLOWED_READINGS 10000
#define AUTOTIMER 500
#define AUTOFILE _T("input.inf")

class App : public CWinApp
{
public:
	BOOL InitInstance();
};

//definitions for MainDialog

static tchar BASED_CODE szFilter[] = _T("All Files (*.*)|*.*||");

class ConvertDialog : public CDialog
{
private:
	CEdit filebox;
	CStatic number;
	Graph *win;
	unsigned int size;
	map<long int, vector<unsigned int> > data;
	vector<tstring> namevector;
	tstring dir;
	void DuplicateData();
	void EraseData();
	bool WriteFiles(tstring);
	Converter<unsigned int> conv;
public:
	BOOL OnInitDialog();
	ConvertDialog(unsigned int d, Graph &);
	void DoDataExchange(CDataExchange *);
	afx_msg void OnOK();
	afx_msg void OnCancel();

};

class OptionsDialog : public CDialog
{
private:
	//KEY VALUES;
	CRegKey key;
	int mode2;
	tstring filename, keyname;
	CEdit Edit, Number, Pixels;
	CButton IsConst, ConstStop, ConstHide, ConstEnlarge, UnknownEnlarge, UnknownHide;
	Converter<unsigned int> uint_convert;
public:
	map<tstring, unsigned int> subKeys;
	BOOL OnInitDialog();
	OptionsDialog(unsigned int,tstring);
	bool UpdateData();
	void DoDataExchange(CDataExchange *);	
	afx_msg void OnOK();
	afx_msg void OnCancel();
	afx_msg void ModeChange();
	afx_msg void OnKillFocusInterval();
	afx_msg void OnKillFocusMeasure();
	afx_msg void onKillFocusPixels();
	DECLARE_MESSAGE_MAP()
};

class MainDialog : public CDialog
{
protected:
	bool ReadColors(vector<RGBQUAD>&);
	void GetLocalDir();
	bool CreateToolBar();
	tstring path;							//location of the local paht
	bool is_attached;						//if graph window is attached, then true
	FileReader<unsigned int> instream;		//instream for data
	FileReader<int> autostream;	
	Converter<unsigned int> conv;
	unsigned int TimerID, TimerID2, TimerID3;			//ID of the timer
	unsigned int up, down;					//For upper and lower limits
	//VARIABLES,related to Grap representation
	long int ID;							//for Graph.. id of the inserted element
	///
	CFileDialog *filedialog;				//For OpenDialog
	OptionsDialog *od;						//For OptionsDialog. Would be hold in memory
	tstring filename;						//Filename for the graph file (if empty then not attached)
	bool is_started;			//if process is running then true (scanning)
	//For check in/out button
	CToolBar *CheckButtonBar;
	CMenu	 *MenuButton;
	CEdit Upper, Lower;
	CButton AutoScaleCheck;
	CStatic MeasureNr, XVal, YVal;

public:
	MainDialog(unsigned int d) : CDialog(d){is_started=false; CheckButtonBar=NULL; MenuButton=NULL;};	//shows that process is stopped
	MainDialog() : CDialog(){is_started=false; CheckButtonBar=NULL; MenuButton=NULL; up=0; down=0;};				//shows that process is stopped
	~MainDialog();
	Graph Window;
	LTexts LeftText;
	void DoDataExchange(CDataExchange *);
	void experiment();
	void Open();
	void Start();
	void Stop();
	void Options();
	bool AutoStartModeStart(CToolBar *, CMenu *);
	void AutoStartModeStop();
	void AutoStartModeForceStop();		//stopping mode, if file opened or due to some error
	void ExchangeGraphData();			// for syncronising graph data with optionsdialog
	void RePaint();
	void Paint() {Window.PaintGraph();};
	tstring GetFilename();
	tstring GetFileInfo();
	unsigned int GetInterval();
	afx_msg void OnTimer(UINT);
	afx_msg void OnUpdate();
	afx_msg void OnUpdateAutoScale(CCmdUI*);
	afx_msg void OnAutoScale();
	afx_msg void OnLButtonUp(UINT, CPoint);
	void OnOK();
	void OnCancel();
	BOOL OnInitDialog();
	bool IsStarted();
	

	//INDICATORS FOR UPDATING
	DECLARE_MESSAGE_MAP()
};



class FrameWnd : public CFrameWnd
{
private:
	//CToolBar ToolBar, ToolBar2;			//Toolbars
	CStatusBar StatusBar;		//Statusbar for information
	bool CreateStatusBar();
	bool CreateToolBar();
	bool isAuto;
	MainDialog *d;
	ConvertDialog *cd;						//convert dialog pointer
	Converter<int> int_convert;				//for converting integers and strings
	Converter<unsigned int> uint_convert;	//for converting uintegers and strings
public:
		CToolBar ToolBar, ToolBar2;			//Toolbars
			CMenu *menu;

	bool InitWindow();			//for registering window class.. and creating window
	afx_msg void Start();
	afx_msg void AutoStart();
			void AutoStartCommon();
	afx_msg void Stop();
	afx_msg void Open();
	afx_msg void Exit();
	afx_msg void Options();
	afx_msg void Help();
	afx_msg void Convert();
	afx_msg void OnDestroy();
	afx_msg void OnUpdateFilename(CCmdUI*);
	afx_msg void OnUpdateAutoStart(CCmdUI*);
	afx_msg void OnUpdateStart(CCmdUI*);
	afx_msg void OnUpdateOpen(CCmdUI*);
	afx_msg void OnUpdateStop(CCmdUI*);
	afx_msg void OnUpdateSettings(CCmdUI*);
	afx_msg void OnUpdateInterval(CCmdUI*);
	afx_msg void OnUpdateConvert(CCmdUI*);
	DECLARE_MESSAGE_MAP()
};