#include "headers.h"

BOOL App::InitInstance()
{
	InitCommonControls();
	//LPINITCOMMONCONTROLSEX LPCC;
	//LPCC->dwICC=ICC_BAR_CLASSES;
	//LPCC->dwSize=sizeof(LPCC);
	//InitCommonControlsEx(LPCC);
	FrameWnd *F;
	F=new FrameWnd();
	if (!F->InitWindow())
	{
		AfxMessageBox(_T("Couldn't create the window"), MB_ICONERROR);
		return false;
	}
	F->ShowWindow(m_nCmdShow);
	F->CenterWindow();
	F->UpdateWindow();
	m_pMainWnd=F;
	return TRUE;
}

///FRAMEWN
static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_PANEL2,
	ID_PANEL_INTER
}; //indicators for statusbar

BEGIN_MESSAGE_MAP(FrameWnd, CFrameWnd)
	ON_COMMAND(ID_OPEN, Open)
	ON_COMMAND(ID_START, Start)
	ON_COMMAND(ID_AUTO, AutoStart)
	ON_COMMAND(ID_STOP, Stop)
	ON_COMMAND(ID_SETTINGS, Options)
	ON_COMMAND(ID_HELP, Help)
	ON_COMMAND(ID_EXIT, Exit)
	ON_COMMAND(ID_CONVERT, Convert)
	ON_WM_DESTROY()
	ON_UPDATE_COMMAND_UI(ID_PANEL2, OnUpdateFilename)
	ON_UPDATE_COMMAND_UI(ID_OPEN, OnUpdateOpen)
	ON_UPDATE_COMMAND_UI(ID_AUTO, OnUpdateAutoStart)
	ON_UPDATE_COMMAND_UI(ID_START, OnUpdateStart)
	ON_UPDATE_COMMAND_UI(ID_STOP, OnUpdateStop)
	ON_UPDATE_COMMAND_UI(ID_SETTINGS, OnUpdateSettings)
	ON_UPDATE_COMMAND_UI(ID_PANEL_INTER, OnUpdateInterval)
	ON_UPDATE_COMMAND_UI(ID_CONVERT, OnUpdateConvert)
END_MESSAGE_MAP()



void FrameWnd::OnUpdateConvert(CCmdUI *p)
{
	if (d->IsStarted())
		p->Enable(FALSE);
	else p->Enable(TRUE);
}
void FrameWnd::OnUpdateInterval(CCmdUI* pCmdUI)
{
	tstring x;
	x=_T("timer interval: ");
	x+=_T(uint_convert.NrToStr(d->GetInterval()));
	x+=_T("ms");
	pCmdUI->SetText(x.c_str());
}


void FrameWnd::OnUpdateAutoStart(CCmdUI* pCmdUI)
{
	if (ToolBar2.GetToolBarCtrl().IsButtonChecked(ID_AUTO)==0)
		isAuto=false;
	else isAuto=true;
	if (d->IsStarted())
		pCmdUI->Enable(FALSE);
	/*isAuto is control variable, which shows if the auto file detecting
	mode is on or off. If it is on, it automatically disables all opening and starting
	functions */

}


void FrameWnd::OnUpdateStart(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(!d->IsStarted() && !isAuto);
}


void FrameWnd::OnUpdateOpen(CCmdUI *pCmdUI)
{
	pCmdUI->Enable(!d->IsStarted() && !isAuto);
}

void FrameWnd::OnUpdateStop(CCmdUI *pCmdUI)
{
	pCmdUI->Enable(d->IsStarted());
}

void FrameWnd::OnUpdateSettings(CCmdUI *pCmdUI)
{
	pCmdUI->Enable(!d->IsStarted() && !isAuto);
}

void FrameWnd::OnUpdateFilename(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(TRUE); 
	if (ToolBar2.GetToolBarCtrl().IsButtonChecked(ID_AUTO)!=0 && d->GetFileInfo().c_str()==tstring(_T("file not attached")))
		pCmdUI->SetText(_T("Waiting for file..."));
	else pCmdUI->SetText(d->GetFileInfo().c_str());
}

void FrameWnd::OnDestroy()
{
	d->Stop();
	delete d;
}


bool FrameWnd::InitWindow()
{
	tstring FWclass;	//window register string
	try
	{
		FWclass = AfxRegisterWndClass(
		CS_VREDRAW | CS_HREDRAW | CS_BYTEALIGNCLIENT,
		::LoadCursor(NULL, IDC_ARROW),
		(HBRUSH) ::GetStockObject(GRAY_BRUSH),
		::LoadIcon(NULL, MAKEINTRESOURCE(IDI_APPLICATION)));
	}
	catch (CResourceException* pEx)
	{
		AfxMessageBox(
			_T("Couldn't register class! (Already registered?)"));
		pEx->Delete();
		return false;
	}
	RECT position = {100, 100, 850, 700};
	if (!Create(FWclass.c_str(), _T("SPECTRO"), WS_OVERLAPPED|WS_SYSMENU|WS_MINIMIZEBOX|CS_BYTEALIGNCLIENT, position, NULL, MAKEINTRESOURCE(IDR_MENU1), NULL, NULL))
		return false;
	EnableDocking(CBRS_ALIGN_ANY); //enables toolbars/statusbar at any position of the frame
	if (!this->CreateStatusBar())
	{
		AfxMessageBox(_T("Couldn't create statusbar for the window"), MB_ICONERROR);
		return false;
	}
	if (!this->CreateToolBar())
	{
		AfxMessageBox(_T("Couldn't create toolbar for the window"), MB_ICONERROR);
		return false;
	}
	menu = new CMenu();
	menu->LoadMenu(IDR_MENU1);
	ASSERT(menu);
	d=new MainDialog();
	
	SetMenu(NULL);
	SetMenu(menu);
	d->Create(IDD_MAINDIALOG, this);
	d->ShowWindow(SW_SHOWNORMAL);
	d->CenterWindow();
	cd=new ConvertDialog(IDD_CONVERT, d->Window);
	UpdateWindow();
	return true;
}


bool FrameWnd::CreateStatusBar()
{
	if (!StatusBar.Create(this) || !StatusBar.SetIndicators(indicators, sizeof(indicators)/sizeof(UINT)))
		return false;
	UINT nID, nStyle;
	int cxWidth;
	StatusBar.GetPaneInfo( 0, nID, nStyle, cxWidth);
	StatusBar.SetPaneInfo( 0, nID, SBPS_STRETCH|SBPS_NORMAL, cxWidth); //sets pane parameters
	StatusBar.GetPaneInfo( 1, nID, nStyle, cxWidth);
	StatusBar.SetPaneInfo( 1, nID, SBPS_NORMAL, 200);		//panel for filename
	StatusBar.GetPaneInfo( 2, nID, nStyle, cxWidth);
	StatusBar.SetPaneInfo( 2, nID, nStyle, 150);			//panel for interval
	return true;
}

bool FrameWnd::CreateToolBar()
{
	CRect rect; //for placing second toolbar
	if (!ToolBar.CreateEx(this, TBSTYLE_FLAT|TBSTYLE_TRANSPARENT|TBSTYLE_AUTOSIZE,  WS_CHILD |WS_VISIBLE |CBRS_TOP|  CBRS_TOOLTIPS |CBRS_FLYBY | CBRS_SIZE_DYNAMIC)
		|| !ToolBar.LoadToolBar(IDR_TOOLBAR1) )
      return false;      // fail to create
	HighColorToolBar *hc = new HighColorToolBar(32, 32, 6, IDB_BUTTONS, NULL, NULL, ILC_COLOR32);
	if (!hc->Create(ToolBar))return false;
	ToolBar.EnableDocking(CBRS_ALIGN_TOP);
	DockControlBar(&ToolBar,AFX_IDW_DOCKBAR_TOP);


	if (!ToolBar2.CreateEx(this, TBSTYLE_FLAT|TBSTYLE_TRANSPARENT|TBSTYLE_AUTOSIZE,WS_CHILD|WS_VISIBLE| CBRS_TOP|  CBRS_TOOLTIPS | CBRS_FLYBY|CBRS_SIZE_DYNAMIC)
		|| !ToolBar2.LoadToolBar(IDR_TOOLBAR2))
		return false;
	HighColorToolBar *hc2 = new HighColorToolBar(32,32,1,IDB_BITMAP7, NULL, NULL, ILC_COLOR32);

	if (!hc2->Create(ToolBar2)) return false;
	ToolBar2.EnableDocking(CBRS_ALIGN_RIGHT);
	this->RecalcLayout();

	ToolBar.GetWindowRect(&rect);
	rect.OffsetRect(1,0);

	DockControlBar(&ToolBar2,AFX_IDW_DOCKBAR_TOP,&rect);
	ToolBar2.GetWindowRect(&rect);
	rect.MoveToX(rect.right + 32);
	DockControlBar(&ToolBar2,AFX_IDW_DOCKBAR_TOP,&rect);
	ToolBar2.SetButtonInfo(0, ID_AUTO, TBBS_CHECKBOX,NULL);
	return true;
}

void FrameWnd::Start()
{
	if (d->IsWindowVisible())	d->Start();
		
}

void FrameWnd::Stop()
{
	if (d->IsWindowVisible())
		d->Stop();
}

void FrameWnd::Options()
{
	d->Options();
}

void FrameWnd::AutoStartCommon()
{

	if (!isAuto)
	 {
		 if (!d->AutoStartModeStart(&ToolBar2, menu))  //isAuto is vice versa because updating will be done later
		 {
			 ToolBar2.GetToolBarCtrl().CheckButton(ID_AUTO, FALSE);
			 
		 }
		 else {}
	 }
	 else
		 d->AutoStartModeStop();

}

void FrameWnd::AutoStart()
{
	AutoStartCommon();
}


void FrameWnd::Help()
{

}

void FrameWnd::Exit()
{
	this->DestroyWindow();
}

void FrameWnd::Open()
{
	if (d->IsWindowVisible())
		d->Open();
}

void FrameWnd::Convert()
{
	if (!d->IsStarted())
	cd->DoModal();
	d->RePaint();
}





///DIALOG

BEGIN_MESSAGE_MAP(MainDialog, CDialog)
	ON_WM_TIMER()
	ON_COMMAND(IDC_UPDATE,OnUpdate)
	ON_COMMAND(IDC_AUTOSCALE, OnAutoScale)
	ON_WM_LBUTTONUP()

END_MESSAGE_MAP()
void MainDialog::OnLButtonUp(UINT u, CPoint c)
{
	
}


MainDialog::~MainDialog()
{
	
}

void MainDialog::OnOK()
{
	Window.params[_T("ChangeOccurred")]=1;
	RePaint();
	return;
}

void MainDialog::OnCancel()
{
	RePaint();
	return;
}

void MainDialog::OnAutoScale()
{
	if( AutoScaleCheck.GetState()&0x0003)	//means not checked
	{
		AutoScaleCheck.SetCheck(1);
		up=0;
		down=0;
		Window.UpdateBounds(up,down);
		this->OnOK();						//for reviewing on stop mode
	}
	else
		OnUpdate();  //tries to enable bounded area
}



void MainDialog::OnUpdate()
{
	Converter<unsigned long> conv;
	CString cs;
	tstring ts;
	unsigned long check;
	Upper.GetWindowText(cs);
	ts=cs;
	if (ts.empty())
	{
		AutoScaleCheck.SetCheck(BST_CHECKED);
		return;
	}
	if (conv.StrToNr(ts)>0) check=conv.StrToNr(ts);
	else
	{
		AutoScaleCheck.SetCheck(BST_CHECKED);
		return;
	}
	up=(unsigned int)check;
	Lower.GetWindowText(cs);
	ts=cs;
	if (ts.empty())
	{
		AutoScaleCheck.SetCheck(BST_CHECKED);
		return;
	}
	if (conv.StrToNr(ts)>=0) check=conv.StrToNr(ts);
	else
	{
		AutoScaleCheck.SetCheck(BST_CHECKED);
		return;
	}
	down=(unsigned int)check;
	Window.UpdateBounds(up,down);
	if (!Window.CheckBounds()) //if error in bound values
	{
		AfxMessageBox(_T("Incorrect limit values. Lower limit cannot be larger nor equal compared to upper limit. Switching back to autoscaling mode.."), MB_ICONERROR);
		AutoScaleCheck.SetCheck(BST_CHECKED);

	}
	else
		AutoScaleCheck.SetCheck(BST_UNCHECKED);
	this->OnOK();					//renews picture
	TRACE("BOUNDS up=%i, down=%i\n",up,down);
}




void MainDialog::OnTimer(UINT identifier)
{
	if (identifier==1)
	{
		//ID++;
		experiment(); 
		unsigned int a = Window.GetAmount();
		MeasureNr.SetWindowText(conv.NrToStr(a).c_str());
#ifdef _DEBUG
		instream.WriteShit(10);
#endif
	}
	else if (identifier==2)
	{
		tstring str;
		if (autostream.IsAttached())
			autostream>>str;
		if (!str.empty())
			if (instream.Open(str))
			{
				Start();
				this->AutoStartModeForceStop();
			}
			else
			{
				instream.Reboot();
				AfxMessageBox(_T("Cannot open file inserted to input.inf"));
				this->AutoStartModeForceStop();
			}
	}
}

void MainDialog::RePaint()
{
	if (is_attached)
	{
		Window.UpdateWholeGraph();
		//LeftText.PaintGraph();
	}
}

void MainDialog::Start()
{
	if (instream.IsOpen())
	{
		TimerID=(unsigned int)SetTimer(1, od->subKeys["interval"], NULL);
		is_started=true;
	}
	else
	{
		Open();
		if (instream.IsOpen())
		{
			TimerID=(unsigned int)SetTimer(1, od->subKeys["interval"], NULL);			//interval is got from OptionsDialog
			is_started=true;											//for buttons
		}
	}
}

void MainDialog::Stop()
{
	this->KillTimer(TimerID);
	is_started=false;
	instream.SetFirstReadFalse();
}

tstring MainDialog::GetFilename()
{
	return instream.GetFileName();
}

unsigned int MainDialog::GetInterval()
{
	return od->subKeys["interval"];
}

tstring MainDialog::GetFileInfo()
{
	if (!instream.IsAttached())
		return tstring(_T("file not attached"));
	if (!instream.GetFileName().empty())
	{
		tstring::size_type st;
		tstring buf;
		st = instream.GetFileName().find_last_of("\\");
		buf=instream.GetFileName().substr(st+1,tstring::npos);
		return buf;
	}
	else
		return tstring(_T("file not attached"));
}

void MainDialog::Open()
{
	filedialog = new CFileDialog(TRUE, NULL, NULL, NULL, szFilter, this);
	if (filedialog->DoModal()==IDOK)
	{
		filename=filedialog->GetPathName();			//gets the filename
		if (!filename.empty() && Window.RebootViewData() && instream.Reboot())
			instream.Open(filename);
		else
			AfxMessageBox(_T("Something went wrong with recreating linearea"));
		RePaint();
		ID=0;
	}

	RePaint();

	delete filedialog;
}

void MainDialog::Options()
{
	od->DoModal();
	ExchangeGraphData();
	RePaint();

}

bool MainDialog::AutoStartModeStart(CToolBar *ctb, CMenu *cm)
{
	CheckButtonBar=ctb;
	MenuButton=cm;
	if (!Window.RebootViewData() || !instream.Reboot() || !autostream.Reboot())
	{
		AfxMessageBox(_T("Couldn't reboot graph data or reboot input module. Try to restart program"), MB_ICONERROR);
		//exit(0);
		return false;
	}
	if (!autostream.Open(AUTOFILE))
	{
		AfxMessageBox(_T("Couldn't open input.inf"));
		return false;
	}
	RePaint();
	TimerID=(unsigned int)SetTimer(2, AUTOTIMER, NULL);
	return true;

}

void MainDialog::AutoStartModeStop()
{
	if (!Window.RebootViewData() || !instream.Reboot())
	{
		AfxMessageBox(_T("Couldn't reboot graph data or reboot input module. Try to restart program"), MB_ICONERROR);
		exit(0);
	}
	this->KillTimer(TimerID2);

}

void MainDialog::AutoStartModeForceStop()
{
	this->KillTimer(TimerID2);
	autostream.ClearFile();
	autostream.Reboot();
	if (CheckButtonBar!=NULL)	CheckButtonBar->GetToolBarCtrl().CheckButton(ID_AUTO, FALSE);
	//if (MenuButton!=NULL)		MenuButton->CheckMenuItem(ID_AUTOSTART, MF_UNCHECKED);
}

void MainDialog::ExchangeGraphData()
{
	Window.params[_T("ConstMode")]=od->subKeys[_T("const_isconst")];
	Window.params[_T("Hide")]=od->subKeys[_T("unknown_scanfull")];
	Window.params[_T("Step")]=od->subKeys[_T("unknown_steps")];
	Window.params[_T("StopAmount")] = (od->subKeys[_T("const_isconst")]==0) ? 0 : od->subKeys[_T("const_measureamount")];
	Window.params[_T("ChangeOccurred")]=1; //!!!

}


bool MainDialog::IsStarted()
{
	return is_started;
}

void MainDialog::experiment()
{
	//containers for data
	vector<unsigned int> vData;
	map<long int, vector<unsigned int> > mData;
	vData.clear();
	mData.clear();
	//at first, tries to read all data from file
	if (instream.IsFirstDone())
	{
		instream >> vData;
		
	}
		
	else
	{
		TRACE("FIRST IS NOT DONE: ");
		instream >> mData;
		TRACE("mData size is: %i\n", mData.size());
	}
	if (!vData.empty())				//if data were written to vector 
	{
		if(Window.AddAndDraw(ID, vData)==false)
		{
			Stop();
			AfxMessageBox(_T("Stopping measuring. Specified amount is full"), MB_ICONINFORMATION);
			RePaint();
		}
		ID++;
		
	}	
	if (!mData.empty())				//if firs read
	{
		if (Window.AddAndDraw(mData, ID)==false)
		{
			Stop();
			AfxMessageBox(_T("Stopping measuring. Specified amount is full"), MB_ICONINFORMATION);
			RePaint();
		}
		ID+=mData.size();
		
	}
}

void MainDialog::GetLocalDir()	//gets local directory path
{
	TCHAR curdir[10*MAX_PATH]; //10*Max Path length - for any case
	HMODULE modul=GetModuleHandle(NULL);
	::GetModuleFileName(modul, curdir, 10*MAX_PATH); //gets path
	path=curdir;
	path=path.substr(0, path.size()-_tcslen(NAME_OF_THE_PROGRAM)); //Cuts Spectro.exe from the end of the string
}

bool MainDialog::ReadColors(vector<RGBQUAD> &col)	//reads colors from file
{
	ifstream input((path + COLORFILE).c_str());
	RGBQUAD rgbq;
	int r,g,b;
	if (!input.good() || !input.is_open())
		return false;
	while (!input.eof())
	{		
		input >> r >> g >> b;
		rgbq.rgbBlue=b;
		rgbq.rgbGreen=g;
		rgbq.rgbRed=r;
		col.push_back(rgbq);
	}
	input.close();
	return true;
}

BOOL MainDialog::OnInitDialog()
{
	CDialog::OnInitDialog();
	vector<RGBQUAD> colors;
	is_attached=false;
	GetLocalDir();				//gets path of file
	if (!ReadColors(colors))	//initializing colors
	{
		AfxMessageBox(_T("Couldn't read colors file"), MB_ICONERROR);
		exit(0);
		return false;
	}
	LeftText.GetWindowHandler(Window);
	if (!Window.InitGraph(colors, &LeftText, &XVal, &YVal)|| !LeftText.InitGraph(colors, NULL,NULL,NULL))	//initializing graph
	{
		AfxMessageBox(_T("Couldn't initialize graph object(s)"),NULL,NULL);
		exit(0);
		return false;
	}
	is_attached=true;
	ID=0;				//index for map
	filename.clear();
	//getting variables for startup
	od=new OptionsDialog(IDD_OPTIONS, path);
	ExchangeGraphData();
	AutoScaleCheck.SetCheck(1);
	return true;
}


void MainDialog::DoDataExchange(CDataExchange *c)
{
	CDialog::DoDataExchange(c);
	DDX_Control(c, IDC_GRAPH, Window);
	DDX_Control(c, IDC_NUMBERS, LeftText);
	DDX_Control(c, IDC_UPPER, Upper);
	DDX_Control(c, IDC_LOWER, Lower);
	DDX_Control(c, IDC_AUTOSCALE, AutoScaleCheck);
	DDX_Control(c, IDC_MEASURENUMBER, MeasureNr);
	DDX_Control(c, IDC_X, XVal);
	DDX_Control(c, IDC_Y, YVal);
}

App a;


BEGIN_MESSAGE_MAP(OptionsDialog, CDialog)
	ON_COMMAND(ID_OK, OnOK)
	ON_EN_KILLFOCUS(IDC_INTERVAL, OnKillFocusInterval)
	ON_EN_KILLFOCUS(IDC_MEASURENUMBER, OnKillFocusMeasure)
	ON_EN_KILLFOCUS(IDC_PIXELS, onKillFocusPixels)
	ON_COMMAND(ID_CANCEL, OnCancel)
	ON_COMMAND(IDC_ISCONSTANT, ModeChange)
END_MESSAGE_MAP()

afx_msg void OptionsDialog::OnKillFocusInterval()
{
	tstring str;
	CString temp;
		//getting interval
	Edit.GetWindowText(temp);
	str=temp;
	if (uint_convert.StrToNr(str)==0 || uint_convert.StrToNr(str)>32000)
	{
		AfxMessageBox(_T("Incorrect value in inteval box. Must be between 0 and 32000"), MB_ICONERROR);
		Edit.SetWindowText(_T("1000"));
	}
}

afx_msg void OptionsDialog::OnKillFocusMeasure()
{
	tstring str;
	CString temp;
		//getting interval
	Number.GetWindowText(temp);
	str=temp;
	if (uint_convert.StrToNr(str)<10 || uint_convert.StrToNr(str)>32000)
	{
		AfxMessageBox(_T("Incorrect value in inteval box. Must be between 10 and 32000"), MB_ICONERROR);
		Number.SetWindowText(_T("100"));
	}
}

afx_msg void OptionsDialog::onKillFocusPixels()
{
	tstring str;
	CString temp;
		//getting interval
	Pixels.GetWindowText(temp);
	str=temp;
	if (uint_convert.StrToNr(str)<1 || uint_convert.StrToNr(str)>20)
	{
		AfxMessageBox(_T("Incorrect value in inteval box. Must be between 1 and 20"), MB_ICONERROR);
		Pixels.SetWindowText(_T("5"));
	}
}

afx_msg void OptionsDialog::ModeChange()
{
	subKeys[_T("const_isconst")]=IsConst.GetState()&0x0003;
	Number.SetReadOnly(!subKeys["const_isconst"]);
}


void OptionsDialog::OnOK()
{
	unsigned int button_state;
	tstring str;
	CString temp;
	//getting interval
	Edit.GetWindowText(temp);
	str=temp;
    subKeys[_T("interval")]=uint_convert.StrToNr(str);

	Number.GetWindowText(temp);
	str=temp;
    subKeys[_T("const_measureamount")]=uint_convert.StrToNr(str);

	Pixels.GetWindowText(temp);
	str=temp;
    subKeys[_T("unknown_steps")]=uint_convert.StrToNr(str);
	map<tstring, unsigned int>::iterator iter=subKeys.begin();


	button_state=0;
	if (UnknownEnlarge.GetState()&0x0003)
		button_state=0;
	else button_state=1;
	subKeys[_T("unknown_scanfull")]=button_state;
	while (iter!=subKeys.end())
	{
		key.SetDWORDValue((iter->first).c_str(), iter->second);
		iter++;
	}
	key.Flush();
	CDialog::OnOK();
}

void OptionsDialog::OnCancel()
{
	CDialog::OnCancel();
}

bool OptionsDialog::UpdateData()
{
	DWORD temp;
	map<tstring, unsigned int>::iterator iter=subKeys.begin();
	while (iter!=subKeys.end())
	{
		if (key.QueryDWORDValue((iter->first).c_str(), temp)==ERROR_SUCCESS)
			subKeys[iter->first]=temp;
		iter++;
	}
	return true;
}

OptionsDialog::OptionsDialog(UINT x, tstring path) : CDialog(x)
{
	filename=path+PREFFILE;
	keyname=_T("SOFTWARE\\Spectro\\");
	key.Create(HKEY_LOCAL_MACHINE,keyname.c_str(),REG_NONE,REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,NULL,NULL);
	subKeys.insert(pair<tstring,unsigned int>(_T("interval"),1000));
	subKeys.insert(pair<tstring,unsigned int>(_T("unknown_steps"),5));
	subKeys.insert(pair<tstring,unsigned int>(_T("unknown_scanfull"),0));
	subKeys.insert(pair<tstring,unsigned int>(_T("const_isconst"),0));
	subKeys.insert(pair<tstring,unsigned int>(_T("const_measureamount"),1000));
	if (!UpdateData())
		AfxMessageBox(_T("Could't read data from file. Default settings are applied"), MB_ICONERROR);
}

BOOL OptionsDialog::OnInitDialog()
{
	CDialog::OnInitDialog();
	Edit.SetWindowText(uint_convert.NrToStr(subKeys[_T("interval")]).c_str());
	Number.SetWindowText(uint_convert.NrToStr(subKeys[_T("const_measureamount")]).c_str());
	Pixels.SetWindowText(uint_convert.NrToStr(subKeys[_T("unknown_steps")]).c_str());
	IsConst.SetCheck(subKeys[_T("const_isconst")]);
	if (subKeys[_T("unknown_scanfull")]==0)
		UnknownEnlarge.SetCheck(TRUE);
	else UnknownHide.SetCheck(TRUE);
	ModeChange();				//for hiding or unhiding Const prefix controls

	
	return TRUE;
}

void OptionsDialog::DoDataExchange(CDataExchange *CDE)
{
	CDialog::DoDataExchange(CDE);
	DDX_Control(CDE, IDC_INTERVAL, Edit);
	DDX_Control(CDE, IDC_ISCONSTANT, IsConst);
	DDX_Control(CDE, IDC_MEASURENUMBER, Number);
	DDX_Control(CDE, IDC_PIXELS, Pixels);
	DDX_Control(CDE, IDC_UNKNOWN_ENLARGE, UnknownEnlarge);
	DDX_Control(CDE, IDC_UNKNOWN_HIDE, UnknownHide);
}

/// CONVERT DIALOG

ConvertDialog::ConvertDialog(unsigned int d, Graph &w) : CDialog(d)
{
	win=&w;
	dir=_T("ASCII_XY");
}

void ConvertDialog::EraseData()
{
	data.clear();
	namevector.clear();
	size=0;
}

void ConvertDialog::DuplicateData()
{
	data=win->GetData();
}

bool ConvertDialog::WriteFiles(tstring str)
{
	//making dir
	CreateDirectory(dir.c_str(),NULL);
	//making namevector
	namevector.clear();
	for (unsigned int i=0; i<size; i++)
		namevector.push_back(dir + "\\" + str + conv.NrToStr(i+1) + ".txt");
	for (unsigned int i=0; i<size; i++)
	{
		ofstream a(namevector[i].c_str());
		if (!a.good())
			return false;
		map<long int, vector<unsigned int> >::iterator p=data.begin();
		unsigned int j=0;
		while (p!=data.end())
		{
			a << j << _T(",") << p->second[i] << endl; 
			p++;
			j++;
		}
		a.close();

	}
	return true;
}

afx_msg void ConvertDialog::OnOK()
{
	CString temp;
	tstring str;
	filebox.GetWindowText(temp);		//postfix would be added
	str=temp;								//standard filename would be str.c_str()
	if (str.empty())
	{
		AfxMessageBox(_T("You have to write filename"), MB_ICONERROR);
		return;
	}
	if (size>1024)
	{
		AfxMessageBox(_T("Incorrect number of values"), MB_ICONERROR);
		return;
	}
	if (WriteFiles(str))
	{
		tstring message;
		message = _T("Files written successfully to the directory ") + dir + "\n\nFilenames are:\n";
		for (unsigned int i=0; i<size; i++)
			message+=namevector[i] + "\n";
		AfxMessageBox(message.c_str(), MB_ICONINFORMATION);
		CDialog::OnOK();
	}
	else
	{
		AfxMessageBox(_T("There was a problem writing those files. Try with another filename"), MB_ICONWARNING);
		return;
	}
}

afx_msg void ConvertDialog::OnCancel()
{
	EraseData();
	CDialog::OnCancel();
}

BOOL ConvertDialog::OnInitDialog()
{
	//Syncronizes data and updates dialog area
	CDialog::OnInitDialog();
	DuplicateData();			
	map<long int, vector<unsigned int> >::iterator p=data.begin();
	if (!data.empty())
	{
		number.SetWindowText(conv.NrToStr((p->second).size()).c_str());
		size=(p->second).size();
	}
	else
	{
		size=0;
		number.SetWindowText(conv.NrToStr(0).c_str());
	}
	return TRUE;
}

void ConvertDialog::DoDataExchange(CDataExchange *c)
{
	DDX_Control(c, IDC_FILENAME, filebox);
	DDX_Control(c, IDC_NUMBER, number);
}