#define WIDTH_IN_BYTES(inbits) ((((inbits) + 31)/32)*4)
#define GRIDSPACE 20			//space between 'squares'
#define GRIDSTEP 5//10			//step in pixels
#define COMP_GRIDSTEP 1			//compact gridstep
#define TEXTSPACE 50			//space for text in the graph
#define LINECOLOR_START_POS 2	//shows, where is beginning of the linecolors in vector.. 0,1.. LINE_...
//first one is grid and second is text color
#define BGCOLOR	0
#define TEXT_COUNT	5			//how many marks.. must be larger than 1
#define TEXT_SIZE	12			//how many pixels
#define TOPBOTMARGIN 10			//space in pixels, which should be 'empty' (at the top and bottom)
#define INCREASE 0.1f			//10% increase if graph is full




class Graph : public CStatic
{
protected:
	CDC			*pMemoryDC;			//Pointer to "memory" device context
	CDC			*pBgMemoryDC;		//Pointer to "bgmemory" device context;
	Graph		*pTextGraph;
	CWindowDC	*pWindowDC;							//Pointer to the video memory context
	CBitmap		cbPicture;							//Graphs Bitmap
	CBitmap		cbBgPicture;						//Background Bitmap
	BYTE		*pBeginning;						//Pointer to the byte, where begins bitmap memory
	BYTE		*pBgBeginning;						//Pointer to the byte, where begins bgbitmap memory
	RGBQUAD		colors[256];						//for colors
	bool		first_load;							//true, if first initialization is done.. changed in CreateBitmap function
	int			gridindex;							//for grid placement

	////////// MODE2
	unsigned int last_y;							//last value of y coord (by the end of the drawing cycle)
	unsigned int wide_area_width;					//in mode 2, graph area width =points + TEXTSPACE;
	unsigned int StopAmount;						//if 0, then unlimited
	unsigned int increase_amount;					//how many times increased
	////////// END MODE2 Variables
	bool increase_now;								//if there is time to increase
	unsigned int dynGridStep;						//GRIDSTEP, depending...
	unsigned int relative_height;					//height-2*TOPBOTMARING
	unsigned int d_linevalues;						//delta max value and min value of seeable area
	unsigned int minimum;							//min value of graph (or showable area)
	unsigned int maximum;							//max value of graph (or showable area)
	unsigned int graph_area_width;					//width of the area where graph is plotted
	unsigned int text_space;						//Dynamic text.. if 0, not used for text
	double		ratio;								//ratio of d_linevalues and height
	unsigned int upper, lower;

	map<long int, vector<unsigned int> > mDataseg;	//Map for data: firs is time, second is vector for values
													//number of elements in vector should not change!!!!
	vector<unsigned int> *pvLastDataseg;			//pointer to previous dataseg.
	vector<unsigned int> topValues;					//top value of each data-vector. (for calculating bounds)
	vector<unsigned int> botValues;
	vector<unsigned long int> vColorLine;			//for CPen colors
	CSize GetBitmapSize();							//for getting size of the bitmap
	unsigned int bgcolor;							//background color!!
	CSize GetClientRectSize();
	Converter<unsigned int> intConverter;
	bool EnlargeBitmap();							//for enlarging previously created bitmap
	bool CreateBitmap();							//Creating bitmap (
	bool CreateBgBitmap();							//Creating background bitmap
	void InitTextSettings();						//Initializing text color and settings
	//void RedrawGraph();								//Redrawing.. using mDataseg elements
	void PrintGreenOnes();							//prints only green lines
	void CalculateBounds(vector<unsigned int>&);	//for calculating new ratio
	void CalculateBounds();							//recalculating purposes
	int CalculateYCoord(unsigned int);				//calculates Y coord for Graph, depends on height, minimum, ratio, coord in absolute scale
	void UpdateText();								//updates numbers
								//on entering to compact mode!
	CStatic *x_out, *y_out;						//Windows for x and y values under mouse pointer

	//MAPPING MAPPING MAPPING
	void RedrawGraph();






	//END OF MAPPING MAPPING MAPPING
public:
	//////////PRIMARY INPUTABLE PARAMETERS
	map<tstring, unsigned int> params;				//first is param name, second is #
	void ClearEverything();
	Graph();		//default constructor
	~Graph();
	void CreatePallette(vector<RGBQUAD> &);			//Creating color pallette - <=256 colors can be predefine
	virtual void PaintGraph();
	virtual void RePaintGraph();
	bool InitGraph(vector<RGBQUAD> &, Graph *, CStatic *, CStatic *);//initalizes functions and creates color pallette
	//if vector<..>==empty.. then DOES NOT ENTER NEW elements - so, this function can be called without insertin new elements
	bool AddAndDraw(long int, vector<unsigned int>);
	bool AddAndDraw(map<long int, vector<unsigned int> >, long int);		//for adding data and showing graph
	void ClearLineData();							//clears map and topValues
	bool RebootViewData();
	bool CheckBounds();								//checks if upper and lower are ok
	void ResetView();								//draws only green lines
	void UpdateBounds(unsigned int x, unsigned int y);	//for updating bounds
	void UpdateWholeGraph();						//includes bounds
	unsigned int GetAmount();						//amount of collected data;
	map<long int, vector<unsigned int> > GetData();	//returns mDataseg
	//MESSAGES
	afx_msg void OnPaint();
	afx_msg void OnMouseMove(UINT, CPoint);
	afx_msg void OnLButtonUp(UINT, CPoint);
	// for working with derived classes
	virtual void TextOut(unsigned int, tstring);
	virtual void FillBackground();
	DECLARE_MESSAGE_MAP()
};

class LTexts : public Graph
{
public:
	Graph *g;
	LTexts() : Graph(){};
	void GetWindowHandler(Graph &h){g=&h;};
	virtual void TextOut(unsigned int, tstring);
	virtual void FillBackground();
	virtual void PaintGraph();
	afx_msg void OnPaint();
	DECLARE_MESSAGE_MAP()
};