#include "headers.h"

BEGIN_MESSAGE_MAP(Graph, CStatic)
	ON_WM_PAINT()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
END_MESSAGE_MAP()

BEGIN_MESSAGE_MAP(LTexts, CStatic)
	ON_WM_PAINT()
END_MESSAGE_MAP()


void Graph::OnPaint()
{	PAINTSTRUCT ps;
	CDC* pDC = BeginPaint (&ps);
	RePaintGraph();
	EndPaint (&ps);
}

void Graph::OnLButtonUp(UINT u, CPoint p)
{
	
}

void Graph::OnMouseMove(UINT u, CPoint p)
{
	////AfxMessageBox("F");
	//if (this->x_out!=NULL)
	//{
	//	if (params[_T("Hide")]==1)
	//	{
	//		//tries to divide area to pieces (lenght of gridstep)
	//		unsigned int pp,aa;
	//		pp=(this->GetClientRectSize().cx)-p.x;
	//		while ((pp%dynGridStep)!=0)
	//			pp--;
	//		int a = mDataseg.size()-pp/dynGridStep;
	//		if (a<0) aa=0;
	//		else aa=a;
	//		x_out->SetWindowText(intConverter.NrToStr(aa).c_str());
	//	}
	//	else
	//	{
	//		unsigned int graph_width, aa,pp, checkdyn;
	//		double relation, newdyn;
	//		
	//		graph_width=wide_area_width-last_y;
	//		relation=(wide_area_width/(this->GetClientRectSize().cx));
	//		newdyn=dynGridStep/relation;
	//		checkdyn=(unsigned int)newdyn;

	//		pp=(this->GetClientRectSize().cx)-p.x;

	//		if (checkdyn>1)
	//		{
	//			while ((pp%checkdyn)!=0)
	//				pp--;
	//			int a = mDataseg.size()-(unsigned int)(pp*relation/newdyn);
	//			if (a<0) aa=0;
	//			else aa=a;
	//		}
	//		x_out->SetWindowText(intConverter.NrToStr(aa).c_str());
	//	}

	//}
	//if (this->y_out!=NULL)
	//{

	//}

}

Graph::Graph()
{
	params.insert(pair<tstring, unsigned int> (_T("Hide"), 0));
	params.insert(pair<tstring, unsigned int> (_T("Step"), GRIDSTEP));
	params.insert(pair<tstring, unsigned int> (_T("StopAmount"),0));
	//IF any data is changed, then Change Occurred is 1.
	params.insert(pair<tstring, unsigned int> (_T("ChangeOccurred"), 1));
	dynGridStep=GRIDSTEP;
	pMemoryDC=NULL;
	pWindowDC=NULL;
	pTextGraph=NULL;
	gridindex=GRIDSPACE;	//Grids spacing
	pvLastDataseg=NULL;
	relative_height=0;
	ratio=1.0f;
	minimum=0;
	text_space=0;
	graph_area_width=-1;
	wide_area_width=0;
	upper=0;
	lower=0;				//it means autoscaling at first
	increase_amount=0;		//0 times area increased
	first_load=false;		//false - means this class is not initialized yet
}

Graph::~Graph()
{
	this->mDataseg.clear();
	this->vColorLine.clear();
	this->topValues.clear();
	this->botValues.clear();
	cbPicture.DeleteObject();
	pMemoryDC->Detach();
	pWindowDC->Detach();
	if (pMemoryDC->DeleteDC()!=0 || pWindowDC->DeleteDC()!=0)
	{
		AfxMessageBox(_T("Couldn't Delete CDC and CWindowDC"),MB_ICONERROR);
		return;
	}
	ReleaseDC(pMemoryDC);
	ReleaseDC(pWindowDC);

}

void Graph::ClearEverything()
{


}



bool Graph::RebootViewData()
{
	ClearLineData();
	ClearEverything();
	wide_area_width=0;
	if (!CreateBitmap())
		return false;
	return true;

}



void Graph::ClearLineData()
{
	mDataseg.clear();
	topValues.clear();
	botValues.clear();
	increase_amount=0;
	minimum=0;
	//maximum=d_linevalues;
	maximum=relative_height;
	d_linevalues=relative_height;
	pvLastDataseg=NULL;
}

void Graph::ResetView()
{
	//PrintGreenOnes();
	//PaintGraph();
}

unsigned int Graph::GetAmount()
{
	return mDataseg.size();
}

map<long int, vector<unsigned int> > Graph::GetData()
{
	return mDataseg;
}

CSize Graph::GetBitmapSize() //returns size of the bitmap
{
	if (!cbPicture.m_hObject) return CSize(0,0);
	BITMAP bm; cbPicture.GetObject(sizeof(BITMAP), &bm);
	return CSize(bm.bmWidth, bm.bmHeight);
}

CSize Graph::GetClientRectSize()
{
	CRect rect;
	GetClientRect(&rect);
	CSize size = rect.Size();
	return size;
}


bool Graph::InitGraph(vector<RGBQUAD> &c, Graph *TextGraph, CStatic *x, CStatic *y) //initializing CStatic control
{
	this->CreatePallette(c);
	if (!this->CreateBitmap())
		return false;
	if (!this->CreateBgBitmap())
		return false;
	if (TextGraph==NULL) InitTextSettings();
	else 
		pTextGraph=TextGraph;					//other place for texts
	if (x==NULL) x_out=NULL;					//output under mouse
	else x_out=x;
	if (y==NULL) y_out=NULL;
	else y_out=y;

	graph_area_width=(unsigned int)(GetClientRectSize().cx - text_space);
	relative_height=(unsigned int)GetClientRectSize().cy-(2*(int)TOPBOTMARGIN); //first is real height
	d_linevalues=(unsigned int)GetClientRectSize().cy;	//linevalues range is height at first
	wide_area_width=0;
	maximum=relative_height;
	increase_now=false;
	increase_amount=0;
	return true;
}

void Graph::CreatePallette(vector<RGBQUAD> &c)
{
	int i=0;
	if (c.size()<=256)
		i=(int)(c.size());
	else i=256;
	for (int j=0; j<i; j++)		//makes color pallette, where the first memebers are from given vector
	{
		colors[j].rgbRed=c[j].rgbRed;
		colors[j].rgbGreen=c[j].rgbGreen;
		colors[j].rgbBlue=c[j].rgbBlue;
		vColorLine.push_back(RGB(c[j].rgbRed,c[j].rgbGreen,c[j].rgbBlue));
	}
	for (int j=i; j<256; j++)	//all memebers until 256th are set to graytone
	{
		colors[j].rgbBlue=colors[j].rgbGreen=colors[j].rgbRed=j;
	}
	colors[255].rgbBlue=colors[255].rgbGreen=colors[255].rgbRed=BGCOLOR;	//last element is defined above
	vColorLine.push_back(RGB(colors[255].rgbRed,colors[255].rgbGreen,colors[255].rgbBlue));	// last element in vector is black too
	bgcolor=RGB(colors[255].rgbRed,colors[255].rgbGreen,colors[255].rgbBlue);
}

void Graph::InitTextSettings()
{
	pMemoryDC->SetBkMode(OPAQUE);
	pMemoryDC->SetTextColor(vColorLine[1]);		//second member is textcolor
	pMemoryDC->SetBkColor(bgcolor);
}

bool Graph::EnlargeBitmap()
{
	CRect rect;
	GetClientRect(&rect);
	CSize size = rect.Size();
	long cx=size.cx;
	TRACE("WIDHT WIDE wide=%i", wide_area_width);
	if (wide_area_width > size.cx) cx=wide_area_width;	//overwriting size!!!!
	TRACE("WIDHT cx=%i", cx);
	BITMAPINFO * bitInfo;
	bitInfo= (BITMAPINFO*) new BYTE[sizeof(BITMAPINFOHEADER) + (256*sizeof(RGBQUAD))];
	bitInfo->bmiHeader.biBitCount		=8;		//bits per pixel
	bitInfo->bmiHeader.biClrImportant	=0;		//all colors are important
	bitInfo->bmiHeader.biClrUsed		=0;		//
	bitInfo->bmiHeader.biCompression	=BI_RGB;//no compression.. BI_JPEG - jpg comp
	bitInfo->bmiHeader.biHeight			=size.cy;	//if negative, then beginning is at the top corner.. else at the lower corner
	bitInfo->bmiHeader.biPlanes			=1;		//must be 1
	bitInfo->bmiHeader.biSize			=sizeof(BITMAPINFOHEADER);
	bitInfo->bmiHeader.biSizeImage		=WIDTH_IN_BYTES((cx)*8)*size.cy;
	bitInfo->bmiHeader.biWidth			=cx;
	memcpy(bitInfo->bmiColors, colors, sizeof(RGBQUAD)*256); // copies color quad values...
	
	HBITMAP hbm=CreateDIBSection(pWindowDC->m_hDC,bitInfo,
		DIB_RGB_COLORS,
		(void**)&pBeginning,
		NULL,		//no mapping
		0
		);
	delete bitInfo;		//not necessary any more :P
	if (hbm==NULL)
		return false;
	if (!cbPicture.DeleteObject())
		AfxMessageBox(_T("Couldn't delete old Bitmap object from memory. It may cause memory leaks!"), MB_ICONWARNING);
	if (!cbPicture.Attach(hbm))
		return false;
	pMemoryDC->SelectObject(&cbPicture);	//cbPicture is now as graphical object
	increase_amount++;
	return true;
}


bool Graph::CreateBitmap()
{
	if (first_load)
	{
		if (EnlargeBitmap())
			return true;
		else return false;
	}
	CRect rect;
	GetClientRect(&rect);
	CSize size = rect.Size();
	long cx=size.cx;
	TRACE("WIDHT WIDE wide=%i", wide_area_width);
	if (wide_area_width > size.cx) cx=wide_area_width;	//overwriting size!!!!
	TRACE("WIDHT cx=%i", cx);
	BITMAPINFO * bitInfo;
	bitInfo= (BITMAPINFO*) new BYTE[sizeof(BITMAPINFOHEADER) + (256*sizeof(RGBQUAD))];
	bitInfo->bmiHeader.biBitCount		=8;		//bits per pixel
	bitInfo->bmiHeader.biClrImportant	=0;		//all colors are important
	bitInfo->bmiHeader.biClrUsed		=0;		//
	bitInfo->bmiHeader.biCompression	=BI_RGB;//no compression.. BI_JPEG - jpg comp
	bitInfo->bmiHeader.biHeight			=size.cy;	//if negative, then beginning is at the top corner.. else at the lower corner
	bitInfo->bmiHeader.biPlanes			=1;		//must be 1
	bitInfo->bmiHeader.biSize			=sizeof(BITMAPINFOHEADER);
	bitInfo->bmiHeader.biSizeImage		=WIDTH_IN_BYTES((cx)*8)*size.cy;
	bitInfo->bmiHeader.biWidth			=cx;
	memcpy(bitInfo->bmiColors, colors, sizeof(RGBQUAD)*256); // copies color quad values...
	
	pWindowDC = new CWindowDC(this);

	HBITMAP hbm=CreateDIBSection(pWindowDC->m_hDC,bitInfo,
		DIB_RGB_COLORS,
		(void**)&pBeginning,
		NULL,		//no mapping
		0
		);
	delete bitInfo;		//not necessary any more :P
	if (hbm==NULL) return false;
	cbPicture.Attach(hbm);

	pMemoryDC = new CDC;
	if (pMemoryDC->CreateCompatibleDC(pWindowDC)==NULL)		//Links pMemoryDC with pWindowDC
		return false;

	pMemoryDC->SelectObject(&cbPicture);	//cbPicture is now as graphical object
	TRACE("BITMAP LOPP");
	first_load=true;
	return true;
	
}

bool Graph::CreateBgBitmap()
{
	CRect rect;
	GetClientRect(&rect);
	CSize size = rect.Size();
	long cx=size.cx;
	TRACE("WIDHT cx=%i", cx);
	BITMAPINFO * bitInfo;
	bitInfo= (BITMAPINFO*) new BYTE[sizeof(BITMAPINFOHEADER) + (256*sizeof(RGBQUAD))];
	bitInfo->bmiHeader.biBitCount		=8;		//bits per pixel
	bitInfo->bmiHeader.biClrImportant	=0;		//all colors are important
	bitInfo->bmiHeader.biClrUsed		=0;		//
	bitInfo->bmiHeader.biCompression	=BI_RGB;//no compression.. BI_JPEG - jpg comp
	bitInfo->bmiHeader.biHeight			=size.cy;	//if negative, then beginning is at the top corner.. else at the lower corner
	bitInfo->bmiHeader.biPlanes			=1;		//must be 1
	bitInfo->bmiHeader.biSize			=sizeof(BITMAPINFOHEADER);
	bitInfo->bmiHeader.biSizeImage		=WIDTH_IN_BYTES((cx)*8)*size.cy;
	bitInfo->bmiHeader.biWidth			=cx;
	memcpy(bitInfo->bmiColors, colors, sizeof(RGBQUAD)*256); // copies color quad values...
	
	HBITMAP hbm=CreateDIBSection(pWindowDC->m_hDC,bitInfo,
		DIB_RGB_COLORS,
		(void**)&pBgBeginning,
		NULL,		//no mapping
		0
		);
	delete bitInfo;		//not necessary any more :P
	if (hbm==NULL) return false;
	cbBgPicture.Attach(hbm);
	pBgMemoryDC = new CDC;
	if (pBgMemoryDC->CreateCompatibleDC(pWindowDC)==NULL)		//Links pBgMemoryDC with pWindowDC
		return false;

	pBgMemoryDC->SelectObject(&cbBgPicture);					//cbBgPicture is now as graphical object
	return true;
}

void Graph::RePaintGraph()
{
		//PrintGreenOnes();		//green
		RedrawGraph();			//lines
		UpdateText();			//numbers
		PaintGraph();			//memory to video	
}

void Graph::UpdateWholeGraph()
{
	//updates all graph, including bounds
	CalculateBounds();
	RedrawGraph();
	UpdateText();			//numbers
	PaintGraph();			//memory to video	

}


void Graph::PaintGraph()
{
	CSize size=this->GetClientRectSize();
	CSize bitm=this->GetBitmapSize();
	pWindowDC->SetStretchBltMode(COLORONCOLOR);
	pWindowDC->BitBlt(0,0,size.cx,size.cy,pBgMemoryDC,0,0,SRCCOPY);
	//pWindowDC->StretchBlt(0,0, size.cx, size.cy, pMemoryDC, 0, 0, bitm.cx, bitm.cy, SRCCOPY);
	pWindowDC->TransparentBlt(0,0, size.cx, size.cy, pMemoryDC, 0, 0, bitm.cx, bitm.cy, bgcolor);
	TRACE("UPDATED\n");
	//this->ValidateRect(NULL);
	if (pTextGraph!=NULL)
	{
		pTextGraph->PaintGraph();
		pTextGraph->FillBackground();

	}
	//pWindowDC->BitBlt(0,0,size.cx,size.cy,pMemoryDC,0,0,SRCCOPY);
	//first zeroes - to copy.. last zeroes - from where to copy
	unsigned long cx, crealx;
	if (params[_T("ChangeOccurred")]==1)
	{
		dynGridStep=params[_T("Step")];			//change step
		if (params[_T("Hide")]==1)				//reboot area if necessary
		{
			cx=GetBitmapSize().cx;
			crealx=this->GetClientRectSize().cx;
			if (cx>crealx)
			{
				ClearEverything();
				wide_area_width=crealx;
				CreateBitmap();
			}
			increase_now=false;
			increase_amount=0;					//reboots amount count
		}
		params[_T("ChangeOccurred")]=0;
		UpdateWholeGraph();						//updates everything
	}
	if (increase_now)
	{
		//extra part
		while (increase_now)
		{
			TRACE("INCREASE NOW\n");
			cx=GetBitmapSize().cx + (unsigned long)(GetBitmapSize().cx*INCREASE);
			ClearEverything();
			wide_area_width=cx;
			CreateBitmap();			//enlarges, causing increase_amount to increase
			RedrawGraph();
		}

		increase_now=false;
		UpdateWholeGraph();			//recursively tries to update everything
	}

}

void Graph::PrintGreenOnes()
{
	
	BYTE *p;
	unsigned int i, j;
	if (gridindex<=0) gridindex=GRIDSPACE;
	CSize size = this->GetClientRectSize();
	CSize bitsize = this->GetBitmapSize();
	//starting from bottom-left of the CStatic
	for (i=0; i<size.cy; i++)
	{
		p=pBgBeginning + WIDTH_IN_BYTES(size.cx*8) * i;
		for (j=0; j<text_space; j++)
				*p++=(BYTE)255;
		for (j=text_space; j<size.cx-gridindex; j++)
		{
			if (i%GRIDSPACE==0)	//if this is the 'green' row
				*p++=(BYTE)0;
			else
			{
				if (j==text_space)		//the first pixel
					for (int k=0; k<gridindex; k++)	//fills with black first pixels
						*p++=(BYTE)255;
				if ((j-text_space)%GRIDSPACE==0)	//now, the pointer is moved (depending on gridindex)
					*p++=(BYTE)0;
				else
					*p++=(BYTE)255;

			}
		}
	}
	unsigned int temp=(unsigned int)(dynGridStep/(bitsize.cx/size.cx));
	gridindex-= temp > 0 ? temp : 1  ;	//step is 3 pixels per 'new data' (move)
}

bool Graph::CheckBounds()
{
	if (upper ==0 && lower==0) return false;
	else if (upper<=lower) return false;
	else return true;
}

void Graph::CalculateBounds()
{
	//in case there is no new data, we'll recalculate bounds on params change
	vector<unsigned int>::iterator max_pos;
	vector<unsigned int>::iterator min_pos;
	CSize size = this->GetBitmapSize();
	unsigned int viewable_steps=(unsigned int)(size.cx/dynGridStep)+1;
	if (topValues.size()>viewable_steps && params[_T("Hide")]==1)							//if more values, than can view (min should be syncroned)
	{
		max_pos=max_element(topValues.end()-viewable_steps, topValues.end());
		min_pos=min_element(botValues.end()-viewable_steps, botValues.end());
	}
	else
	{
		max_pos=max_element(topValues.begin(), topValues.end());
		min_pos=min_element(botValues.begin(), botValues.end());
	}

	if (!CheckBounds()){
		if (topValues.empty() || botValues.empty())
		{
			//AfxMessageBox("EMTPY");
			return;
		}
		if (((*max_pos)-(*min_pos))>=relative_height)
		{
			minimum = (*min_pos);
			maximum = (*max_pos);
			d_linevalues=(*max_pos)-(*min_pos);				//TOPBOTMARGIN for emtpy space
			ratio=(double)d_linevalues/(double)relative_height;							//new ratio
		}
		else
		{
			// if graph above the height, range starts from higher position than 0 (from minimum)
			if ((*max_pos)>relative_height)
				minimum = (*min_pos);
			else minimum=0;
			d_linevalues=relative_height;
			maximum=(*max_pos);
			ratio=1;
		}
	}
	else
	{
		d_linevalues=upper-lower;			//GLOBAL in class!!!
		ratio=(double)(d_linevalues)/(double)relative_height;
		minimum = lower;
		maximum=upper;
	}

}

void Graph::CalculateBounds(vector<unsigned int> &data)
{

	//calculates new ratio (in seeable area only!)
	vector<unsigned int>::iterator max_pos;
	vector<unsigned int>::iterator min_pos;
	CSize size = this->GetBitmapSize();
	unsigned int viewable_steps=(unsigned int)(size.cx/dynGridStep)+1;

	max_pos=max_element(data.begin(), data.end());					//maximum of values
	min_pos=min_element(data.begin(), data.end());					//minimum of values
	topValues.push_back(*max_pos);										//new value is inserted
	botValues.push_back(*min_pos);										//new min value is inserted
	if (topValues.size()>viewable_steps && params[_T("Hide")]==1)							//if more values, than can view (min should be syncroned)
	{
		max_pos=max_element(topValues.end()-viewable_steps, topValues.end());
		min_pos=min_element(botValues.end()-viewable_steps, botValues.end());
	}
	else
	{
		max_pos=max_element(topValues.begin(), topValues.end());
		min_pos=min_element(botValues.begin(), botValues.end());
	}
	if (!CheckBounds()){

		if (((*max_pos)-(*min_pos))>=relative_height)
		{
			minimum = (*min_pos);
			maximum = (*max_pos);
			d_linevalues=(*max_pos)-(*min_pos);				//TOPBOTMARGIN for emtpy space
			ratio=(double)d_linevalues/(double)relative_height;							//new ratio
		}
		else
		{
			// if graph above the height, range starts from higher position than 0 (from minimum)
			if ((*max_pos)>relative_height)
				minimum = (*min_pos);
			else minimum=0;
			d_linevalues=relative_height;
			maximum=(*max_pos);
			ratio=1;
		}
	}
	else
	{
		d_linevalues=upper-lower;			//GLOBAL in class!!!
		ratio=(double)(d_linevalues)/(double)relative_height;
		minimum = lower;
		maximum=upper;
	}

}


bool Graph::AddAndDraw(long int id, vector<unsigned int> data)
{
	//returns false if const mode and amount is full
	if (params[_T("StopAmount")]!=0 && params[_T("StopAmount")]<mDataseg.size())
		return false;
	//there are values of different lines in the vector (it means, vector dimensions represent line count)
	//id is for mapping.. because, values are sorted by id in the std::map
	//searching for max element
	if (!data.empty())
	{
		mDataseg.insert(pair<long int, vector<unsigned int> >(id, data));
		CalculateBounds(data);

		PrintGreenOnes();		//green
		RedrawGraph();			//lines
		UpdateText();			//numbers
		PaintGraph();			//memory to video
	}
	return true;
}

bool Graph::AddAndDraw(map<long int, vector<unsigned int> > data, long int extraID)
{
	//returns false if const mode and amount is full
	TRACE("MAP INSERTED AddAndDraw\n");
	if (params[_T("StopAmount")]!=0 && (UINT)params[_T("StopAmount")]<(UINT)mDataseg.size())
		return false;
	//for inserting multiple steps
	long int ID;
	ID=0;
	map<long int, vector<unsigned int> >::reverse_iterator	riter;
	map<long int, vector<unsigned int> >::iterator			iter;
	riter = mDataseg.rbegin();
	//id = riter->first;
	ID+=extraID;				//new index
	//copying data array to mDataseg
	iter=data.begin();
	while(iter!=data.end())
	{
		mDataseg.insert(pair<long int, vector<unsigned int> >(ID, iter->second));
		CalculateBounds(iter->second);		//for calculating new ratio, considering each vector
		iter++;
		ID++;
	}
	PrintGreenOnes();
	RedrawGraph();
	UpdateText();
	PaintGraph();
	return true;
}

//void Graph::RedrawGraph()
//{
//	unsigned int size_x, size_y;
//	size_x=this->GetClientRectSize().cx;
//	size_y=this->GetClientRectSize().cy;
//	pMemoryDC->SetMapMode(MM_ANISOTROPIC);
//	pMemoryDC->SetViewportOrg(0,0);
//	pMemoryDC->SetWindowExt(size_x*10, size_y);	//nii8elda loogilised yhikud
//	pMemoryDC->SetViewportExt(size_x,size_y);
//
//	pMemoryDC->SetWindowOrg(0,0);
//
//	
//
//	
//	
//	//pMemoryDC->SetWindowExt(100, 100);	//nii8elda loogilised yhikud
//	//pMemoryDC->SetViewportExt(this->GetClientRectSize().cx, this->GetClientRectSize().cy); //device units
//
//	
//	//
//	CPen *pen;
//	pen =new CPen(PS_SOLID, 1, vColorLine[LINECOLOR_START_POS+0]);
//	pMemoryDC->SelectObject(pen);
//	pMemoryDC->SetBkMode(TRANSPARENT);
//	pMemoryDC->MoveTo(0, 1);
//	pMemoryDC->LineTo(size_x/2, 1);
//	delete pen;
//
//
//}

void Graph::RedrawGraph()
{
	map<long int, vector<unsigned int> >::reverse_iterator iter;
	iter = mDataseg.rbegin();
	unsigned long i;
	CPen *pen;
	CRect rect;
	//this->GetClientRect(&rect);
	unsigned long cx = this->GetBitmapSize().cx;
	i=cx-1;
	this->FillBackground();			//with background color
	while (iter!=mDataseg.rend() && i>=text_space)
	{
		last_y = i;
		if (pvLastDataseg==NULL)
			pvLastDataseg=&iter->second;

		else
		{
			unsigned int pen_width;
			if (params[_T("Hide")]!=0)
			pen_width=2;
			else
			{
				if (increase_amount<=3)
					pen_width=2;
				else if (increase_amount <=6)
					pen_width=3;
				else if (increase_amount <=9)
					pen_width=4;
				else if (increase_amount <=12)
					pen_width=6;
				else if (increase_amount <=15)
					pen_width=7;
				else if (increase_amount <=18)
					pen_width=8;
				else pen_width=10;
				
			}

			for (unsigned int j=0; j<(iter->second.size()); j++)	//searching for all kind of lines
			{
				pen =new CPen(PS_SOLID, pen_width, vColorLine[LINECOLOR_START_POS+j]);
				pMemoryDC->SelectObject(pen);
//				pMemoryDC->SetBkMode(TRANSPARENT);
				//Autoscaling with variable ratio! (y=(ratio*height_inpix - value)/ratio)
				pMemoryDC->MoveTo(i, CalculateYCoord((*pvLastDataseg)[j]));
				pMemoryDC->LineTo(i-dynGridStep, CalculateYCoord(iter->second[j]));
				delete pen;
			}
			pvLastDataseg=&iter->second;
			if (i>=dynGridStep) i-=dynGridStep;
			//If not hiding, compacting
			
		}
		if (i<(text_space + 2*dynGridStep) && params[_T("Hide")]==0 ) increase_now=true;
			else increase_now=false;
		iter++;
	}
	pvLastDataseg=NULL;
}

int Graph::CalculateYCoord(unsigned int y)
{
	//considers margins too
	//return CheckBounds() ? (int)(y*ratio) : (int)((ratio*relative_height-(y-minimum))/ratio)+TOPBOTMARGIN;
	return (int)((ratio*relative_height-(y-minimum))/ratio)+TOPBOTMARGIN;
}

void Graph::UpdateBounds(unsigned int x, unsigned int y)
{
	upper=x;
	lower=y;
}

void Graph::UpdateText()
{
	unsigned int i;	
	unsigned int maximum, temp, text_pos;	//maximum value of the graph
	double coef;					//coefficent
	tstring str;
	maximum=minimum+d_linevalues;
	coef=(d_linevalues)/(TEXT_COUNT-1);
	for (i=0; i<TEXT_COUNT; i++)
	{
		text_pos=(unsigned int)((relative_height+TOPBOTMARGIN-TEXT_SIZE)-(relative_height/(TEXT_COUNT-1)*i));
		temp=(unsigned int)(i*coef+minimum);
		temp/=2;									//FOR PRECISION
		temp*=2;
		if (i==0) temp = minimum;					//for correct boundary values
		else if (i==TEXT_COUNT-1) temp=maximum;
		str=intConverter.NrToStr(temp);
		if (pTextGraph!=NULL)
			pTextGraph->TextOut(text_pos, str);
		else if (text_space>0)
			pMemoryDC->ExtTextOut(5,text_pos,ETO_OPAQUE,NULL,str.c_str(),NULL);
	}
}

void Graph::TextOut(unsigned int t, tstring t3){}	//no use for this class
void Graph::FillBackground(){
	pMemoryDC->FillSolidRect(0,0, this->GetBitmapSize().cx, this->GetBitmapSize().cy,bgcolor);
}						//no use for this class


void LTexts::TextOut(unsigned int text_pos, tstring str)
{
	this->pMemoryDC->ExtTextOut(5,text_pos,ETO_OPAQUE,NULL, str.c_str(), NULL);
}

void LTexts::FillBackground()
{
	pMemoryDC->FillSolidRect(0,0, this->GetClientRectSize().cx, this->GetClientRectSize().cy,bgcolor);
}

void LTexts::PaintGraph()
{
	CSize size=this->GetClientRectSize();
	pWindowDC->BitBlt(0,0,size.cx,size.cy,pMemoryDC,0,0,SRCCOPY);
}

void LTexts::OnPaint()
{
	PAINTSTRUCT ps;
	CDC* pDC = BeginPaint (&ps);
	g->RePaintGraph();
	EndPaint (&ps);
}