/*Data in the file:
1..n:	values
n+1:	-1
...		values
...		-1
*/

//Mingi jama tqttu Visual studios ei saa template Cpp faili panna
template <class _Type> class FileReader
{
private:
	tstring		filename;
	ifstream	input;
	bool		isAttached;				//if filename is attached to tstring
	void		ReadEntries(vector<_Type> &);				//reads entry from file
	void		ReadEntries(map<long int, vector<_Type> >&);
	void		ReadStringLine(tstring &);
	bool		first_read_done;		//if first read is done, then true
public:
	bool Reboot();					//for new file
	FileReader(tstring name);		//constructor with filename
	FileReader();					//constructor without filename
	~FileReader();
	bool Open();					//opens file with default filename
	bool Open(tstring);				//opens file with new filename -  updates filename too
	bool IsOpen();					//if is opened..
	bool IsFirstDone();				//
	void SetFirstReadFalse();		//after stopping..
	void operator>>(vector<_Type>&);		//overloaded operator >>
	void operator>>(map<long int, vector<_Type> >&);
	void operator>>(tstring &);		//for reading a string
	void ClearFile();
	void WriteShit(_Type);

	// 2 control functions if the file is attached
	tstring GetFileName();
	bool IsAttached();
};

//2 IMPORTANT CONTROL FUNCTIONS

template <class _Type> bool FileReader<_Type>::IsAttached()
{
	return isAttached;
}

template <class _Type> tstring FileReader<_Type>::GetFileName()
{
	if (isAttached) return filename;
	else return tstring("");
}


template <class _Type> bool FileReader<_Type>::Reboot()
{
	if (input.is_open()) input.close();
	input.clear();
	SetFirstReadFalse();
	filename.clear();
	isAttached=false;
	return true;
}

template <class _Type> void FileReader<_Type>::ClearFile()
{
	if (input.is_open()) input.close();
	ofstream  x(filename.c_str());
	x.close();
	//reopens file
	this->Open();
}
	

template <class _Type> bool FileReader<_Type>::Open(tstring x)
{
	if (input.is_open()) input.close();
	if (x.length()==0)
		return false;
	filename=x;
	isAttached=true;
	input.open(filename.c_str());
	if (input.is_open())
		return true;
	else return false;
}


//overloaded operator >> for reading vector from file
template <class _Type> void FileReader<_Type>::operator>>(vector<_Type> &x){
	if (isAttached && IsOpen())
		ReadEntries(x);
}

template <class _Type> void FileReader<_Type>::operator>>(map<long int, vector<_Type> >&x){
	if (isAttached && IsOpen())
	{
		ReadEntries(x);
		if (!first_read_done) first_read_done=true;
	}
}

template <class _Type> void FileReader<_Type>::operator>>(tstring &inp_str){

	if (isAttached && IsOpen()){
		ReadStringLine(inp_str);
	}

}

template <class _Type> FileReader<_Type>::FileReader()
{
	isAttached=false;
	first_read_done=false;
}

template <class _Type> FileReader<_Type>::FileReader(tstring x)
{
	isAttached=true;
	filename=x;
	first_read_done=false;
}

template <class _Type> FileReader<_Type>::~FileReader()
{
	input.close();
}

//tries to open the file attached to filename object
template <class _Type> bool FileReader<_Type>::Open()
{
	if (input.is_open()) input.close();
	if (!isAttached)
		return false;
	input.open(filename.c_str());
	if (input.is_open())
		return true;
	else return false;
}
//tries to open the file x

//checks if the file is open
template <class _Type> bool FileReader<_Type>::IsOpen()
{
	return input.is_open() ? true : false;
}

template <class _Type> bool FileReader<_Type>::IsFirstDone()
{
	return first_read_done;
}

template <class _Type> void FileReader<_Type>::SetFirstReadFalse()
{
	first_read_done=false;
}

template <class _Type> void FileReader<_Type>::ReadStringLine(tstring &inp_str)
{
	//reads only the last line of the file
	inp_str.clear();
	tstring temp;
	input.clear(ios::goodbit);
	while (!input.eof())
	{
		getline(input,temp, '\n');
		if (!temp.empty())
			inp_str=temp;
	}
	//input.seekg(0);


}


//will be called only if isAttached and IsOpen
template <class _Type> void FileReader<_Type>::ReadEntries(vector<_Type> &entries)
{
	//first clears the vector entries!!!
	entries.clear();
	_Type in;
	in = (_Type)0;
	int first_pointer;
	input.clear(ios::goodbit);	//clears the eof bit (check the rdstate() function)
	first_pointer=input.tellg();
	while (!input.eof() && in!=-1)
	{
		input >> in;
		if (in != -1) entries.push_back(in);
	}
	if (input.eof() && in!=-1) // all data couldn't be read... it means data end marker wasan't found
	{
		input.clear(ios::goodbit);
		input.seekg(first_pointer);
		entries.clear();
	}
}

template <class _Type> void FileReader<_Type>::ReadEntries(map<long int, vector<_Type> >&entries)
{
	vector<_Type> subentry;		//vector for item
	entries.clear();			//clears the map to fill it with new items
	long int index=0;
	do
	{
		ReadEntries(subentry);
		if (!subentry.empty())
		{
			entries.insert(pair<long int, vector<_Type> >(index, subentry));
			index++;
		}
	}while (!subentry.empty());
}

template <class _Type> void FileReader<_Type>::WriteShit(_Type a)
{	
	ofstream output;
	output.open(filename.c_str(), ios::app);
	output << 150 << endl << 180 <<endl << 5000 << endl << -1 << endl;
	output.flush();
	output.close();
}
