clear all;
close all;

filename = 'testPlanes';

vecs = 10000;

a = [0 0 1; 1 -1 0; 1 1 0];

atoms = dlmread(filename, ' ', 2, 0);
n = size(atoms, 1);
devs = zeros(vecs, 1);

for i = 1:vecs
    a1 = 0;
    a2 = 0;
    a3 = 0;
    while a1 == a2 || a1 == a3 || a2 == a3
        a1 = randi(n, 1);
        a2 = randi(n, 1);
        a3 = randi(n, 1);
    end
    v1 = atoms(a1,:)-atoms(a2,:);
    v2 = atoms(a1,:)-atoms(a3,:);
    vec = cross(v1,v2);
    vec = vec*a;
    devs(i) = acos(dot(vec,[1 1 -1])/(norm(vec)*norm([1 1 1]))) * 180 / pi;
    devs(i) = min(devs(i), 180 - devs(i));
end

m = mean(devs);
st = std(devs);


hist(devs, sqrt(size(devs, 1)))