#!/bin/bash

function gendia {
AGRFILE="$1"
PNGFILE="$2"
DATFILEMASK="$3"
MINX="$4"
MAXX="$5"
MAXY="$6"
MAXCN="$7"
XLABEL="$8"
XSCALE="$9"

YMAJOR=0.5; YMINOR=4
gawk "BEGIN {exit !($MAXY > 8)}" && YMAJOR=1; YMINOR=4
gawk "BEGIN {exit !($MAXY > 20)}" && YMAJOR=10; YMINOR=4
gawk "BEGIN {exit !($MAXY > 200)}" && YMAJOR=100; YMINOR=4
CNMAJOR=0.5; CNMINOR=4
gawk "BEGIN {exit !($MAXCN > 5)}" && CNMAJOR=1; CNMINOR=4
gawk "BEGIN {exit !($MAXCN > 15)}" && CNMAJOR=2; CNMINOR=1

DATFILE1="${DATFILEMASK//#/3}"
DATFILE2="${DATFILEMASK//#/5}"
DATFILE3="${DATFILEMASK//#/8}"
DATFILE4="${DATFILEMASK//#/16}"

echo -e "@target G0.S0\n@type xy" >> $AGRFILE
gawk '{print $1,$2}' < "$DATFILE1" >> $AGRFILE
echo "&" >> $AGRFILE
AGRSCRIPT="agr-print"
cat <<END > $AGRFILE
# Grace project file
#
@version 50121
@page size 667, 417
@page scroll 5%
@page inout 5%
@link page off
@PRINT TO "$PNGFILE"
@HARDCOPY DEVICE "PNG"
@map font 2 to "Times-Bold", "Times-Bold"
@map font 3 to "Times-BoldItalic", "Times-BoldItalic"
@map font 1 to "Times-Italic", "Times-Italic"
@map font 0 to "Times-Roman", "Times-Roman"
@map color 0 to (255, 255, 255), "white"
@map color 1 to (0, 0, 0), "black"
@map color 2 to (255, 0, 0), "red"
@map color 3 to (0, 255, 0), "green"
@map color 4 to (0, 0, 255), "blue"
@map color 5 to (255, 0, 255), "magenta"
@map color 6 to (188, 143, 143), "brown"
@map color 7 to (220, 220, 220), "grey"
@default linewidth 2.5
@default linestyle 1
@default color 1
@default font 0
@default char size 1.000000
@default symbol size 1.000000
@default sformat "%.8g"
@g0 on
@g0 bar hgap 0.000000
@with g0
@    world $MINX, 0, $MAXX, $MAXY
#@    view 0.150000, 0.150000, 1.150000, 0.850000
@    view 0.12, 0.09, 1.56, 0.98
#@    title "Shape distribution"
#@    xaxis  label "Distance /"
@    xaxis  label "$XLABEL"
@    xaxis  label font 2
#@    xaxis  tick major 1
#@    xaxis  tick minor ticks 4
@    xaxis  tick out
@    xaxis  tick major linewidth 2.5
@    xaxis  tick minor linewidth 2.5
@    xaxis  ticklabel font 2
@    xaxis  tick place normal
@    yaxis  label "Distribution /arb. units"
@    yaxis  label font 2
@    yaxis  tick major $YMAJOR
@    yaxis  tick minor ticks $YMINOR
@    yaxis  tick out
@    yaxis  tick major linewidth 2.5
@    yaxis  tick minor linewidth 2.5
@    yaxis  ticklabel off
@    yaxis  tick place normal
@    legend 0.2, 0.9
@    legend box linestyle 0
@    legend length 8
@    frame linewidth 2.5
@    s0 line linestyle 1
@    s0 line color 1
@    s0 comment "$DATFILE1"
@    s0 legend  "2.7% polymer content"
@    s1 line linestyle 2
@    s1 line color 2
@    s1 comment "$DATFILE2"
@    s1 legend  "5.4% polymer content"
@    s2 line linestyle 3
@    s2 line color 3
@    s2 comment "$DATFILE3"
@    s2 legend  "8.1% polymer content"
@    s3 line linestyle 5
@    s3 line color 4
@    s3 comment "$DATFILE4"
@    s3 legend  "16.2% polymer content"
END

function copy_data {
	DATFILE="$1"
	AGRFILE="$2"
	TARGET="$3"
	XCOL="$4"
	YCOL="$5"
	XSCALE="$6"
	echo -e "@target $TARGET\n@type xy" >> $AGRFILE
	gawk "{print $XSCALE*\$$XCOL,\$$YCOL}" < "$DATFILE" >> $AGRFILE
	echo "&" >> $AGRFILE
}

copy_data "$DATFILE1" "$AGRFILE" "G0.S0" 1 2 $XSCALE
copy_data "$DATFILE2" "$AGRFILE" "G0.S1" 1 2 $XSCALE
copy_data "$DATFILE3" "$AGRFILE" "G0.S2" 1 2 $XSCALE
copy_data "$DATFILE4" "$AGRFILE" "G0.S3" 1 2 $XSCALE

cat <<END > $AGRSCRIPT
PAGE SIZE 2000, 1200
PRINT
END

grace $AGRFILE -batch $AGRSCRIPT -hardcopy -nosafe
}

gendia hist.agr    carbon-bondlen-npt.png    system-#-npt/histLen.dat   0.0 5.0 250000.0 X "Bond length /" 0.01
gendia hist.agr    carbon-bondlen-nvt.png    system-#-nvt/histLen.dat   0.0 5.0 250000.0 X "Bond length /" 0.01
gendia hist.agr    carbon-bondlen-e-npt.png  system-#e-npt/histLen.dat  0.0 5.0 250000.0 X "Bond length /" 0.01
gendia hist.agr    carbon-bondlen-e-nvt.png  system-#e-nvt/histLen.dat  0.0 5.0 250000.0 X "Bond length /" 0.01

gendia hist.agr    carbon-bondang-npt.png    system-#-npt/histAng.dat   0.0 180.0 200000.0 X "Valence angle /deg" 1
gendia hist.agr    carbon-bondang-nvt.png    system-#-nvt/histAng.dat   0.0 180.0 200000.0 X "Valence angle /deg" 1
gendia hist.agr    carbon-bondang-e-npt.png  system-#e-npt/histAng.dat  0.0 180.0 200000.0 X "Valence angle /deg" 1
gendia hist.agr    carbon-bondang-e-nvt.png  system-#e-nvt/histAng.dat  0.0 180.0 200000.0 X "Valence angle /deg" 1

gendia hist.agr    carbon-bonddih-npt.png    system-#-npt/histDih.dat   0.0 180.0 200000.0 X "Dihedral angle /deg" 1
gendia hist.agr    carbon-bonddih-nvt.png    system-#-nvt/histDih.dat   0.0 180.0 200000.0 X "Dihedral angle /deg" 1
gendia hist.agr    carbon-bonddih-e-npt.png  system-#e-npt/histDih.dat  0.0 180.0 200000.0 X "Dihedral angle /deg" 1
gendia hist.agr    carbon-bonddih-e-nvt.png  system-#e-nvt/histDih.dat  0.0 180.0 200000.0 X "Dihedral angle /deg" 1


