import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.UIDefaults;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.NamedNodeMap;

public class View extends JPanel implements MouseListener, MouseMotionListener, ChangeListener {
	// sux
	private static final long serialVersionUID = 1L;

	List<DriveButtons> buttons;
	Image bkgnd = null;
	float bkgndScale = 1.0f;
	boolean center = false;
	int bkX, bkY;
	
	Dimension prefered;
	int prevW, prevH;
	BufferedImage dblBuf;
	Graphics dblGraph;
	String name;
	static LinkedList<View> allViews;
	
	static {
		allViews = new LinkedList();
	}
	
	public void stateChanged(ChangeEvent e) {
		/*System.out.println("change detected " + e);
		if (((JTabbedPane)e.getSource()).getSelectedComponent() == this) {
			System.out.println("name" + name);
		}*/
		for (Iterator<View> iter = allViews.iterator(); iter.hasNext(); ) {
			iter.next().hideTips();
		}
	}
	
	public void hideTips() {
		for (Iterator<DriveButtons> iter = buttons.iterator(); iter.hasNext(); ) {
			iter.next().hideTip();
		}
	}

	public Dimension getPreferredSize() {
		return prefered;
	}
	
	/**
	 * Analyses given "View" XMLNode.
	 * <config>
	 *   <actuator name="hips2">
	 *     <motor id="32" inverted="false" if="left"/>
	 *     <motor id="33" inverted="false" if="right"/>
	 *   </actuator>
	 *   <View name="name" sizeX="500" sizeY="400">
	 *     <background x="100" y="200" picture="picture_name.jpg" scale="80" center="true"/>
	 *     <button x="100" y="200" style="right" tip="o~lad laiemaks">
	 *       <actuator name="shoulders_apart" direction="+"/>
	 *       <actuator name="shoulders_apart1" direction="-"/>
	 *	   </button>
	 *   </View>
	 * </config>
	 */
	 
	private void read(Node node) {
		System.out.println("reading view");
		NamedNodeMap attrs = node.getAttributes();
		name = attrs.getNamedItem("name").getNodeValue();
		//Node sizeXnd = attrs.getNamedItem("sizeX");
		//Node sizeYnd = attrs.getNamedItem("sizeY");
		
		try {
			int sizeX = Integer.parseInt(attrs.getNamedItem("sizeX").getNodeValue());
			int sizeY = Integer.parseInt(attrs.getNamedItem("sizeY").getNodeValue());
			prefered.setSize(sizeX, sizeY);
			
			NodeList children = node.getChildNodes();
			System.out.println("parsing View's children");
			for (int i = 0; i < children.getLength(); i++) {
				
				Node n = children.item(i);
				System.out.println("reading view's child "+i + " " + n.getNodeName() + " " + n.getNodeValue());
				if (n.getNodeName().equals("Background")) {
					readBackground(n);
				} else if (n.getNodeName().equals("Button")) {
					buttons.add(new DriveButtons(n, this));
				}
			}
		} catch (NumberFormatException e) {
			System.exit(0);
		}
	}
	
	/**
	 * reads 
	 * <background x="100" y="200" picture="picture_name.jpg" scale="80" center="true"/>
	 */
	private void readBackground(Node node) {
		System.out.println("reading background");
		NamedNodeMap attrs = node.getAttributes();
		
		try {
			bkX = Integer.parseInt(attrs.getNamedItem("x").getNodeValue());
			bkY = Integer.parseInt(attrs.getNamedItem("y").getNodeValue());
			String fileName = attrs.getNamedItem("picture").getNodeValue();
			bkgnd = ImageIO.read(new File(fileName));
			if (bkgnd == null) {
				System.exit(0);
			}
			bkgndScale = Integer.parseInt(attrs.getNamedItem("scale").getNodeValue());
			bkgndScale /= 100;
			center = Boolean.parseBoolean(attrs.getNamedItem("center").getNodeValue());
			if (bkgndScale != 1.0f) {
				bkgnd = bkgnd.getScaledInstance(
					(int) (bkgnd.getWidth(null) * bkgndScale), (int) (bkgnd
							.getHeight(null) * bkgndScale), Image.SCALE_SMOOTH);
			}
			if (center) {
				bkX += (prefered.width - bkgnd.getWidth(null)) / 2;
				bkY += (prefered.height - bkgnd.getHeight(null)) / 2;
			}
		} catch (NumberFormatException e) {
			System.out.println(e);
			System.exit(0);
		} catch (IOException e) {
			System.out.println(e);
			System.exit(0);
		}
	}


	private View() {
		super();
		buttons = new LinkedList();
		prefered = new Dimension(800, 500);
		addMouseListener(this);
		addMouseMotionListener(this);
		allViews.add(this);
		// buttons.add(new DriveButtons(100, 50, DriveButtons.DIR_APART_VERT, 0,
		// 0));
	}

	public View(Node node) {
		this();
		/*UIDefaults uid = new UIDefaults();
		setUI(uid.getUI(new JTabbedPane()));*/
		read(node);
	}

	public void update(Graphics g) {
		if ((prevH != getHeight()) || (prevW != getWidth()) || (dblBuf == null)) {
			// allocate new buffer
			dblBuf = null;
			while (dblBuf == null) {
				dblBuf = new BufferedImage(getWidth(), getHeight(),
						BufferedImage.TYPE_INT_ARGB);
			}
			
			System.out.println("prev " + prevW + "," + prevH + "  now "
					+ getWidth() + "," + getHeight());
			dblGraph = dblBuf.getGraphics();
			prevH = getHeight();
			prevW = getWidth();
		}
		//dblGraph.setColor(Color.RED);
		dblGraph.clearRect(0, 0, getWidth(), getHeight());
		//dblGraph.fillRect(0, 0, getWidth(), getHeight());
		paint(dblGraph);
		g.drawImage(dblBuf, 0, 0, null);
	}

	public void paint(Graphics g) {
		super.paint(g);
		
		g.drawImage(bkgnd, bkX, bkY, null);
		
		for (Iterator i = buttons.iterator(); i.hasNext();) {
			DriveButtons btn = (DriveButtons) (i.next());
			btn.paint(g);
		}
	}

	public static void main(String[] args) {
		Main.main(args);
	}

	public void mouseClicked(MouseEvent evt) {
	}

	public void mousePressed(MouseEvent evt) {
		boolean needRepaint = false;
		for (Iterator i = buttons.iterator(); i.hasNext();) {
			DriveButtons btn = (DriveButtons) (i.next());
			needRepaint |= btn.handleMouseDown(evt.getX(), evt.getY());
		}
		if (needRepaint) {
			repaint();
		}
	}

	public void mouseReleased(MouseEvent evt) {
		boolean needRepaint = false;
		for (Iterator i = buttons.iterator(); i.hasNext();) {
			DriveButtons btn = (DriveButtons) (i.next());
			needRepaint |= btn.handleMouseUp(evt.getX(), evt.getY());
		}
		if (needRepaint) {
			repaint();
		}
	}

	public void mouseEntered(MouseEvent arg0) {
	}

	public void mouseExited(MouseEvent arg0) {
	}

	public void mouseDragged(MouseEvent arg0) {
	}

	public void mouseMoved(MouseEvent evt) {
		for (Iterator i = buttons.iterator(); i.hasNext();) {
			DriveButtons btn = (DriveButtons) (i.next());
			btn.handleMouseMove(evt.getX(), evt.getY());
		}
	}
}
