import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

import java.io.FilenameFilter;


class MyFileFilter extends FileFilter {
	public String ext;
	public String descr;
	
	public MyFileFilter(String ext, String descr) {
		this.ext = ext;
		this.descr = descr;
	}
	
	public String appendExt(String nm) {
		if (nm.endsWith(ext)) return nm;
		
		if (ext.startsWith(".")) {
			return nm+ext;
		} else {
			return nm+"."+ext;
		}
	}
	
	public String getDescription() {
		return descr;
	}
    
	public boolean accept(File fl) {
		return fl.getName().endsWith(ext) || fl.isDirectory();
	}
}


public class PositionsPanel extends Panel implements ActionListener, LayoutManager, LayoutManager2, KeyListener {
	private static final long serialVersionUID = 1L;

	private static final int SPACING = 10;
	
	JButton getCurrentForm;
	JButton takeForm;
	JButton removeForm;
	JButton clearManneken;
	JButton resetManneken;
	JButton extremeStop;
	JComboBox formList; 
	
	List components;
	
	public void keyPressed(KeyEvent e) {
		int newIndex;
		switch (e.getKeyCode()) {
			case KeyEvent.VK_UP:
				newIndex = formList.getSelectedIndex()-1;
				if (newIndex < 0) newIndex = formList.getItemCount()-1;
				formList.setSelectedIndex(newIndex);
				System.out.println("UUUP");
				break;
			case KeyEvent.VK_DOWN:
				newIndex = formList.getSelectedIndex()+1;
				if (newIndex >= formList.getItemCount()) newIndex = 0;
				formList.setSelectedIndex(newIndex);
				System.out.println("DOWN");
				break;
		}
	}
	
	public void keyReleased(KeyEvent e) {
	}
	
	public void keyTyped(KeyEvent e) {
		if ((e.getKeyChar() == 'p') || (e.getKeyChar() == 'P')) {
			((Position)formList.getSelectedItem()).takeThisPosition();
		}
	}
	
	public static void main(String[] args) {
		Main.main(args);
	}
	
	public Dimension getMaximumSize() {
		return new Dimension(300, 30000);
	}
	
	public PositionsPanel() {
		/** Buttons:
		 *  get figure, save figure, remove figure, load figure.
		 */
		//setLayout(new GridLayout(6, 1));
		//setLayout(new FlowLayout(FlowLayout.LEADING, 0, 20));
		components = new LinkedList();
		addKeyListener(this);
		setLayout(this);
		formList = new JComboBox(Position.allPositions.toArray());
		getCurrentForm = new JButton("Salvesta praegune mannekenni positsioon");
		takeForm = new JButton("Võta valitud positsioon");
		removeForm = new JButton("Eemalda valitud positsioon");
		clearManneken = new JButton("Kõik mootorid algusse");
		resetManneken = new JButton("Reset manneken");
		extremeStop = new JButton("EXTREME STOP");
		
		formList.addActionListener(this);
		getCurrentForm.addActionListener(this);
		takeForm.addActionListener(this);
		removeForm.addActionListener(this);
		clearManneken.addActionListener(this);
		resetManneken.addActionListener(this);
		extremeStop.addActionListener(this);
		
		//formList.addKeyListener(this);
		getCurrentForm.addKeyListener(this);
		takeForm.addKeyListener(this);
		removeForm.addKeyListener(this);
		clearManneken.addKeyListener(this);
		resetManneken.addKeyListener(this);
		extremeStop.addKeyListener(this);
		
		add(formList);
		add(getCurrentForm);
		add(takeForm);
		add(removeForm);
		add(clearManneken);
		add(resetManneken);
		add(new JSeparator());
		add(extremeStop);
	}
	
	public void actionPerformed(ActionEvent evt) {
		if (evt.getSource() == getCurrentForm) {
			String fileName = "";
		

			JFileChooser chooser = new JFileChooser();
			chooser.setAcceptAllFileFilterUsed(false);
			chooser.setFileFilter(new MyFileFilter(".csv", "csv files"));
			File f = new File("confs/positions/");
			chooser.setCurrentDirectory(f);
			
			int returnVal = chooser.showSaveDialog(Main.m);
			if (returnVal == JFileChooser.CANCEL_OPTION) {
				return;
			}
			
			MyFileFilter filt = (MyFileFilter)(chooser.getFileFilter());
			fileName = filt.appendExt(chooser.getSelectedFile().getName());
			
			System.out.println(fileName);
			BoardStatus.requestAllStatuses();
			Position pp = BoardStatus.getPosition(fileName);
			Vector<String> errs = BoardStatus.displayMotorErrorSummary();
			if (errs.size() != 0) {
				RetVal result = new RetVal(1);
				new MotorErrorsMsgBox(errs, result);
				if (result.equals(MotorErrorsMsgBox.OK)) {
					return;
				} else if (result.equals(MotorErrorsMsgBox.FORCE)) {	
					// do nothing just continue saving
					System.out.println("Ignoring errors");
				} else if (result.equals(MotorErrorsMsgBox.RESET_ALL_STUCK)) {
					System.out.println("Resetting stuck motors");
					BoardStatus.resetAllStuck();
					return;
				}
			}
			
			if (pp == null) {
				return;
			}
			
			Position.allPositions.remove(pp);
			Position.allPositions.add(pp);
			
			formList.removeItem(pp);
			formList.addItem(pp);
			
			pp.save();
		} else if (evt.getSource() == takeForm) { 
			((Position)formList.getSelectedItem()).takeThisPosition();
		} else if (evt.getSource() == removeForm) {
			int n = JOptionPane.showConfirmDialog(
				    Main.m,
				    "Kas te tõesti tahate eemaldada see positsioon?",
				    "Küsimus",
				    JOptionPane.YES_NO_OPTION);
			System.out.println("" + n);
			if (n == JOptionPane.YES_OPTION) {
				Position pp = ((Position)formList.getSelectedItem());
				formList.removeItem(pp);
				pp.remove();
			}
		} else if (evt.getSource() == clearManneken) {
			for (Iterator iter = Actuator.allMotors.iterator(); iter.hasNext();) {
				Actuator.Motor m = (Actuator.Motor) iter.next();
				//MotorDriver.defaultDriver.sendMotorMoveEnd(m.motorId, -10);
				MotorDriver.defaultDriver.sendMotorMoveEnd(m.motorId, 10);
			} 
		} else if (evt.getSource() == resetManneken) {
			for (Iterator iter = BoardStatus.allBoards.iterator(); iter.hasNext();) {
				BoardStatus brd = (BoardStatus) iter.next();
				System.out.println("resetting brd" + brd.boardID);
				MotorDriver.defaultDriver.sendReset(brd.boardID);
			}
		} else if (evt.getSource() == extremeStop) {
			for (Iterator iter = BoardStatus.allBoards.iterator(); iter.hasNext();) {
				BoardStatus brd = (BoardStatus) iter.next();
				MotorDriver.defaultDriver.sendStop(brd.boardID);
				System.out.println("board " + brd.boardID + " extreme stop");
			}
		}
	}
	
	public Dimension getPreferredSize() {
		return preferredLayoutSize(null);
	}

	public void addLayoutComponent(String name, Component comp) {
		components.add(comp);
		System.out.println("addComp");
	}

	public void layoutContainer(Container parent) {
		Dimension size = getSize();
		int curY = SPACING;
		for (Iterator iter = components.iterator(); iter.hasNext();) {
			Component comp = (Component) iter.next();
			comp.setBounds(100, curY, size.width-200, comp.getPreferredSize().height);
			curY += SPACING + comp.getPreferredSize().height;
		}
		System.out.println("dolay");
	}

	public Dimension minimumLayoutSize(Container parent) {
		return getPreferredSize();
	}

	public Dimension preferredLayoutSize(Container parent) {
		int minX = 0;
		int minY = 0;
		for (Iterator iter = components.iterator(); iter.hasNext();) {
			Component comp = (Component) iter.next();
			
			minX = Math.max(comp.getPreferredSize().width, minX);
			minY += comp.getPreferredSize().height;
		}
		minY += (components.size() - 1) * SPACING;
		System.out.println("prefLayout " + minX + " " + minY);
		return new Dimension(minX + 2*SPACING, minY + 2*SPACING);
	}

	public void removeLayoutComponent(Component comp) {
		components.remove(comp);
	}

	public void addLayoutComponent(Component comp, Object constraints) {
		addLayoutComponent("d", comp);
	}

	public float getLayoutAlignmentX(Container target) {
		return 0;
	}

	public float getLayoutAlignmentY(Container target) {
		return 0;
	}

	public void invalidateLayout(Container target) {
		layoutContainer(null);
	}

	public Dimension maximumLayoutSize(Container target) {
		return getPreferredSize();
	}
}
