import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.FileNotFoundException;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.LinkedList;

import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.NamedNodeMap;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;

import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;

import javax.xml.transform.stream.StreamResult;
import java.io.FileWriter;
import java.io.FileInputStream;
import java.io.BufferedReader;
import java.io.FileReader;
import org.xml.sax.SAXException;


public class Position {

	public class PositionParseException extends Exception {
		Exception nested;
		
		public PositionParseException(Exception e) {
			super(e);
			nested = e;
		}
		
		public String toString() {
			return "PositionParseException: " + nested;
		}
	}
	
	// ===========================================
	
	class MotorState {
		int motorId;
		int position;
		
		public MotorState(MotorState ms) {
			motorId = ms.motorId;
			position = ms.position;
		}
		
		public MotorState(int id, int pos) {
			motorId = id;
			position = pos;
		}
		
		public MotorState(Node node) throws PositionParseException {
			NamedNodeMap nnm = node.getAttributes();
			for (int i = 0; i < nnm.getLength(); i++) {
				Node attr = nnm.item(i);
				try {
					if (attr.getNodeName().equals("id")) {
						motorId = Integer.parseInt(attr.getNodeValue());
					} else if (attr.getNodeName().equals("pos")) {
						position = Integer.parseInt(attr.getNodeValue());
					}
				} catch (NumberFormatException e) {
					throw new PositionParseException(e);
				}
			}
		}
		
		public MotorState(String csv) throws PositionParseException {
			String parts[] = csv.split(", ");
			int k = 0;
			try {
				for (int i = 0; i < parts.length; i++) {
					if (parts[i].length() != 0) {
						if (k == 0) {
							motorId = Integer.parseInt(parts[i]);
						} if (k == 1) {
							position = Integer.parseInt(parts[i]);
							return;
						}
						k++;
					}
				}
			} catch (NumberFormatException e) {
				throw new PositionParseException(e);
			}
		}
		
		/*public String toCsv() {
		}*/
		
		public Node toXML(Document doc) {
			Element node = doc.createElement("m");
			node.setAttribute("id", ""+motorId);
			node.setAttribute("pos", ""+position);
			return node;
		}
		
		public String toCSV() {
			return "" + motorId + ", " + position;
		}
		
		public String toMyML(String preLine) {
			return preLine + "[motor]\n" + 
				preLine + "\t[nr]"+motorId+"[\\nr]\n" + 
				preLine + "\t[pos]"+position+"[\\pos]\n" + 
				preLine + "[\\motor]\n";
		}
	}
	
	
	
	// ===========================================



	String name;
	LinkedList<MotorState> motorStates;
	
	//static final String POS_FILE_NAME = "confs/positions.myml"; 
	static final String POS_DIR_NAME = "confs/positions/";
	
	public static LinkedList allPositions;
	public static String newline;
	
	static {
		newline = System.getProperty("line.separator");
		allPositions = new LinkedList();
	}
	
	public static void main(String[] args) {
		Main.main(args);
	}
	
	public String toString() {
		return name;
	}
	
	
	public static void parsePositions() {
		File f = new File(POS_DIR_NAME);
		String files[] = f.list();
		
		for (int i = 0; i < files.length; i++) {
			if (files[i].endsWith(".myml") || 
				files[i].endsWith(".xml") || 
				files[i].endsWith(".csv")) {
				try {
					new Position(files[i]);
				} catch (PositionParseException e) {
					System.out.println(e);
				}
			}
		}
	}
	
	static public void MyMLtoCSV() {
		for (Iterator<Position> iter = allPositions.iterator(); iter.hasNext(); ) {
			Position p = iter.next();
			if (p.name.endsWith(".myml")) {
				Position n = new Position(p, ".csv");
				System.out.println(n.name);
				n.save();
			}
		}
		
		Iterator<Position> iter = allPositions.iterator();
		
		while (iter.hasNext()) {
			Position p = iter.next();
			if (p.name.endsWith(".myml")) {
				p.remove();
				iter = allPositions.iterator();
			}
		}
	}
	
	public void remove() {
		// FIXME
		File posConf = new File(POS_DIR_NAME + name);
		posConf.delete();
		allPositions.remove(this);
	}
	
	
	
	
	// ====================================================
	//   MYML STUFF
	// ====================================================
	
	
	
	
	/*public Position(StringBuffer myMLTag) throws PositionParseException {
		motorStates = new LinkedList();
		String tagName;
		while ((tagName = MyML.getNextTagName(myMLTag)) != null) {
			if (tagName.equalsIgnoreCase("motor")) {
				parseAddMotorMyml(MyML.getFirstTagContents(myMLTag));
			} else {
				throw new PositionParseException(new MyMLParseException("ERROR: unexpected tag while parsing position \"" + tagName + "\""));
			}
		}
		
		allPositions.add(this);
	}*/
	
	/**
	 * writes file in MyML format, before this name must be checked to have extension ".myml"
	 */
	private void saveMyML() {
		File posConf = new File(POS_DIR_NAME + name);
		posConf.delete();
		try {
			posConf.createNewFile();
			OutputStreamWriter fout = new OutputStreamWriter(new FileOutputStream(POS_DIR_NAME + name));
			fout.write(toMyML().toString());
			fout.flush();
			fout.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	private void parseAddMotorMyml(StringBuffer motorMyMLTag) throws PositionParseException {
		String tagName;
		MotorState ms = new MotorState(0, 0);
		try {
			while ((tagName = MyML.getNextTagName(motorMyMLTag)) != null) {
				if (tagName.equalsIgnoreCase("nr")) {
					ms.motorId = MyML.parseIntTag(motorMyMLTag);
				} else if (tagName.equalsIgnoreCase("pos")) {
					ms.position = MyML.parseIntTag(motorMyMLTag);
				} else {
					throw new MyMLParseException("ERROR: unexpected tag while parsing position->motor \"" + tagName + "\"");
				}
			}
			motorStates.add(ms);
		} catch (MyMLParseException e) {
			throw new PositionParseException(e);
		}
	}
	
	private void parseMyml(String fileName) throws PositionParseException {
		try {
			StringBuffer fileContents = MyML.readFileIn(POS_DIR_NAME + fileName);
			
			name = fileName;
			System.out.println("reading position " + name);
			
			String tagName = MyML.getNextTagName(fileContents);
			if (!tagName.equals("position")) {
				return;
			}
			
			StringBuffer myMLTag = MyML.getFirstTagContents(fileContents);
			while ((tagName = MyML.getNextTagName(myMLTag)) != null) {
				if (tagName.equalsIgnoreCase("motor")) {
					parseAddMotorMyml(MyML.getFirstTagContents(myMLTag));
				} else {
					throw new MyMLParseException("ERROR: unexpected tag while parsing position \"" + tagName + "\"");
				}
			}
		} catch (MyMLParseException e) {
			throw new PositionParseException(e);
		}
	}
	
	public StringBuffer toMyML() {
		StringBuffer sb = new StringBuffer();
		sb.append("[position]\n");
		//sb.append("\t[name]"+name+"[\\name]\n");
		for (Iterator<MotorState> iter = motorStates.iterator(); iter.hasNext();) {
			MotorState ms = (MotorState) iter.next();
			sb.append(ms.toMyML("\t"));
		}
		sb.append("[\\position]\n");
		return sb;
	}
	
	
	
	// ====================================================
	//          XML STUFF
	// ====================================================
	
	
	
	
	private void parseXML(String fileName) throws PositionParseException {
		try {
			// get Schema
			//SchemaFactory schFact = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
			//Schema sch = schFact.newSchema(new File("confs/config.xsd"));
			
			// get xmlDocument
			DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
			//fact.setSchema(sch);
			//fact.setValidating(false);
			//fact.setNamespaceAware(true);
			DocumentBuilder parser = fact.newDocumentBuilder();
			//parser.setErrorHandler(this);
			File f = new File(POS_DIR_NAME + fileName);
			Document doc = parser.parse(new FileInputStream(f));
			
			NodeList nl = doc.getChildNodes();
			Node motNode = null;
			for (int i = 0; i < nl.getLength(); i++) {
				if (nl.item(i).getNodeName().equals("motors")) {
					motNode = nl.item(i);
				}
			}
			
			nl = motNode.getChildNodes();
			for (int i = 0; i < nl.getLength(); i++) {
				Node nn = nl.item(i);
				if (nn.getNodeName().equals("m")) {
					MotorState ms = new MotorState(nn);
					motorStates.add(ms);
				}
			}
		} catch (ParserConfigurationException e) {
			throw new PositionParseException(e);
		} catch (FileNotFoundException e) {
			throw new PositionParseException(e);
		} catch (SAXException e) {
			throw new PositionParseException(e);
		} catch (IOException e) {
			throw new PositionParseException(e);
		}
	}
	
	
	private void saveXML() {
		try {
			// We need a Document
			DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
			DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
			Document doc = docBuilder.newDocument();
			
			Element chh = doc.createElement("motors");
			doc.appendChild(chh);
			
			// add all motor position nodes
			for (Iterator<MotorState> iter = motorStates.iterator(); iter.hasNext();) {
				MotorState ms = iter.next();
				chh.appendChild(ms.toXML(doc));
			}
			
			// set up a transformer
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
            trans.setOutputProperty(OutputKeys.INDENT, "yes");

            // create string from xml tree
            FileWriter sw = new FileWriter(new File(POS_DIR_NAME + name));
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(doc);
            trans.transform(source, result);
		} catch (ParserConfigurationException e) {
			System.out.println(e);
			System.exit(0);
		} catch (IOException e) {
			System.out.println(e);
			System.exit(0);
		} catch (TransformerConfigurationException e) {
			System.out.println(e);
			System.exit(0);
		} catch (TransformerException e) {
			System.out.println(e);
			System.exit(0);
		}
		
	}
	
	
	// ====================================================
	//          CSV STUFF
	// ====================================================
	
	private void saveCSV() {
		try {
			FileWriter sw = new FileWriter(new File(POS_DIR_NAME + name));
			
			StringBuffer sb = new StringBuffer();
			for (Iterator<MotorState> iter = motorStates.iterator(); iter.hasNext();) {
				MotorState ms = iter.next();
				sb.append(ms.toCSV());
				sb.append(newline);
			}
			sw.write(sb.toString());
			sw.flush();
			sw.close();
		} catch (FileNotFoundException e) {
		} catch (IOException e) {
		}
	}
	
	private void parseCSV(String fileName) throws PositionParseException {
		try {
			BufferedReader in = new BufferedReader(new FileReader(POS_DIR_NAME + fileName));
			
			String ln;
			while ((ln = in.readLine()) != null) {
				try {
					motorStates.add(new MotorState(ln));
				} catch (PositionParseException e) {
				}
			}
			
			in.close();
		} catch (IOException e) {
			throw new PositionParseException(e);
		}
	}
	
	// ====================================================
	//          GENERAL STUFF
	// ====================================================
	
	
	public Position(String fileName) throws PositionParseException {
		motorStates = new LinkedList();
		
		if (fileName.endsWith(".myml")) {
			parseMyml(fileName);
		} else if (fileName.endsWith(".xml")) {
			parseXML(fileName);
		} else if (fileName.endsWith(".csv")) {
			parseCSV(fileName);
		} else {
			throw new PositionParseException(null);
		}
		
		name = fileName;
		
		allPositions.add(this);
	}
	
	public boolean equals(Object obj) {
		if (obj instanceof Position) {
			return ((Position)obj).name.equals(name);
		}
		return false;
	}
	
	public void save() {
		if (name.endsWith(".xml")) {
			saveXML();
		} else if (name.endsWith(".myml")) {
			saveMyML();
		} else if (name.endsWith(".csv")) {
			saveCSV();
		}
	}
	
	/**
	 * newExt must have a dot in it like ".csv"
	 */
	public Position(Position prototype, String newExt) {
		name = prototype.name.substring(0, prototype.name.lastIndexOf('.')) + newExt;
		motorStates = new LinkedList();
		for (Iterator<MotorState> iter = prototype.motorStates.iterator(); iter.hasNext();) {
			motorStates.add(new MotorState(iter.next()));
		}
	}
	
	public Position() {
		motorStates = new LinkedList();
	}
	
	public void addMotorState(int id, int pos) {
		MotorState ms = new MotorState(id, pos);
		motorStates.add(ms);
	}

	public void takeThisPosition() {
		for (Iterator<MotorState> iter = motorStates.iterator(); iter.hasNext();) {
			MotorState ms = (MotorState) iter.next();
			MotorDriver.defaultDriver.sendMotorMoveTo(ms.motorId, 11, ms.position);
		}
	}
}
