import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/**
 * This sux is like xml, but you must know what tag to expect, end of tag uses backslash, 
 * and there are no parameters in tags (no <body bgcolor=#555555></body> , 
 * just [body][bgcolor]#555555[\bgcolor][\body]), and mby some other little 
 * stuff to make parsing easier. 
 */
public class MyML {
	
	/**
	 * Reads file into stringBuffer, and treating it as MyML file, strips it of comments
	 * @param fileName name of file to read
	 * @return StringBuffer with contents 
	 * @throws MyMLParseException if file not found or something like that
	 */
	public static StringBuffer readFileIn(String fileName) throws MyMLParseException {
		File f = new File(fileName);
		StringBuffer string = null;
		try {
			FileReader rdr = new FileReader(f);
			char arr[] = new char[(int)(f.length())];
			rdr.read(arr);
			rdr.close();
			string = new StringBuffer(new String(arr));
		} catch (FileNotFoundException e) {
			throw new MyMLParseException("ERROR: File not found \"" + fileName + "\"");
		} catch (IOException e) {
			throw new MyMLParseException("ERROR: Can not read from file \"" + fileName + "\"");
		}
		stripOfComments(string);
		return string;
	}
	
	public static List getTagList(StringBuffer bfr) {
		List ret = new LinkedList();
		StringBuffer copy = new StringBuffer(bfr.toString());
		String tagName = getNextTagName(copy);
		while (tagName != null) {
			ret.add(tagName.toLowerCase());
			readMyMLTag(copy, tagName);
			tagName = getNextTagName(copy);
		}
		
		return ret;
	}
	
	public static void stripOfComments(StringBuffer sb) {
		int start = sb.indexOf("[[");
		int end = sb.indexOf("]]", start);
		
		while ((start >= 0) && (end >= start)) {
			sb.replace(start, end+2, "");
			start = sb.indexOf("[[", start);
			end = sb.indexOf("]]", start);
		}
		
		System.out.println(sb);
	}
	
	public static StringBuffer getMyMLTag(String tagName, Object value) {
		return new StringBuffer("["+tagName+"]" + value
				+ "[\\" + tagName + "]\n");
	}
	
	/**
	 * finds first string <tagName> and the first string </tagName> after that,
	 * returns all that is between them.. and throws out of source string all that
	 * was before </tagName>.
	 */
	public static StringBuffer readMyMLTag(StringBuffer source, String tagName) {
		if (source == null) {
			return null;
		}
		int start = source.indexOf("[" + tagName + "]");
		int end = source.indexOf("[\\" + tagName + "]", start);
		if ((start == -1) || (end == -1)) { 
			source.setLength(0);
			return null;
		}
		StringBuffer ret = new StringBuffer(source.substring(start+tagName.length()+2, end));
		/*System.out.println("readXmlTag tag=" + tagName +
				" from source=\"" + source + "\"");*/
		source.delete(0, end + tagName.length() + 3);
		/*System.out.println(" start=" + start + " end=" + end + 
				" ret=\"" + ret + "\" newSource=\"" + source + "\"");*/
		return ret;
	}
	
	/**
	 * returns name of the first tag in the buffer.  
	 * @param source string buffer with MyML
	 * @return
	 */
	public static String getNextTagName(StringBuffer source) {
		if (source == null) {
			return null;
		}
		int start = source.indexOf("[");
		int end = source.indexOf("]", start);
		if ((start == -1) || (end == -1)) { 
			source.setLength(0);
			return null;
		}
		
		return source.substring(start+1, end);
	}
	
	public static StringBuffer getFirstTagContents(StringBuffer source) {
		String tagName = getNextTagName(source);
		return readMyMLTag(source, tagName);
	}
	
	/**
	 * Parses first tag assuming that this tag contains an integer.
	 * Call this if you have previously called getNextTagName, and by 
	 * this you know that this tag is an integer 
	 * @param source
	 * @return
	 * @throws MyMLParseException if shit happens
	 */
	public static int parseIntTag(StringBuffer source) throws MyMLParseException {
		String tagName = getNextTagName(source);
		StringBuffer tagContent = readMyMLTag(source, tagName);
		int ret = 0;
		try {
			ret = Integer.parseInt(tagContent.toString().trim());
			return ret;
		} catch (NumberFormatException e) {
			throw new MyMLParseException("ERROR PARSING MyML FILE: invalid int tag \"" + tagName + "\".");
		} 
	}
	
	/**
	 * This parses first tag in source as boolean tag. Values "YES", "NO", "FALSE", "TRUE" 
	 * in upper and lower case and "0", "1" are allowed. 
	 * You should call getNextTagName first to be sure that first tag in source is boolean. 
	 * @param source
	 * @return
	 * @throws MyMLParseException
	 */
	public static boolean parseBoolTag(StringBuffer source) throws MyMLParseException {
		String tagName = getNextTagName(source);
		String tagContent = readMyMLTag(source, tagName).toString().trim();
		
		if (tagContent.equalsIgnoreCase("YES") 
				|| tagContent.equalsIgnoreCase("TRUE") 
				|| tagContent.equalsIgnoreCase("1")) {
			return true;
		}
		if (tagContent.equalsIgnoreCase("NO") 
				|| tagContent.equalsIgnoreCase("FALSE") 
				|| tagContent.equalsIgnoreCase("0")) {
			return false;
		}
		
		throw new MyMLParseException("ERROR PARSING MyML FILE: invalid boolean tag \"" + tagName + "\".");
	}
}
