import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SpringLayout;
import javax.swing.Spring;
import javax.swing.GroupLayout;

import javax.swing.JButton;
import javax.swing.JButton;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.TextArea;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Button;
import java.awt.Panel;

import java.util.Vector;
import java.util.Iterator;


class RetVal {
	int i;
	public RetVal() {
		i = 0;
	}
	
	public RetVal(int i) {
		this.i = i;
	}
	
	public void set(RetVal r) {
		i = r.i;
	}
	
	public boolean equals(Object o) {
		if (o instanceof RetVal) {
			return ((RetVal)(o)).i == i;
		} 
		return false;
	}
}


public class MotorErrorsMsgBox extends JDialog implements ActionListener {
	public static final RetVal OK;
	public static final RetVal FORCE;
	public static final RetVal RESET_ALL_STUCK;
	
	static {	
		OK = new RetVal(1);
		FORCE = new RetVal(2);
		RESET_ALL_STUCK = new RetVal(3);
	};
	
	JLabel lbl;
	JList list;
	TextArea ta;
	JButton okBtn;
	JButton forceBtn;
	JButton resetAllStuckBtn;
	
	RetVal result;
	
	public static String newline;
	
	static {
		newline = System.getProperty("line.separator");
	}
	
	MotorErrorsMsgBox(Vector<String> errs, RetVal result) {
		super(Main.m, "Attention", true);
		this.result = result;
		Container contentPane = getContentPane();
		//SpringLayout lay = new SpringLayout();
		GroupLayout lay = new GroupLayout(contentPane);
		contentPane.setLayout(lay);
		
		lbl = new JLabel("The following ERRORS were detected:");
		
		ta = new TextArea();
		StringBuffer sb = new StringBuffer();
		for (Iterator<String> iter = errs.iterator(); iter.hasNext(); ) {
			sb.append(iter.next());
			sb.append(newline);
		}
		ta.setText(sb.toString());
		ta.setEditable(false);
		
		
		okBtn = new JButton("Ok");
		okBtn.addActionListener(this);
		forceBtn = new JButton("Ingnore and FORCE saving");
		forceBtn.addActionListener(this);
		resetAllStuckBtn = new JButton("Reset all STUCK motors");
		resetAllStuckBtn.addActionListener(this);
		
		contentPane.add(lbl);
		contentPane.add(ta);
		//contentPane.add(btns);
		contentPane.add(okBtn);
		contentPane.add(forceBtn);
		contentPane.add(resetAllStuckBtn);
		
		lay.setAutoCreateGaps(true);
		lay.setAutoCreateContainerGaps(true);
		
		GroupLayout.SequentialGroup hGroup = lay.createSequentialGroup();
		
		// Variable indentation is used to reinforce the level of grouping.
		hGroup.addGroup(lay.createParallelGroup().
				addComponent(lbl).
				addComponent(ta).
				addGroup(
					lay.createSequentialGroup().addComponent(okBtn).addComponent(forceBtn).addComponent(resetAllStuckBtn)
				));
		lay.setHorizontalGroup(hGroup);
		
		// Create a sequential group for the vertical axis.
		GroupLayout.SequentialGroup vGroup = lay.createSequentialGroup();
		
		vGroup.addGroup(lay.createParallelGroup(GroupLayout.Alignment.BASELINE).
				addComponent(lbl));
		vGroup.addGroup(lay.createParallelGroup(GroupLayout.Alignment.BASELINE).
				addComponent(ta));
		vGroup.addGroup(lay.createParallelGroup(GroupLayout.Alignment.BASELINE).
				addComponent(okBtn).addComponent(forceBtn).addComponent(resetAllStuckBtn));
		lay.setVerticalGroup(vGroup);
		
		pack();
		setResizable(false);
		//setSize(new Dimension(300, 330));
		setVisible(true);
	}
	
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == okBtn) {
			result.set(OK);
			dispose();
		} else if (e.getSource() == forceBtn) {
			result.set(FORCE);
			dispose();
		} else if (e.getSource() == resetAllStuckBtn) {
			result.set(RESET_ALL_STUCK); 
			dispose();
		}
	}
}