import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

import gnu.io.*;

//import javax.comm.CommPortIdentifier;
//import javax.comm.PortInUseException;
//import javax.comm.SerialPort;
//import javax.comm.UnsupportedCommOperationException;

class ReceivePackage {
	int length;
	byte data[];
	
	public ReceivePackage(Vector<Byte> vec, int start, int end) {
		data = new byte[end-start-1];
		for (int i = start+1; i < end; i++) {
			data[i-start-1] = ((Byte)vec.elementAt(i)) .byteValue() ;
		}
		
		System.out.println("PACK RECEIVED");
	}
}

public class MotorDriver implements Runnable {
	
	public static final byte PACK_START = (byte)(0xFE);
	public static final byte PACK_END = (byte)(0xFD);
	
	public static final byte PACK_ID_DRIVE_TIME = 1;
	public static final byte PACK_ID_DRIVE_END = 2;
	public static final byte PACK_ID_DRIVE_COORD = 3;
	public static final byte PACK_ID_GET_STATUS = 4;
	public static final byte PACK_ID_RESET = 5;
	public static final byte PACK_ID_STOP = 6;
	
	public static final byte PACK_ID_STATUS_ANS = 20;
	public static final byte PROTOCOL_ACTIONS_COMPLETE_BIT = 0x01;
	public static final byte PROTOCOL_STUCK_BIT = 0x02;
	
	public static int INT16_SHIFT = 32768;
	public static int INT8_SHIFT = 128;

	
	public static MotorDriver defaultDriver;
	Vector<Byte> rawRecvData;
	Vector<ReceivePackage> packs;
	
	BoardStatus states[];
	
	SerialPort com;
	InputStream comInStream;
	
	Thread thr;
	
	
	private void analyzePack(ReceivePackage pack) {
		int m0, m1, tm, brdId, maxX;
		if (pack.data[0] == PACK_ID_STATUS_ANS) {
			System.out.println("status received");
			brdId = getSubByte(pack.data, 1);
			m0 = getInt16_t(pack.data, 2);
			maxX = getUint16_t(pack.data, 5);
			tm = getUint32_t(pack.data, 8);
			int statuzz = getSubByte(pack.data, 13);
			boolean completion = false;
			if ((statuzz & PROTOCOL_ACTIONS_COMPLETE_BIT) != 0) {
				completion = true;
			}
			boolean stuck = false;
			if ((statuzz & PROTOCOL_STUCK_BIT) != 0) {
				stuck = true;
			}
			/*
			encodeSubByte(buffer+2, addr);
			encodeInt16_t(buffer+3, getCoord());
			encodeUint16_t(buffer+6, getMaxPosition());
			encodeUint32_t(buffer+9, getGlobalTime());
			uint8_t stat = 0;
			if (getStatus() == MOTOR_STATUS_STUCK) {
				stat |= PROTOCOL_STUCK_BIT;
			}
			if (allActionsComplete()) {
				stat |= PROTOCOL_ACTIONS_COMPLETE_BIT;
			}
			encodeSubByte(buffer+14, stat);
			*/
			
			BoardStatus.refresh(brdId, m0, maxX, tm, stuck, completion);
		}
	}
	
	
	void accountBytes(byte newData[], int num) {
		for (int i = 0; i < num; i++) {
			rawRecvData.add(newData[i]);
		}
		
		while (checkWholePackage());
		while (packs.size() != 0) {
			analyzePack(packs.elementAt(0));
			packs.removeElementAt(0);
		}
	}
	
	boolean checkWholePackage() {
		int startIndex = -1;
		
		int endIndex = -1;
		
		for (int i = 0; i < rawRecvData.size(); i++) {
			if (rawRecvData.elementAt(i) == MotorDriver.PACK_START) {
				startIndex = i;
			}
			if ((startIndex != -1) && (rawRecvData.elementAt(i) == MotorDriver.PACK_END)) {
				endIndex = i;
				break;
			}
		}
		
		if (endIndex != -1) {
			ReceivePackage p = new ReceivePackage(rawRecvData, startIndex, endIndex);
			packs.add(p);
			for (int i = 0; i <= endIndex; i++) {
				rawRecvData.removeElementAt(0);
			}
			return true;
		} 
		return false;
	}
	
	
	
	
	
	public static void init() {
		defaultDriver = new MotorDriver();
	}
	
	/*public static void main(String[] args) {
		Main.main(args);
	}*/
	
	public MotorDriver() {
		rawRecvData = new Vector<Byte>();
		packs = new Vector<ReceivePackage>();
		getCom();
		
		try {
			comInStream = com.getInputStream();
		} catch (IOException e) {
			System.out.println("Error while trying to read COM port");
			System.exit(0);
		}
		
		thr = new Thread(this);
		thr.start();
	}
	
	public void run() {
		byte buf[] = new byte[1000];
		while (true) {
			try {
				int avl = comInStream.available();
				if (avl > 1000) avl = 1000;
				int rd = comInStream.read(buf, 0, avl);
/*				if(rd > 5) {
					for (int i =0 ; i < rd ; i++) {
						System.out.print(buf[i] + " : ");
					}
					System.out.println();
				}*/
				accountBytes(buf, rd);
			} catch (IOException e) {
				System.out.println("ERROR READING");
			}
			try {
				Thread.sleep(10);
			} catch (InterruptedException e) {
				System.out.println(e);
			}
		}
	}

	
	
	
	/**
	 * subByte numbers are coded as 1 byte.
	 */
	private static byte getSubByte(byte ptr[], int offset) {
		return ptr[offset];
	}
	
	private static void encodeSubByte(byte ptr[], int offset, byte val) {
		ptr[offset] = (byte)(val&0x7f);
	}

	/**
	 * single byte numbers are coded as 2 bytes.
	 */
	private static byte getInt8_t(byte ptr[], int offset) {
		return (byte)(getUint8_t(ptr, offset) - INT8_SHIFT);
	}

	private static int getUint8_t(byte ptr[], int offset) {
		int rr = ptr[offset] & 0x7f;
		rr += ((int)(ptr[offset+1] & 0x01)) << 7;
		return rr;
	}

	private static void encodeInt8_t(byte ptr[], int offset, byte val) {
		encodeUint8_t(ptr, offset, ((int)(val)) + INT8_SHIFT);
	}

	private static void encodeUint8_t(byte ptr[], int offset, int val) {
		//System.out.println(" encoding uint8, " + val);
		ptr[offset+0] = (byte)(val & 0x7f);
		ptr[offset+1] = (byte)((val >> 7) & 0x01);
	}


	/**
	 * two byte numbers are coded as 3 bytes
	 */
	private static int getUint16_t(byte ptr[], int offset) {
		int ret = ptr[offset+0] & 0x7f;
		ret += (int)(ptr[offset+1] & 0x7f) << 7;
		ret += (int)(ptr[offset+2] & 0x03) << 14;
		return ret;
	}

	private static int getInt16_t(byte ptr[], int offset) {
		return (int)(getUint16_t(ptr, offset)) - INT16_SHIFT;
	}

	private static void encodeUint16_t(byte ptr[], int offset, int val) {
		ptr[offset+0] = (byte)(val & 0x7f);
		ptr[offset+1] = (byte)((val >> 7) & 0x7f);
		ptr[offset+2] = (byte)((val >> 14) & 0x03);
		//System.out.println(" encoding uint16 " + val);
	}

	private static void encodeInt16_t(byte ptr[], int offset, int val) {
		//System.out.println(" encoding int16 " + val);
		encodeUint16_t(ptr, offset, val + INT16_SHIFT);
	}


	/**
	 * 4 byte numbers are coded as 5 bytes
	 */
	private static int getUint32_t(byte ptr[], int offset) {
		int ret = ptr[offset+0];
		ret += (int)(ptr[offset+1]) << 7;
		ret += (int)(ptr[offset+2]) << 14;
		ret += (int)(ptr[offset+3]) << 21;
		ret += (int)(ptr[offset+4]) << 28;
		return ret;
	}


	private static void encodeUint32_t(byte ptr[], int offset, int val) {
		ptr[offset+0] = (byte)(val & 0x7f);
		ptr[offset+1] = (byte)((val / 128) & 0x7f);
		ptr[offset+2] = (byte)((val / 128/ 128) & 0x7f);
		ptr[offset+3] = (byte)((val / 128/ 128/ 128) & 0x7f);
		ptr[offset+4] = (byte)((val / 128/ 128/ 128/ 128) & 0x7f);
	}

	public static void main(String[] args) {
		int suka = -120;
		byte dest[] = new byte[10];
		encodeInt8_t(dest, 0, (byte)(suka));
		int suka1 = getInt8_t(dest, 0);
		//System.out.println("src=" + suka + " coded=" + dest[4] + ", " + dest[3] + ", " + dest[2] + ", " + dest[1]  + ", " + dest[0] + " result=" + suka1);
		
		
	}

	
	/*private void encodeUint16_t(byte ptr[], int offset, int val) {
		ptr[offset] = (byte)(val % 128);
		ptr[offset+1] = (byte)((val/128) % 128);
	}

	private void encodeInt16_t(byte ptr[], int offset, int val) {
		encodeUint16_t(ptr, offset, val + INT16_SHIFT);
	}*/

	
	public void sendBuffer(byte buf[]) {
		try {
			com.getOutputStream().write(buf);
			com.getOutputStream().flush();
		} catch (IOException e) {
			System.out.println("ERROR: could not write to COM port");
		}
		//try {
	//		Thread.sleep(10);
	//	}
	//	catch(Exception e) {}
	}
	
	public void sendMotorMoveTime(int motorNr, int dir_spd, int time) {
		byte pack[] = new byte[9];
		pack[0] = PACK_START;
		encodeSubByte(pack, 1, (byte)(motorNr));
		pack[2] = PACK_ID_DRIVE_TIME;
		encodeInt8_t(pack, 3, (byte)(dir_spd));
		encodeUint16_t(pack, 5, time / 10);
		pack[8] = PACK_END;
		
		
		
		sendBuffer(pack);
	}
	
	public void sendMotorMoveTo(int motorNr, int spd, int coord) {
		byte pack[] = new byte[9];
		pack[0] = PACK_START;
		encodeSubByte(pack, 1, (byte)(motorNr));
		pack[2] = PACK_ID_DRIVE_COORD;
		encodeInt8_t(pack, 3, (byte)(spd));
		encodeInt16_t(pack, 5, coord);
		pack[8] = PACK_END;

		for (int i = 0; i < 9; i++) {
			System.out.print(" " + pack[i]);
		}
//		System.out.println("");

		sendBuffer(pack);
	}
	
	public void sendMotorMoveEnd(int motorNr, int dir_spd) {
		byte pack[] = new byte[6];
		pack[0] = PACK_START;
		encodeSubByte(pack, 1, (byte)(motorNr));
		pack[2] = PACK_ID_DRIVE_END;
		encodeInt8_t(pack, 3, (byte)(dir_spd));
		pack[5] = PACK_END;
		
		sendBuffer(pack);
	}
	
	public void sendStatusRequest(int motorNr) {
		byte pack[] = new byte[4];
		pack[0] = PACK_START;
		encodeSubByte(pack, 1, (byte)(motorNr));
		pack[2] = PACK_ID_GET_STATUS;
		pack[3] = PACK_END;
		
		sendBuffer(pack);
	}
	
	public void sendReset(int motorNr) {
		byte pack[] = new byte[4];
		pack[0] = PACK_START;
		encodeSubByte(pack, 1, (byte)(motorNr));
		pack[2] = PACK_ID_RESET;
		pack[3] = PACK_END;
		
		sendBuffer(pack);
	}
	
	public void sendStop(int motorNr) {
		// TODO Auto-generated method stub
		byte pack[] = new byte[4];
		pack[0] = PACK_START;
		encodeSubByte(pack, 1, (byte)(motorNr));
		pack[2] = PACK_ID_STOP;
		pack[3] = PACK_END;
		
		sendBuffer(pack);
	}
	
	/*public void getStatus(int boardId) {
		sendStatusRequest(boardId*2);
		
		// TODO!
		//while ()
	}*/
	
	private void getCom(){
		String comName = "";
		
		try {
			BufferedReader rdr = new BufferedReader(new FileReader("confs/comConf.conf"));
			comName = rdr.readLine().trim();
		} catch (IOException e) {
			System.out.println("ERROR: invalid COM port configuration file");
			System.exit(0);
		}
		Enumeration enumer = CommPortIdentifier.getPortIdentifiers();
		
		while (enumer.hasMoreElements()) {
			CommPortIdentifier element = ((CommPortIdentifier)enumer.nextElement());
			
			if (element.getPortType() != CommPortIdentifier.PORT_SERIAL) {
				continue;
			}
			
			System.out.println(element.getName());
			
			if (element.getName().equalsIgnoreCase(comName)) {
				try {
					com = (SerialPort)(element.open("Manneken V1", 1000));
				}
				catch (Exception e) {
					System.out.println("ERROR: cant open COM port");
					System.exit(0);
					System.out.println();
				}
				try {
					Thread.sleep(10);
				}
				catch(Exception e) {}
				try {
					com.setSerialPortParams(38400, SerialPort.DATABITS_8,
							SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);
				}
				catch (UnsupportedCommOperationException e) {
					System.out.println("ERROR: cant set COM port settings");
					System.out.println(e.toString());
					System.exit(0);
				}
				return;
			}
		}
		
		System.out.println("ERROR: COM port named \"" + comName + "\" could not be foud");
		System.exit(0);
	}
}
