import java.awt.Dimension;
import java.awt.BorderLayout;
import java.awt.Panel;
import javax.swing.JTabbedPane;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Schema;
import javax.xml.XMLConstants;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.NamedNodeMap;


import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.w3c.dom.Text;
import org.w3c.dom.Element;
import org.w3c.dom.Comment;


import javax.xml.transform.stream.StreamResult;
import java.io.StringWriter;



public class MainPanel extends Panel implements ErrorHandler {
	/** sux that java wants */
	private static final long serialVersionUID = 1L;
	
	
	public static MainPanel mp;
	JTabbedPane viewsPan;
	
	public static void main(String[] args) {
		Main.main(args);
	}
	
	public void error(SAXParseException exception) {
		System.out.println(exception);
		System.exit(0);
	}
	
	public void fatalError(SAXParseException exception) {
		System.out.println(exception);
		System.exit(0);
	}
	
	public void warning(SAXParseException exception) {
	}
	
	private void readConfig() {
		try {
			// get Schema
			SchemaFactory schFact = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
			Schema sch = schFact.newSchema(new File("confs/config.xsd"));
			
			// get xmlDocument
			DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
			fact.setSchema(sch);
			fact.setValidating(false);
			fact.setNamespaceAware(true);
			DocumentBuilder parser = fact.newDocumentBuilder();
			parser.setErrorHandler(this);
			File f = new File("confs/config.xml");
			Document doc = parser.parse(new FileInputStream(f));
			
			// analyze it
			NodeList nl = doc.getChildNodes();
			analyzeConfig(nl.item(0));
			//System.exit(0);
		} catch (FileNotFoundException e) {
			System.out.println(e);
			System.exit(0);
		} catch (SAXException e) {
			System.out.println(e);
			System.exit(0);
		} catch (ParserConfigurationException e) {
			System.out.println(e);
			System.exit(0);
		} catch (IOException e) {
			System.out.println(e);
			System.exit(0);
		}
	}
	
	private void analyzeConfig(Node node) {
		NodeList nl = node.getChildNodes();
		for (int i = 0; i < nl.getLength(); i++) {
			Node n = nl.item(i);
			if (n.getNodeName().equals("Actuator")) {
				new Actuator(n);
			} else if (n.getNodeName().equals("View")) {
				View pp = new View(n);
				viewsPan.addTab(pp.name, pp);
				viewsPan.addChangeListener(pp);
			}
		}
	}
	
	public MainPanel() {
		
		super();
		//testParser();
		setLayout(new BorderLayout());
		
		//System.exit(0);
		//LeftPanel lp = new LeftPanel();
		//add(new ParamPanel(), BorderLayout.NORTH);
		
		viewsPan = new JTabbedPane();//SuxPanel();
		//System.out.println("parsing began");
		readConfig();
		
		Position.parsePositions();
		PositionsPanel ppp = new PositionsPanel();
		Position.MyMLtoCSV();
		ppp.setMaximumSize(new Dimension(300, 30000));
		viewsPan.add("Saving", ppp);
		add(viewsPan, BorderLayout.CENTER);
		
		mp = this;
	}
}
