import java.awt.Graphics;
import java.awt.Image;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.JLabel;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.NamedNodeMap;
import java.util.Vector;
import java.util.Iterator;

public class DriveButtons {
	private static Image UP_LIT = null;
	private static Image UP = null;
	private static Image DOWN_LIT = null;
	private static Image DOWN = null;
	private static Image RIGHT_LIT = null;
	private static Image RIGHT = null;
	private static Image LEFT_LIT = null;
	private static Image LEFT = null;

	private static Image APART_HORIS_LIT = null;
	private static Image APART_HORIS = null;
	private static Image APART_VERT_LIT = null;
	private static Image APART_VERT = null;
	
	private static Image TOGETHER_VERT_LIT = null;
	private static Image TOGETHER_VERT = null;
	private static Image TOGETHER_HORIS_LIT = null;
	private static Image TOGETHER_HORIS = null;
	
	public static final int STYLE_RIGHT = 1;
	public static final int STYLE_LEFT = 2;
	public static final int STYLE_UP = 3;
	public static final int STYLE_DOWN = 4;
	public static final int STYLE_APART_HORIS = 5;
	public static final int STYLE_APART_VERT = 6;
	public static final int STYLE_TOGETHER_HORIS = 7;
	public static final int STYLE_TOGETHER_VERT = 8;
	
	public static final String STYLE_STR_RIGHT = "right";
	public static final String STYLE_STR_LEFT = "left";
	public static final String STYLE_STR_UP = "up";
	public static final String STYLE_STR_DOWN = "down";
	public static final String STYLE_STR_APART_HORIS = "apart_horis";
	public static final String STYLE_STR_APART_VERT = "apart_vert";
	public static final String STYLE_STR_TOGETHER_HORIS = "together_horis";
	public static final String STYLE_STR_TOGETHER_VERT = "together_vert";
	
	
	class ActuatorDescription {
		String name;
		int actuatorDirection;
		
		/**
		 * <Actuator name="suka" direction="+"/>
		 */
		public ActuatorDescription(Node node) {
			System.out.println("reading ActuatorDescription " + node.getNodeName());
			NamedNodeMap nm = node.getAttributes();
			name = nm.getNamedItem("name").getNodeValue();
			if (nm.getNamedItem("direction").getNodeValue().equals("+")) {
				actuatorDirection = 1;
			} else {
				actuatorDirection = -1;
			}
		};
		
		public void start() {
			Actuator.getActuatorByName(name).start(actuatorDirection);
		};
		
		public void stop() {
			Actuator.getActuatorByName(name).stop();
		};
	};
	
	
	int x, y; // coords on screen
	int buttonStyle; // for drawing right images
	
	Image dark; // two images to be shown
	Image lit;
	
	Vector<ActuatorDescription> actuators;
	
	String tip;
	Popup pop;
	JLabel ll;
	View myView;
	
	private boolean isUp = true;
	
	public static void main(String[] args) {
		Main.main(args);
	}
	
	public static int convertStyle(String styleString) {
		if (styleString.equals(STYLE_STR_RIGHT)) 			return STYLE_RIGHT;
		if (styleString.equals(STYLE_STR_LEFT)) 			return STYLE_LEFT;
		if (styleString.equals(STYLE_STR_UP)) 				return STYLE_UP;
		if (styleString.equals(STYLE_STR_DOWN)) 			return STYLE_DOWN;
		if (styleString.equals(STYLE_STR_APART_HORIS)) 		return STYLE_APART_HORIS;
		if (styleString.equals(STYLE_STR_APART_VERT)) 		return STYLE_APART_VERT;
		if (styleString.equals(STYLE_STR_TOGETHER_HORIS)) 	return STYLE_TOGETHER_HORIS;
		if (styleString.equals(STYLE_STR_TOGETHER_VERT)) 	return STYLE_TOGETHER_VERT;
		System.out.println("ERROR, unkown button style \""+styleString+"\"");
		System.exit(0);
		return 0;
	}
	
	/**
	 * <button x="100" y="300" tip="suka" style="up">
			<actuator name="suka" direction="+"/>
			<actuator name="suka1" direction="+"/>
		</button>
	 */
	public DriveButtons(Node node, View myView) {
		System.out.println("reading button");
		if (UP_LIT == null) {
			loadImages();
		}
		this.myView = myView;
		actuators = new Vector();
		
		NamedNodeMap nm = node.getAttributes();
		try {
			x = Integer.parseInt(nm.getNamedItem("x").getNodeValue());
			y = Integer.parseInt(nm.getNamedItem("y").getNodeValue());
			tip = nm.getNamedItem("tip").getNodeValue();
			buttonStyle = convertStyle(nm.getNamedItem("style").getNodeValue());
			
			NodeList nl = node.getChildNodes();
			for (int i = 0; i < nl.getLength(); i++) {
				Node n = nl.item(i);
				if (n.getNodeName().equals("Actuator")) {
					ActuatorDescription act = new ActuatorDescription(n);
					actuators.add(act);
				}
			}
			
		} catch (NumberFormatException e) {
			System.out.println(e);
			System.exit(0);
		}
		
		switch (buttonStyle) {
			case STYLE_APART_HORIS:
				dark = APART_HORIS;
				lit = APART_HORIS_LIT;
				break;
			case STYLE_APART_VERT:
				dark = APART_VERT;
				lit = APART_VERT_LIT;
				break;
			case STYLE_TOGETHER_HORIS:
				dark = TOGETHER_HORIS;
				lit = TOGETHER_HORIS_LIT;
				break;
			case STYLE_TOGETHER_VERT:
				dark = TOGETHER_VERT;
				lit = TOGETHER_VERT_LIT;
				break;
			case STYLE_DOWN:
				dark = DOWN;
				lit = DOWN_LIT;
				break;
			case STYLE_UP:
				dark = UP;
				lit = UP_LIT;
				break;
			case STYLE_RIGHT:
				dark = RIGHT;
				lit = RIGHT_LIT;
				break;
			case STYLE_LEFT:
				dark = LEFT;
				lit = LEFT_LIT;
				break;
		}
		
		if (tip.equals("")) {
			ll = null;
		} else {
			ll = new JLabel(tip);
		}
	}
	
	/*public DriveButtons(int x, int y, int buttonStyle, String actuatorName, 
			int actuatorDirection, View myView, String tip) {
		//if images not loaded then load them
		if (UP_LIT == null) {
			loadImages();
		}
		this.myView = myView;
		
		
		this.tip = tip;
		this.x = x;
		this.y = y;
		this.buttonStyle = buttonStyle;
		//this.actuatorDirection = actuatorDirection;
		//this.actuatorName = actuatorName;
		
		if (Actuator.getActuatorByName(actuatorName) == null) {
			System.out.println("ERROR: config.myml invalid. Actuator \"" + actuatorName + "\" used before it was declared");
		}
		
		switch (buttonStyle) {
			case STYLE_APART_HORIS:
				dark = APART_HORIS;
				lit = APART_HORIS_LIT;
				break;
			case STYLE_APART_VERT:
				dark = APART_VERT;
				lit = APART_VERT_LIT;
				break;
			case STYLE_TOGETHER_HORIS:
				dark = TOGETHER_HORIS;
				lit = TOGETHER_HORIS_LIT;
				break;
			case STYLE_TOGETHER_VERT:
				dark = TOGETHER_VERT;
				lit = TOGETHER_VERT_LIT;
				break;
			case STYLE_DOWN:
				dark = DOWN;
				lit = DOWN_LIT;
				break;
			case STYLE_UP:
				dark = UP;
				lit = UP_LIT;
				break;
			case STYLE_RIGHT:
				dark = RIGHT;
				lit = RIGHT_LIT;
				break;
			case STYLE_LEFT:
				dark = LEFT;
				lit = LEFT_LIT;
				break;
		}
		
		if (tip.equals("")) {
			ll = null;
		} else {
			ll = new Label(tip);
		}
	}*/
	
	private void loadImages() {
		try {
			UP_LIT = ImageIO.read(new File("pics/arr/arrow_up_lit.png"));
			UP = ImageIO.read(new File("pics/arr/arrow_up.png"));
			DOWN_LIT = ImageIO.read(new File("pics/arr/arrow_down_lit.png"));
			DOWN = ImageIO.read(new File("pics/arr/arrow_down.png"));
			RIGHT_LIT = ImageIO.read(new File("pics/arr/arrow_right_lit.png"));
			RIGHT = ImageIO.read(new File("pics/arr/arrow_right.png"));
			LEFT_LIT = ImageIO.read(new File("pics/arr/arrow_left_lit.png"));
			LEFT = ImageIO.read(new File("pics/arr/arrow_left.png"));

			APART_HORIS_LIT = ImageIO.read(new File("pics/arr/apart_horis_lit.png"));
			APART_HORIS = ImageIO.read(new File("pics/arr/apart_horis.png"));
			APART_VERT_LIT = ImageIO.read(new File("pics/arr/apart_vert_lit.png"));
			APART_VERT = ImageIO.read(new File("pics/arr/apart_vert.png"));
			
			TOGETHER_HORIS_LIT= ImageIO.read(new File("pics/arr/together_horis_lit.png"));
			TOGETHER_HORIS = ImageIO.read(new File("pics/arr/together_horis.png"));
			TOGETHER_VERT_LIT = ImageIO.read(new File("pics/arr/together_vert_lit.png"));
			TOGETHER_VERT = ImageIO.read(new File("pics/arr/together_vert.png"));
		} catch (IOException e) {
			System.out.println(e);
			System.exit(0);
		}
	}
	
	private boolean hits(int hitx, int hity) {
		int size = dark.getHeight(null);
		int centerX = x + size/2;
		int centerY = y + size/2;
		int deltax = hitx - centerX;
		int deltay = hity - centerY;
		
		if (deltax*deltax + deltay*deltay < size*size/4) {
			return true;
		}
		
		return false;
	}

	public boolean handleMouseDown(int x, int y) {
		if (hits(x, y)) {
			for (Iterator<ActuatorDescription> iter = actuators.iterator(); iter.hasNext(); ) {
				iter.next().start();
			}
			//Actuator.getActuatorByName(actuatorName).start(actuatorDirection);
			isUp = false;
			return true;
		}
		return false;
	}
	
	public boolean handleMouseUp(int x, int y) {
		// FIXME
		for (Iterator<ActuatorDescription> iter = actuators.iterator(); iter.hasNext(); ) {
			iter.next().stop();
		}
		//Actuator.getActuatorByName(actuatorName).stop();
		if (!isUp) {
			isUp = true;
			return true;
		}
		return false;
	}
	
	public void handleMouseMove(int x, int y) {
		if (hits(x, y)) {
			if ((pop == null) && (ll != null)) {
				//System.out.println(pop);
				pop = PopupFactory.getSharedInstance().getPopup(myView, ll, 
						myView.getLocationOnScreen().x + this.x + 35,
						myView.getLocationOnScreen().y + this.y + 35);
				pop.show();
		 	}
		} else if (pop != null) {
			//System.out.println("not Null, and doesn't hit");
			pop.hide();
			pop = null;
		}
	}
	
	public void hideTip() {
		if (pop != null) {
			pop.hide();
		}
	}
	
	public void paint(Graphics g) {
		if (isUp) {
			g.drawImage(dark, x, y, null);
		} else {
			g.drawImage(lit, x, y, null);
		}
	}

}
