import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.NamedNodeMap;

public class Actuator {
	static Map allActuators; // this is by name
	static List actuators; // this
	static List allMotors;
	static Map conditions;
	
	String name;
	List motors;
	boolean active;
	int curDir;
	static Poller pp;
	static Thread thr;
	
	static {
		allActuators = new TreeMap();
		conditions = new TreeMap();
		actuators = new LinkedList();
		allMotors = new LinkedList();
		//Thread thr = new Thread(new Actuator.Poller());
	}
	
	class Poller implements Runnable {

		public void run() {
			while (true) {
				for (Iterator i = actuators.iterator(); i.hasNext();) {
					Actuator act = (Actuator) i.next();
					act.act();
				}
				try {
					Thread.sleep(50);
				} catch (InterruptedException e) {
					System.out.println("sux TODO!");
				}
			}
		}
		
	}
	
	class Motor {
		int motorId;
		boolean inverted;
		String condition;
		
		Motor(Node node) {
			NamedNodeMap nm = node.getAttributes();
			motorId = Integer.parseInt(nm.getNamedItem("id").getNodeValue());
			inverted = Boolean.parseBoolean(nm.getNamedItem("inverted").getNodeValue());
			condition = nm.getNamedItem("if").getNodeValue();
			
			if (!conditions.keySet().contains(condition)) {
				conditions.put(condition, new Boolean(true));
			}
			
			if (!allMotors.contains(this)) {
				allMotors.add(this);
				BoardStatus.accountMotor(this.motorId);
			}
		}
		
		/*Motor(StringBuffer myMLTag) throws MyMLParseException {
			// parse it
			String tagName;
			while ((tagName = MyML.getNextTagName(myMLTag)) != null) {
				if (tagName.equalsIgnoreCase("nr")) {
					motorId = MyML.parseIntTag(myMLTag);
				} else if (tagName.equalsIgnoreCase("inverted")) {
					inverted = MyML.parseBoolTag(myMLTag);
				} else if (tagName.equalsIgnoreCase("if")) {
					condition = MyML.getFirstTagContents(myMLTag).toString().trim().toUpperCase();
					// add condition if needed
					if (!conditions.keySet().contains(condition)) {
						conditions.put(condition, new Boolean(true));
					}
				} else {
					throw new MyMLParseException("ERROR: unexpected tag \"" + tagName + "\"");
				}
			}
			
			if (!allMotors.contains(this)) {
				allMotors.add(this);
				BoardStatus.accountMotor(this.motorId);
			}
		}// constructor*/
		
		void sendCommand(int direction) {
			MotorDriver.defaultDriver.sendMotorMoveTime(motorId, direction*10, 70);
		}
		
		public boolean equals(Object obj) {
			if (obj instanceof Motor) {
				return ((Motor)obj).motorId == this.motorId;
			}
			return false;
		}
	}// Motor calss

	
	public static void main(String[] args) {
		Main.main(args);
	}
	
	/*static boolean getCondition(String condition) {
		if (ParamPanel.defaultParam == null) {
			return true;
		}
		return ParamPanel.defaultParam.getParam(condition);
	}*/
	
	public Actuator(Node node) {
		// check if pollerThread is created
		if (thr == null) {
			pp = new Poller();
			thr = new Thread(pp);
			thr.start();
		}
		
		// parse myml
		motors = new LinkedList();
		
		NamedNodeMap nm = node.getAttributes();
		name = nm.getNamedItem("name").getNodeValue();
		
		NodeList nl = node.getChildNodes();
		for (int i = 0; i < nl.getLength(); i++) {
			Node n = nl.item(i);
			if (n.getNodeName().equals("Motor")) {
				Motor m = new Motor(n);
				motors.add(m);
			}
		}
		
		// put to map
		allActuators.put(name, this);
		actuators.add(this);
	}
	
	/*public Actuator(StringBuffer myMLTag) throws MyMLParseException {
		
		// check if pollerThread is created
		if (thr == null) {
			pp = new Poller();
			thr = new Thread(pp);
			thr.start();
		}
		
		// parse myml
		motors = new LinkedList();
		String tagName;
		while ((tagName = MyML.getNextTagName(myMLTag)) != null) {
			if (tagName.equalsIgnoreCase("name")) {
				name = MyML.getFirstTagContents(myMLTag).toString().trim();
			} else if (tagName.equalsIgnoreCase("motor")) {
				Motor m = new Motor(MyML.getFirstTagContents(myMLTag));
				motors.add(m);
			} else {
				throw new MyMLParseException("ERROR: unexpected tag \"" + tagName + "\"");
			}
		}
		
		// put to map
		allActuators.put(name, this);
		actuators.add(this);
	}*/
	
	public void start(int direction) {
		// just send commands to all motors that need it.
		System.out.println("direction " + direction);
		curDir = direction;
		active = true;
	}
	
	public void act() {
		if (!active) {
			return;
		}
		System.out.println("actuator \"" + name + "\" acting");
		for (Iterator i = motors.iterator(); i.hasNext();) {
			Motor m = (Motor) i.next();
			//if (getCondition(m.condition)) {
				if (m.inverted) {
					System.out.println("motor " + m.motorId + " inverted");
					m.sendCommand(-curDir);
				} else {
					System.out.println("motor " + m.motorId + " inverted");
					m.sendCommand(curDir);
				}
			//}
		}
	}
	
	public void stop() {
		active = false;
	}
	
	public static Actuator getActuatorByName(String name) {
		//System.out.println("get act " + name);
		return (Actuator)allActuators.get(name);
	}
	
	public static void readConfig() {
	}
	
	public static void setCondition(String condName, boolean condValue) {
		conditions.remove(condName);
		conditions.put(condName, new Boolean(condValue));
	}
}
