clear all;
close all;

% pure Al uniaxial tension
a = [1 0 0; 0 1 0; 0 0 1];
x1 = [170.388 5.1637 120.303];
x2 = [184.288 10.0299 138.207];
x3 = [178.528 20.0525 143.062];
% result: [1 1.0949 -1.0740], dev = 2.2

% old orientation
%a = [-1 1 1; 1 -1 2; 1 1 0];

% new orientation
%a = [0 0 1; 1 -1 0; 1 1 0];

% clean Cu old orientation atom coordinates
%x1 = [119.375 188.202 87.3284];
%x2 = [141.617 49.7165 161.177];
%x3 = [19.0646 84.7064 191.471];
% result: [1 0.6923 1.3704], dev = 15.2

% clean Cu new orientation
%x1 = [6.005 163.786 56.9267];
%x2 = [161.441 162.09 172.521];
%x3 = [155.543 3.6467 168.548];
% result: [1 0.9948 -0.7417], dev = 7.5

% CuFe old orientation
%x1 = [204.209 6.82841 147.322];
%x2 = [315.384 103.361 43.6227];
%x3 = [46.9271 40.1197 193.239];
% result: [1 0.7009 1.3644], dev = 14.9

% CuFe new orientation
%x1 = [157.719 7.71941 114.529];
%x2 = [128.337 154.474 136.126];
%x3 = [50.9655 123.515 192.942];
% result: [1 1.0003 0.7345], dev = 7.8

% define two vectors from atom coordinates
v1 = x2-x1;
v2 = x3-x1;

% plane normal
plane = cross(v1,v2);

% transform back to unrotated coordinate system
n = plane*a;

% normalize first miller index to 1
n = n ./ n(1)

% deviation from general <111> direction in degrees
deviation = acos(dot(n,[1 1 -1])/(norm(n)*norm([1 1 1]))) * 180 / pi