function y = totalerror_allpoints(fit)
% See funktisoon arvutab veafunktsiooni väärtuse, võttes kõik punktid
% arvesse võrdsete kaaludega.

% Sisend: 10-kohaline vektor fit, mis sisaldab S ja O3 osalaenguid ja S-Li
% ja O3-Li VdW parameetreid.

% Väljund: skalaar veafunktsiooni väärtusega kõigi punktide põhjal kokku.

% Kuna dibu potentsiaali parameetrid ei tohi olla negatiivsed,
% võtame neist absoluutväärtused.
absfit=[fit(1),fit(2),abs(fit(3)),abs(fit(4)),abs(fit(5)),abs(fit(6)),abs(fit(7)),abs(fit(8)),abs(fit(9)),abs(fit(10))];

% Loeb uuesti sisse punktide ja sisendparameetrite vektorite väärtused.
init;

% Arvutab valitud parameetrite fit järgi kõigi nelja graafiku
% kõigi punktide energiad.
l1v=arvuta(l1base,l1d1,l1d2,l1r1,l1r2,l1r3,l1r4,absfit);
l2v=arvuta(l2base,l2d1,l2d2,l2r1,l2r2,l2r3,l2r4,absfit);
l3v=arvuta(l3base,l3d1,l3d2,l3r1,l3r2,l3r3,l3r4,absfit);
l4v=arvuta(l4base,l4d1,l4d2,l4r1,l4r2,l4r3,l4r4,absfit);

% Nihutab energiagraafikuid vertikaalsuunas nii, et miinimumkohal oleks
% energia null.
l1v=l1v-min(l1v);
l2v=l2v-min(l2v);
l3v=l3v-min(l3v);
l4v=l4v-min(l4v);

% Arvutab iga grafiku punktidest ruutvea summaarsed väärtused.
l1r=sum((l1v-l1g).^2);
l2r=sum((l2v-l2g).^2);
l3r=sum((l3v-l3g).^2);
l4r=sum((l4v-l4g).^2);

% Liidab nelja graafiku vead kokku üheks veaväärtuseks,
% mille funktsioon tagastab.
r=l1r+l2r+l3r+l4r;

y=r;
end

