% Põhiprogramm.

% Loeb sisse fititavad graafiku punktid
init;

% Fittimisel kasutatav maksimaalne iteratsioonide arv suurendatakse 10000-ni:
fitopts = struct('MaxFunEvals',10000,'MaxIter',10000);

% Baasenergia graafiku joonistamise jaoks viime baasenergia miinimumpunkti
% nullnivoole.
l1basesh=l1base-min(l1base);
l2basesh=l2base-min(l2base);
l3basesh=l3base-min(l3base);
l4basesh=l4base-min(l4base);

% S ja O3 elektrilaengute algväärtused.
fit=[1.0817; -0.6142];

% Teisendame S-Li VdW potentsiaali 12-6 kujult dibu kujule
%S1 Li1 12-6 2 63856.2590045 363.018304152

V12=63856.2590045;
V6=363.018304152;
R0=(2*V12/V6)^(1/6);
D0=V12/R0^12;
A=D0*exp(12);
rho=R0/12;
C=D0*R0;
fit=[fit;A;rho;C;0];

% Teisendame O3-Li VdW potentsiaali 12-6 kujult dibu kujule
%O3 Li1 12-6 2 12244.6538283 115.448532607

V12=12244.6538283;
V6=115.448532607;
R0=(2*V12/V6)^(1/6);
D0=V12/R0^12;
A=D0*exp(12);
rho=R0/12;
C=D0*R0;
fit=[fit;A;rho;C;0];

% Alglähend on juba eelmine kord välja arvutatud. Siin on tema arvulised
% väärtused.
% Alglähend (eelmine Li-nafion FIELD):
fit=[
	1.081700
	-0.614200
	83970
	0.229679
	452.3
	0.000000
	44290
	0.20362
	115.8
	0.000000
	]

algfit=fit;

C1=algfit(5);
C2=algfit(9);

% Arvutame alglähendi vea suuruse kolme eri kriteeriumi järgi:
algalltapsus=totalerror_allpoints(fit);
algcoldtapsus=totalerror_cold(fit);
alghottapsus=totalerror_hot(fit);

% Arvutame alglähendile vastava energia graafiku kuju.
% Neljast erinevat tüüpi Gaussiani skännist l1...l4
% saab neli eraldi graafikut.
% Graafikute y-teljele minevad energia väärtused on vektorites l1v...l4v.
l1v=arvuta(l1base,l1d1,l1d2,l1r1,l1r2,l1r3,l1r4,fit);
l2v=arvuta(l2base,l2d1,l2d2,l2r1,l2r2,l2r3,l2r4,fit);
l3v=arvuta(l3base,l3d1,l3d2,l3r1,l3r2,l3r3,l3r4,fit);
l4v=arvuta(l4base,l4d1,l4d2,l4r1,l4r2,l4r3,l4r4,fit);

% Nihutame graafikute miinimumkohad energia nullnivoole.
l1alg=l1v-min(l1v);
l2alg=l2v-min(l2v);
l3alg=l3v-min(l3v);
l4alg=l4v-min(l4v);

% confun - funktsioon, mille väärtust minimeerida. Funktsioonil tohib olla
% ainult üks sisendvektor, mille kõiki elemente võib muuta.
% Selleks, et elektrilaengud ja dibu energia C-parameetrid ei muutuks,
% tuleb need sisendmuutujate vektorist välja võtta.
confun=@(x)(totalerror_allpoints([1.0817; -0.6142; x(1); x(2); C1; x(3); x(4); x(5); C2; x(6)]));

% conx0 - funktsiooni confun esialgne sisendmuutujate vektor.
conx0=[fit(3);fit(4);fit(6);fit(7);fit(8);fit(10)];

% Minimeerida confun(x) väärtus, muutes x-vektorit.
[x,b,c,d]=fminsearch(confun, conx0, fitopts);

% Leitud x vektori elemendid kirjutame tagasi fit-vektorisse õigesse kohta
fit=[1.0817; -0.6142; x(1); x(2); C1; x(3); x(4); x(5); C2; x(6)];

% Et dibu parameetrid ei läheks negatiivseks, kasutame fminsearch leitud
% arvude absoluutväärtusi.
fit=[fit(1),fit(2),abs(fit(3)),abs(fit(4)),abs(fit(5)),abs(fit(6)),abs(fit(7)),abs(fit(8)),abs(fit(9)),abs(fit(10))];

% Salvestame fittimise tulemuse ja arvutame tema lõpliku vea väärtuse.
allfit=fit;
alltapsus=totalerror_allpoints(fit)

% Arvutame fititud jõuvälja järgi kõigi punktide energiad
% graafikule kandmiseks

l1v=arvuta(l1base,l1d1,l1d2,l1r1,l1r2,l1r3,l1r4,fit);
l2v=arvuta(l2base,l2d1,l2d2,l2r1,l2r2,l2r3,l2r4,fit);
l3v=arvuta(l3base,l3d1,l3d2,l3r1,l3r2,l3r3,l3r4,fit);
l4v=arvuta(l4base,l4d1,l4d2,l4r1,l4r2,l4r3,l4r4,fit);

% Nihutame graafikute miinimumid nullenergiale

l1fitall=l1v-min(l1v);
l2fitall=l2v-min(l2v);
l3fitall=l3v-min(l3v);
l4fitall=l4v-min(l4v);

% Samasugune fittimine, aga seekord toatemperatuurile vastavate Boltzmanni
% kordajatega kaalutud veafunktsiooniga.

confun=@(x)(totalerror_cold([1.0817; -0.6142; x(1); x(2); C1; x(3); x(4); x(5); C2; x(6)]));
conx0=[fit(3);fit(4);fit(6);fit(7);fit(8);fit(10)];
[x,b,c,d]=fminsearch(confun, conx0, fitopts);
fit=[1.0817; -0.6142; x(1); x(2); C1; x(3); x(4); x(5); C2; x(6)];
fit=[fit(1),fit(2),abs(fit(3)),abs(fit(4)),abs(fit(5)),abs(fit(6)),abs(fit(7)),abs(fit(8)),abs(fit(9)),abs(fit(10))];
coldfit=fit;
coldtapsus=totalerror_cold(fit)

l1v=arvuta(l1base,l1d1,l1d2,l1r1,l1r2,l1r3,l1r4,fit);
l2v=arvuta(l2base,l2d1,l2d2,l2r1,l2r2,l2r3,l2r4,fit);
l3v=arvuta(l3base,l3d1,l3d2,l3r1,l3r2,l3r3,l3r4,fit);
l4v=arvuta(l4base,l4d1,l4d2,l4r1,l4r2,l4r3,l4r4,fit);

l1fitcold=l1v-min(l1v);
l2fitcold=l2v-min(l2v);
l3fitcold=l3v-min(l3v);
l4fitcold=l4v-min(l4v);

% Samasugune fittimine, aga seekord kõrgemale temperatuurile vastavate
% Boltzmanni kordajatega kaalutud veafunktsiooniga.

confun=@(x)(totalerror_hot([1.0817; -0.6142; x(1); x(2); C1; x(3); x(4); x(5); C2; x(6)]));
conx0=[fit(3);fit(4);fit(6);fit(7);fit(8);fit(10)];
[x,b,c,d]=fminsearch(confun, conx0, fitopts);
fit=[1.0817; -0.6142; x(1); x(2); C1; x(3); x(4); x(5); C2; x(6)];
fit=[fit(1),fit(2),abs(fit(3)),abs(fit(4)),abs(fit(5)),abs(fit(6)),abs(fit(7)),abs(fit(8)),abs(fit(9)),abs(fit(10))];
hotfit=fit;
hottapsus=totalerror_hot(fit)

l1v=arvuta(l1base,l1d1,l1d2,l1r1,l1r2,l1r3,l1r4,fit);
l2v=arvuta(l2base,l2d1,l2d2,l2r1,l2r2,l2r3,l2r4,fit);
l3v=arvuta(l3base,l3d1,l3d2,l3r1,l3r2,l3r3,l3r4,fit);
l4v=arvuta(l4base,l4d1,l4d2,l4r1,l4r2,l4r3,l4r4,fit);

l1fithot=l1v-min(l1v);
l2fithot=l2v-min(l2v);
l3fithot=l3v-min(l3v);
l4fithot=l4v-min(l4v);

% Graafiku joonistamine

subplot(2,2,1);
plot(x1,l1g,'o',x1,l1basesh,x1,l1alg,x1,l1fitall,x1,l1fithot,x1,l1fitcold);
axis([min(x1),max(x1),0,100]);
legend('Gaussian','Baaspotentsiaal','Alglähend','Fititudd kaaludeta','kaalutud 2930K','kaalutud 293K');
xlabel('X-Li / A'); 
ylabel('Energia / (kcal/mol)');
title('1-koordinaatne kaugus scan');

subplot(2,2,2);
plot(x2,l2g,'o',x2,l2basesh,x2,l2alg,x2,l2fitall,x2,l2fithot,x2,l2fitcold);
axis([min(x2),max(x2),0,60]);
legend('Gaussian','Baaspotentsiaal','Alglähend','Fititud kaaludeta','kaalutud 2930K','kaalutud 293K'); 
xlabel('S-Li / A'); 
ylabel('Energia / (kcal/mol)');
title('2-koordinaatne kaugus scan');

subplot(2,2,3);
plot(x3,l3g,'o',x3,l3basesh,x3,l3alg,x3,l3fitall,x3,l3fithot,x3,l3fitcold);
axis([min(x3),max(x3),0,10]);
legend('Gaussian','Baaspotentsiaal','Alglähend','Fititud kaaludeta','kaalutud 2930K','kaalutud 293K'); 
xlabel('Li Beta');
ylabel('Energia / (kcal/mol)');
title('2-koordinaatne ruuminurk scan');

subplot(2,2,4);
plot(x4,l4g,'o',x4,l4basesh,x4,l4alg,x4,l4fitall,x4,l4fithot,x4,l4fitcold);
axis([min(x4),max(x4),0,80]);
legend('Gaussian','Baaspotentsiaal','Alglähend','Fititud kaaludeta','kaalutud 2930K','kaalutud 293K'); 
xlabel('X-Li / A');
ylabel('Energia / (kcal/mol)'); 
title('3-koordinaatne kaugus scan');

% Hinnangulise fittimistäpsuse ja fittimisel tekkinud võimalike vigade
% väljatrükk
y=fit
tapsus=b
info=d

% Leitud parimate parameetrite väljatrükk
% koos vastavate veafunktsioonide väärtustega.

fprintf(1,'\n');

fprintf(1,'Alglähend: [\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n]\n', algfit(1), algfit(2), algfit(3), algfit(4), algfit(5), algfit(6), algfit(7), algfit(8), algfit(9), algfit(10));

fprintf(1,'\n');

fprintf(1,'Kaaludeta fit: [\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n]\n', allfit(1), allfit(2), allfit(3), allfit(4), allfit(5), allfit(6), allfit(7), allfit(8), allfit(9), allfit(10));
fprintf(1,'Selle viga: %12.6f\n',alltapsus);
fprintf(1,'Alglähendi viga sama kriteeriumi järgi: %12.6f\n',algalltapsus);

fprintf(1,'\n');

fprintf(1,'Madalatemperatuuriline fit: [\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n]\n', coldfit(1), coldfit(2), coldfit(3), coldfit(4), coldfit(5), coldfit(6), coldfit(7), coldfit(8), coldfit(9), coldfit(10));
fprintf(1,'Selle viga: %12.6f\n',coldtapsus);
fprintf(1,'Alglähendi viga sama kriteeriumi järgi: %12.6f\n',algcoldtapsus);

fprintf(1,'\n');

fprintf(1,'Kõrgtemperatuuriline fit: [\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n%12.6f\n]\n', hotfit(1), hotfit(2), hotfit(3), hotfit(4), hotfit(5), hotfit(6), hotfit(7), hotfit(8), hotfit(9), hotfit(10));
fprintf(1,'Selle viga: %12.6f\n',hottapsus);
fprintf(1,'Alglähendi viga sama kriteeriumi järgi: %12.6f\n',alghottapsus);

fprintf(1,'\n');

% Programmi lõpp.

