% Siin failis on kirjas punktid, mida fittida, ja iga punkti jaoks kõik
% vajalikud parameetrid selle punkti energia arvutamiseks.

% l1 kuni l5 tähendavad Gaussiani faili järjekorranumbrit, kust on
% konfiguratsioon võetud.

% l1 - esimene fail, 1-coordinated
% lxbase - baasenergiate vektor funktsiooni arvuta() sisendiks.
% Arvutatud Gaussiani failist võetud aatomite koordinaatide järgi
% molekulaardünaamika jõuvälja alusel, kus fittimiseks mõeldud parameetrid
% on ära nullitud.
l1base=[217062.19530998; 217062.44840601; 217062.76480907; 217063.12588026; 217063.51692089; 217063.92650419; 217064.34582112; 217064.76818728; 217065.18858867; 217065.60333037; 217066.00974033; 217066.40594534; 217066.79068398; 217067.16316187; 217067.52293718; 217067.86983686; 217068.20388329; 217068.52524877; 217068.83420210; 217069.13109253; 217069.41631379];
% lxb1 ja %lxb2 - samamoodi arvutatud energia, aga vastavalt kas S või O
% aatomile on antud osalaeng +1.
% lxb1-lxbase annab väävli elektrivälja potentsiaali.
l1b1=[217194.55372408; 217184.59285108; 217176.12744140; 217168.85736488; 217162.55565452; 217157.04781108; 217152.19769288; 217147.89772692; 217144.06185017; 217140.62064700; 217137.51749008; 217134.70586342; 217132.14716276; 217129.80922024; 217127.66496917; 217125.69153844; 217123.86944060; 217122.18201414; 217120.61493221; 217119.15580229; 217117.79385369];
l1b2=[217952.92284657; 217887.90697823; 217839.67279749; 217802.16081971; 217771.96742950; 217747.02367991; 217725.99338063; 217707.97125308; 217692.31942055; 217678.57437815; 217666.38981545; 217655.50132286; 217645.70275311; 217636.83103252; 217628.75498979; 217621.36790852; 217614.58181993; 217608.32358130; 217602.53181270; 217597.15452230; 217592.14734867];
% lxr1, lxr2, lxr3, lxr4 - S-Li ja O-Li vahekaugused, nagu kirjeldatud
% failis "arvuta.m".
l1r1=[2.45280539; 2.65280587; 2.85280577; 3.05280536; 3.25280526; 3.45280574; 3.65280609; 3.85280523; 4.05280558; 4.25280561; 4.45280596; 4.65280510; 4.85280545; 5.05280548; 5.25280583; 5.45280542; 5.65280532; 5.85280580; 6.05280570; 6.25280529; 6.45280519];
l1r2=[3.43723796; 3.62260798; 3.80945814; 3.99758023; 4.18680429; 4.37698694; 4.56800818; 4.75976605; 4.95217700; 5.14516669; 5.33867258; 5.53263930; 5.72702211; 5.92177891; 6.11687425; 6.31227575; 6.50795721; 6.70389394; 6.90006347; 7.09644628; 7.29302622];
l1r3=[1.00000022; 1.20000070; 1.40000060; 1.60000019; 1.80000009; 2.00000057; 2.20000092; 2.40000006; 2.60000041; 2.80000043; 3.00000079; 3.19999993; 3.40000028; 3.60000030; 3.80000065; 4.00000025; 4.20000015; 4.40000062; 4.60000052; 4.80000012; 5.00000002];
l1r4=[3.44044353; 3.62582665; 3.81268702; 4.00081793; 4.19004859; 4.38023688; 4.57126286; 4.76302418; 4.95543827; 5.14842995; 5.34193789; 5.53590591; 5.73029003; 5.92504737; 6.12014349; 6.31554559; 6.51122713; 6.70716401; 6.90333338; 7.09971625; 7.29629586];
% lxgauss - Gaussiani arvutatud energiad.
l1gauss=[-1448338.73738748; -1448495.50163718; -1448553.44612213; -1448570.48306553; -1448571.10569090; -1448565.74200341; -1448558.67680478; -1448551.54635789; -1448544.93450238; -1448539.02641229; -1448533.83082586; -1448529.28601272; -1448525.30055001; -1448521.78599970; -1448518.66525768; -1448515.87339147; -1448513.35674428; -1448511.07292240; -1448508.98562107; -1448507.53160128; -1448506.05465459];
%l2 - teine Gaussiani fail
l2base=[217068.36174332; 217068.43435038; 217068.59782412; 217068.82374166; 217069.08974500; 217069.37917933; 217069.68011726; 217069.98422370; 217070.28581636; 217070.58109067; 217070.86758088; 217071.14376098];
l2b1=[217169.08628340; 217163.05039232; 217157.78409167; 217153.15181958; 217149.04542525; 217145.37890484; 217142.08349306; 217139.10400091; 217136.39560965; 217133.92171129; 217131.65203471; 217129.56140042];
l2b2=[217761.86667401; 217742.51949885; 217725.27048794; 217709.82896218; 217695.94530220; 217683.40823531; 217672.03925674; 217661.68818871; 217652.22789249; 217643.55082999; 217635.56533142; 217628.19316026];
l2r1=[3.19999923; 3.39999975; 3.60000028; 3.79999958; 4.00000010; 4.19999940; 4.40000022; 4.59999952; 4.80000005; 4.99999967; 5.19999987; 5.39999950];
l2r2=[2.60020701; 2.77878817; 2.96011002; 3.14369729; 3.32917717; 3.51624820; 3.70467191; 3.89424886; 4.08482104; 4.27625370; 4.46843728; 4.66127816];
l2r3=[4.53700394; 4.73487270; 4.93291340; 5.13110502; 5.32943282; 5.52788003; 5.72643671; 5.92508906; 6.12383023; 6.32264991; 6.52154243; 6.72050001];
l2r4=[2.61034325; 2.78879650; 2.96999670; 3.15346923; 3.33884156; 3.52581198; 3.71414127; 3.90363062; 4.09412111; 4.28547725; 4.47758971; 4.67036368];
l2gauss=[-1448575.78025814; -1448568.18841282; -1448561.07584256; -1448554.54562029; -1448548.61593299; -1448543.27706110; -1448538.48547941; -1448534.18807152; -1448530.32588747; -1448526.84267326; -1448523.68945986; -1448520.82325221];
%l3 - kolmas Gaussianiu fail
l3base=[217104.83056212; 217078.32361860; 217071.20566634; 217069.62727708; 217069.56519223; 217069.85413889; 217070.16521508; 217070.41645433; 217070.59745525; 217070.71647107; 217070.78462742; 217070.81163669; 217070.80501029; 217070.77025262; 217070.71127459];
l3b1=[217241.61552194; 217215.10858025; 217207.99061365; 217206.41221320; 217206.35011498; 217206.63910398; 217206.95014450; 217207.20138666; 217207.38238408; 217207.50140841; 217207.56957978; 217207.59652239; 217207.58992454; 217207.55519074; 217207.49616880];
l3b2=[217886.84659874; 217865.21629417; 217862.78467363; 217865.54409439; 217869.30661321; 217872.75103625; 217875.41871763; 217877.14300887; 217877.88570358; 217877.68955522; 217876.65734246; 217874.93431364; 217872.69057665; 217870.10158715; 217867.33399661];
l3r1=[2.37519926; 2.37519923; 2.37519948; 2.37519967; 2.37519989; 2.37519917; 2.37519978; 2.37519973; 2.37519979; 2.37519964; 2.37519939; 2.37520052; 2.37520004; 2.37519963; 2.37520038];
l3r2=[1.90915691; 1.90915669; 1.90915688; 1.90915706; 1.90915725; 1.90915634; 1.90915683; 1.90915699; 1.90915709; 1.90915706; 1.90915673; 1.90915749; 1.90915733; 1.90915666; 1.90915692];
l3r3=[3.81139532; 3.80041597; 3.78465364; 3.76416898; 3.73904168; 3.70936985; 3.67527452; 3.63689263; 3.59438520; 3.54793278; 3.49773967; 3.44403417; 3.38706507; 3.32711211; 3.26448070];
l3r4=[2.13546827; 2.07383400; 2.01936367; 1.97308133; 1.93593730; 1.90875438; 1.89217325; 1.88659926; 1.89217293; 1.90875426; 1.93593673; 1.97308182; 2.01936392; 2.07383402; 2.13546910];
l3gauss=[-1448584.72563306; -1448593.85443234; -1448598.02331056; -1448599.75670613; -1448600.33326663; -1448600.35579060; -1448600.09463154; -1448599.64270753; -1448599.01099946; -1448598.17787451; -1448597.11432408; -1448595.80217688; -1448594.24478329; -1448592.47207603; -1448590.54249997];
%l4 - Neljas Gaussiani fail
l4base=[186225.22785107; 186225.39638986; 186225.59366105; 186225.81029749; 186226.03941216; 186226.27588922; 186226.51589803; 186226.75657746; 186226.99580529; 186227.23201115; 186227.46406085; 186227.69114438; 186227.91270527; 186228.12837886; 186228.33794526; 186228.54129887; 186228.73841855; 186228.92934568; 186229.11417073; 186229.29301492; 186229.46602786];
l4b1=[186425.43097782; 186402.52308321; 186384.25917409; 186369.37116066; 186357.01311347; 186346.59892970; 186337.70979800; 186330.03854015; 186323.35480406; 186317.48253272; 186312.28483139; 186307.65370976; 186303.50289243; 186299.76258030; 186296.37581832; 186293.29556317; 186290.48271260; 186287.90446253; 186285.53311553; 186283.34514214; 186281.32039917];
l4b2=[187119.25023279; 187083.36326450; 187049.69510653; 187018.67873352; 186990.41410316; 186964.81079760; 186941.68225064; 186920.80274650; 186901.93977728; 186884.87112646; 186869.39259045; 186855.32097285; 186842.49427291; 186830.77018390; 186820.02459699; 186810.14907941; 186801.04922691; 186792.64264729; 186784.85739636; 186777.63058068; 186770.90698081];
l4r1=[1.60000038; 1.80000002; 1.99999998; 2.20000062; 2.40000057; 2.60000021; 2.79999985; 2.99999986; 3.20000045; 3.40000040; 3.60000010; 3.80000005; 3.99999969; 4.20000060; 4.40000029; 4.60000024; 4.79999988; 4.99999984; 5.20000048; 5.40000043; 5.60000007];
l4r2=[1.96596363; 2.10383855; 2.25105716; 2.40590640; 2.56700360; 2.73324544; 2.90374818; 3.07780354; 3.25484309; 3.43440319; 3.61610941; 3.79965378; 3.98478240; 4.17128523; 4.35898407; 4.54773171; 4.73740278; 4.92789067; 5.11910515; 5.31096593; 5.50340622];
l4r3=[1.83104838; 1.96117292; 2.10229911; 2.25236056; 2.40968683; 2.57294602; 2.74107853; 2.91324162; 3.08876050; 3.26709409; 3.44780607; 3.63054113; 3.81500829; 4.00096951; 4.18822391; 4.37660618; 4.56597641; 4.75621725; 4.94722881; 5.13892353; 5.33122814];
l4r4=[1.77122146; 1.90240392; 2.04476365; 2.19612705; 2.35475942; 2.51928693; 2.68862810; 2.86192887; 3.03851205; 3.21783673; 3.39946841; 3.58305777; 3.76831746; 3.95501459; 4.14295211; 4.33197066; 4.52193352; 4.71272746; 4.90425525; 5.09643377; 5.28919178];
l4gauss=[-1448433.23188618; -1448471.89940139; -1448488.58140154; -1448493.58955253; -1448492.53080960; -1448488.44415212; -1448482.98576268; -1448477.05903135; -1448471.14492107; -1448465.49499345; -1448460.22525342; -1448455.37648137; -1448450.94638503; -1448446.91022367; -1448443.23473660; -1448439.88288505; -1448436.81826676; -1448434.00744858; -1448431.42018912; -1448429.03006200; -1448426.81448250];
%l5 - Viies Gaussiani fail, sialdab ainult ühte lisapunkti.
l5base=[186225.10122794];
l5b1=[186454.97409265];
l5b2=[187156.39634554];
l5r1=[1.40000043];
l5r2=[1.83953556];
l5r3=[1.71443158];
l5r4=[1.65387653];
l5gauss=[-1448354.36010678];

% Elektrivälja potentsiaali arvutamine potentsiaalse energia kasvamise põhjal
% laengu kasvades 1 ühiku võrra:
l1d1=l1b1-l1base;
l2d1=l2b1-l2base;
l3d1=l3b1-l3base;
l4d1=l4b1-l4base;
l5d1=l5b1-l5base;

l1d2=l1b2-l1base;
l2d2=l2b2-l2base;
l3d2=l3b2-l3base;
l4d2=l4b2-l4base;
l5d2=l5b2-l5base;

% 5. failis oli 4. faili lisapunkt. Siin pannakse kahest failist
% saadud suuruste vektorid üheks kokku.

l4base=[l5base;l4base];
l4d1=[l5d1;l4d1];
l4d2=[l5d2;l4d2];
l4r1=[l5r1;l4r1];
l4r2=[l5r2;l4r2];
l4r3=[l5r3;l4r3];
l4r4=[l5r4;l4r4];
l4gauss=[l5gauss;l4gauss];

% Nihutame kvantkeemia graafikuid nii, et miinimumis oleks energia null:
l1g=l1gauss-min(l1gauss);
l2g=l2gauss-min(l2gauss);
l3g=l3gauss-min(l3gauss);
l4g=l4gauss-min(l4gauss);
l5g=l5gauss-min(l5gauss);

% Potentsiaali graafiku x-teljele minev suurus: kas liitiumiiooni kaugus
% või selle suuna nurk, olenevalt koordinatsiooni ja skänni tüübist:
x1=1.0:0.2:5.0;
x2=3.2:0.2:5.4;
x3=-35:5:35;
x4=1.6:0.2:5.6;
x5=1.4;

% 4. ja 5. faili x-telje väärtuste kokkupanek
x4=[x5 x4];

