function E=arvuta(base,d1,d2,r1,r2,r3,r4,fit)
% Arvutab etteantud parameetrite järgi energia graafiku kuju.
% Sisend:
% base - baaspotentsiaal. See osa energiast, mis ei sõltu fititavatest
% parameetritest.
% d1 - elektrivälja potentsiaal väävliaatomi asukohas. Ühik: kcal/(mol*e)
% d2 - elektrivälja potentsiaalide summa hapnikuaatomite asukohtades.
% r1 - Li-S vahekaugus /Å
% r2, r3, r4 - kaugused liitiumiioonist kolme hapnikuaatomini.
% fit - jõuvälja parameetrite vektor 10 elemendiga.
% fit[1], fit[2] - väävli ja hapniku laengud
% fit[3]...fit[6] - S-Li VdW parameetrid
% fit[7]...fit[10] - O3-Li VdW parameetrid
% 
% Sisendparameetrid base kuni r4 on antud vektorite kujul, milles iga element
% vastab ühele S-Li vahekaugusele.
% 
% Väljund: vektor arvutatud energiatest, üks kirje iga punkti kohta.

% Baasenergiale liidame elektrostaatilise energia:
E1=base+d1*fit(1)+d2*fit(2);
% Li-S VdW energia, vastavalt dibu valemile
E2=fit(3)*exp(-r1/fit(4))-(fit(5)*r1.^-6)-(fit(6)*r1.^-4);
% Li-O3 VdW energiad, 3 tk.
E3=fit(7)*exp(-r2/fit(8))-(fit(9)*r2.^-6)-(fit(10)*r2.^-4);
E4=fit(7)*exp(-r3/fit(8))-(fit(9)*r3.^-6)-(fit(10)*r3.^-4);
E5=fit(7)*exp(-r4/fit(8))-(fit(9)*r4.^-6)-(fit(10)*r4.^-4);

%Koguenergia on kõigi komponentide summa:
E=E1+E2+E3+E4+E5;
end
