// POV 3.x input script : planaarmolekul.pov 
// try povray +W1272 +H720 -Iplanaarmolekul.pov -Oplanaarmolekul.pov.tga +P +X +A +FT +C
#if (version < 3.5) 
#error "POV3DisplayDevice has been compiled for POV-Ray 3.5 or above.\nPlease upgrade POV-Ray or recompile VMD."
#end 
#declare VMD_clip_on=array[3] {0, 0, 0};
#declare VMD_clip=array[3];
#declare VMD_scaledclip=array[3];
#declare VMD_line_width=0.0020;
#macro VMDC ( C1 )
  texture { pigment { rgbt C1 }}
#end
#macro VMD_point (P1, R1, C1)
  #local T = texture { finish { ambient 1.0 diffuse 0.0 phong 0.0 specular 0.0 } pigment { C1 } }
  #if(VMD_clip_on[2])
  intersection {
    sphere {P1, R1 texture {T} #if(VMD_clip_on[1]) clipped_by {VMD_clip[1]} #end no_shadow}
    VMD_clip[2]
  }
  #else
  sphere {P1, R1 texture {T} #if(VMD_clip_on[1]) clipped_by {VMD_clip[1]} #end no_shadow}
  #end
#end
#macro VMD_line (P1, P2, C1)
  #local T = texture { finish { ambient 1.0 diffuse 0.0 phong 0.0 specular 0.0 } pigment { C1 } }
  #if(VMD_clip_on[2])
  intersection {
    cylinder {P1, P2, VMD_line_width texture {T} #if(VMD_clip_on[1]) clipped_by {VMD_clip[1]} #end no_shadow}
    VMD_clip[2]
  }
  #else
  cylinder {P1, P2, VMD_line_width texture {T} #if(VMD_clip_on[1]) clipped_by {VMD_clip[1]} #end no_shadow}
  #end
#end
#macro VMD_sphere (P1, R1, C1)
  #local T = texture { pigment { C1 } }
  #if(VMD_clip_on[2])
  intersection {
    sphere {P1, R1 texture {T} #if(VMD_clip_on[1]) clipped_by {VMD_clip[1]} #end no_shadow}
    VMD_clip[2]
  }
  #else
  sphere {P1, R1 texture {T} #if(VMD_clip_on[1]) clipped_by {VMD_clip[1]} #end no_shadow}
  #end
#end
#macro VMD_cylinder (P1, P2, R1, C1, O1)
  #local T = texture { pigment { C1 } }
  #if(VMD_clip_on[2])
  intersection {
    cylinder {P1, P2, R1 #if(O1) open #end texture {T} #if(VMD_clip_on[1]) clipped_by {VMD_clip[1]} #end no_shadow}
    VMD_clip[2]
  }
  #else
  cylinder {P1, P2, R1 #if(O1) open #end texture {T} #if(VMD_clip_on[1]) clipped_by {VMD_clip[1]} #end no_shadow}
  #end
#end
#macro VMD_cone (P1, P2, R1, C1)
  #local T = texture { pigment { C1 } }
  #if(VMD_clip_on[2])
  intersection {
    cone {P1, R1, P2, VMD_line_width texture {T} #if(VMD_clip_on[1]) clipped_by {VMD_clip[1]} #end no_shadow}
    VMD_clip[2]
  }
  #else
  cone {P1, R1, P2, VMD_line_width texture {T} #if(VMD_clip_on[1]) clipped_by {VMD_clip[1]} #end no_shadow}
  #end
#end
#macro VMD_triangle (P1, P2, P3, N1, N2, N3, C1)
  #local T = texture { pigment { C1 } }
  smooth_triangle {P1, N1, P2, N2, P3, N3 texture {T} #if(VMD_clip_on[1]) clipped_by {VMD_clip[1]} #end no_shadow}
#end
#macro VMD_tricolor (P1, P2, P3, N1, N2, N3, C1, C2, C3)
  #local NX = P2-P1;
  #local NY = P3-P1;
  #local NZ = vcross(NX, NY);
  #local T = texture { pigment {
    average pigment_map {
      [1 gradient x color_map {[0 rgb 0] [1 C2*3]}]
      [1 gradient y color_map {[0 rgb 0] [1 C3*3]}]
      [1 gradient z color_map {[0 rgb 0] [1 C1*3]}]
    }
    matrix <1.01,0,1,0,1.01,1,0,0,1,-.002,-.002,-1>
    matrix <NX.x,NX.y,NX.z,NY.x,NY.y,NY.z,NZ.x,NZ.y,NZ.z,P1.x,P1.y,P1.z>
  } }
  smooth_triangle {P1, N1, P2, N2, P3, N3 texture {T} #if(VMD_clip_on[1]) clipped_by {VMD_clip[1]} #end no_shadow}
#end
camera {
  orthographic
  location <0.0000, 0.0000, -2.0000>
  look_at <-0.0000, -0.0000, 2.0000>
  up <0.0000, 3.0000, 0.0000>
  right <5.3000, 0.0000, 0.0000>
}
light_source { 
  <-0.1000, 0.1000, -1.0000> 
  color rgb<1.000, 1.000, 1.000> 
  parallel 
  point_at <0.0, 0.0, 0.0> 
}
light_source { 
  <1.0000, 2.0000, -0.5000> 
  color rgb<1.000, 1.000, 1.000> 
  parallel 
  point_at <0.0, 0.0, 0.0> 
}
background {
  color rgb<1.000, 1.000, 1.000>
}
#default { texture {
 finish { ambient 0.000 diffuse 0.650 phong 0.1 phong_size 40.000 specular 0.500 }
} }
// VMD: Starting axes output.
VMD_cylinder(<-1.67833328,-0.94999999,-0.00000000>,<-1.85342705,-0.88325989,-0.10022516>0.0300,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_triangle(<-1.8828336,-0.93595105,-0.083938807>,<-1.8861189,-0.92961478,-0.073980048>,<-1.884326,-0.87148225,-0.11791195>,<0.94861197,0.16443469,0.27036384>,<0.97565639,0.11227569,0.18838495>,<0.96337748,0.14212744,0.22738449>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8828336,-0.93595105,-0.083938807>,<-1.8861189,-0.92961478,-0.073980048>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8861189,-0.92961478,-0.073980048>,<-1.8881478,-0.92149717,-0.065029874>,<-1.884326,-0.87148225,-0.11791195>,<0.97565639,0.11227569,0.18838495>,<0.99235886,0.045452476,0.1147084>,<0.98543477,0.082136251,0.14890255>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8861189,-0.92961478,-0.073980048>,<-1.8881478,-0.92149717,-0.065029874>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8881478,-0.92149717,-0.065029874>,<-1.8888426,-0.91191012,-0.057432242>,<-1.884326,-0.87148225,-0.11791195>,<0.99235886,0.045452476,0.1147084>,<0.99807751,-0.033466857,0.052165762>,<0.99673969,0.0086521888,0.080220245>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8881478,-0.92149717,-0.065029874>,<-1.8888426,-0.91191012,-0.057432242>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8888426,-0.91191012,-0.057432242>,<-1.8881762,-0.90122199,-0.051479105>,<-1.884326,-0.87148225,-0.11791195>,<0.99807751,-0.033466857,0.052165762>,<0.99259257,-0.12144959,0.0031605959>,<0.99685752,-0.075500146,0.023977593>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8888426,-0.91191012,-0.057432242>,<-1.8881762,-0.90122199,-0.051479105>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8881762,-0.90122199,-0.051479105>,<-1.8861746,-0.88984364,-0.047399268>,<-1.884326,-0.87148225,-0.11791195>,<0.99259257,-0.12144959,0.0031605959>,<0.97611487,-0.21511462,-0.030424185>,<0.98578382,-0.16708776,-0.017664624>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8881762,-0.90122199,-0.051479105>,<-1.8861746,-0.88984364,-0.047399268>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8861746,-0.88984364,-0.047399268>,<-1.8829144,-0.87821227,-0.04534949>,<-1.884326,-0.87148225,-0.11791195>,<0.97611487,-0.21511462,-0.030424185>,<0.9492774,-0.31086215,-0.047297627>,<0.9639442,-0.2625902,-0.043105781>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8861746,-0.88984364,-0.047399268>,<-1.8829144,-0.87821227,-0.04534949>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8829144,-0.87821227,-0.04534949>,<-1.8785211,-0.86677492,-0.045408551>,<-1.884326,-0.87148225,-0.11791195>,<0.9492774,-0.31086215,-0.047297627>,<0.91311187,-0.40501291,-0.046811454>,<0.9321779,-0.35833746,-0.051368285>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8829144,-0.87821227,-0.04534949>,<-1.8785211,-0.86677492,-0.045408551>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8785211,-0.86677492,-0.045408551>,<-1.8731633,-0.85597098,-0.047574181>,<-1.884326,-0.87148225,-0.11791195>,<0.91311187,-0.40501291,-0.046811454>,<0.86900783,-0.49394876,-0.028984277>,<0.89170563,-0.45065042,-0.042134676>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8785211,-0.86677492,-0.045408551>,<-1.8731633,-0.85597098,-0.047574181>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8731633,-0.85597098,-0.047574181>,<-1.8670472,-0.84621584,-0.051763169>,<-1.884326,-0.87148225,-0.11791195>,<0.86900783,-0.49394876,-0.028984277>,<0.81866026,-0.57425171,0.0054988563>,<0.84408295,-0.53598112,-0.015759673>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8731633,-0.85597098,-0.047574181>,<-1.8670472,-0.84621584,-0.051763169>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8670472,-0.84621584,-0.051763169>,<-1.8604077,-0.83788419,-0.057814516>,<-1.884326,-0.87148225,-0.11791195>,<0.81866026,-0.57425171,0.0054988563>,<0.76400417,-0.64283609,0.055312719>,<0.79113966,-0.61105067,0.026743233>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8670472,-0.84621584,-0.051763169>,<-1.8604077,-0.83788419,-0.057814516>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8604077,-0.83788419,-0.057814516>,<-1.8534999,-0.83129638,-0.065495692>,<-1.884326,-0.87148225,-0.11791195>,<0.76400417,-0.64283609,0.055312719>,<0.70713991,-0.69706583,0.11854269>,<0.73491067,-0.67297399,0.083740354>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8604077,-0.83788419,-0.057814516>,<-1.8534999,-0.83129638,-0.065495692>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8534999,-0.83129638,-0.065495692>,<-1.8465892,-0.82670546,-0.074511491>,<-1.884326,-0.87148225,-0.11791195>,<0.70713991,-0.69706583,0.11854269>,<0.65025282,-0.73485726,0.19275922>,<0.67755699,-0.71937126,0.15304115>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8534999,-0.83129638,-0.065495692>,<-1.8465892,-0.82670546,-0.074511491>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8465892,-0.82670546,-0.074511491>,<-1.8399414,-0.82428789,-0.08451546>,<-1.884326,-0.87148225,-0.11791195>,<0.65025282,-0.73485726,0.19275922>,<0.59552872,-0.75475824,0.27511027>,<0.62128216,-0.74845999,0.23198316>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8465892,-0.82670546,-0.074511491>,<-1.8399414,-0.82428789,-0.08451546>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8399414,-0.82428789,-0.08451546>,<-1.8338118,-0.82413661,-0.095123149>,<-1.884326,-0.87148225,-0.11791195>,<0.59552872,-0.75475824,0.27511027>,<0.54507089,-0.75600362,0.36243096>,<0.56824905,-0.75912201,0.3175323>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8399414,-0.82428789,-0.08451546>,<-1.8338118,-0.82413661,-0.095123149>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8338118,-0.82413661,-0.095123149>,<-1.828436,-0.82625741,-0.1059269>,<-1.884326,-0.87148225,-0.11791195>,<0.54507089,-0.75600362,0.36243096>,<0.50081843,-0.73854584,0.4513658>,<0.52049589,-0.75094777,0.40640083>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8338118,-0.82413661,-0.095123149>,<-1.828436,-0.82625741,-0.1059269>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.828436,-0.82625741,-0.1059269>,<-1.8240206,-0.83056873,-0.11651152>,<-1.884326,-0.87148225,-0.11791195>,<0.50081843,-0.73854584,0.4513658>,<0.46447182,-0.70305556,0.53849691>,<0.47985739,-0.72425109,0.49517399>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.828436,-0.82625741,-0.1059269>,<-1.8240206,-0.83056873,-0.11651152>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8240206,-0.83056873,-0.11651152>,<-1.8207353,-0.836905,-0.1264703>,<-1.884326,-0.87148225,-0.11791195>,<0.46447182,-0.70305556,0.53849691>,<0.43742776,-0.65089679,0.62047583>,<0.44789577,-0.68005824,0.58043969>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8240206,-0.83056873,-0.11651152>,<-1.8207353,-0.836905,-0.1264703>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8207353,-0.836905,-0.1264703>,<-1.8187063,-0.84502262,-0.13542047>,<-1.884326,-0.87148225,-0.11791195>,<0.43742776,-0.65089679,0.62047583>,<0.42072558,-0.5840739,0.69415247>,<0.42583874,-0.62006724,0.6589219>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8207353,-0.836905,-0.1264703>,<-1.8187063,-0.84502262,-0.13542047>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8187063,-0.84502262,-0.13542047>,<-1.8180116,-0.85460973,-0.1430181>,<-1.884326,-0.87148225,-0.11791195>,<0.42072558,-0.5840739,0.69415247>,<0.41500717,-0.50515479,0.75669527>,<0.41453409,-0.54658371,0.72760403>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8187063,-0.84502262,-0.13542047>,<-1.8180116,-0.85460973,-0.1430181>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8180116,-0.85460973,-0.1430181>,<-1.8186779,-0.86529779,-0.14897123>,<-1.884326,-0.87148225,-0.11791195>,<0.41500717,-0.50515479,0.75669527>,<0.42049223,-0.41717207,0.80570078>,<0.41441649,-0.46243122,0.78384715>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8180116,-0.85460973,-0.1430181>,<-1.8186779,-0.86529779,-0.14897123>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8186779,-0.86529779,-0.14897123>,<-1.8206797,-0.8766762,-0.15305106>,<-1.884326,-0.87148225,-0.11791195>,<0.42049223,-0.41717207,0.80570078>,<0.43697006,-0.32350719,0.83928561>,<0.42549026,-0.3708438,0.82548946>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8186779,-0.86529779,-0.14897123>,<-1.8206797,-0.8766762,-0.15305106>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8206797,-0.8766762,-0.15305106>,<-1.8239398,-0.88830757,-0.15510084>,<-1.884326,-0.87148225,-0.11791195>,<0.43697006,-0.32350719,0.83928561>,<0.46380734,-0.22775953,0.85615909>,<0.44732994,-0.27534139,0.85093069>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8206797,-0.8766762,-0.15305106>,<-1.8239398,-0.88830757,-0.15510084>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8239398,-0.88830757,-0.15510084>,<-1.8283331,-0.89974493,-0.15504175>,<-1.884326,-0.87148225,-0.11791195>,<0.46380734,-0.22775953,0.85615909>,<0.49997282,-0.13360865,0.85567284>,<0.47909603,-0.17959395,0.85919327>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8239398,-0.88830757,-0.15510084>,<-1.8283331,-0.89974493,-0.15504175>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8283331,-0.89974493,-0.15504175>,<-1.8336909,-0.91054881,-0.15287611>,<-1.884326,-0.87148225,-0.11791195>,<0.49997282,-0.13360865,0.85567284>,<0.54407668,-0.04467259,0.8378455>,<0.5195682,-0.087280892,0.84995943>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8283331,-0.89974493,-0.15504175>,<-1.8336909,-0.91054881,-0.15287611>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8336909,-0.91054881,-0.15287611>,<-1.839807,-0.920304,-0.14868711>,<-1.884326,-0.87148225,-0.11791195>,<0.54407668,-0.04467259,0.8378455>,<0.59442371,0.035630655,0.80336225>,<0.56719065,-0.0019498277,0.8235842>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8336909,-0.91054881,-0.15287611>,<-1.839807,-0.920304,-0.14868711>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.839807,-0.920304,-0.14868711>,<-1.8464465,-0.9286356,-0.14263575>,<-1.884326,-0.87148225,-0.11791195>,<0.59442371,0.035630655,0.80336225>,<0.64907956,0.10421506,0.75354815>,<0.6201334,0.073119812,0.78108132>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.839807,-0.920304,-0.14868711>,<-1.8464465,-0.9286356,-0.14263575>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8464465,-0.9286356,-0.14263575>,<-1.8533545,-0.93522346,-0.13495457>,<-1.884326,-0.87148225,-0.11791195>,<0.64907956,0.10421506,0.75354815>,<0.70594352,0.158445,0.69031799>,<0.67636222,0.13504328,0.7240839>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8464465,-0.9286356,-0.14263575>,<-1.8533545,-0.93522346,-0.13495457>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8533545,-0.93522346,-0.13495457>,<-1.860265,-0.93981433,-0.12593876>,<-1.884326,-0.87148225,-0.11791195>,<0.70594352,0.158445,0.69031799>,<0.76283067,0.19623655,0.61610109>,<0.73371565,0.18144071,0.65478289>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8533545,-0.93522346,-0.13495457>,<-1.860265,-0.93981433,-0.12593876>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.860265,-0.93981433,-0.12593876>,<-1.8669128,-0.94223189,-0.11593479>,<-1.884326,-0.87148225,-0.11791195>,<0.76283067,0.19623655,0.61610109>,<0.81755465,0.21613751,0.53374988>,<0.78999054,0.21052958,0.57584041>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.860265,-0.93981433,-0.12593876>,<-1.8669128,-0.94223189,-0.11593479>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8669128,-0.94223189,-0.11593479>,<-1.8730425,-0.94238317,-0.10532711>,<-1.884326,-0.87148225,-0.11791195>,<0.81755465,0.21613751,0.53374988>,<0.86801255,0.21738276,0.44642895>,<0.8430236,0.22119157,0.49029133>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8669128,-0.94223189,-0.11593479>,<-1.8730425,-0.94238317,-0.10532711>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8730425,-0.94238317,-0.10532711>,<-1.8784182,-0.94026238,-0.094523348>,<-1.884326,-0.87148225,-0.11791195>,<0.86801255,0.21738276,0.44642895>,<0.91226536,0.19992478,0.35749412>,<0.89077705,0.21301703,0.40142259>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8730425,-0.94238317,-0.10532711>,<-1.8784182,-0.94026238,-0.094523348>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8784182,-0.94026238,-0.094523348>,<-1.8828336,-0.93595099,-0.083938718>,<-1.884326,-0.87148225,-0.11791195>,<0.91226536,0.19992478,0.35749412>,<0.94861221,0.1644343,0.27036312>,<0.93141562,0.18632013,0.31264949>,rgbt<1.000,0.000,0.000,0.000>)
VMD_triangle(<-1.8784182,-0.94026238,-0.094523348>,<-1.8828336,-0.93595099,-0.083938718>,<-1.8534271,-0.88325989,-0.10022516>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,<0.82396251,-0.31406787,0.47164303>,rgbt<1.000,0.000,0.000,0.000>)
VMD_cylinder(<-1.67833328,-0.94999999,-0.00000000>,<-1.67808592,-1.12667596,-0.11808020>0.0300,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_triangle(<-1.6789219,-1.1614033,-0.0661221>,<-1.6910981,-1.1606572,-0.067263961>,<-1.6780423,-1.1578541,-0.13891788>,<0.00588409,0.99879277,0.048768152>,<0.10611546,0.99265105,0.05816783>,<0.056480199,0.99718571,0.049301308>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6789219,-1.1614033,-0.0661221>,<-1.6910981,-1.1606572,-0.067263961>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6910981,-1.1606572,-0.067263961>,<-1.7027742,-1.1586051,-0.070358664>,<-1.6780423,-1.1578541,-0.13891788>,<0.10611546,0.99265105,0.05816783>,<0.20223066,0.97575957,0.083642907>,<0.15547876,0.98557234,0.066885285>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6910981,-1.1606572,-0.067263961>,<-1.7027742,-1.1586051,-0.070358664>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7027742,-1.1586051,-0.070358664>,<-1.7135015,-1.1553261,-0.075287282>,<-1.6780423,-1.1578541,-0.13891788>,<0.20223066,0.97575957,0.083642907>,<0.29053584,0.94876748,0.12421434>,<0.24846432,0.96344602,0.10018617>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7027742,-1.1586051,-0.070358664>,<-1.7135015,-1.1553261,-0.075287282>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7135015,-1.1553261,-0.075287282>,<-1.7228677,-1.1509461,-0.081860408>,<-1.6780423,-1.1578541,-0.13891788>,<0.29053584,0.94876748,0.12421434>,<0.36763752,0.9127121,0.17832322>,<0.33186281,0.93165749,0.14792415>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7135015,-1.1553261,-0.075287282>,<-1.7228677,-1.1509461,-0.081860408>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7228677,-1.1509461,-0.081860408>,<-1.7305131,-1.1456335,-0.089825429>,<-1.6780423,-1.1578541,-0.13891788>,<0.36763752,0.9127121,0.17832322>,<0.43057299,0.86897904,0.24389>,<0.40247017,0.89142776,0.20826524>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7228677,-1.1509461,-0.081860408>,<-1.7305131,-1.1456335,-0.089825429>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7305131,-1.1456335,-0.089825429>,<-1.7361437,-1.1395922,-0.098876283>,<-1.6780423,-1.1578541,-0.13891788>,<0.43057299,0.86897904,0.24389>,<0.47692329,0.81924891,0.31839499>,<0.45757234,0.84430325,0.27888986>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7305131,-1.1456335,-0.089825429>,<-1.7361437,-1.1395922,-0.098876283>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7361437,-1.1395922,-0.098876283>,<-1.7395432,-1.1330546,-0.10866512>,<-1.6780423,-1.1578541,-0.13891788>,<0.47692329,0.81924891,0.31839499>,<0.50490749,0.76543278,0.39897507>,<0.49505198,0.79209495,0.35708416>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7361437,-1.1395922,-0.098876283>,<-1.7395432,-1.1330546,-0.10866512>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7395432,-1.1330546,-0.10866512>,<-1.7405809,-1.1262718,-0.11881578>,<-1.6780423,-1.1578541,-0.13891788>,<0.50490749,0.76543278,0.39897507>,<0.51344997,0.70959878,0.48253378>,<0.51346892,0.7368089,0.43984354>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7395432,-1.1330546,-0.10866512>,<-1.7405809,-1.1262718,-0.11881578>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7405809,-1.1262718,-0.11881578>,<-1.7392169,-1.1195047,-0.12893815>,<-1.6780423,-1.1578541,-0.13891788>,<0.51344997,0.70959878,0.48253378>,<0.50222248,0.65389246,0.56585974>,<0.51211524,0.68056995,0.52398735>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7405809,-1.1262718,-0.11881578>,<-1.7392169,-1.1195047,-0.12893815>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7392169,-1.1195047,-0.12893815>,<-1.7355038,-1.113013,-0.13864329>,<-1.6780423,-1.1578541,-0.13891788>,<0.50222248,0.65389246,0.56585974>,<0.47165644,0.60045469,0.64575106>,<0.49104264,0.62553912,0.606282>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7392169,-1.1195047,-0.12893815>,<-1.7355038,-1.113013,-0.13864329>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7355038,-1.113013,-0.13864329>,<-1.7295841,-1.1070465,-0.14755818>,<-1.6780423,-1.1578541,-0.13891788>,<0.47165644,0.60045469,0.64575106>,<0.42292672,0.55133915,0.71913713>,<0.45106143,0.57383132,0.68356508>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7355038,-1.113013,-0.13864329>,<-1.7295841,-1.1070465,-0.14755818>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7295841,-1.1070465,-0.14755818>,<-1.7216854,-1.1018343,-0.15534025>,<-1.6780423,-1.1578541,-0.13891788>,<0.42292672,0.55133915,0.71913713>,<0.35790572,0.50843334,0.783198>,<0.39370808,0.52743393,0.75286609>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7295841,-1.1070465,-0.14755818>,<-1.7216854,-1.1018343,-0.15534025>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7216854,-1.1018343,-0.15534025>,<-1.7121111,-1.0975767,-0.16169046>,<-1.6780423,-1.1578541,-0.13891788>,<0.35790572,0.50843334,0.783198>,<0.27909198,0.47338587,0.83547199>,<0.32118604,0.48812965,0.8115226>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7216854,-1.1018343,-0.15534025>,<-1.7121111,-1.0975767,-0.16169046>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7121111,-1.0975767,-0.16169046>,<-1.7012293,-1.0944375,-0.16636471>,<-1.6780423,-1.1578541,-0.13891788>,<0.27909198,0.47338587,0.83547199>,<0.18951467,0.4475438,0.87395012>,<0.23628262,0.4574289,0.85728019>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7121111,-1.0975767,-0.16169046>,<-1.7012293,-1.0944375,-0.16636471>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7012293,-1.0944375,-0.16636471>,<-1.6894581,-1.092537,-0.16918345>,<-1.6780423,-1.1578541,-0.13891788>,<0.18951467,0.4475438,0.87395012>,<0.092615895,0.43190029,0.89715362>,<0.14226088,0.43651175,0.88838023>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.7012293,-1.0944375,-0.16636471>,<-1.6894581,-1.092537,-0.16918345>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6894581,-1.092537,-0.16918345>,<-1.6772499,-1.0919486,-0.1700383>,<-1.6780423,-1.1578541,-0.13891788>,<0.092615895,0.43190029,0.89715362>,<-0.0078803534,0.4270564,0.90419066>,<0.042733509,0.42618188,0.90362769>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6894581,-1.092537,-0.16918345>,<-1.6772499,-1.0919486,-0.1700383>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6772499,-1.0919486,-0.1700383>,<-1.6650738,-1.0926948,-0.16889644>,<-1.6780423,-1.1578541,-0.13891788>,<-0.0078803534,0.4270564,0.90419066>,<-0.1081121,0.43319833,0.89479101>,<-0.058473993,0.4268364,0.90243644>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6772499,-1.0919486,-0.1700383>,<-1.6650738,-1.0926948,-0.16889644>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6650738,-1.0926948,-0.16889644>,<-1.6533978,-1.0947467,-0.16580173>,<-1.6780423,-1.1578541,-0.13891788>,<-0.1081121,0.43319833,0.89479101>,<-0.20422757,0.45009002,0.86931598>,<-0.15747307,0.43845001,0.88485253>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6650738,-1.0926948,-0.16889644>,<-1.6533978,-1.0947467,-0.16580173>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6533978,-1.0947467,-0.16580173>,<-1.6426704,-1.0980258,-0.1608731>,<-1.6780423,-1.1578541,-0.13891788>,<-0.20422757,0.45009002,0.86931598>,<-0.29253298,0.47708225,0.82874423>,<-0.25045863,0.46057639,0.85155141>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6533978,-1.0947467,-0.16580173>,<-1.6426704,-1.0980258,-0.1608731>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6426704,-1.0980258,-0.1608731>,<-1.6333041,-1.1024058,-0.15429997>,<-1.6780423,-1.1578541,-0.13891788>,<-0.29253298,0.47708225,0.82874423>,<-0.36963496,0.51313794,0.77463508>,<-0.33385766,0.49236545,0.80381304>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6426704,-1.0980258,-0.1608731>,<-1.6333041,-1.1024058,-0.15429997>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6333041,-1.1024058,-0.15429997>,<-1.6256588,-1.1077185,-0.14633493>,<-1.6780423,-1.1578541,-0.13891788>,<-0.36963496,0.51313794,0.77463508>,<-0.43257025,0.55687135,0.709068>,<-0.40446493,0.53259534,0.7434718>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6333041,-1.1024058,-0.15429997>,<-1.6256588,-1.1077185,-0.14633493>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6256588,-1.1077185,-0.14633493>,<-1.6200281,-1.1137598,-0.13728407>,<-1.6780423,-1.1578541,-0.13891788>,<-0.43257025,0.55687135,0.709068>,<-0.4789204,0.60660166,0.63456261>,<-0.45956698,0.57972014,0.67284685>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6256588,-1.1077185,-0.14633493>,<-1.6200281,-1.1137598,-0.13728407>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6200281,-1.1137598,-0.13728407>,<-1.6166288,-1.1202973,-0.12749523>,<-1.6780423,-1.1578541,-0.13891788>,<-0.4789204,0.60660166,0.63456261>,<-0.50690418,0.66041797,0.55398226>,<-0.4970465,0.63192856,0.59465218>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6200281,-1.1137598,-0.13728407>,<-1.6166288,-1.1202973,-0.12749523>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6166288,-1.1202973,-0.12749523>,<-1.615591,-1.1270801,-0.11734456>,<-1.6780423,-1.1578541,-0.13891788>,<-0.50690418,0.66041797,0.55398226>,<-0.51544619,0.71625209,0.47042331>,<-0.51546282,0.68721479,0.51189256>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6166288,-1.1202973,-0.12749523>,<-1.615591,-1.1270801,-0.11734456>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.615591,-1.1270801,-0.11734456>,<-1.6169549,-1.1338472,-0.10722217>,<-1.6780423,-1.1578541,-0.13891788>,<-0.51544619,0.71625209,0.47042331>,<-0.5042184,0.77195823,0.38709724>,<-0.51410866,0.7434538,0.4277485>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.615591,-1.1270801,-0.11734456>,<-1.6169549,-1.1338472,-0.10722217>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6169549,-1.1338472,-0.10722217>,<-1.6206682,-1.1403389,-0.097517051>,<-1.6780423,-1.1578541,-0.13891788>,<-0.5042184,0.77195823,0.38709724>,<-0.47365198,0.82539582,0.30720621>,<-0.49303591,0.79848433,0.34545392>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6169549,-1.1338472,-0.10722217>,<-1.6206682,-1.1403389,-0.097517051>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6206682,-1.1403389,-0.097517051>,<-1.6265879,-1.1463054,-0.088602163>,<-1.6780423,-1.1578541,-0.13891788>,<-0.47365198,0.82539582,0.30720621>,<-0.42492184,0.874511,0.23382036>,<-0.45305422,0.85019183,0.26817113>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6206682,-1.1403389,-0.097517051>,<-1.6265879,-1.1463054,-0.088602163>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6265879,-1.1463054,-0.088602163>,<-1.6344866,-1.1515176,-0.080820091>,<-1.6780423,-1.1578541,-0.13891788>,<-0.42492184,0.874511,0.23382036>,<-0.35990056,0.91741669,0.16975971>,<-0.39570054,0.89658886,0.19887032>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6265879,-1.1463054,-0.088602163>,<-1.6344866,-1.1515176,-0.080820091>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6344866,-1.1515176,-0.080820091>,<-1.6440609,-1.1557752,-0.074469909>,<-1.6780423,-1.1578541,-0.13891788>,<-0.35990056,0.91741669,0.16975971>,<-0.28108674,0.95246381,0.1174859>,<-0.32317823,0.93589312,0.14021391>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6344866,-1.1515176,-0.080820091>,<-1.6440609,-1.1557752,-0.074469909>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6440609,-1.1557752,-0.074469909>,<-1.6549426,-1.1589144,-0.069795646>,<-1.6780423,-1.1578541,-0.13891788>,<-0.28108674,0.95246381,0.1174859>,<-0.19150946,0.97830564,0.079008281>,<-0.23827499,0.96659344,0.094456829>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6440609,-1.1557752,-0.074469909>,<-1.6549426,-1.1589144,-0.069795646>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6549426,-1.1589144,-0.069795646>,<-1.6667138,-1.1608148,-0.066976935>,<-1.6780423,-1.1578541,-0.13891788>,<-0.19150946,0.97830564,0.079008281>,<-0.094610937,0.99394894,0.055805102>,<-0.14425324,0.9875105,0.063357107>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6549426,-1.1589144,-0.069795646>,<-1.6667138,-1.1608148,-0.066976935>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6667138,-1.1608148,-0.066976935>,<-1.6789221,-1.1614033,-0.0661221>,<-1.6780423,-1.1578541,-0.13891788>,<-0.094610937,0.99394894,0.055805102>,<0.0058849398,0.99879277,0.048768155>,<-0.044726212,0.99784011,0.048110038>,rgbt<0.000,1.000,0.000,0.000>)
VMD_triangle(<-1.6667138,-1.1608148,-0.066976935>,<-1.6789221,-1.1614033,-0.0661221>,<-1.6780859,-1.126676,-0.1180802>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,<-0.0011638829,0.83140576,0.55566448>,rgbt<0.000,1.000,0.000,0.000>)
VMD_cylinder(<-1.67833328,-0.94999999,-0.00000000>,<-1.55792069,-0.85258925,-0.14549594>0.0300,rgbt<0.000,0.000,1.000,0.000>,1)
VMD_triangle(<-1.6006994,-0.8651374,-0.18930064>,<-1.6054709,-0.8543396,-0.18602043>,<-1.5366714,-0.83539915,-0.17117168>,<-0.13374323,-0.28977993,0.94770271>,<-0.094464786,-0.37866539,0.92070031>,<-0.11035584,-0.33322418,0.93636709>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.6006994,-0.8651374,-0.18930064>,<-1.6054709,-0.8543396,-0.18602043>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.6054709,-0.8543396,-0.18602043>,<-1.6084151,-0.84347457,-0.18118289>,<-1.5366714,-0.83539915,-0.17117168>,<-0.094464786,-0.37866539,0.92070031>,<-0.070228636,-0.4681046,0.88087803>,<-0.078331575,-0.42313603,0.90267384>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.6054709,-0.8543396,-0.18602043>,<-1.6084151,-0.84347457,-0.18118289>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.6084151,-0.84347457,-0.18118289>,<-1.6094189,-0.83295983,-0.17497392>,<-1.5366714,-0.83539915,-0.17117168>,<-0.070228636,-0.4681046,0.88087803>,<-0.06196611,-0.5546602,0.82976633>,<-0.061945628,-0.51187342,0.85682464>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.6084151,-0.84347457,-0.18118289>,<-1.6094189,-0.83295983,-0.17497392>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.6094189,-0.83295983,-0.17497392>,<-1.6084435,-0.82319945,-0.16763213>,<-1.5366714,-0.83539915,-0.17117168>,<-0.06196611,-0.5546602,0.82976633>,<-0.069994934,-0.63500613,0.76932961>,<-0.061827846,-0.59602541,0.80058163>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.6094189,-0.83295983,-0.17497392>,<-1.6084435,-0.82319945,-0.16763213>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.6084435,-0.82319945,-0.16763213>,<-1.6055267,-0.81456846,-0.15943965>,<-1.5366714,-0.83539915,-0.17117168>,<-0.069994934,-0.63500613,0.76932961>,<-0.094006374,-0.70605469,0.70189005>,<-0.077982664,-0.67235929,0.7361058>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.6084435,-0.82319945,-0.16763213>,<-1.6055267,-0.81456846,-0.15943965>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.6055267,-0.81456846,-0.15943965>,<-1.6007802,-0.80739862,-0.15071133>,<-1.5366714,-0.83539915,-0.17117168>,<-0.094006374,-0.70605469,0.70189005>,<-0.13307758,-0.76507539,0.63003969>,<-0.1097891,-0.73794049,0.66587543>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.6055267,-0.81456846,-0.15943965>,<-1.6007802,-0.80739862,-0.15071133>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.6007802,-0.80739862,-0.15071133>,<-1.5943868,-0.80196542,-0.14178258>,<-1.5366714,-0.83539915,-0.17117168>,<-0.13307758,-0.76507539,0.63003969>,<-0.18570721,-0.80980039,0.5565396>,<-0.15602493,-0.79024941,0.59258926>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.6007802,-0.80739862,-0.15071133>,<-1.5943868,-0.80196542,-0.14178258>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5943868,-0.80196542,-0.14178258>,<-1.5865921,-0.79847765,-0.13299653>,<-1.5366714,-0.83539915,-0.17117168>,<-0.18570721,-0.80980039,0.5565396>,<-0.24987273,-0.83851075,0.48421404>,<-0.21491346,-0.82727581,0.51906341>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5943868,-0.80196542,-0.14178258>,<-1.5865921,-0.79847765,-0.13299653>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5865921,-0.79847765,-0.13299653>,<-1.5776954,-0.79706937,-0.12469083>,<-1.5366714,-0.83539915,-0.17117168>,<-0.24987273,-0.83851075,0.48421404>,<-0.3231084,-0.85010338,0.41584289>,<-0.28419155,-0.84759676,0.44812378>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5865921,-0.79847765,-0.13299653>,<-1.5776954,-0.79706937,-0.12469083>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5776954,-0.79706937,-0.12469083>,<-1.5680388,-0.7977947,-0.11718465>,<-1.5366714,-0.83539915,-0.17117168>,<-0.3231084,-0.85010338,0.41584289>,<-0.40259975,-0.8441326,0.3540532>,<-0.36119708,-0.85043132,0.38249621>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5776954,-0.79706937,-0.12469083>,<-1.5680388,-0.7977947,-0.11718465>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5680388,-0.7977947,-0.11718465>,<-1.5579934,-0.8006258,-0.11076647>,<-1.5366714,-0.83539915,-0.17117168>,<-0.40259975,-0.8441326,0.3540532>,<-0.48529166,-0.82082796,0.30121985>,<-0.44297054,-0.83567053,0.32470283>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5680388,-0.7977947,-0.11718465>,<-1.5579934,-0.8006258,-0.11076647>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5579934,-0.8006258,-0.11076647>,<-1.5479453,-0.80545378,-0.10568291>,<-1.5366714,-0.83539915,-0.17117168>,<-0.48529166,-0.82082796,0.30121985>,<-0.56800687,-0.78108513,0.25937301>,<-0.52636915,-0.80388182,0.27696487>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5579934,-0.8006258,-0.11076647>,<-1.5479453,-0.80545378,-0.10568291>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5479453,-0.80545378,-0.10568291>,<-1.5382804,-0.81209314,-0.10212936>,<-1.5366714,-0.83539915,-0.17117168>,<-0.56800687,-0.78108513,0.25937301>,<-0.64756656,-0.72643101,0.23012067>,<-0.60818869,-0.75628656,0.24111639>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5479453,-0.80545378,-0.10568291>,<-1.5382804,-0.81209314,-0.10212936>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5382804,-0.81209314,-0.10212936>,<-1.5293703,-0.82028878,-0.10024235>,<-1.5366714,-0.83539915,-0.17117168>,<-0.64756656,-0.72643101,0.23012067>,<-0.72091323,-0.6589663,0.21458727>,<-0.68528473,-0.69471377,0.2185352>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5382804,-0.81209314,-0.10212936>,<-1.5293703,-0.82028878,-0.10024235>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5293703,-0.82028878,-0.10024235>,<-1.5215573,-0.82972562,-0.10009441>,<-1.5366714,-0.83539915,-0.17117168>,<-0.72091323,-0.6589663,0.21458727>,<-0.78522813,-0.58128333,0.21336955>,<-0.75469416,-0.62152988,0.21008924>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5293703,-0.82028878,-0.10024235>,<-1.5215573,-0.82972562,-0.10009441>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5215573,-0.82972562,-0.10009441>,<-1.515142,-0.84004122,-0.10169123>,<-1.5366714,-0.83539915,-0.17117168>,<-0.78522813,-0.58128333,0.21336955>,<-0.83803976,-0.49636748,0.22651443>,<-0.81374973,-0.53954685,0.21610293>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5215573,-0.82972562,-0.10009441>,<-1.515142,-0.84004122,-0.10169123>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.515142,-0.84004122,-0.10169123>,<-1.5103704,-0.85083896,-0.10497145>,<-1.5366714,-0.83539915,-0.17117168>,<-0.83803976,-0.49636748,0.22651443>,<-0.87731844,-0.40748218,0.25351679>,<-0.86018193,-0.45191598,0.23634534>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.515142,-0.84004122,-0.10169123>,<-1.5103704,-0.85083896,-0.10497145>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5103704,-0.85083896,-0.10497145>,<-1.5074263,-0.86170399,-0.109809>,<-1.5366714,-0.83539915,-0.17117168>,<-0.87731844,-0.40748218,0.25351679>,<-0.90155482,-0.31804293,0.29333881>,<-0.89220649,-0.36200398,0.27003849>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5103704,-0.85083896,-0.10497145>,<-1.5074263,-0.86170399,-0.109809>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5074263,-0.86170399,-0.109809>,<-1.5064225,-0.87221873,-0.11601797>,<-1.5366714,-0.83539915,-0.17117168>,<-0.90155482,-0.31804293,0.29333881>,<-0.90981746,-0.23148708,0.34445024>,<-0.90859264,-0.27326679,0.31588736>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5074263,-0.86170399,-0.109809>,<-1.5064225,-0.87221873,-0.11601797>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5064225,-0.87221873,-0.11601797>,<-1.5073979,-0.88197917,-0.12335977>,<-1.5366714,-0.83539915,-0.17117168>,<-0.90981746,-0.23148708,0.34445024>,<-0.90178877,-0.15114076,0.40488708>,<-0.9087106,-0.18911411,0.37213036>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5064225,-0.87221873,-0.11601797>,<-1.5073979,-0.88197917,-0.12335977>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5073979,-0.88197917,-0.12335977>,<-1.5103147,-0.8906101,-0.13155225>,<-1.5366714,-0.83539915,-0.17117168>,<-0.90178877,-0.15114076,0.40488708>,<-0.87777734,-0.080091909,0.47232652>,<-0.89255583,-0.11278008,0.43660602>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5073979,-0.88197917,-0.12335977>,<-1.5103147,-0.8906101,-0.13155225>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5103147,-0.8906101,-0.13155225>,<-1.5150611,-0.89777994,-0.14028059>,<-1.5366714,-0.83539915,-0.17117168>,<-0.87777734,-0.080091909,0.47232652>,<-0.8387059,-0.021070745,0.54417694>,<-0.86074913,-0.047198392,0.50683641>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5103147,-0.8906101,-0.13155225>,<-1.5150611,-0.89777994,-0.14028059>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5150611,-0.89777994,-0.14028059>,<-1.5214546,-0.90321314,-0.14920934>,<-1.5366714,-0.83539915,-0.17117168>,<-0.8387059,-0.021070745,0.54417694>,<-0.78607601,0.023654463,0.61767709>,<-0.81451315,0.0051109642,0.58012259>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5150611,-0.89777994,-0.14028059>,<-1.5214546,-0.90321314,-0.14920934>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5214546,-0.90321314,-0.14920934>,<-1.5292494,-0.90670091,-0.15799539>,<-1.5366714,-0.83539915,-0.17117168>,<-0.78607601,0.023654463,0.61767709>,<-0.72191006,0.052365087,0.69000268>,<-0.75562423,0.04213747,0.65364861>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5214546,-0.90321314,-0.14920934>,<-1.5292494,-0.90670091,-0.15799539>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5292494,-0.90670091,-0.15799539>,<-1.538146,-0.90810919,-0.16630109>,<-1.5366714,-0.83539915,-0.17117168>,<-0.72191006,0.052365087,0.69000268>,<-0.64867413,0.063957818,0.75837409>,<-0.68634576,0.062458575,0.72458851>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5292494,-0.90670091,-0.15799539>,<-1.538146,-0.90810919,-0.16630109>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.538146,-0.90810919,-0.16630109>,<-1.5478026,-0.90738386,-0.17380726>,<-1.5366714,-0.83539915,-0.17117168>,<-0.64867413,0.063957818,0.75837409>,<-0.56918263,0.057986889,0.82016379>,<-0.60934007,0.065293103,0.79021609>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.538146,-0.90810919,-0.16630109>,<-1.5478026,-0.90738386,-0.17380726>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5478026,-0.90738386,-0.17380726>,<-1.557848,-0.90455276,-0.18022543>,<-1.5366714,-0.83539915,-0.17117168>,<-0.56918263,0.057986889,0.82016379>,<-0.48649043,0.034682002,0.87299728>,<-0.52756643,0.050532117,0.84800959>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5478026,-0.90738386,-0.17380726>,<-1.557848,-0.90455276,-0.18022543>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.557848,-0.90455276,-0.18022543>,<-1.5678962,-0.89972478,-0.18530899>,<-1.5366714,-0.83539915,-0.17117168>,<-0.48649043,0.034682002,0.87299728>,<-0.40377513,-0.0050614034,0.91484427>,<-0.44416764,0.018743053,0.89574766>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.557848,-0.90455276,-0.18022543>,<-1.5678962,-0.89972478,-0.18530899>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5678962,-0.89972478,-0.18530899>,<-1.577561,-0.89308536,-0.18886253>,<-1.5366714,-0.83539915,-0.17117168>,<-0.40377513,-0.0050614034,0.91484427>,<-0.32421532,-0.059715886,0.94409668>,<-0.36234772,-0.028852748,0.93159628>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5678962,-0.89972478,-0.18530899>,<-1.577561,-0.89308536,-0.18886253>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.577561,-0.89308536,-0.18886253>,<-1.5864711,-0.88488978,-0.19074953>,<-1.5366714,-0.83539915,-0.17117168>,<-0.32421532,-0.059715886,0.94409668>,<-0.25086886,-0.12718119,0.95963007>,<-0.28525198,-0.090425923,0.9541775>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.577561,-0.89308536,-0.18886253>,<-1.5864711,-0.88488978,-0.19074953>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5864711,-0.88488978,-0.19074953>,<-1.5942841,-0.87545282,-0.19089746>,<-1.5366714,-0.83539915,-0.17117168>,<-0.25086886,-0.12718119,0.95963007>,<-0.18655412,-0.20486458,0.96084756>,<-0.21584269,-0.16361043,0.96262336>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5864711,-0.88488978,-0.19074953>,<-1.5942841,-0.87545282,-0.19089746>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5942841,-0.87545282,-0.19089746>,<-1.6006994,-0.86513728,-0.18930063>,<-1.5366714,-0.83539915,-0.17117168>,<-0.18655412,-0.20486458,0.96084756>,<-0.13374287,-0.28978065,0.94770253>,<-0.1567874,-0.24559373,0.95660943>,rgbt<0.000,0.000,1.000,0.000>)
VMD_triangle(<-1.5942841,-0.87545282,-0.19089746>,<-1.6006994,-0.86513728,-0.18930063>,<-1.5579207,-0.85258925,-0.14549594>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,<-0.56664217,-0.458399,0.68468028>,rgbt<0.000,0.000,1.000,0.000>)
VMD_sphere(<-1.6783,-0.9500,-0.0000>,0.0300,rgbt<0.250,0.750,0.750,0.000>)
// VMD: Done with axes.
#declare VMD_line_width=0.0020;
// MoleculeID: 1 ReprID: 0 Beginning CPK
// MoleculeID: 1 ReprID: 0 Beginning VDW
VMD_sphere(<2.9043,-1.3990,0.0597>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<3.0129,-1.4467,-0.1136>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.7592,-1.2553,0.0111>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.8079,-1.5701,0.1339>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<3.0507,-1.3151,0.2277>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<3.1171,-1.4798,0.3443>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<3.2183,-1.2280,0.1304>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.9600,-1.1525,0.3761>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<2.9155,-1.2497,0.5598>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<3.1094,-1.0055,0.4108>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.7629,-1.0404,0.3034>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<2.8072,-0.9440,0.1193>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.6132,-1.1873,0.2697>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.6728,-0.8771,0.4514>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<2.7767,-0.8923,0.6361>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.7100,-0.6856,0.3673>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.4397,-0.8925,0.4974>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<2.4136,-0.8751,0.7075>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.3437,-0.7284,0.4025>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.3303,-1.0918,0.4266>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<2.1260,-1.0773,0.4828>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.3428,-1.1011,0.2147>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.4155,-1.2964,0.5137>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<2.4317,-1.4339,0.3525>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.6097,-1.2583,0.5911>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.2876,-1.4002,0.6855>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<2.3361,-1.6071,0.6868>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.3464,-1.3149,0.8710>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.0509,-1.3810,0.6682>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.9646,-1.5484,0.7665>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.9924,-1.2040,0.7702>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.9609,-1.3713,0.4480>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<2.1233,-1.3568,0.3119>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.8573,-1.5533,0.4120>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.8111,-1.1920,0.4022>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.9044,-1.0639,0.2607>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.6358,-1.2743,0.3149>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.7445,-1.0590,0.5881>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.9165,-0.9572,0.6602>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.6041,-0.9155,0.5184>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.6459,-1.1745,0.7715>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.6544,-1.3794,0.7375>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.7571,-1.1281,0.9567>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<1.7598,-1.3061,1.0876>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.8693,-1.2531,1.2922>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<2.0765,-1.1887,1.2506>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<1.7859,-1.0658,1.4133>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.9012,-1.4100,1.4249>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.5760,-1.3747,1.1562>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.8719,-1.4686,1.0223>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.9414,-0.9342,1.4546>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.7012,-1.1300,1.5920>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.6414,-0.9680,1.3003>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.2178,-1.3239,1.3534>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<2.1823,-1.3610,1.5549>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.2612,-1.5038,1.2587>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.4330,-1.2224,1.3619>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<2.4926,-1.1546,1.5491>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.5876,-1.3335,1.2784>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.4469,-0.9868,1.2111>,0.0700,rgbt<1.000,1.000,0.000,0.000>)
VMD_sphere(<2.3066,-0.8348,1.3124>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<2.3773,-1.0402,0.9981>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<2.6666,-0.9180,1.2156>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<2.4615,-0.7394,1.0527>,0.0584,rgbt<1.000,1.000,1.000,0.000>)
VMD_sphere(<1.4188,-1.1069,0.7957>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.3362,-1.2139,0.9595>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.4173,-0.8994,0.8414>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.2771,-1.1410,0.6074>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.0927,-1.0429,0.6461>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.3694,-1.0498,0.4391>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.2288,-1.3671,0.5504>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.3915,-1.4415,0.4358>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.2155,-1.4783,0.7309>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.0290,-1.4051,0.4265>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.0808,-1.5134,0.2512>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<0.9004,-1.5250,0.5458>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<0.9071,-1.2119,0.3595>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<0.7432,-1.2763,0.2408>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<0.8322,-1.1182,0.5349>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.0273,-1.0482,0.2351>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<0.8867,-0.9364,0.1218>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.1226,-0.9183,0.3736>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.1935,-1.1296,0.0853>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.2735,-1.3084,0.1677>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.0981,-1.1755,-0.0989>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.3754,-0.9831,0.0386>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.5473,-1.0594,0.1375>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.4096,-0.9867,-0.1710>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.3484,-0.7558,0.1042>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.1406,-0.7201,0.1308>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.4469,-0.7298,0.2906>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.4320,-0.5912,-0.0461>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.2700,-0.4654,-0.1014>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.5763,-0.4753,0.0582>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.5335,-0.6715,-0.2459>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.6566,-0.5165,-0.3231>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.6562,-0.8372,-0.1945>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.3862,-0.7409,-0.4195>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.4830,-0.8948,-0.5294>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.2117,-0.8210,-0.3285>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.3174,-0.5733,-0.5740>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.1572,-0.6524,-0.6888>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.2463,-0.4072,-0.4623>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.4832,-0.4938,-0.7253>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.6516,-0.4339,-0.6191>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.5404,-0.6558,-0.8643>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<1.7431,-0.7280,-0.8139>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.9008,-0.6366,-0.9670>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.9186,-0.4189,-0.9334>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<2.1272,-0.7061,-0.9424>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.8503,-0.6427,-1.1686>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.8221,-0.6659,-0.6320>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.7780,-0.9318,-0.8362>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.1341,-0.9103,-0.9043>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.2151,-0.6038,-0.7841>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.2324,-0.6654,-1.1170>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.9555,-0.3173,-1.1261>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<2.1227,-0.3781,-1.2336>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.7941,-0.3015,-1.2561>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.0062,-0.0880,-1.0866>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.9573,0.0423,-1.2410>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.9344,-0.0101,-0.9077>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<2.2811,-0.0416,-1.0603>,0.0700,rgbt<1.000,1.000,0.000,0.000>)
VMD_sphere(<2.3883,-0.2155,-1.1666>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<2.3265,-0.0371,-0.8346>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<2.3241,0.1610,-1.1612>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<2.5698,0.0072,-1.0328>,0.0584,rgbt<1.000,1.000,1.000,0.000>)
VMD_sphere(<1.3969,-0.3094,-0.8487>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.5582,-0.1775,-0.8900>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.3206,-0.3841,-1.0324>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.2243,-0.1830,-0.7442>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.0719,-0.3183,-0.6841>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.3066,-0.0912,-0.5712>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.1227,-0.0126,-0.8758>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.0098,-0.1072,-1.0289>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<0.9904,0.0964,-0.7503>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.2697,0.1434,-0.9796>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.4689,0.0867,-0.9319>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.2426,0.1284,-1.1898>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.2424,0.3719,-0.9186>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.3474,0.4037,-0.7367>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.3312,0.4908,-1.0707>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<1.0188,0.4478,-0.8880>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.0064,0.6460,-0.9636>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<0.8913,0.3225,-1.0028>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<0.9370,0.4498,-0.6644>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<1.0782,0.3482,-0.5425>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<0.9251,0.6523,-0.6013>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<0.7240,0.3496,-0.6282>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<0.7553,0.1645,-0.5288>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<0.6126,0.4779,-0.5008>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<0.5924,0.3069,-0.8220>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<0.6415,0.4537,-0.9676>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<0.6466,0.1155,-0.8966>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<0.3561,0.3096,-0.7926>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<0.2993,0.5074,-0.7402>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<0.2669,0.2596,-0.9789>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<0.2679,0.1622,-0.6277>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<0.3283,-0.0352,-0.6778>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<0.3540,0.2149,-0.4407>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<0.0312,0.1616,-0.6014>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-0.0456,-0.0056,-0.7075>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-0.0112,0.1371,-0.3947>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-0.0846,0.3554,-0.6771>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-0.0882,0.4955,-0.5174>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<0.0258,0.4383,-0.8386>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-0.3087,0.3232,-0.7509>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-0.3090,0.2726,-0.9526>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-0.4017,0.1590,-0.6360>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-0.4798,0.0064,-0.7754>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-0.5098,-0.1995,-0.6597>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-0.3407,-0.2316,-0.5212>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-0.6951,-0.2132,-0.5109>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-0.5025,-0.3731,-0.7739>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-0.6705,0.0383,-0.8519>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-0.3541,-0.0518,-0.9304>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-0.7486,-0.4123,-0.4837>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-0.8566,-0.1091,-0.5902>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-0.6437,-0.1304,-0.3272>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-0.1956,-0.3707,-0.6129>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-0.2538,-0.5696,-0.6292>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-0.1092,-0.3112,-0.7924>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-0.0040,-0.3895,-0.4728>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<0.0458,-0.2182,-0.3660>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-0.0036,-0.5520,-0.3431>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<0.2314,-0.4343,-0.6178>,0.0700,rgbt<1.000,1.000,0.000,0.000>)
VMD_sphere(<0.2203,-0.3009,-0.8052>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<0.2348,-0.6583,-0.6712>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<0.4064,-0.3755,-0.4800>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-2.6212,-2.4500,-0.7700>,0.0584,rgbt<1.000,1.000,1.000,0.000>)
VMD_sphere(<-0.4330,0.5237,-0.7187>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-0.4551,0.5536,-0.5095>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-0.3195,0.6842,-0.7993>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-0.6498,0.5312,-0.8168>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-0.6570,0.6998,-0.9459>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-0.6749,0.3550,-0.9327>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-0.8339,0.5466,-0.6666>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-0.7744,0.4604,-0.4818>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-0.8758,0.7526,-0.6359>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.0359,0.4405,-0.7348>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.0291,0.2388,-0.6684>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.1972,0.5393,-0.6380>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.0813,0.4388,-0.9686>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.2851,0.4923,-0.9956>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-0.9589,0.5866,-1.0597>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.0442,0.2330,-1.0825>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-0.9062,0.2697,-1.2397>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-0.9567,0.0972,-0.9446>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.2358,0.1277,-1.1768>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.1785,0.0433,-1.3632>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.2951,-0.0288,-1.0459>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.4254,0.2666,-1.2150>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.5340,0.2800,-1.0328>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.3549,0.4601,-1.2671>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.5766,0.1959,-1.3849>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.7449,0.1080,-1.2896>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.6402,0.3684,-1.4912>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.4925,0.0394,-1.5434>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.3015,0.1073,-1.6069>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.4696,-0.1473,-1.4446>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.6253,0.0032,-1.7377>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.8079,0.1087,-1.7122>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.5212,0.0852,-1.9038>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.6785,-0.2230,-1.7895>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.8149,-0.2221,-1.9524>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.4994,-0.3196,-1.8505>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.7750,-0.3523,-1.6143>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.6711,-0.5374,-1.6053>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.7447,-0.2476,-1.4320>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.0075,-0.4001,-1.6332>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.0997,-0.2533,-1.7479>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.0352,-0.5958,-1.7320>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-1.9024,-0.6089,-1.9082>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.9527,-0.8062,-2.0316>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.1329,-0.7721,-2.1549>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-1.7950,-0.8726,-2.1971>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.0094,-0.9734,-1.9219>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.9256,-0.4626,-2.0540>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.6996,-0.6348,-1.8708>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.7246,-0.7050,-2.2980>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.8859,-1.0011,-2.3329>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.6354,-0.9702,-2.1066>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.3082,-0.8632,-2.0560>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.3246,-1.0702,-2.0663>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.3482,-0.8023,-1.8613>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.5070,-0.7950,-2.1679>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.6228,-0.9488,-2.2463>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.6300,-0.6659,-2.0611>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.4545,-0.6433,-2.3975>,0.0700,rgbt<1.000,1.000,0.000,0.000>)
VMD_sphere(<-2.6507,-0.6351,-2.5179>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-2.2872,-0.7523,-2.5122>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-2.3884,-0.4348,-2.3256>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-2.3994,-0.4841,-2.6386>,0.0584,rgbt<1.000,1.000,1.000,0.000>)
VMD_sphere(<-2.1058,-0.4055,-1.4164>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.1862,-0.2129,-1.3767>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.2645,-0.5467,-1.4204>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.9616,-0.4630,-1.2358>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.7736,-0.5182,-1.3177>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.9359,-0.2897,-1.1155>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.0343,-0.6400,-1.0940>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.8682,-0.7015,-0.9766>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.1845,-0.5627,-0.9652>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.1228,-0.8329,-1.2019>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.0096,-0.8664,-1.3785>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.0966,-0.9983,-1.0711>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.3528,-0.8243,-1.2632>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.4307,-0.6380,-1.1970>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.3639,-0.8319,-1.4752>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.4924,-0.9966,-1.1766>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.6916,-0.9561,-1.2384>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.4298,-1.1804,-1.2629>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.4935,-1.0237,-0.9401>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.4399,-1.2248,-0.8974>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.3455,-0.8946,-0.8591>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.6990,-0.9779,-0.8288>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.6714,-1.0183,-0.6221>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.7415,-0.7712,-0.8533>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.8893,-1.1007,-0.9023>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.8535,-1.1625,-1.1024>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.9069,-1.2731,-0.7794>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.0980,-0.9862,-0.8976>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.1570,-0.9668,-0.6944>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.0677,-0.7924,-0.9791>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.2777,-1.0878,-1.0163>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.4016,-1.1865,-0.8746>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.3898,-0.9332,-1.1095>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.2183,-1.2461,-1.1840>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.0905,-1.1487,-1.3229>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.1104,-1.4031,-1.0899>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.3978,-1.3439,-1.3061>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.4143,-1.2409,-1.4911>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.3473,-1.5466,-1.3447>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.6117,-1.3407,-1.2015>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.6635,-1.1449,-1.1548>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.7629,-1.4236,-1.3397>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-3.8189,-1.2700,-1.4884>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.8243,-1.3675,-1.7056>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.7925,-1.2104,-1.8577>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-3.6496,-1.5201,-1.7593>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-4.0055,-1.4482,-1.7676>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.0109,-1.1915,-1.4742>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.6845,-1.1140,-1.5170>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.6817,-1.5995,-1.9487>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.6463,-1.6745,-1.6200>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.4668,-1.4213,-1.7564>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.9797,-1.1778,-1.9704>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-4.0537,-1.3396,-2.0780>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.1367,-1.0883,-1.8675>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.9415,-1.0197,-2.1441>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.8379,-0.8484,-2.0880>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.8558,-1.0961,-2.3174>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.1790,-0.9099,-2.2440>,0.0700,rgbt<1.000,1.000,0.000,0.000>)
VMD_sphere(<-4.1998,-0.7005,-2.1506>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-4.3495,-1.0507,-2.1794>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-4.1567,-0.9007,-2.4731>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-4.4285,-0.7947,-2.3489>,0.0584,rgbt<1.000,1.000,1.000,0.000>)
VMD_sphere(<-3.6053,-1.4713,-1.0025>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.4044,-1.4747,-0.9334>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.7262,-1.3744,-0.8572>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.6799,-1.6967,-1.0208>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.8853,-1.7017,-0.9670>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.6608,-1.7552,-1.2242>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.5656,-1.8576,-0.8877>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.6712,-2.0414,-0.9029>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.3712,-1.8833,-0.9692>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.5415,-1.8064,-0.6564>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.4720,-1.9813,-0.5579>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.3941,-1.6545,-0.6385>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.7372,-1.7318,-0.5431>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.8676,-1.6467,-0.6876>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.8315,-1.9018,-0.4573>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.7052,-1.5712,-0.3702>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.8042,-1.6423,-0.1962>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.4969,-1.5591,-0.3305>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.7840,-1.3508,-0.4140>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.6626,-1.2675,-0.5671>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.9836,-1.3661,-0.4853>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.7837,-1.1994,-0.2302>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.6888,-1.2960,-0.0665>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.6685,-1.0298,-0.2860>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.9962,-1.1219,-0.1560>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-4.0696,-1.2607,-0.0128>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.9674,-0.9341,-0.0609>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.1636,-1.0942,-0.3231>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-4.0665,-1.0385,-0.5037>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.2589,-1.2819,-0.3514>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.3327,-0.9326,-0.2783>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-4.3442,-0.8025,-0.4459>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.5174,-1.0355,-0.2585>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.3027,-0.7984,-0.0839>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-4.2483,-0.9271,0.0761>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.1424,-0.6642,-0.1215>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.4904,-0.6699,-0.0135>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-4.6204,-0.7985,0.0946>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.4198,-0.5180,0.1172>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.6177,-0.5649,-0.1852>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-4.6879,-0.7088,-0.3178>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.7904,-0.4600,-0.0957>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-4.9691,-0.5895,-0.1066>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-5.1386,-0.5039,0.0370>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-5.0508,-0.4556,0.2340>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-5.2352,-0.2949,-0.0233>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-5.2905,-0.6350,0.0912>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-5.0693,-0.5956,-0.2887>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.9487,-0.7834,-0.0347>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-5.4256,-0.3255,-0.1010>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-5.1169,-0.2017,-0.1666>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-5.2486,-0.1728,0.1445>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-5.1002,-0.6157,0.3780>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-5.2922,-0.6142,0.4577>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-5.0523,-0.8101,0.3221>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.9680,-0.5896,0.5743>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-4.8906,-0.3992,0.6054>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-5.0557,-0.6561,0.7507>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.7341,-0.7436,0.5678>,0.0700,rgbt<1.000,1.000,0.000,0.000>)
VMD_sphere(<-4.7327,-0.8536,0.3655>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-4.7458,-0.8896,0.7455>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-4.5576,-0.5970,0.5878>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-4.4885,-0.9052,0.5610>,0.0584,rgbt<1.000,1.000,1.000,0.000>)
VMD_sphere(<-4.4810,-0.4087,-0.3019>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-4.5277,-0.2146,-0.2294>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.2783,-0.4524,-0.2555>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.5024,-0.4051,-0.5390>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-4.4997,-0.6062,-0.6076>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.6910,-0.3192,-0.5859>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.3356,-0.2848,-0.6589>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-4.1485,-0.3227,-0.5657>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.3302,-0.3612,-0.8571>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.3639,-0.0488,-0.6725>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-4.1887,0.0327,-0.7609>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.5293,-0.0103,-0.8001>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.4019,0.0657,-0.4672>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-4.6092,0.0520,-0.4226>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.2923,-0.0348,-0.3155>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.3410,0.2958,-0.4610>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-4.5120,0.4067,-0.4009>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.1892,0.3189,-0.3142>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.2608,0.3900,-0.6643>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-4.3587,0.2912,-0.8249>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.3152,0.5954,-0.6668>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.0262,0.3764,-0.7025>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.9964,0.2870,-0.8929>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.9494,0.5744,-0.7069>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.8996,0.2526,-0.5433>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.8318,0.3883,-0.3945>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-4.0296,0.1110,-0.4528>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.7101,0.1349,-0.6264>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.5746,0.1075,-0.4651>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.7761,-0.0555,-0.6937>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.5909,0.2380,-0.8050>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.6963,0.1981,-0.9851>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.5908,0.4477,-0.7706>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.3651,0.1690,-0.8358>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.2501,0.3417,-0.8817>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.2963,0.0876,-0.6521>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.3256,0.0077,-1.0064>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.4233,0.0744,-1.1829>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.1163,0.0009,-1.0423>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.3992,-0.2143,-0.9618>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.6037,-0.2138,-0.9244>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.3592,-0.3423,-1.1374>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-3.5401,-0.3530,-1.2638>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.4838,-0.4438,-1.4765>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.2802,-0.3788,-1.5329>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-3.4624,-0.6805,-1.4901>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.5945,-0.3769,-1.6393>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.6898,-0.4834,-1.2021>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.6269,-0.1721,-1.3184>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.2654,-0.7307,-1.5335>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.5864,-0.7536,-1.6401>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.5165,-0.7663,-1.3086>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.2636,-0.3709,-1.7531>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.2872,-0.5504,-1.8553>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.3734,-0.2235,-1.8502>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.0413,-0.3114,-1.8140>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.9703,-0.1344,-1.7312>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.8984,-0.4600,-1.7874>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.0152,-0.2584,-2.0877>,0.0700,rgbt<1.000,1.000,0.000,0.000>)
VMD_sphere(<-2.8034,-0.3253,-2.1484>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-3.0453,-0.0316,-2.1146>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-3.1784,-0.3806,-2.1948>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-2.9878,-0.2027,-2.3752>,0.0584,rgbt<1.000,1.000,1.000,0.000>)
VMD_sphere(<-3.2836,-0.3003,-0.7723>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.1963,-0.4858,-0.8280>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.1286,-0.1635,-0.7232>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.4135,-0.3367,-0.5761>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.5474,-0.1731,-0.5554>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.5262,-0.5145,-0.6048>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.2933,-0.3589,-0.3717>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.0860,-0.3476,-0.4166>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.3456,-0.1947,-0.2474>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.3304,-0.5588,-0.2478>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.2180,-0.5456,-0.0680>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.5369,-0.5678,-0.1991>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.2719,-0.7629,-0.3554>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.4442,-0.8346,-0.4569>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.1209,-0.7200,-0.4986>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.1918,-0.9379,-0.2152>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.0069,-0.8748,-0.1317>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.3323,-0.9649,-0.0582>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.1566,-1.1494,-0.3187>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.2898,-1.1641,-0.4836>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.9570,-1.1540,-0.3912>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.1888,-1.3415,-0.1817>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.3974,-1.3627,-0.1474>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.1195,-1.5108,-0.2897>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.0799,-1.3405,0.0300>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.0404,-1.1383,0.0818>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.2141,-1.4229,0.1726>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.8750,-1.4609,0.0446>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.7721,-1.4368,-0.1397>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.7591,-1.3734,0.1998>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.8918,-1.6942,0.0888>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.0729,-1.7275,0.1948>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.9020,-1.7952,-0.0978>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.7147,-1.7916,0.2148>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.7984,-1.9419,0.3393>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.5801,-1.8829,0.0780>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.5890,-1.6440,0.3531>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.4345,-1.7569,0.4452>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.5010,-1.4967,0.2279>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.7092,-1.5312,0.5249>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.6496,-1.3322,0.5327>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.9257,-1.5391,0.4814>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-3.0345,-1.4106,0.6245>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.1605,-1.5465,0.7740>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.2490,-1.4198,0.9319>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-3.3543,-1.6526,0.6854>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.0542,-1.6846,0.8873>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.9191,-1.3000,0.7574>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.1828,-1.2879,0.5461>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.3806,-1.8377,0.7764>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.3319,-1.6796,0.4805>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.5215,-1.5344,0.7211>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.1862,-1.4945,1.1302>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.2423,-1.6885,1.1794>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.9866,-1.4672,1.1817>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.2959,-1.3695,1.3006>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-3.1950,-1.1999,1.3662>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.4937,-1.3189,1.2611>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.3226,-1.5134,1.5394>,0.0700,rgbt<1.000,1.000,0.000,0.000>)
VMD_sphere(<-3.1172,-1.6078,1.5833>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-3.4849,-1.6726,1.5031>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-3.3846,-1.3620,1.7015>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-3.3506,-1.6645,1.7901>,0.0584,rgbt<1.000,1.000,1.000,0.000>)
VMD_sphere(<-2.6660,-1.6357,0.7344>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.7684,-1.5255,0.8844>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.7464,-1.8322,0.7269>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.4376,-1.6528,0.7996>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.4316,-1.6725,1.0110>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.3581,-1.8292,0.7120>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.2960,-1.4712,0.7392>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.2925,-1.4592,0.5272>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.3821,-1.2931,0.8166>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.0707,-1.4822,0.8154>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.9487,-1.3836,0.6721>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.0590,-1.3770,0.9995>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.9808,-1.7000,0.8501>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.0560,-1.8265,0.6969>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.7696,-1.6870,0.8308>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.0287,-1.8026,1.0595>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.2268,-1.8787,1.0508>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.8939,-1.9649,1.0847>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.0123,-1.6637,1.2522>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.9134,-1.7745,1.4040>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.8929,-1.4955,1.2011>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.2172,-1.5828,1.3426>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.1713,-1.4687,1.5158>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.3063,-1.4552,1.1980>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.3783,-1.7470,1.4041>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.5519,-1.7153,1.2857>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.2976,-1.9380,1.3577>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.4454,-1.7498,1.6325>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.6428,-1.8279,1.6414>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.3149,-1.8809,1.7370>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.4447,-1.5405,1.7461>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.5843,-1.5527,1.9058>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.2504,-1.5110,1.8269>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.4994,-1.3488,1.6159>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.3334,-1.2163,1.6223>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.5285,-1.4125,1.4153>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.6927,-1.2267,1.6825>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.8635,-1.3352,1.6178>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.6937,-1.2172,1.8947>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.7118,-1.0044,1.5995>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.9123,-0.9500,1.5913>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.6056,-0.8655,1.7345>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-2.6791,-0.8929,1.9411>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.6801,-0.6833,2.0540>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.8057,-0.5399,1.9422>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-2.7828,-0.6773,2.2687>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.4994,-0.5808,2.0631>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.8772,-0.9519,1.9629>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.5606,-1.0070,2.0682>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.7415,-0.4957,2.3611>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.7089,-0.8322,2.3861>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.9886,-0.6987,2.2486>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.6764,-0.3917,1.8413>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.5713,-0.2604,1.9634>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.5483,-0.4638,1.6943>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.8114,-0.2410,1.7158>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.7703,-0.2324,1.5122>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.0166,-0.2615,1.7421>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.7727,0.0261,1.7909>,0.0700,rgbt<1.000,1.000,0.000,0.000>)
VMD_sphere(<-2.9030,0.1540,1.6505>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-2.5483,0.0705,1.7649>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-2.8395,0.0436,2.0106>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-2.7322,0.3065,1.8697>,0.0584,rgbt<1.000,1.000,1.000,0.000>)
VMD_sphere(<-2.6168,-0.9920,1.3815>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.4575,-1.1323,1.3719>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.7666,-1.0487,1.2419>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.5313,-0.7801,1.3146>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.4126,-0.7047,1.4739>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.4071,-0.8106,1.1450>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.6920,-0.6136,1.2583>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.8115,-0.6896,1.0999>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.8154,-0.5822,1.4284>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.6065,-0.4021,1.1902>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.4997,-0.3193,1.3541>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.4712,-0.4352,1.0298>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.7665,-0.2409,1.1185>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.8060,-0.2756,0.9127>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.9451,-0.2729,1.2291>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.7053,-0.0122,1.1435>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.7287,0.0394,1.3482>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.5003,0.0064,1.0910>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.8283,0.1454,1.0141>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.8007,0.0969,0.8091>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-3.0339,0.1232,1.0628>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.7709,0.3747,1.0432>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.7977,0.4726,0.8565>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.9058,0.4581,1.1844>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.5495,0.4201,1.1182>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.4177,0.2893,1.0149>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.5027,0.6205,1.0652>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.5091,0.3951,1.3515>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.6828,0.4603,1.4549>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.4796,0.1883,1.3905>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.3225,0.5134,1.4403>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.3311,0.7127,1.3673>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.3425,0.5169,1.6518>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.1070,0.4261,1.3888>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.0903,0.4147,1.1774>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.9622,0.5633,1.4619>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.0554,0.2113,1.4777>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.2372,0.1217,1.5412>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.9723,0.0944,1.3210>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.9035,0.2059,1.6610>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.7173,0.2748,1.5994>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.9780,0.3366,1.8228>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-1.8104,0.3921,1.9558>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.8347,0.6187,2.0246>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.6441,0.6907,2.1100>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-1.8724,0.7796,1.8532>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.9662,0.6556,2.1813>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.8003,0.2947,2.1392>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.6207,0.3953,1.8710>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.7568,0.9486,1.8890>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.0732,0.8333,1.8504>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.8206,0.6989,1.6687>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.6789,0.7663,2.3147>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.7668,0.9539,2.3317>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.7714,0.6364,2.4481>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.4698,0.8028,2.4226>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.3419,0.6390,2.4276>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.3634,0.9692,2.3575>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.4978,0.8590,2.6955>,0.0700,rgbt<1.000,1.000,0.000,0.000>)
VMD_sphere(<-1.5232,0.6567,2.8026>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-1.6845,0.9922,2.7171>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-1.3058,0.9680,2.7610>,0.0584,rgbt<1.000,0.000,0.000,0.000>)
VMD_sphere(<-1.5273,0.9179,2.9821>,0.0584,rgbt<1.000,1.000,1.000,0.000>)
VMD_sphere(<-1.8834,-0.0173,1.7415>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.6976,-0.0333,1.8432>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.0407,-0.0507,1.8804>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.8923,-0.1904,1.5782>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.0715,-0.1656,1.4669>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.7265,-0.1653,1.4479>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.8876,-0.4140,1.6600>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.7831,-0.5328,1.5183>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.7794,-0.4141,1.8428>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.0986,-0.5169,1.7000>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.1774,-0.4359,1.8799>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.2276,-0.4654,1.5393>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.0989,-0.7541,1.7207>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.2413,-0.8063,1.8694>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-2.1611,-0.8355,1.5345>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.8918,-0.8560,1.7791>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.7779,-0.7137,1.8883>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.9341,-1.0215,1.9054>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.7572,-0.9343,1.5990>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.8662,-0.9051,1.4190>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.5813,-0.8153,1.5927>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.6905,-1.1627,1.6076>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.6842,-1.2362,1.4084>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.4947,-1.1702,1.6897>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.8286,-1.3090,1.7349>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-2.0273,-1.2343,1.7268>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.8234,-1.5002,1.6425>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.7707,-1.3373,1.9641>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.9465,-1.3938,2.0692>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.6295,-1.4955,1.9765>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.6776,-1.1478,2.0743>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.6041,-1.0154,1.9253>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.8340,-1.0512,2.1808>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.5005,-1.1904,2.2277>,0.0584,rgbt<0.250,0.750,0.750,0.000>)
VMD_sphere(<-1.4599,-1.3963,2.2359>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.5538,-1.1246,2.4198>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_sphere(<-1.3267,-1.0893,2.1674>,0.0584,rgbt<0.000,1.000,0.000,0.000>)
VMD_cylinder(<2.90433288,-1.39903295,0.05968750>,<2.85610771,-1.48457944,0.09681535>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.90433288,-1.39903295,0.05968750>,<2.95863771,-1.42287374,-0.02694333>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.90433288,-1.39903295,0.05968750>,<2.97752666,-1.35706282,0.14370406>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.90433288,-1.39903295,0.05968750>,<2.83176017,-1.32716143,0.03539801>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<3.01294279,-1.44671464,-0.11357427>,<2.95863771,-1.42287374,-0.02694333>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.75918722,-1.25528991,0.01110840>,<2.83176017,-1.32716143,0.03539801>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.80788231,-1.57012582,0.13394332>,<2.85610771,-1.48457944,0.09681535>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<3.05072069,-1.31509280,0.22772050>,<3.00536418,-1.23379815,0.30193508>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<3.05072069,-1.31509280,0.22772050>,<2.97752666,-1.35706282,0.14370406>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<3.05072069,-1.31509280,0.22772050>,<3.08389950,-1.39744759,0.28603482>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<3.05072069,-1.31509280,0.22772050>,<3.13450408,-1.27155125,0.17905748>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<3.11707830,-1.47980237,0.34434915>,<3.08389950,-1.39744759,0.28603482>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<3.21828747,-1.22800982,0.13039446>,<3.13450408,-1.27155125,0.17905748>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.96000791,-1.15250373,0.37614977>,<3.03472376,-1.07900977,0.39346623>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.96000791,-1.15250373,0.37614977>,<2.86147594,-1.09644771,0.33977616>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.96000791,-1.15250373,0.37614977>,<3.00536418,-1.23379815,0.30193508>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.96000791,-1.15250373,0.37614977>,<2.93776774,-1.20110261,0.46795011>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.91552734,-1.24970150,0.55975020>,<2.93776774,-1.20110261,0.46795011>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<3.10943961,-1.00551593,0.41078258>,<3.03472376,-1.07900977,0.39346623>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.76294398,-1.04039168,0.30340254>,<2.68809032,-1.11385179,0.28654242>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.76294398,-1.04039168,0.30340254>,<2.86147594,-1.09644771,0.33977616>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.76294398,-1.04039168,0.30340254>,<2.71787333,-0.95873809,0.37739718>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.76294398,-1.04039168,0.30340254>,<2.78505635,-0.99219584,0.21135950>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.80716848,-0.94400012,0.11931658>,<2.78505635,-0.99219584,0.21135950>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.61323667,-1.18731213,0.26968217>,<2.68809032,-1.11385179,0.28654242>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.67280245,-0.87708473,0.45139194>,<2.72474670,-0.88469052,0.54373670>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.67280245,-0.87708473,0.45139194>,<2.55624485,-0.88478434,0.47439158>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.67280245,-0.87708473,0.45139194>,<2.69140220,-0.78132010,0.40935826>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.67280245,-0.87708473,0.45139194>,<2.71787333,-0.95873809,0.37739718>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.77669120,-0.89229631,0.63608134>,<2.72474670,-0.88469052,0.54373670>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.71000195,-0.68555546,0.36732483>,<2.69140220,-0.78132010,0.40935826>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.43968773,-0.89248395,0.49739134>,<2.42663336,-0.88377333,0.60244954>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.43968773,-0.89248395,0.49739134>,<2.55624485,-0.88478434,0.47439158>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.43968773,-0.89248395,0.49739134>,<2.39169621,-0.81045258,0.44994283>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.43968773,-0.89248395,0.49739134>,<2.38501024,-0.99214327,0.46200478>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.41357851,-0.87506270,0.70750773>,<2.42663336,-0.88377333,0.60244954>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.34370446,-0.72842097,0.40249419>,<2.39169621,-0.81045258,0.44994283>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.33033228,-1.09180260,0.42661810>,<2.22814369,-1.08454943,0.45469904>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.33033228,-1.09180260,0.42661810>,<2.37292123,-1.19410539,0.47014034>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.33033228,-1.09180260,0.42661810>,<2.38501024,-0.99214327,0.46200478>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.33033228,-1.09180260,0.42661810>,<2.33654761,-1.09643722,0.32067633>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.12595487,-1.07729626,0.48277986>,<2.22814369,-1.08454943,0.45469904>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.34276295,-1.10107160,0.21473455>,<2.33654761,-1.09643722,0.32067633>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.41551018,-1.29640818,0.51366258>,<2.35153580,-1.34832084,0.59960532>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.41551018,-1.29640818,0.51366258>,<2.42358541,-1.36516094,0.43309259>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.41551018,-1.29640818,0.51366258>,<2.51258111,-1.27736735,0.55236936>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.41551018,-1.29640818,0.51366258>,<2.37292123,-1.19410539,0.47014034>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.43166089,-1.43391395,0.35252297>,<2.42358541,-1.36516094,0.43309259>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.60965228,-1.25832653,0.59107614>,<2.51258111,-1.27736735,0.55236936>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.28756142,-1.40023351,0.68554807>,<2.31696963,-1.35754406,0.77826488>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.28756142,-1.40023351,0.68554807>,<2.16921425,-1.39059615,0.67688704>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.28756142,-1.40023351,0.68554807>,<2.31181145,-1.50365138,0.68617320>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.28756142,-1.40023351,0.68554807>,<2.35153580,-1.34832084,0.59960532>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.33606124,-1.60706913,0.68679833>,<2.31181145,-1.50365138,0.68617320>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.34637761,-1.31485462,0.87098169>,<2.31696963,-1.35754406,0.77826488>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.05086708,-1.38095880,0.66822600>,<2.02163315,-1.29247451,0.71921206>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.05086708,-1.38095880,0.66822600>,<2.00774574,-1.46469116,0.71734953>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.05086708,-1.38095880,0.66822600>,<2.00586081,-1.37613881,0.55811238>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.05086708,-1.38095880,0.66822600>,<2.16921425,-1.39059615,0.67688704>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.96462488,-1.54842353,0.76647294>,<2.00774574,-1.46469116,0.71734953>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.99239969,-1.20399022,0.77019799>,<2.02163315,-1.29247451,0.71921206>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.96085477,-1.37131906,0.44799852>,<1.90908813,-1.46231723,0.43002057>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.96085477,-1.37131906,0.44799852>,<1.88597655,-1.28164339,0.42507434>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.96085477,-1.37131906,0.44799852>,<2.04210019,-1.36405206,0.37995577>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.96085477,-1.37131906,0.44799852>,<2.00586081,-1.37613881,0.55811238>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.12334561,-1.35678494,0.31191313>,<2.04210019,-1.36405206,0.37995577>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.85732138,-1.55331552,0.41204262>,<1.90908813,-1.46231723,0.43002057>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.81109798,-1.19196773,0.40215015>,<1.72342741,-1.23315227,0.35854685>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.81109798,-1.19196773,0.40215015>,<1.88597655,-1.28164339,0.42507434>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.81109798,-1.19196773,0.40215015>,<1.77778828,-1.12546647,0.49511206>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.81109798,-1.19196773,0.40215015>,<1.85776019,-1.12792444,0.33140540>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.90442204,-1.06388104,0.26066041>,<1.85776019,-1.12792444,0.33140540>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.63575697,-1.27433681,0.31494331>,<1.72342741,-1.23315227,0.35854685>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.74447858,-1.05896533,0.58807373>,<1.67427325,-0.98725307,0.55325747>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.74447858,-1.05896533,0.58807373>,<1.69517219,-1.11671031,0.67977035>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.74447858,-1.05896533,0.58807373>,<1.77778828,-1.12546647,0.49511206>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.74447858,-1.05896533,0.58807373>,<1.83047199,-1.00808442,0.62412882>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.91646552,-0.95720351,0.66018414>,<1.83047199,-1.00808442,0.62412882>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.60406756,-0.91554093,0.51844120>,<1.67427325,-0.98725307,0.55325747>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.64586580,-1.17445517,0.77146685>,<1.53235173,-1.14066112,0.78356266>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.64586580,-1.17445517,0.77146685>,<1.70149100,-1.15129650,0.86407006>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.64586580,-1.17445517,0.77146685>,<1.65011668,-1.27691698,0.75449109>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.64586580,-1.17445517,0.77146685>,<1.69517219,-1.11671031,0.67977035>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.65436780,-1.37937891,0.73751545>,<1.65011668,-1.27691698,0.75449109>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.75711608,-1.12813783,0.95667315>,<1.70149100,-1.15129650,0.86407006>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<1.75711608,-1.12813783,0.95667315>,<1.75847328,-1.21713996,1.02211547>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<1.75983059,-1.30614209,1.08755779>,<1.66789103,-1.34040821,1.12187195>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.75983059,-1.30614209,1.08755779>,<1.81454074,-1.27962601,1.18989897>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.75983059,-1.30614209,1.08755779>,<1.81587720,-1.38737452,1.05492902>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.75983059,-1.30614209,1.08755779>,<1.75847328,-1.21713996,1.02211547>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.86925089,-1.25310993,1.29224026>,<1.97286701,-1.22092927,1.27140689>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.86925089,-1.25310993,1.29224026>,<1.81454074,-1.27962601,1.18989897>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.86925089,-1.25310993,1.29224026>,<1.82757008,-1.15947354,1.35278070>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.86925089,-1.25310993,1.29224026>,<1.88520753,-1.33155131,1.35854840>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.07648325,-1.18874872,1.25057375>,<1.97286701,-1.22092927,1.27140689>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<2.07648325,-1.18874872,1.25057375>,<2.14713860,-1.25634217,1.30200219>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<1.78588915,-1.06583714,1.41332114>,<1.71366870,-1.01689970,1.35680664>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.78588915,-1.06583714,1.41332114>,<1.82757008,-1.15947354,1.35278070>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.78588915,-1.06583714,1.41332114>,<1.74354434,-1.09790826,1.50266731>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.78588915,-1.06583714,1.41332114>,<1.86364925,-1.00001514,1.43395007>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.90116417,-1.40999234,1.42485666>,<1.88520753,-1.33155131,1.35854840>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.57595158,-1.37467432,1.15618622>,<1.66789103,-1.34040821,1.12187195>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.87192392,-1.46860683,1.02230036>,<1.81587720,-1.38737452,1.05492902>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.94140959,-0.93419313,1.45457900>,<1.86364925,-1.00001514,1.43395007>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.70119953,-1.12997925,1.59201348>,<1.74354434,-1.09790826,1.50266731>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.64144814,-0.96796250,1.30029225>,<1.71366870,-1.01689970,1.35680664>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.21779370,-1.32393575,1.35343075>,<2.20002198,-1.34248376,1.45415068>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.21779370,-1.32393575,1.35343075>,<2.23951912,-1.41387272,1.30606031>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.21779370,-1.32393575,1.35343075>,<2.14713860,-1.25634217,1.30200219>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.21779370,-1.32393575,1.35343075>,<2.32539082,-1.27319002,1.35766530>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.18225026,-1.36103189,1.55487072>,<2.20002198,-1.34248376,1.45415068>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.26124477,-1.50380993,1.25869012>,<2.23951912,-1.41387272,1.30606031>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.43298769,-1.22244453,1.36190009>,<2.32539082,-1.27319002,1.35766530>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.43298769,-1.22244453,1.36190009>,<2.46278715,-1.18850863,1.45552087>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.43298769,-1.22244453,1.36190009>,<2.43993807,-1.10463989,1.28649008>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.43298769,-1.22244453,1.36190009>,<2.51030660,-1.27796936,1.32014751>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.49258661,-1.15457273,1.54914176>,<2.46278715,-1.18850863,1.45552087>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.58762550,-1.33349419,1.27839518>,<2.51030660,-1.27796936,1.32014751>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.44688845,-0.98683524,1.21108019>,<2.43993807,-1.10463989,1.28649008>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.44688845,-0.98683524,1.21108019>,<2.37675548,-0.91083264,1.26171708>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.44688845,-0.98683524,1.21108019>,<2.55675507,-0.95243561,1.21331513>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.44688845,-0.98683524,1.21108019>,<2.45418620,-0.86314118,1.13189971>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.44688845,-0.98683524,1.21108019>,<2.41209435,-1.01349330,1.10460079>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.30662274,-0.83483028,1.31235421>,<2.37675548,-0.91083264,1.26171708>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<2.37730050,-1.04015160,0.99812150>,<2.41209435,-1.01349330,1.10460079>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<2.66662192,-0.91803634,1.21555018>,<2.55675507,-0.95243561,1.21331513>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<2.46148419,-0.73944712,1.05271924>,<2.45418620,-0.86314118,1.13189971>0.0117,rgbt<1.000,1.000,1.000,0.000>,1)
VMD_cylinder(<1.41883731,-1.10686707,0.79565847>,<1.37753391,-1.16038883,0.87759161>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.41883731,-1.10686707,0.79565847>,<1.53235173,-1.14066112,0.78356266>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.41883731,-1.10686707,0.79565847>,<1.34798598,-1.12395442,0.70152116>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.41883731,-1.10686707,0.79565847>,<1.41805673,-1.00314057,0.81854951>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.33623052,-1.21391034,0.95952451>,<1.37753391,-1.16038883,0.87759161>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.41727638,-0.89941406,0.84144092>,<1.41805673,-1.00314057,0.81854951>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.27713466,-1.14104164,0.60738373>,<1.34798598,-1.12395442,0.70152116>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.27713466,-1.14104164,0.60738373>,<1.25296783,-1.25408053,0.57888484>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.27713466,-1.14104164,0.60738373>,<1.32326865,-1.09544349,0.52326524>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.27713466,-1.14104164,0.60738373>,<1.18494034,-1.09195888,0.62674427>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.09274602,-1.04287612,0.64610493>,<1.18494034,-1.09195888,0.62674427>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.36940217,-1.04984498,0.43914652>,<1.32326865,-1.09544349,0.52326524>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.22880149,-1.36711967,0.55038607>,<1.25296783,-1.25408053,0.57888484>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.22880149,-1.36711967,0.55038607>,<1.22217035,-1.42270660,0.64066267>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.22880149,-1.36711967,0.55038607>,<1.12891197,-1.38612008,0.48845971>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.22880149,-1.36711967,0.55038607>,<1.31015468,-1.40431285,0.49309862>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.39150763,-1.44150615,0.43581104>,<1.31015468,-1.40431285,0.49309862>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.21553946,-1.47829342,0.73093903>,<1.22217035,-1.42270660,0.64066267>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.02902246,-1.40512049,0.42653310>,<1.12891197,-1.38612008,0.48845971>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.02902246,-1.40512049,0.42653310>,<0.96472049,-1.46508265,0.48614430>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.02902246,-1.40512049,0.42653310>,<0.96807528,-1.30849242,0.39303255>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.02902246,-1.40512049,0.42653310>,<1.05490875,-1.45925355,0.33887982>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.08079529,-1.51338673,0.25122654>,<1.05490875,-1.45925355,0.33887982>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.90041828,-1.52504468,0.54575574>,<0.96472049,-1.46508265,0.48614430>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.90712833,-1.21186423,0.35953212>,<0.96807528,-1.30849242,0.39303255>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.90712833,-1.21186423,0.35953212>,<0.86967611,-1.16502929,0.44720984>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.90712833,-1.21186423,0.35953212>,<0.82514691,-1.24409389,0.30017006>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.90712833,-1.21186423,0.35953212>,<0.96722627,-1.13004661,0.29733896>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.74316502,-1.27632356,0.24080825>,<0.82514691,-1.24409389,0.30017006>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.83222342,-1.11819422,0.53488755>,<0.86967611,-1.16502929,0.44720984>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.02732420,-1.04822886,0.23514533>,<1.11042786,-1.08890021,0.16022158>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.02732420,-1.04822886,0.23514533>,<0.95698810,-0.99233508,0.17846847>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.02732420,-1.04822886,0.23514533>,<0.96722627,-1.13004661,0.29733896>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.02732420,-1.04822886,0.23514533>,<1.07495451,-0.98326683,0.30439079>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.88665175,-0.93644106,0.12179148>,<0.95698810,-0.99233508,0.17846847>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.12258482,-0.91830480,0.37363636>,<1.07495451,-0.98326683,0.30439079>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.19353199,-1.12957156,0.08529794>,<1.11042786,-1.08890021,0.16022158>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.19353199,-1.12957156,0.08529794>,<1.28446436,-1.05635250,0.06197286>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.19353199,-1.12957156,0.08529794>,<1.14583659,-1.15255606,-0.00679171>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.19353199,-1.12957156,0.08529794>,<1.23349190,-1.21896315,0.12648070>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.27345204,-1.30835485,0.16766357>,<1.23349190,-1.21896315,0.12648070>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.09814095,-1.17554045,-0.09888148>,<1.14583659,-1.15255606,-0.00679171>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.37539673,-0.98313344,0.03864789>,<1.28446436,-1.05635250,0.06197286>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.37539673,-0.98313344,0.03864789>,<1.36187530,-0.86948609,0.07144189>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.37539673,-0.98313344,0.03864789>,<1.46133828,-1.02124679,0.08809578>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.37539673,-0.98313344,0.03864789>,<1.39251637,-0.98491979,-0.06617272>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.54727983,-1.05936027,0.13754368>,<1.46133828,-1.02124679,0.08809578>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.40963602,-0.98670614,-0.17099309>,<1.39251637,-0.98491979,-0.06617272>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.34835362,-0.75583887,0.10423565>,<1.24449086,-0.73797441,0.11753821>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.34835362,-0.75583887,0.10423565>,<1.36187530,-0.86948609,0.07144189>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.34835362,-0.75583887,0.10423565>,<1.39016914,-0.67350936,0.02908754>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.34835362,-0.75583887,0.10423565>,<1.39761376,-0.74281228,0.19744194>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.14062786,-0.72010982,0.13084066>,<1.24449086,-0.73797441,0.11753821>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.44687414,-0.72978580,0.29064822>,<1.39761376,-0.74281228,0.19744194>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.43198514,-0.59117997,-0.04606032>,<1.39016914,-0.67350936,0.02908754>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.43198514,-0.59117997,-0.04606032>,<1.50414121,-0.53322303,0.00607538>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.43198514,-0.59117997,-0.04606032>,<1.35097814,-0.52829194,-0.07374811>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.43198514,-0.59117997,-0.04606032>,<1.48276579,-0.63132918,-0.14597631>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.26997089,-0.46540368,-0.10143590>,<1.35097814,-0.52829194,-0.07374811>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.57629704,-0.47526586,0.05821085>,<1.50414121,-0.53322303,0.00607538>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.53354609,-0.67147827,-0.24589229>,<1.45985341,-0.70621181,-0.33270741>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.53354609,-0.67147827,-0.24589229>,<1.59505796,-0.59396660,-0.28451705>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.53354609,-0.67147827,-0.24589229>,<1.48276579,-0.63132918,-0.14597631>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.53354609,-0.67147827,-0.24589229>,<1.59485173,-0.75432944,-0.22018456>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.65656984,-0.51645505,-0.32314205>,<1.59505796,-0.59396660,-0.28451705>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.65615797,-0.83718061,-0.19447637>,<1.59485173,-0.75432944,-0.22018456>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.38616061,-0.74094534,-0.41952252>,<1.45985341,-0.70621181,-0.33270741>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.38616061,-0.74094534,-0.41952252>,<1.29891920,-0.78098893,-0.37403512>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.38616061,-0.74094534,-0.41952252>,<1.35179448,-0.65711892,-0.49676204>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.38616061,-0.74094534,-0.41952252>,<1.43460417,-0.81788659,-0.47444868>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.48304772,-0.89482784,-0.52937484>,<1.43460417,-0.81788659,-0.47444868>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.21167803,-0.82103276,-0.32854748>,<1.29891920,-0.78098893,-0.37403512>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.31742859,-0.57329249,-0.57400179>,<1.40031767,-0.53354812,-0.64965677>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.31742859,-0.57329249,-0.57400179>,<1.23729277,-0.61286688,-0.63141131>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.31742859,-0.57329249,-0.57400179>,<1.35179448,-0.65711892,-0.49676204>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.31742859,-0.57329249,-0.57400179>,<1.28186607,-0.49022937,-0.51814938>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.15715671,-0.65244126,-0.68882108>,<1.23729277,-0.61286688,-0.63141131>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.24630380,-0.40716648,-0.46229672>,<1.28186607,-0.49022937,-0.51814938>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.48320687,-0.49380398,-0.72531199>,<1.40031767,-0.53354812,-0.64965677>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.48320687,-0.49380398,-0.72531199>,<1.44003057,-0.40160513,-0.78702903>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.48320687,-0.49380398,-0.72531199>,<1.51181638,-0.57477808,-0.79481387>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.48320687,-0.49380398,-0.72531199>,<1.56738925,-0.46384788,-0.67220306>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.65157199,-0.43389201,-0.61909413>,<1.56738925,-0.46384788,-0.67220306>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.54042614,-0.65575218,-0.86431623>,<1.51181638,-0.57477808,-0.79481387>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<1.54042614,-0.65575218,-0.86431623>,<1.64174414,-0.69189239,-0.83912873>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<1.74306178,-0.72803235,-0.81394124>,<1.76053214,-0.82989168,-0.82507968>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.74306178,-0.72803235,-0.81394124>,<1.78256154,-0.69695330,-0.72295499>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.74306178,-0.72803235,-0.81394124>,<1.82194066,-0.68230796,-0.89047599>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.74306178,-0.72803235,-0.81394124>,<1.64174414,-0.69189239,-0.83912873>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.90081990,-0.63658369,-0.96701074>,<1.82194066,-0.68230796,-0.89047599>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.90081990,-0.63658369,-0.96701074>,<1.87553787,-0.63963759,-1.06778741>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.90081990,-0.63658369,-0.96701074>,<2.01401091,-0.67131972,-0.95470548>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.90081990,-0.63658369,-0.96701074>,<1.90971196,-0.52775407,-0.95018888>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.91860354,-0.41892457,-0.93336701>,<1.90971196,-0.52775407,-0.95018888>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<1.91860354,-0.41892457,-0.93336701>,<1.93703926,-0.36809969,-1.02971387>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<2.12720203,-0.70605588,-0.94240022>,<2.13063908,-0.80818141,-0.92334342>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.12720203,-0.70605588,-0.94240022>,<2.01401091,-0.67131972,-0.95470548>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.12720203,-0.70605588,-0.94240022>,<2.17113304,-0.65494466,-0.86326599>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.12720203,-0.70605588,-0.94240022>,<2.17978668,-0.68571556,-1.02972484>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.85025597,-0.64269161,-1.16856408>,<1.87553787,-0.63963759,-1.06778741>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.82206130,-0.66587424,-0.63196874>,<1.78256154,-0.69695330,-0.72295499>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.77800286,-0.93175089,-0.83621812>,<1.76053214,-0.82989168,-0.82507968>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.13407612,-0.91030681,-0.90428662>,<2.13063908,-0.80818141,-0.92334342>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.21506405,-0.60383344,-0.78413177>,<2.17113304,-0.65494466,-0.86326599>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.23237133,-0.66537535,-1.11704898>,<2.17978668,-0.68571556,-1.02972484>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.95547473,-0.31727481,-1.12606120>,<1.93703926,-0.36809969,-1.02971387>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.95547473,-0.31727481,-1.12606120>,<1.87476790,-0.30939364,-1.19109035>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.95547473,-0.31727481,-1.12606120>,<1.98082495,-0.20265543,-1.10631204>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.95547473,-0.31727481,-1.12606120>,<2.03907061,-0.34767044,-1.17984176>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.12266636,-0.37806630,-1.23362279>,<2.03907061,-0.34767044,-1.17984176>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.79406095,-0.30151248,-1.25611949>,<1.87476790,-0.30939364,-1.19109035>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.00617456,-0.08803558,-1.08656335>,<2.14365625,-0.06480694,-1.07345271>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.00617456,-0.08803558,-1.08656335>,<1.97029233,-0.04905128,-0.99713635>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.00617456,-0.08803558,-1.08656335>,<1.98082495,-0.20265543,-1.10631204>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<2.00617456,-0.08803558,-1.08656335>,<1.98176122,-0.02287459,-1.16378093>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.95734739,0.04228640,-1.24099898>,<1.98176122,-0.02287459,-1.16378093>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.93440998,-0.01006651,-0.90770984>,<1.97029233,-0.04905128,-0.99713635>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.28113770,-0.04157805,-1.06034207>,<2.30380297,-0.03935862,-0.94746804>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.28113770,-0.04157805,-1.06034207>,<2.33470535,-0.12855697,-1.11348772>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.28113770,-0.04157805,-1.06034207>,<2.14365625,-0.06480694,-1.07345271>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.28113770,-0.04157805,-1.06034207>,<2.30263853,0.05969357,-1.11074948>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.28113770,-0.04157805,-1.06034207>,<2.42549324,-0.01718807,-1.04657578>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<2.38827324,-0.21553564,-1.16663337>,<2.33470535,-0.12855697,-1.11348772>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<2.32646799,-0.03713942,-0.83459401>,<2.30380297,-0.03935862,-0.94746804>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<2.32413912,0.16096520,-1.16115642>,<2.30263853,0.05969357,-1.11074948>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<2.56984878,0.00720167,-1.03280902>,<2.42549324,-0.01718807,-1.04657578>0.0117,rgbt<1.000,1.000,1.000,0.000>,1)
VMD_cylinder(<1.39685440,-0.30940640,-0.84874606>,<1.31057024,-0.24619663,-0.79646349>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.39685440,-0.30940640,-0.84874606>,<1.44003057,-0.40160513,-0.78702903>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.39685440,-0.30940640,-0.84874606>,<1.47752976,-0.24346077,-0.86938977>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.39685440,-0.30940640,-0.84874606>,<1.35871887,-0.34675705,-0.94058371>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.55820549,-0.17751503,-0.89003348>,<1.47752976,-0.24346077,-0.86938977>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.32058334,-0.38410747,-1.03242183>,<1.35871887,-0.34675705,-0.94058371>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.22428632,-0.18298697,-0.74418116>,<1.26546335,-0.13707685,-0.65769196>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.22428632,-0.18298697,-0.74418116>,<1.14808631,-0.25061965,-0.71413159>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.22428632,-0.18298697,-0.74418116>,<1.17350531,-0.09776926,-0.81000686>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.22428632,-0.18298697,-0.74418116>,<1.31057024,-0.24619663,-0.79646349>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.07188559,-0.31825244,-0.68408203>,<1.14808631,-0.25061965,-0.71413159>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.30663991,-0.09116697,-0.57120275>,<1.26546335,-0.13707685,-0.65769196>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.12272382,-0.01255131,-0.87583280>,<1.17350531,-0.09776926,-0.81000686>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.12272382,-0.01255131,-0.87583280>,<1.05655527,0.04191875,-0.81307673>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.12272382,-0.01255131,-0.87583280>,<1.19623041,0.06542253,-0.92770600>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.12272382,-0.01255131,-0.87583280>,<1.06625748,-0.05988264,-0.95235038>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.00979137,-0.10721350,-1.02886796>,<1.06625748,-0.05988264,-0.95235038>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.99038672,0.09638882,-0.75032067>,<1.05655527,0.04191875,-0.81307673>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.26973677,0.14339638,-0.97957921>,<1.19623041,0.06542253,-0.92770600>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.26973677,0.14339638,-0.97957921>,<1.36929321,0.11504531,-0.95574021>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.26973677,0.14339638,-0.97957921>,<1.25617075,0.13591695,-1.08466792>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.26973677,0.14339638,-0.97957921>,<1.25608921,0.25767255,-0.94910598>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.46885002,0.08669448,-0.93190122>,<1.36929321,0.11504531,-0.95574021>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.24260426,0.12843752,-1.18975639>,<1.25617075,0.13591695,-1.08466792>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.24244165,0.37194896,-0.91863275>,<1.29492736,0.38782978,-0.82765603>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.24244165,0.37194896,-0.91863275>,<1.28681755,0.43139601,-0.99466157>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.24244165,0.37194896,-0.91863275>,<1.13063526,0.40987301,-0.90331054>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.24244165,0.37194896,-0.91863275>,<1.25608921,0.25767255,-0.94910598>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.34741306,0.40371060,-0.73667932>,<1.29492736,0.38782978,-0.82765603>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.33119369,0.49084282,-1.07069039>,<1.28681755,0.43139601,-0.99466157>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<1.01882887,0.44779730,-0.88798881>,<0.97790813,0.44881010,-0.77619219>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.01882887,0.44779730,-0.88798881>,<1.13063526,0.40987301,-0.90331054>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.01882887,0.44779730,-0.88798881>,<1.01263332,0.54687548,-0.92578816>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.01882887,0.44779730,-0.88798881>,<0.95508814,0.38513637,-0.94538593>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.00643826,0.64595389,-0.96358752>,<1.01263332,0.54687548,-0.92578816>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.89134741,0.32247567,-1.00278354>,<0.95508814,0.38513637,-0.94538593>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.93698764,0.44982266,-0.66439605>,<0.83051848,0.39970779,-0.64632249>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.93698764,0.44982266,-0.66439605>,<0.93104339,0.55108547,-0.63286424>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.93698764,0.44982266,-0.66439605>,<1.00761628,0.39901018,-0.60345912>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.93698764,0.44982266,-0.66439605>,<0.97790813,0.44881010,-0.77619219>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<1.07824492,0.34819770,-0.54252219>,<1.00761628,0.39901018,-0.60345912>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.92509985,0.65234828,-0.60133266>,<0.93104339,0.55108547,-0.63286424>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.72404909,0.34959316,-0.62824821>,<0.73969889,0.25703001,-0.57854152>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.72404909,0.34959316,-0.62824821>,<0.65821886,0.32826853,-0.72512817>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.72404909,0.34959316,-0.62824821>,<0.83051848,0.39970779,-0.64632249>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.72404909,0.34959316,-0.62824821>,<0.66830969,0.41375327,-0.56452918>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.75534868,0.16446686,-0.52883506>,<0.73969889,0.25703001,-0.57854152>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.61256981,0.47791338,-0.50080991>,<0.66830969,0.41375327,-0.56452918>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.59238911,0.30694389,-0.82200789>,<0.65821886,0.32826853,-0.72512817>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.59238911,0.30694389,-0.82200789>,<0.47425151,0.30824971,-0.80732417>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.59238911,0.30694389,-0.82200789>,<0.61947131,0.21123791,-0.85929990>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.59238911,0.30694389,-0.82200789>,<0.61692905,0.38032103,-0.89478993>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.64146900,0.45369768,-0.96757197>,<0.61692905,0.38032103,-0.89478993>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.64655328,0.11553168,-0.89659214>,<0.61947131,0.21123791,-0.85929990>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.35611391,0.30955529,-0.79264045>,<0.31199861,0.23589611,-0.71016622>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.35611391,0.30955529,-0.79264045>,<0.32770038,0.40849519,-0.76642299>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.35611391,0.30955529,-0.79264045>,<0.31149912,0.28458691,-0.88575196>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.35611391,0.30955529,-0.79264045>,<0.47425151,0.30824971,-0.80732417>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.29928660,0.50743484,-0.74020529>,<0.32770038,0.40849519,-0.76642299>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.26688480,0.25961876,-0.97886300>,<0.31149912,0.28458691,-0.88575196>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.26788306,0.16223717,-0.62769151>,<0.31092405,0.18857026,-0.53421664>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.26788306,0.16223717,-0.62769151>,<0.14955735,0.16193366,-0.61454535>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.26788306,0.16223717,-0.62769151>,<0.29807329,0.06352782,-0.65276623>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.26788306,0.16223717,-0.62769151>,<0.31199861,0.23589611,-0.71016622>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.32826328,-0.03518128,-0.67784119>,<0.29807329,0.06352782,-0.65276623>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.35396504,0.21490383,-0.44074154>,<0.31092405,0.18857026,-0.53421664>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.03123093,0.16163039,-0.60139942>,<0.01003265,0.14937019,-0.49803638>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.03123093,0.16163039,-0.60139942>,<0.14955735,0.16193366,-0.61454535>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.03123093,0.16163039,-0.60139942>,<-0.00716138,0.07799101,-0.65444684>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.03123093,0.16163039,-0.60139942>,<-0.02668858,0.25851583,-0.63924623>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.04555392,-0.00564861,-0.70749402>,<-0.00716138,0.07799101,-0.65444684>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-0.01116562,0.13710999,-0.39467335>,<0.01003265,0.14937019,-0.49803638>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-0.08460879,0.35540080,-0.67709327>,<-0.08642483,0.42545414,-0.59726310>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.08460879,0.35540080,-0.67709327>,<-0.02668858,0.25851583,-0.63924623>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.08460879,0.35540080,-0.67709327>,<-0.02939177,0.39682603,-0.75783157>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.08460879,0.35540080,-0.67709327>,<-0.19664192,0.33930111,-0.71401620>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.08824062,0.49550748,-0.51743269>,<-0.08642483,0.42545414,-0.59726310>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.02582550,0.43825126,-0.83857012>,<-0.02939177,0.39682603,-0.75783157>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-0.30867481,0.32320094,-0.75093913>,<-0.37083268,0.42345357,-0.73482132>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.30867481,0.32320094,-0.75093913>,<-0.30885935,0.29789495,-0.85175610>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.30867481,0.32320094,-0.75093913>,<-0.35519528,0.24111271,-0.69346499>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.30867481,0.32320094,-0.75093913>,<-0.19664192,0.33930111,-0.71401620>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.30904317,0.27258849,-0.95257258>,<-0.30885935,0.29789495,-0.85175610>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-0.40171623,0.15902472,-0.63599133>,<-0.44076848,0.08271980,-0.70569348>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-0.40171623,0.15902472,-0.63599133>,<-0.35519528,0.24111271,-0.69346499>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-0.47981954,0.00641489,-0.77539563>,<-0.41698480,-0.02269864,-0.85291123>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.47981954,0.00641489,-0.77539563>,<-0.57514143,0.02238035,-0.81365037>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.47981954,0.00641489,-0.77539563>,<-0.49481297,-0.09654999,-0.71757030>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.47981954,0.00641489,-0.77539563>,<-0.44076848,0.08271980,-0.70569348>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.50980663,-0.19951499,-0.65974474>,<-0.42525220,-0.21555853,-0.59047031>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.50980663,-0.19951499,-0.65974474>,<-0.60244846,-0.20636213,-0.58530855>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.50980663,-0.19951499,-0.65974474>,<-0.50613570,-0.28629875,-0.71683884>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.50980663,-0.19951499,-0.65974474>,<-0.49481297,-0.09654999,-0.71757030>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.34069824,-0.23160195,-0.52119589>,<-0.42525220,-0.21555853,-0.59047031>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-0.34069824,-0.23160195,-0.52119589>,<-0.26814127,-0.30116260,-0.56705141>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-0.69508982,-0.21320903,-0.51087236>,<-0.66939926,-0.17180812,-0.41905522>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.69508982,-0.21320903,-0.51087236>,<-0.72184563,-0.31272972,-0.49729276>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.69508982,-0.21320903,-0.51087236>,<-0.60244846,-0.20636213,-0.58530855>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.69508982,-0.21320903,-0.51087236>,<-0.77583361,-0.16113591,-0.55053949>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.50246406,-0.37308240,-0.77393293>,<-0.50613570,-0.28629875,-0.71683884>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-0.67046309,0.03834581,-0.85190511>,<-0.57514143,0.02238035,-0.81365037>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-0.35414934,-0.05181241,-0.93042636>,<-0.41698480,-0.02269864,-0.85291123>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-0.74860191,-0.41225028,-0.48371291>,<-0.72184563,-0.31272972,-0.49729276>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-0.85657740,-0.10906291,-0.59020662>,<-0.77583361,-0.16113591,-0.55053949>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-0.64370871,-0.13040733,-0.32723808>,<-0.66939926,-0.17180812,-0.41905522>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-0.19558454,-0.37072325,-0.61290717>,<-0.26814127,-0.30116260,-0.56705141>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.19558454,-0.37072325,-0.61290717>,<-0.09980011,-0.38010466,-0.54285312>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.19558454,-0.37072325,-0.61290717>,<-0.22470641,-0.47017264,-0.62104750>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.19558454,-0.37072325,-0.61290717>,<-0.15237951,-0.34094584,-0.70263505>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.25382900,-0.56962192,-0.62918854>,<-0.22470641,-0.47017264,-0.62104750>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-0.10917473,-0.31116831,-0.79236293>,<-0.15237951,-0.34094584,-0.70263505>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-0.00401592,-0.38948607,-0.47279906>,<-0.00380087,-0.47073030,-0.40796137>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.00401592,-0.38948607,-0.47279906>,<0.02090931,-0.30385935,-0.41940117>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.00401592,-0.38948607,-0.47279906>,<-0.09980011,-0.38010466,-0.54285312>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.00401592,-0.38948607,-0.47279906>,<0.11369395,-0.41188633,-0.54529166>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<0.04583454,-0.21823263,-0.36600304>,<0.02090931,-0.30385935,-0.41940117>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-0.00358605,-0.55197442,-0.34312391>,<-0.00380087,-0.47073030,-0.40796137>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.23140454,-0.43428683,-0.61778378>,<0.11369395,-0.41188633,-0.54529166>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.23140454,-0.43428683,-0.61778378>,<0.31888914,-0.40491831,-0.54891515>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.23140454,-0.43428683,-0.61778378>,<0.23312712,-0.54628301,-0.64448977>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.23140454,-0.43428683,-0.61778378>,<0.22587538,-0.36758411,-0.71148133>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<0.22034645,-0.30088127,-0.80517936>,<0.22587538,-0.36758411,-0.71148133>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<0.23484921,-0.65827918,-0.67119622>,<0.23312712,-0.54628301,-0.64448977>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<0.40637445,-0.37554979,-0.48004603>,<0.31888914,-0.40491831,-0.54891515>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-0.43299174,0.52370572,-0.71870351>,<-0.44406652,0.53863692,-0.61411858>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.43299174,0.52370572,-0.71870351>,<-0.54140949,0.52747464,-0.76774549>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.43299174,0.52370572,-0.71870351>,<-0.37626314,0.60396886,-0.75899506>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.43299174,0.52370572,-0.71870351>,<-0.37083268,0.42345357,-0.73482132>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.45514202,0.55356789,-0.50953412>,<-0.44406652,0.53863692,-0.61411858>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-0.31953478,0.68423200,-0.79928637>,<-0.37626314,0.60396886,-0.75899506>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-0.64982796,0.53124380,-0.81678772>,<-0.66238403,0.44310570,-0.87473369>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.64982796,0.53124380,-0.81678772>,<-0.54140949,0.52747464,-0.76774549>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.64982796,0.53124380,-0.81678772>,<-0.65340471,0.61553192,-0.88133550>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.64982796,0.53124380,-0.81678772>,<-0.74188566,0.53891397,-0.74168515>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.65698147,0.69982052,-0.94588304>,<-0.65340471,0.61553192,-0.88133550>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-0.67494011,0.35496783,-0.93267941>,<-0.66238403,0.44310570,-0.87473369>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-0.83394384,0.54658389,-0.66658306>,<-0.80418968,0.50348330,-0.57416749>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.83394384,0.54658389,-0.66658306>,<-0.93492270,0.49354744,-0.70070434>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.83394384,0.54658389,-0.66658306>,<-0.85488605,0.64958644,-0.65123105>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.83394384,0.54658389,-0.66658306>,<-0.74188566,0.53891397,-0.74168515>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.77443504,0.46038270,-0.48175192>,<-0.80418968,0.50348330,-0.57416749>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-0.87582874,0.75258875,-0.63587880>,<-0.85488605,0.64958644,-0.65123105>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.03590202,0.44051123,-0.73482585>,<-1.03249979,0.33967280,-0.70160294>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.03590202,0.44051123,-0.73482585>,<-1.05860806,0.43963909,-0.85169148>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.03590202,0.44051123,-0.73482585>,<-0.93492270,0.49354744,-0.70070434>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.03590202,0.44051123,-0.73482585>,<-1.11653090,0.48988080,-0.68639684>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.02909660,0.23883438,-0.66837978>,<-1.03249979,0.33967280,-0.70160294>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.19715881,0.53925061,-0.63796782>,<-1.11653090,0.48988080,-0.68639684>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.08131266,0.43876672,-0.96855712>,<-1.05860806,0.43963909,-0.85169148>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.08131266,0.43876672,-0.96855712>,<-1.02010202,0.51266336,-1.01412296>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.08131266,0.43876672,-0.96855712>,<-1.18321753,0.46552968,-0.98208046>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.08131266,0.43876672,-0.96855712>,<-1.06277561,0.33588433,-1.02552629>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.28512239,0.49229240,-0.99560356>,<-1.18321753,0.46552968,-0.98208046>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-0.95889091,0.58655953,-1.05968881>,<-1.02010202,0.51266336,-1.01412296>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.04423857,0.23300219,-1.08249521>,<-0.97519922,0.25135016,-1.16111159>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.04423857,0.23300219,-1.08249521>,<-1.00045395,0.16508603,-1.01354599>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.04423857,0.23300219,-1.08249521>,<-1.14004326,0.18036413,-1.12966228>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.04423857,0.23300219,-1.08249521>,<-1.06277561,0.33588433,-1.02552629>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-0.90615892,0.26969790,-1.23972750>,<-0.97519922,0.25135016,-1.16111159>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-0.95667028,0.09717011,-0.94459677>,<-1.00045395,0.16508603,-1.01354599>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.23584700,0.12772608,-1.17682958>,<-1.14004326,0.18036413,-1.12966228>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.23584700,0.12772608,-1.17682958>,<-1.26548719,0.04948664,-1.11137962>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.23584700,0.12772608,-1.17682958>,<-1.33064699,0.19717312,-1.19590497>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.23584700,0.12772608,-1.17682958>,<-1.20718670,0.08550525,-1.26999402>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.17852545,0.04328418,-1.36315846>,<-1.20718670,0.08550525,-1.26999402>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.29512739,-0.02875280,-1.04592943>,<-1.26548719,0.04948664,-1.11137962>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.42544746,0.26661992,-1.21498060>,<-1.47971201,0.27329946,-1.12390780>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.42544746,0.26661992,-1.21498060>,<-1.50100136,0.23125100,-1.29991961>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.42544746,0.26661992,-1.21498060>,<-1.33064699,0.19717312,-1.19590497>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.42544746,0.26661992,-1.21498060>,<-1.39016485,0.36335945,-1.24106193>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.53397703,0.27997899,-1.03283477>,<-1.47971201,0.27329946,-1.12390780>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.35488272,0.46009922,-1.26714349>,<-1.39016485,0.36335945,-1.24106193>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.57655525,0.19588208,-1.38485813>,<-1.66073990,0.15194750,-1.33725286>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.57655525,0.19588208,-1.38485813>,<-1.53454018,0.11761832,-1.46412516>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.57655525,0.19588208,-1.38485813>,<-1.60837317,0.28214908,-1.43804979>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.57655525,0.19588208,-1.38485813>,<-1.50100136,0.23125100,-1.29991961>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.74492502,0.10801315,-1.28964782>,<-1.66073990,0.15194750,-1.33725286>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.64019108,0.36841607,-1.49124169>,<-1.60837317,0.28214908,-1.43804979>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.49252510,0.03935409,-1.54339218>,<-1.53454018,0.11761832,-1.46412516>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.49252510,0.03935409,-1.54339218>,<-1.48107147,-0.05398655,-1.49399543>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.49252510,0.03935409,-1.54339218>,<-1.39701271,0.07331610,-1.57513237>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.49252510,0.03935409,-1.54339218>,<-1.55892038,0.02127266,-1.64054561>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.30149984,0.10727787,-1.60687232>,<-1.39701271,0.07331610,-1.57513237>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.46961689,-0.14732742,-1.44459867>,<-1.48107147,-0.05398655,-1.49399543>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.62531519,0.00319123,-1.73769879>,<-1.57328081,0.04419613,-1.82073331>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.62531519,0.00319123,-1.73769879>,<-1.65190649,-0.10992908,-1.76359296>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.62531519,0.00319123,-1.73769879>,<-1.71661663,0.05596972,-1.72496772>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.62531519,0.00319123,-1.73769879>,<-1.55892038,0.02127266,-1.64054561>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.80791903,0.10874844,-1.71223736>,<-1.71661663,0.05596972,-1.72496772>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.52124691,0.08520126,-1.90376782>,<-1.57328081,0.04419613,-1.82073331>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.67849874,-0.22304916,-1.78948760>,<-1.65190649,-0.10992908,-1.76359296>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.67849874,-0.22304916,-1.78948760>,<-1.74668837,-0.22259462,-1.87093377>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.67849874,-0.22304916,-1.78948760>,<-1.58893919,-0.27133703,-1.82000089>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.67849874,-0.22304916,-1.78948760>,<-1.72674417,-0.28768241,-1.70191550>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.81487894,-0.22214043,-1.95238018>,<-1.74668837,-0.22259462,-1.87093377>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.49937963,-0.31962490,-1.85051394>,<-1.58893919,-0.27133703,-1.82000089>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.77498960,-0.35231543,-1.61434340>,<-1.89124107,-0.37619841,-1.62377167>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.77498960,-0.35231543,-1.61434340>,<-1.75983047,-0.29997516,-1.52316022>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.77498960,-0.35231543,-1.61434340>,<-1.72303724,-0.44485843,-1.60982037>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.77498960,-0.35231543,-1.61434340>,<-1.72674417,-0.28768241,-1.70191550>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.67108488,-0.53740144,-1.60529780>,<-1.72303724,-0.44485843,-1.60982037>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.74467230,-0.24763453,-1.43197680>,<-1.75983047,-0.29997516,-1.52316022>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.00749302,-0.40008152,-1.63319993>,<-2.05663013,-0.40278161,-1.52479315>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.00749302,-0.40008152,-1.63319993>,<-2.02133226,-0.49792719,-1.68260360>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.00749302,-0.40008152,-1.63319993>,<-2.05362082,-0.32669199,-1.69056654>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.00749302,-0.40008152,-1.63319993>,<-1.89124107,-0.37619841,-1.62377167>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.09974813,-0.25330269,-1.74793267>,<-2.05362082,-0.32669199,-1.69056654>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.03517056,-0.59577274,-1.73200727>,<-1.96879244,-0.60233402,-1.82007885>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-2.03517056,-0.59577274,-1.73200727>,<-2.02133226,-0.49792719,-1.68260360>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-1.90241432,-0.60889471,-1.90815067>,<-1.96879244,-0.60233402,-1.82007885>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.90241432,-0.60889471,-1.90815067>,<-1.80099010,-0.62185657,-1.88945222>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.90241432,-0.60889471,-1.90815067>,<-1.91402245,-0.53572273,-1.98105907>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.90241432,-0.60889471,-1.90815067>,<-1.92757225,-0.70753503,-1.96985483>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.95273018,-0.80617499,-2.03155875>,<-1.87387562,-0.83938098,-2.11432052>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.95273018,-0.80617499,-2.03155875>,<-2.04281330,-0.78914034,-2.09320903>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.95273018,-0.80617499,-2.03155875>,<-1.98106909,-0.88980949,-1.97672486>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.95273018,-0.80617499,-2.03155875>,<-1.92757225,-0.70753503,-1.96985483>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.13289547,-0.77210522,-2.15485883>,<-2.22057152,-0.81765795,-2.10542417>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-2.13289547,-0.77210522,-2.15485883>,<-2.04281330,-0.78914034,-2.09320903>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-1.79502058,-0.87258697,-2.19708180>,<-1.87387562,-0.83938098,-2.11432052>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.79502058,-0.87258697,-2.19708180>,<-1.84044838,-0.93686628,-2.26497293>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.79502058,-0.87258697,-2.19708180>,<-1.75979328,-0.78880906,-2.24752831>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.79502058,-0.87258697,-2.19708180>,<-1.71518898,-0.92140806,-2.15182900>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.00940752,-0.97344410,-1.92189050>,<-1.98106909,-0.88980949,-1.97672486>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.92563105,-0.46255052,-2.05396771>,<-1.91402245,-0.53572273,-1.98105907>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.69956589,-0.63481796,-1.87075329>,<-1.80099010,-0.62185657,-1.88945222>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.72456598,-0.70503092,-2.29797435>,<-1.75979328,-0.78880906,-2.24752831>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.88587475,-1.00114512,-2.33286357>,<-1.84044838,-0.93686628,-2.26497293>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.63535738,-0.97022915,-2.10657573>,<-1.71518898,-0.92140806,-2.15182900>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.30824661,-0.86321080,-2.05598879>,<-2.32822227,-0.83277547,-1.95862794>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.30824661,-0.86321080,-2.05598879>,<-2.40760756,-0.82909274,-2.11196685>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.30824661,-0.86321080,-2.05598879>,<-2.31644821,-0.96670365,-2.06115556>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.30824661,-0.86321080,-2.05598879>,<-2.22057152,-0.81765795,-2.10542417>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.32464981,-1.07019651,-2.06632161>,<-2.31644821,-0.96670365,-2.06115556>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.34819746,-0.80233991,-1.86126733>,<-2.32822227,-0.83277547,-1.95862794>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.50696802,-0.79497480,-2.16794419>,<-2.40760756,-0.82909274,-2.11196685>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.50696802,-0.79497480,-2.16794419>,<-2.56850815,-0.73045874,-2.11451268>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.50696802,-0.79497480,-2.16794419>,<-2.56490088,-0.87187958,-2.20711112>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.50696802,-0.79497480,-2.16794419>,<-2.48074150,-0.71914840,-2.28272796>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.62283421,-0.94878423,-2.24627709>,<-2.56490088,-0.87187958,-2.20711112>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.63004827,-0.66594255,-2.06108046>,<-2.56850815,-0.73045874,-2.11451268>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.45451498,-0.64332175,-2.39751172>,<-2.48074150,-0.71914840,-2.28272796>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.45451498,-0.64332175,-2.39751172>,<-2.55259228,-0.63922632,-2.45770478>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.45451498,-0.64332175,-2.39751172>,<-2.42147255,-0.53903878,-2.36156106>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.45451498,-0.64332175,-2.39751172>,<-2.42697668,-0.56370437,-2.51803422>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.45451498,-0.64332175,-2.39751172>,<-2.37083673,-0.69779658,-2.45486665>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.65066957,-0.63513124,-2.51789832>,<-2.55259228,-0.63922632,-2.45770478>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-2.28715754,-0.75227153,-2.51222157>,<-2.37083673,-0.69779658,-2.45486665>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-2.38843012,-0.43475556,-2.32561040>,<-2.42147255,-0.53903878,-2.36156106>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-2.39943886,-0.48408699,-2.63855624>,<-2.42697668,-0.56370437,-2.51803422>0.0117,rgbt<1.000,1.000,1.000,0.000>,1)
VMD_cylinder(<-2.10576820,-0.40548146,-1.41638684>,<-2.18511820,-0.47607267,-1.41840458>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.10576820,-0.40548146,-1.41638684>,<-2.03370571,-0.43421626,-1.32607985>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.10576820,-0.40548146,-1.41638684>,<-2.05663013,-0.40278161,-1.52479315>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.10576820,-0.40548146,-1.41638684>,<-2.14600420,-0.30920088,-1.39651918>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.18624163,-0.21292007,-1.37665200>,<-2.14600420,-0.30920088,-1.39651918>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.26446867,-0.54666340,-1.42042279>,<-2.18511820,-0.47607267,-1.41840458>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.96164370,-0.46295071,-1.23577356>,<-1.86760712,-0.49057209,-1.27673578>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.96164370,-0.46295071,-1.23577356>,<-2.03370571,-0.43421626,-1.32607985>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.96164370,-0.46295071,-1.23577356>,<-1.99794817,-0.55146241,-1.16491055>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.96164370,-0.46295071,-1.23577356>,<-1.94875717,-0.37634230,-1.17563510>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.77357197,-0.51819313,-1.31769848>,<-1.86760712,-0.49057209,-1.27673578>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.93587017,-0.28973377,-1.11549687>,<-1.94875717,-0.37634230,-1.17563510>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.03425407,-0.63997376,-1.09404778>,<-1.95124912,-0.67075288,-1.03534174>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.03425407,-0.63997376,-1.09404778>,<-2.10937309,-0.60133314,-1.02964520>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.03425407,-0.63997376,-1.09404778>,<-2.07854700,-0.73644209,-1.14795399>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.03425407,-0.63997376,-1.09404778>,<-1.99794817,-0.55146241,-1.16491055>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.86824417,-0.70153236,-0.97663522>,<-1.95124912,-0.67075288,-1.03534174>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.18449211,-0.56269252,-0.96524262>,<-2.10937309,-0.60133314,-1.02964520>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.12283993,-0.83291006,-1.20185995>,<-2.06624317,-0.84967268,-1.29017425>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.12283993,-0.83291006,-1.20185995>,<-2.23780012,-0.82858145,-1.23251081>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.12283993,-0.83291006,-1.20185995>,<-2.10970163,-0.91559911,-1.13648748>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.12283993,-0.83291006,-1.20185995>,<-2.07854700,-0.73644209,-1.14795399>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.00964689,-0.86643529,-1.37848902>,<-2.06624317,-0.84967268,-1.29017425>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.09656382,-0.99828804,-1.07111430>,<-2.10970163,-0.91559911,-1.13648748>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.35275888,-0.82425296,-1.26316142>,<-2.42257452,-0.91043377,-1.21988869>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.35275888,-0.82425296,-1.26316142>,<-2.39174080,-0.73113799,-1.23009062>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.35275888,-0.82425296,-1.26316142>,<-2.23780012,-0.82858145,-1.23251081>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.35275888,-0.82425296,-1.26316142>,<-2.35830879,-0.82805753,-1.36917233>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.43072319,-0.63802290,-1.19701958>,<-2.39174080,-0.73113799,-1.23009062>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.36385870,-0.83186233,-1.47518325>,<-2.35830879,-0.82805753,-1.36917233>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.49239016,-0.99661493,-1.17661548>,<-2.49295855,-1.01017523,-1.05833840>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.49239016,-0.99661493,-1.17661548>,<-2.59198427,-0.97636056,-1.20750856>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.49239016,-0.99661493,-1.17661548>,<-2.46111727,-1.08851802,-1.21973848>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.49239016,-0.99661493,-1.17661548>,<-2.42257452,-0.91043377,-1.21988869>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.69157743,-0.95610654,-1.23840141>,<-2.59198427,-0.97636056,-1.20750856>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.42984486,-1.18042135,-1.26286149>,<-2.46111727,-1.08851802,-1.21973848>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.49352694,-1.02373624,-0.94006133>,<-2.46670151,-1.12428093,-0.91873240>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.49352694,-1.02373624,-0.94006133>,<-2.49295855,-1.01017523,-1.05833840>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.49352694,-1.02373624,-0.94006133>,<-2.59626865,-1.00083911,-0.88444066>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.49352694,-1.02373624,-0.94006133>,<-2.41953278,-0.95916486,-0.89957547>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.43987656,-1.22482538,-0.89740396>,<-2.46670151,-1.12428093,-0.91873240>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.34553862,-0.89459395,-0.85908937>,<-2.41953278,-0.95916486,-0.89957547>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.69901037,-0.97794151,-0.82881999>,<-2.68521929,-0.99811506,-0.72544479>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.69901037,-0.97794151,-0.82881999>,<-2.72028017,-0.87458968,-0.84106135>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.69901037,-0.97794151,-0.82881999>,<-2.79416227,-1.03933978,-0.86556411>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.69901037,-0.97794151,-0.82881999>,<-2.59626865,-1.00083911,-0.88444066>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.67142773,-1.01828909,-0.62206960>,<-2.68521929,-0.99811506,-0.72544479>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.74154997,-0.77123773,-0.85330224>,<-2.72028017,-0.87458968,-0.84106135>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.88931513,-1.10073781,-0.90230799>,<-2.89812183,-1.18692160,-0.84083796>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.88931513,-1.10073781,-0.90230799>,<-2.79416227,-1.03933978,-0.86556411>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.88931513,-1.10073781,-0.90230799>,<-2.99366474,-1.04347038,-0.89995742>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.88931513,-1.10073781,-0.90230799>,<-2.87142324,-1.13164234,-1.00234985>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.85353041,-1.16254675,-1.10239220>,<-2.87142324,-1.13164234,-1.00234985>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.90692902,-1.27310514,-0.77936840>,<-2.89812183,-1.18692160,-0.84083796>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.09801388,-0.98620296,-0.89760661>,<-3.12748957,-0.97648728,-0.79601741>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.09801388,-0.98620296,-0.89760661>,<-3.18786240,-1.03701258,-0.95693088>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.09801388,-0.98620296,-0.89760661>,<-2.99366474,-1.04347038,-0.89995742>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.09801388,-0.98620296,-0.89760661>,<-3.08283520,-0.88927937,-0.93833947>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.15696478,-0.96677184,-0.69442773>,<-3.12748957,-0.97648728,-0.79601741>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.06765604,-0.79235673,-0.97907233>,<-3.08283520,-0.88927937,-0.93833947>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.27771235,-1.08782220,-1.01625562>,<-3.33964300,-1.13716412,-0.94544864>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.27771235,-1.08782220,-1.01625562>,<-3.18786240,-1.03701258,-0.95693088>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.27771235,-1.08782220,-1.01625562>,<-3.33373356,-1.01053178,-1.06285524>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.27771235,-1.08782220,-1.01625562>,<-3.24801683,-1.16694999,-1.10010648>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.40157318,-1.18650615,-0.87464166>,<-3.33964300,-1.13716412,-0.94544864>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.38975430,-0.93324125,-1.10945487>,<-3.33373356,-1.01053178,-1.06285524>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.21832037,-1.24607742,-1.18395686>,<-3.16437054,-1.32457685,-1.13693595>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.21832037,-1.24607742,-1.18395686>,<-3.30805206,-1.29499912,-1.24502063>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.21832037,-1.24607742,-1.18395686>,<-3.15442896,-1.19737530,-1.25345206>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.21832037,-1.24607742,-1.18395686>,<-3.24801683,-1.16694999,-1.10010648>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.09053707,-1.14867330,-1.32294726>,<-3.15442896,-1.19737530,-1.25345206>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.11042023,-1.40307617,-1.08991528>,<-3.16437054,-1.32457685,-1.13693595>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.39778328,-1.34392071,-1.30608487>,<-3.30805206,-1.29499912,-1.24502063>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.39778328,-1.34392071,-1.30608487>,<-3.50473356,-1.34232414,-1.25380826>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.39778328,-1.34392071,-1.30608487>,<-3.37252760,-1.44527769,-1.32538605>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.39778328,-1.34392071,-1.30608487>,<-3.40603828,-1.29240656,-1.39861417>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.41429329,-1.24089217,-1.49114394>,<-3.40603828,-1.29240656,-1.39861417>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.34727144,-1.54663491,-1.34468794>,<-3.37252760,-1.44527769,-1.32538605>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.61168337,-1.34072733,-1.20153165>,<-3.60847902,-1.40601861,-1.10202956>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.61168337,-1.34072733,-1.20153165>,<-3.50473356,-1.34232414,-1.25380826>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.61168337,-1.34072733,-1.20153165>,<-3.68731260,-1.38214111,-1.27060580>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.61168337,-1.34072733,-1.20153165>,<-3.63760757,-1.24281693,-1.17816281>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.66353035,-1.14490628,-1.15479350>,<-3.63760757,-1.24281693,-1.17816281>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.76294088,-1.42355466,-1.33967996>,<-3.79091883,-1.34679735,-1.41405296>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-3.76294088,-1.42355466,-1.33967996>,<-3.68731260,-1.38214111,-1.27060580>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-3.81889629,-1.27003980,-1.48842597>,<-3.79091883,-1.34679735,-1.41405296>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.81889629,-1.27003980,-1.48842597>,<-3.75169516,-1.19203925,-1.50272799>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.81889629,-1.27003980,-1.48842597>,<-3.91487741,-1.23077548,-1.48131919>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.81889629,-1.27003980,-1.48842597>,<-3.82157898,-1.31875253,-1.59700775>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.82426167,-1.36746514,-1.70558953>,<-3.82157898,-1.31875253,-1.59700775>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.82426167,-1.36746514,-1.70558953>,<-3.73695564,-1.44380283,-1.73242640>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.82426167,-1.36746514,-1.70558953>,<-3.91487551,-1.40785170,-1.73661423>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.82426167,-1.36746514,-1.70558953>,<-3.80836964,-1.28892481,-1.78164721>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.79247713,-1.21038437,-1.85770512>,<-3.80836964,-1.28892481,-1.78164721>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-3.79247713,-1.21038437,-1.85770512>,<-3.88611269,-1.19411612,-1.91404033>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-3.64964771,-1.52014041,-1.75926328>,<-3.73695564,-1.44380283,-1.73242640>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.64964771,-1.52014041,-1.75926328>,<-3.64795208,-1.59731340,-1.68965030>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.64964771,-1.52014041,-1.75926328>,<-3.55821848,-1.47071087,-1.75784159>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.64964771,-1.52014041,-1.75926328>,<-3.66567421,-1.55980682,-1.85399580>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.00548983,-1.44823790,-1.76763868>,<-3.91487551,-1.40785170,-1.73661423>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.01085806,-1.19151139,-1.47421241>,<-3.91487741,-1.23077548,-1.48131919>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.68449450,-1.11403883,-1.51703000>,<-3.75169516,-1.19203925,-1.50272799>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.68170118,-1.59947264,-1.94872880>,<-3.66567421,-1.55980682,-1.85399580>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.64625597,-1.67448640,-1.62003732>,<-3.64795208,-1.59731340,-1.68965030>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.46678877,-1.42128134,-1.75641942>,<-3.55821848,-1.47071087,-1.75784159>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.97974730,-1.17784786,-1.97037554>,<-4.05820560,-1.13307118,-1.91895533>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.97974730,-1.17784786,-1.97037554>,<-3.88611269,-1.19411612,-1.91404033>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.97974730,-1.17784786,-1.97037554>,<-4.01671171,-1.25872087,-2.02420568>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.97974730,-1.17784786,-1.97037554>,<-3.96061850,-1.09875357,-2.05725741>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.05367661,-1.33959377,-2.07803655>,<-4.01671171,-1.25872087,-2.02420568>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.13666248,-1.08829474,-1.86753416>,<-4.05820560,-1.13307118,-1.91895533>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.94148874,-1.01965904,-2.14413905>,<-4.06026649,-0.96480310,-2.19409204>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.94148874,-1.01965904,-2.14413905>,<-3.89866018,-1.05788195,-2.23079419>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.94148874,-1.01965904,-2.14413905>,<-3.88970709,-0.93401563,-2.11605954>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.94148874,-1.01965904,-2.14413905>,<-3.96061850,-1.09875357,-2.05725741>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.83792543,-0.84837198,-2.08798075>,<-3.88970709,-0.93401563,-2.11605954>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.85583162,-1.09610486,-2.31744933>,<-3.89866018,-1.05788195,-2.23079419>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.17904377,-0.90994680,-2.24404454>,<-4.18943977,-0.80520713,-2.19734406>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.17904377,-0.90994680,-2.24404454>,<-4.06026649,-0.96480310,-2.19409204>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.17904377,-0.90994680,-2.24404454>,<-4.26426125,-0.98033082,-2.21174359>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.17904377,-0.90994680,-2.24404454>,<-4.30376148,-0.85234785,-2.29649377>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.17904377,-0.90994680,-2.24404454>,<-4.16787100,-0.90530586,-2.35855508>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.19983578,-0.70046747,-2.15064454>,<-4.18943977,-0.80520713,-2.19734406>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-4.34947920,-1.05071509,-2.17944312>,<-4.26426125,-0.98033082,-2.21174359>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-4.15669680,-0.90066504,-2.47306657>,<-4.16787100,-0.90530586,-2.35855508>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-4.42847967,-0.79474938,-2.34894347>,<-4.30376148,-0.85234785,-2.29649377>0.0117,rgbt<1.000,1.000,1.000,0.000>,1)
VMD_cylinder(<-3.60527420,-1.47131014,-1.00252748>,<-3.66572714,-1.42283416,-0.92986941>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.60527420,-1.47131014,-1.00252748>,<-3.64258909,-1.58399415,-1.01168418>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.60527420,-1.47131014,-1.00252748>,<-3.60847902,-1.40601861,-1.10202956>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.60527420,-1.47131014,-1.00252748>,<-3.50484037,-1.47301424,-0.96797776>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.40440702,-1.47471833,-0.93342805>,<-3.50484037,-1.47301424,-0.96797776>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.72617960,-1.37435830,-0.85721135>,<-3.66572714,-1.42283416,-0.92986941>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.67990351,-1.69667828,-1.02084112>,<-3.78262520,-1.69920325,-0.99390340>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.67990351,-1.69667828,-1.02084112>,<-3.64258909,-1.58399415,-1.01168418>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.67990351,-1.69667828,-1.02084112>,<-3.62277031,-1.77715278,-0.95425677>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.67990351,-1.69667828,-1.02084112>,<-3.67037439,-1.72592378,-1.12251472>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.88534689,-1.70172858,-0.96696639>,<-3.78262520,-1.69920325,-0.99390340>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.66084623,-1.75516915,-1.22418857>,<-3.67037439,-1.72592378,-1.12251472>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.56563711,-1.85762739,-0.88767171>,<-3.55357504,-1.83200276,-0.77203631>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.56563711,-1.85762739,-0.88767171>,<-3.61840963,-1.94950068,-0.89529324>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.56563711,-1.85762739,-0.88767171>,<-3.46839571,-1.87043929,-0.92845988>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.56563711,-1.85762739,-0.88767171>,<-3.62277031,-1.77715278,-0.95425677>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.67118120,-2.04137421,-0.90291429>,<-3.61840963,-1.94950068,-0.89529324>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.37115479,-1.88325119,-0.96924758>,<-3.46839571,-1.87043929,-0.92845988>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.54151392,-1.80637836,-0.65640044>,<-3.46779919,-1.73041964,-0.64744639>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.54151392,-1.80637836,-0.65640044>,<-3.63935661,-1.76907885,-0.59974909>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.54151392,-1.80637836,-0.65640044>,<-3.55357504,-1.83200276,-0.77203631>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.54151392,-1.80637836,-0.65640044>,<-3.50678110,-1.89385962,-0.60716271>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.47204924,-1.98134089,-0.55792499>,<-3.50678110,-1.89385962,-0.60716271>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.39408493,-1.65446091,-0.63849235>,<-3.46779919,-1.73041964,-0.64744639>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.73720074,-1.73177886,-0.54309821>,<-3.72120619,-1.65148175,-0.45666623>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.73720074,-1.73177886,-0.54309821>,<-3.63935661,-1.76907885,-0.59974909>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.73720074,-1.73177886,-0.54309821>,<-3.80238485,-1.68922067,-0.61537099>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.73720074,-1.73177886,-0.54309821>,<-3.78433418,-1.81676877,-0.50021672>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.86756849,-1.64666247,-0.68764424>,<-3.80238485,-1.68922067,-0.61537099>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.83146811,-1.90175855,-0.45733571>,<-3.78433418,-1.81676877,-0.50021672>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.70521116,-1.57118475,-0.37023377>,<-3.75471592,-1.60675621,-0.28324199>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.70521116,-1.57118475,-0.37023377>,<-3.60103941,-1.56511998,-0.35035944>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.70521116,-1.57118475,-0.37023377>,<-3.74462175,-1.46099305,-0.39211345>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.70521116,-1.57118475,-0.37023377>,<-3.72120619,-1.65148175,-0.45666623>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.80422068,-1.64232731,-0.19624972>,<-3.75471592,-1.60675621,-0.28324199>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.49686718,-1.55905557,-0.33048463>,<-3.60103941,-1.56511998,-0.35035944>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.78403139,-1.35080206,-0.41399288>,<-3.74462175,-1.46099305,-0.39211345>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.78403139,-1.35080206,-0.41399288>,<-3.78385973,-1.27508426,-0.32212019>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.78403139,-1.35080206,-0.41399288>,<-3.72331858,-1.30916393,-0.49056792>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.78403139,-1.35080206,-0.41399288>,<-3.88379717,-1.35843682,-0.44965959>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.66260672,-1.26752567,-0.56714272>,<-3.72331858,-1.30916393,-0.49056792>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.98356295,-1.36607146,-0.48532605>,<-3.88379717,-1.35843682,-0.44965959>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.78368807,-1.19936645,-0.23024726>,<-3.88996267,-1.16063881,-0.19310403>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.78368807,-1.19936645,-0.23024726>,<-3.72609186,-1.11457086,-0.25810695>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.78368807,-1.19936645,-0.23024726>,<-3.78385973,-1.27508426,-0.32212019>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.78368807,-1.19936645,-0.23024726>,<-3.73624849,-1.24766815,-0.14839435>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.68880892,-1.29597008,-0.06654108>,<-3.73624849,-1.24766815,-0.14839435>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.66849613,-1.02977538,-0.28596616>,<-3.72609186,-1.11457086,-0.25810695>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.99623823,-1.12191105,-0.15596080>,<-4.03293371,-1.19130051,-0.08439136>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.99623823,-1.12191105,-0.15596080>,<-4.07991123,-1.10803378,-0.23950863>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.99623823,-1.12191105,-0.15596080>,<-3.88996267,-1.16063881,-0.19310403>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.99623823,-1.12191105,-0.15596080>,<-3.98183489,-1.02800488,-0.10844374>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.06962919,-1.26069021,-0.01282167>,<-4.03293371,-1.19130051,-0.08439136>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.96743155,-0.93409920,-0.06092644>,<-3.98183489,-1.02800488,-0.10844374>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.16358376,-1.09415698,-0.32305551>,<-4.24811697,-1.01336002,-0.30069900>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.16358376,-1.09415698,-0.32305551>,<-4.07991123,-1.10803378,-0.23950863>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.16358376,-1.09415698,-0.32305551>,<-4.21124792,-1.18802166,-0.33724284>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.16358376,-1.09415698,-0.32305551>,<-4.11506319,-1.06632686,-0.41335940>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.06654215,-1.03849661,-0.50366282>,<-4.11506319,-1.06632686,-0.41335940>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.25891209,-1.28188670,-0.35142994>,<-4.21124792,-1.18802166,-0.33724284>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.33265114,-0.93256307,-0.27834296>,<-4.31767988,-0.86549771,-0.18112111>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.33265114,-0.93256307,-0.27834296>,<-4.24811697,-1.01336002,-0.30069900>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.33265114,-0.93256307,-0.27834296>,<-4.42503214,-0.98405159,-0.26842499>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.33265114,-0.93256307,-0.27834296>,<-4.33844805,-0.86753273,-0.36213446>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.34424591,-0.80250227,-0.44592690>,<-4.33844805,-0.86753273,-0.36213446>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.51741362,-1.03553963,-0.25850797>,<-4.42503214,-0.98405159,-0.26842499>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.30270863,-0.79843211,-0.08389950>,<-4.27551222,-0.86278355,-0.00388157>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.30270863,-0.79843211,-0.08389950>,<-4.31767988,-0.86549771,-0.18112111>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.30270863,-0.79843211,-0.08389950>,<-4.22254229,-0.73132920,-0.10271788>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.30270863,-0.79843211,-0.08389950>,<-4.39654303,-0.73416221,-0.04870927>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.24831486,-0.92713475,0.07613611>,<-4.27551222,-0.86278355,-0.00388157>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.14237547,-0.66422641,-0.12153649>,<-4.22254229,-0.73132920,-0.10271788>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.49037790,-0.66989195,-0.01351941>,<-4.55540800,-0.73419547,0.04051638>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.49037790,-0.66989195,-0.01351941>,<-4.45510626,-0.59396017,0.05185497>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.49037790,-0.66989195,-0.01351941>,<-4.55404520,-0.61741495,-0.09934783>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.49037790,-0.66989195,-0.01351941>,<-4.39654303,-0.73416221,-0.04870927>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.62043810,-0.79849863,0.09455156>,<-4.55540800,-0.73419547,0.04051638>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.41983461,-0.51802874,0.11722946>,<-4.45510626,-0.59396017,0.05185497>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.61771250,-0.56493759,-0.18517637>,<-4.70404005,-0.51246607,-0.14045501>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.61771250,-0.56493759,-0.18517637>,<-4.65282869,-0.63688254,-0.25147367>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.61771250,-0.56493759,-0.18517637>,<-4.54936838,-0.48684168,-0.24352121>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.61771250,-0.56493759,-0.18517637>,<-4.55404520,-0.61741495,-0.09934783>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.68794489,-0.70882773,-0.31777024>,<-4.65282869,-0.63688254,-0.25147367>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.79036856,-0.45999444,-0.09573388>,<-4.87973452,-0.52472281,-0.10119081>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-4.79036856,-0.45999444,-0.09573388>,<-4.70404005,-0.51246607,-0.14045501>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-4.96910048,-0.58945119,-0.10664749>,<-5.05383062,-0.54668331,-0.03480089>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.96910048,-0.58945119,-0.10664749>,<-5.01918840,-0.59250498,-0.19767737>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.96910048,-0.58945119,-0.10664749>,<-4.87973452,-0.52472281,-0.10119081>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.96910048,-0.58945119,-0.10664749>,<-4.95890856,-0.68643868,-0.07067430>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-5.13856077,-0.50391543,0.03704548>,<-5.09468031,-0.47976172,0.13551855>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-5.13856077,-0.50391543,0.03704548>,<-5.05383062,-0.54668331,-0.03480089>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-5.13856077,-0.50391543,0.03704548>,<-5.18689775,-0.39939857,0.00688148>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-5.13856077,-0.50391543,0.03704548>,<-5.21454477,-0.56947613,0.06411231>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-5.05079985,-0.45560813,0.23399150>,<-5.09468031,-0.47976172,0.13551855>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-5.05079985,-0.45560813,0.23399150>,<-5.07549524,-0.53566802,0.30600929>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-5.23523378,-0.29488134,-0.02328277>,<-5.24190474,-0.23385084,0.06059432>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-5.23523378,-0.29488134,-0.02328277>,<-5.33041143,-0.31020832,-0.06215036>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-5.23523378,-0.29488134,-0.02328277>,<-5.17606878,-0.24828804,-0.09492850>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-5.23523378,-0.29488134,-0.02328277>,<-5.18689775,-0.39939857,0.00688148>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-5.29053068,-0.63503611,0.09117913>,<-5.21454477,-0.56947613,0.06411231>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-5.06927633,-0.59555900,-0.28870797>,<-5.01918840,-0.59250498,-0.19767737>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.94871664,-0.78342617,-0.03470063>,<-4.95890856,-0.68643868,-0.07067430>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-5.42559004,-0.32553470,-0.10101891>,<-5.33041143,-0.31020832,-0.06215036>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-5.11690378,-0.20169449,-0.16657424>,<-5.17606878,-0.24828804,-0.09492850>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-5.24857473,-0.17282021,0.14447165>,<-5.24190474,-0.23385084,0.06059432>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-5.10019064,-0.61572742,0.37802649>,<-5.07622099,-0.71293354,0.35008335>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-5.10019064,-0.61572742,0.37802649>,<-5.07549524,-0.53566802,0.30600929>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-5.10019064,-0.61572742,0.37802649>,<-5.19619703,-0.61495781,0.41785884>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-5.10019064,-0.61572742,0.37802649>,<-5.03409243,-0.60267162,0.47616267>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-5.29220438,-0.61418855,0.45769095>,<-5.19619703,-0.61495781,0.41785884>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-5.05225134,-0.81013978,0.32214069>,<-5.07622099,-0.71293354,0.35008335>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.96799421,-0.58961606,0.57429910>,<-5.01182699,-0.62283456,0.66250134>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.96799421,-0.58961606,0.57429910>,<-4.92929983,-0.49439967,0.58983064>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.96799421,-0.58961606,0.57429910>,<-5.03409243,-0.60267162,0.47616267>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.96799421,-0.58961606,0.57429910>,<-4.85104895,-0.66659665,0.57105422>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.89060545,-0.39918327,0.60536242>,<-4.92929983,-0.49439967,0.58983064>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-5.05566168,-0.65605330,0.75070357>,<-5.01182699,-0.62283456,0.66250134>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.73410368,-0.74357760,0.56780958>,<-4.73994970,-0.81657600,0.65667057>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.73410368,-0.74357760,0.56780958>,<-4.64584684,-0.67029619,0.57779908>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.73410368,-0.74357760,0.56780958>,<-4.61131144,-0.82440782,0.56440282>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.73410368,-0.74357760,0.56780958>,<-4.73337889,-0.79858613,0.46665263>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.73410368,-0.74357760,0.56780958>,<-4.85104895,-0.66659665,0.57105422>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.73265409,-0.85359466,0.36549616>,<-4.73337889,-0.79858613,0.46665263>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-4.74579573,-0.88957429,0.74553180>,<-4.73994970,-0.81657600,0.65667057>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-4.55759096,-0.59701455,0.58778894>,<-4.64584684,-0.67029619,0.57779908>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-4.48851919,-0.90523815,0.56099582>,<-4.61131144,-0.82440782,0.56440282>0.0117,rgbt<1.000,1.000,1.000,0.000>,1)
VMD_cylinder(<-4.48102474,-0.40874624,-0.30186629>,<-4.54936838,-0.48684168,-0.24352121>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.48102474,-0.40874624,-0.30186629>,<-4.37967920,-0.43055797,-0.27869368>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.48102474,-0.40874624,-0.30186629>,<-4.50437307,-0.31166530,-0.26561737>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.48102474,-0.40874624,-0.30186629>,<-4.49173307,-0.40693820,-0.42042303>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.52772188,-0.21458483,-0.22936845>,<-4.50437307,-0.31166530,-0.26561737>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.27833366,-0.45236993,-0.25552082>,<-4.37967920,-0.43055797,-0.27869368>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.50244141,-0.40512991,-0.53898025>,<-4.50104904,-0.50565171,-0.57328916>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.50244141,-0.40512991,-0.53898025>,<-4.59671354,-0.36217332,-0.56246090>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.50244141,-0.40512991,-0.53898025>,<-4.41902304,-0.34498334,-0.59896064>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.50244141,-0.40512991,-0.53898025>,<-4.49173307,-0.40693820,-0.42042303>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.49965620,-0.60617352,-0.60759854>,<-4.50104904,-0.50565171,-0.57328916>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.69098425,-0.31921649,-0.58594155>,<-4.59671354,-0.36217332,-0.56246090>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.33560467,-0.28483677,-0.65894103>,<-4.41902304,-0.34498334,-0.59896064>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.33560467,-0.28483677,-0.65894103>,<-4.24204540,-0.30376387,-0.61233687>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.33560467,-0.28483677,-0.65894103>,<-4.34973478,-0.16681910,-0.66572595>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.33560467,-0.28483677,-0.65894103>,<-4.33291721,-0.32302022,-0.75802875>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.14848518,-0.32269073,-0.56573248>,<-4.24204540,-0.30376387,-0.61233687>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.33022833,-0.36120367,-0.85711598>,<-4.33291721,-0.32302022,-0.75802875>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.36386538,-0.04880095,-0.67251134>,<-4.38289690,0.00842905,-0.56986403>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.36386538,-0.04880095,-0.67251134>,<-4.34973478,-0.16681910,-0.66572595>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.36386538,-0.04880095,-0.67251134>,<-4.44660473,-0.02957487,-0.73629355>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.36386538,-0.04880095,-0.67251134>,<-4.27628660,-0.00805688,-0.71670914>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.18870831,0.03268766,-0.76090741>,<-4.27628660,-0.00805688,-0.71670914>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.52934361,-0.01034832,-0.80007577>,<-4.44660473,-0.02957487,-0.73629355>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.40192986,0.06565952,-0.46721697>,<-4.34711742,0.01543760,-0.39134240>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.40192986,0.06565952,-0.46721697>,<-4.37148905,0.18071389,-0.46408510>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.40192986,0.06565952,-0.46721697>,<-4.38289690,0.00842905,-0.56986403>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.40192986,0.06565952,-0.46721697>,<-4.50555944,0.05881715,-0.44490719>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.60918856,0.05197430,-0.42259669>,<-4.50555944,0.05881715,-0.44490719>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.29230499,-0.03478503,-0.31546760>,<-4.34711742,0.01543760,-0.39134240>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.34104824,0.29576778,-0.46095300>,<-4.26512575,0.30732632,-0.38756537>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.34104824,0.29576778,-0.46095300>,<-4.37148905,0.18071389,-0.46408510>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.34104824,0.29576778,-0.46095300>,<-4.30092382,0.34290791,-0.56264758>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.34104824,0.29576778,-0.46095300>,<-4.42652750,0.35121083,-0.43090415>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.51200724,0.40665388,-0.40085554>,<-4.42652750,0.35121083,-0.43090415>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.18920279,0.31888485,-0.31417751>,<-4.26512575,0.30732632,-0.38756537>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.26079893,0.39004803,-0.66434193>,<-4.30092382,0.34290791,-0.56264758>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.26079893,0.39004803,-0.66434193>,<-4.28802204,0.49271750,-0.66555476>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.26079893,0.39004803,-0.66434193>,<-4.14348459,0.38321495,-0.68343377>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.26079893,0.39004803,-0.66434193>,<-4.30974865,0.34063053,-0.74462628>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.35869741,0.29121304,-0.82491016>,<-4.30974865,0.34063053,-0.74462628>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.31524515,0.59538698,-0.66676784>,<-4.28802204,0.49271750,-0.66555476>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.02617073,0.37638164,-0.70252585>,<-3.96288729,0.31450653,-0.62289762>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.02617073,0.37638164,-0.70252585>,<-4.14348459,0.38321495,-0.68343377>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.02617073,0.37638164,-0.70252585>,<-4.01127195,0.33168006,-0.79772735>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-4.02617073,0.37638164,-0.70252585>,<-3.98776722,0.47539711,-0.70473289>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.99637270,0.28697848,-0.89292860>,<-4.01127195,0.33168006,-0.79772735>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.94936466,0.57441235,-0.70694041>,<-3.98776722,0.47539711,-0.70473289>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.89960432,0.25263214,-0.54326987>,<-3.86569929,0.32046938,-0.46889114>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.89960432,0.25263214,-0.54326987>,<-3.96288729,0.31450653,-0.62289762>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.89960432,0.25263214,-0.54326987>,<-3.96458673,0.18181133,-0.49804473>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.89960432,0.25263214,-0.54326987>,<-3.80483389,0.19378757,-0.58485937>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.83179283,0.38830614,-0.39451241>,<-3.86569929,0.32046938,-0.46889114>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-4.02956915,0.11099052,-0.45281935>,<-3.96458673,0.18181133,-0.49804473>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.71006393,0.13494372,-0.62644935>,<-3.64232922,0.12123537,-0.54577994>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.71006393,0.13494372,-0.62644935>,<-3.80483389,0.19378757,-0.58485937>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.71006393,0.13494372,-0.62644935>,<-3.74308395,0.03974366,-0.66007018>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.71006393,0.13494372,-0.62644935>,<-3.65048504,0.18647647,-0.71571708>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.57459259,0.10752749,-0.46511054>,<-3.64232922,0.12123537,-0.54577994>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.77610350,-0.05545640,-0.69369078>,<-3.74308395,0.03974366,-0.66007018>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.59090567,0.23800898,-0.80498433>,<-3.59083557,0.34283280,-0.78778768>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.59090567,0.23800898,-0.80498433>,<-3.47800493,0.20352602,-0.82041049>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.59090567,0.23800898,-0.80498433>,<-3.64359951,0.21805644,-0.89503455>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.59090567,0.23800898,-0.80498433>,<-3.65048504,0.18647647,-0.71571708>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.69629335,0.19810390,-0.98508477>,<-3.64359951,0.21805644,-0.89503455>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.59076548,0.44765639,-0.77059150>,<-3.59083557,0.34283280,-0.78778768>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.36510420,0.16904283,-0.83583665>,<-3.47800493,0.20352602,-0.82041049>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.36510420,0.16904283,-0.83583665>,<-3.33070564,0.12830997,-0.74396110>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.36510420,0.16904283,-0.83583665>,<-3.34536219,0.08836961,-0.92113686>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.36510420,0.16904283,-0.83583665>,<-3.30758810,0.25535560,-0.85876393>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.25007248,0.34166813,-0.88169146>,<-3.30758810,0.25535560,-0.85876393>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.29630709,0.08757710,-0.65208483>,<-3.33070564,0.12830997,-0.74396110>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.32562113,0.00769615,-1.00643706>,<-3.37446642,0.04105425,-1.09466958>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.32562113,0.00769615,-1.00643706>,<-3.34536219,0.08836961,-0.92113686>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.32562113,0.00769615,-1.00643706>,<-3.36243153,-0.10330772,-0.98414302>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.32562113,0.00769615,-1.00643706>,<-3.22097588,0.00427556,-1.02436376>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.42331076,0.07441211,-1.18290210>,<-3.37446642,0.04105425,-1.09466958>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.11633062,0.00085473,-1.04228973>,<-3.22097588,0.00427556,-1.02436376>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.39924192,-0.21431124,-0.96184897>,<-3.34141493,-0.25728452,-0.86706853>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.39924192,-0.21431124,-0.96184897>,<-3.50148773,-0.21403742,-0.94313359>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.39924192,-0.21431124,-0.96184897>,<-3.37921190,-0.27832723,-1.04963660>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.39924192,-0.21431124,-0.96184897>,<-3.36243153,-0.10330772,-0.98414302>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.60373306,-0.21376395,-0.92441797>,<-3.50148773,-0.21403742,-0.94313359>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.35918283,-0.34234273,-1.13742447>,<-3.44965744,-0.34765315,-1.20060611>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-3.35918283,-0.34234273,-1.13742447>,<-3.37921190,-0.27832723,-1.04963660>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-3.54013300,-0.35296297,-1.26378775>,<-3.44965744,-0.34765315,-1.20060611>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.54013300,-0.35296297,-1.26378775>,<-3.61497927,-0.41817510,-1.23296618>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.54013300,-0.35296297,-1.26378775>,<-3.51194954,-0.39836907,-1.37015581>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.54013300,-0.35296297,-1.26378775>,<-3.58353567,-0.26253986,-1.29107165>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.48376608,-0.44377530,-1.47652364>,<-3.47307301,-0.56213856,-1.48331642>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.48376608,-0.44377530,-1.47652364>,<-3.38200331,-0.41127765,-1.50470471>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.48376608,-0.44377530,-1.47652364>,<-3.53911257,-0.41034651,-1.55790997>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.48376608,-0.44377530,-1.47652364>,<-3.51194954,-0.39836907,-1.37015581>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.28024054,-0.37877989,-1.53288579>,<-3.38200331,-0.41127765,-1.50470471>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-3.28024054,-0.37877989,-1.53288579>,<-3.27194357,-0.37485993,-1.64298344>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-3.46237993,-0.68050158,-1.49010921>,<-3.52437067,-0.71703684,-1.56512117>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.46237993,-0.68050158,-1.49010921>,<-3.48944998,-0.72339380,-1.39937925>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.46237993,-0.68050158,-1.49010921>,<-3.36387444,-0.70559525,-1.51182532>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.46237993,-0.68050158,-1.49010921>,<-3.47307301,-0.56213856,-1.48331642>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.59445953,-0.37691760,-1.63929653>,<-3.53911257,-0.41034651,-1.55790997>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.68982601,-0.48338723,-1.20214486>,<-3.61497927,-0.41817510,-1.23296618>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.62693834,-0.17211664,-1.31835556>,<-3.58353567,-0.26253986,-1.29107165>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.26536894,-0.73068881,-1.53354144>,<-3.36387444,-0.70559525,-1.51182532>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.58636189,-0.75357199,-1.64013314>,<-3.52437067,-0.71703684,-1.56512117>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.51652145,-0.76628590,-1.30864930>,<-3.48944998,-0.72339380,-1.39937925>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.26364565,-0.37093985,-1.75308156>,<-3.27194357,-0.37485993,-1.64298344>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.26364565,-0.37093985,-1.75308156>,<-3.27542353,-0.46068013,-1.80419540>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.26364565,-0.37093985,-1.75308156>,<-3.31852818,-0.29720914,-1.80162215>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.26364565,-0.37093985,-1.75308156>,<-3.15248680,-0.34114945,-1.78351736>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.28720140,-0.55042005,-1.85530925>,<-3.27542353,-0.46068013,-1.80419540>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.37341118,-0.22347844,-1.85016298>,<-3.31852818,-0.29720914,-1.80162215>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.04132795,-0.31135941,-1.81395364>,<-3.00581598,-0.22285974,-1.77258611>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.04132795,-0.31135941,-1.81395364>,<-3.15248680,-0.34114945,-1.78351736>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.04132795,-0.31135941,-1.81395364>,<-3.02827692,-0.28486919,-1.95084977>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.04132795,-0.31135941,-1.81395364>,<-2.96987152,-0.38566959,-1.80066347>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.97030449,-0.13436007,-1.73121881>,<-3.00581598,-0.22285974,-1.77258611>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.89841509,-0.45997953,-1.78737378>,<-2.96987152,-0.38566959,-1.80066347>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.01522541,-0.25837934,-2.08774567>,<-3.03028107,-0.14501381,-2.10119271>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.01522541,-0.25837934,-2.08774567>,<-3.02827692,-0.28486919,-1.95084977>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.01522541,-0.25837934,-2.08774567>,<-2.90929127,-0.29181457,-2.11806417>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.01522541,-0.25837934,-2.08774567>,<-3.09682369,-0.31947839,-2.14129663>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.01522541,-0.25837934,-2.08774567>,<-3.00152111,-0.23056436,-2.23148704>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.80335712,-0.32525015,-2.14838290>,<-2.90929127,-0.29181457,-2.11806417>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-3.04533768,-0.03164840,-2.11463952>,<-3.03028107,-0.14501381,-2.10119271>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-3.17842245,-0.38057721,-2.19484735>,<-3.09682369,-0.31947839,-2.14129663>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-2.98781633,-0.20274937,-2.37522817>,<-3.00152111,-0.23056436,-2.23148704>0.0117,rgbt<1.000,1.000,1.000,0.000>,1)
VMD_cylinder(<-3.28358793,-0.30025792,-0.77228832>,<-3.20608044,-0.23189485,-0.74774003>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.28358793,-0.30025792,-0.77228832>,<-3.34852886,-0.31849599,-0.67418647>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.28358793,-0.30025792,-0.77228832>,<-3.34141493,-0.25728452,-0.86706853>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.28358793,-0.30025792,-0.77228832>,<-3.23996210,-0.39302468,-0.80012393>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.19633675,-0.48579144,-0.82795978>,<-3.23996210,-0.39302468,-0.80012393>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.12857246,-0.16353202,-0.72319126>,<-3.20608044,-0.23189485,-0.74774003>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.41346979,-0.33673453,-0.57608414>,<-3.35340452,-0.34779775,-0.47389054>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.41346979,-0.33673453,-0.57608414>,<-3.48044252,-0.25493312,-0.56575370>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.41346979,-0.33673453,-0.57608414>,<-3.46983719,-0.42561388,-0.59046388>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.41346979,-0.33673453,-0.57608414>,<-3.34852886,-0.31849599,-0.67418647>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.54741526,-0.17313218,-0.55542254>,<-3.48044252,-0.25493312,-0.56575370>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.52620506,-0.51449299,-0.60484385>,<-3.46983719,-0.42561388,-0.59046388>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.29333973,-0.35886121,-0.37169719>,<-3.18966627,-0.35323358,-0.39414430>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.29333973,-0.35886121,-0.37169719>,<-3.31948853,-0.27676809,-0.30956244>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.29333973,-0.35886121,-0.37169719>,<-3.35340452,-0.34779775,-0.47389054>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.29333973,-0.35886121,-0.37169719>,<-3.31184530,-0.45882082,-0.30973363>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.08599281,-0.34760642,-0.41659045>,<-3.18966627,-0.35323358,-0.39414430>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.34563732,-0.19467497,-0.24742818>,<-3.31948853,-0.27676809,-0.30956244>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.33035183,-0.55878043,-0.24777031>,<-3.27416992,-0.55217433,-0.15786123>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.33035183,-0.55878043,-0.24777031>,<-3.43364906,-0.56328642,-0.22341943>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.33035183,-0.55878043,-0.24777031>,<-3.30110741,-0.66086018,-0.30160856>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.33035183,-0.55878043,-0.24777031>,<-3.31184530,-0.45882082,-0.30973363>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.21798754,-0.54556787,-0.06795263>,<-3.27416992,-0.55217433,-0.15786123>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.53694582,-0.56779242,-0.19906831>,<-3.43364906,-0.56328642,-0.22341943>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.27186155,-0.76293969,-0.35544658>,<-3.35802698,-0.79878664,-0.40618348>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.27186155,-0.76293969,-0.35544658>,<-3.19635868,-0.74148130,-0.42701745>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.27186155,-0.76293969,-0.35544658>,<-3.30110741,-0.66086018,-0.30160856>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.27186155,-0.76293969,-0.35544658>,<-3.23181629,-0.85042548,-0.28533006>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.44419289,-0.83463323,-0.45692062>,<-3.35802698,-0.79878664,-0.40618348>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.12085485,-0.72002292,-0.49858785>,<-3.19635868,-0.74148130,-0.42701745>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.19177055,-0.93791115,-0.21521354>,<-3.26203966,-0.95139909,-0.13670278>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.19177055,-0.93791115,-0.21521354>,<-3.09932375,-0.90638006,-0.17346430>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.19177055,-0.93791115,-0.21521354>,<-3.23181629,-0.85042548,-0.28533006>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.19177055,-0.93791115,-0.21521354>,<-3.17420483,-1.04367471,-0.26697779>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.00687647,-0.87484860,-0.13171506>,<-3.09932375,-0.90638006,-0.17346430>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.33230925,-0.96488678,-0.05819261>,<-3.26203966,-0.95139909,-0.13670278>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.15663862,-1.14943814,-0.31874228>,<-3.05681658,-1.15171671,-0.35499072>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.15663862,-1.14943814,-0.31874228>,<-3.22323990,-1.15675569,-0.40117073>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.15663862,-1.14943814,-0.31874228>,<-3.17274141,-1.24546349,-0.25023222>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.15663862,-1.14943814,-0.31874228>,<-3.17420483,-1.04367471,-0.26697779>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.28984213,-1.16407323,-0.48359895>,<-3.22323990,-1.15675569,-0.40117073>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.95699453,-1.15399528,-0.39123964>,<-3.05681658,-1.15171671,-0.35499072>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.18884420,-1.34148932,-0.18172193>,<-3.13436413,-1.34098506,-0.07586634>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.18884420,-1.34148932,-0.18172193>,<-3.29313898,-1.35207522,-0.16457272>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.18884420,-1.34148932,-0.18172193>,<-3.15419531,-1.42614341,-0.23572898>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.18884420,-1.34148932,-0.18172193>,<-3.17274141,-1.24546349,-0.25023222>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.39743328,-1.36266088,-0.14742351>,<-3.29313898,-1.35207522,-0.16457272>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.11954737,-1.51079774,-0.28973651>,<-3.15419531,-1.42614341,-0.23572898>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.07988405,-1.34048080,0.02998948>,<-2.97743130,-1.40067816,0.03731418>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.07988405,-1.34048080,0.02998948>,<-3.13436413,-1.34098506,-0.07586634>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.07988405,-1.34048080,0.02998948>,<-3.14698410,-1.38168550,0.10128748>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.07988405,-1.34048080,0.02998948>,<-3.06012630,-1.23937869,0.05590653>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.04036760,-1.13827693,0.08182395>,<-3.06012630,-1.23937869,0.05590653>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.21408510,-1.42288995,0.17258513>,<-3.14698410,-1.38168550,0.10128748>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.87497854,-1.46087587,0.04463887>,<-2.97743130,-1.40067816,0.03731418>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.87497854,-1.46087587,0.04463887>,<-2.82354116,-1.44884801,-0.04751921>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.87497854,-1.46087587,0.04463887>,<-2.88336754,-1.57755983,0.06674182>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.87497854,-1.46087587,0.04463887>,<-2.81705666,-1.41716170,0.12221253>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.77210331,-1.43681991,-0.13967729>,<-2.82354116,-1.44884801,-0.04751921>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.75913477,-1.37344730,0.19978595>,<-2.81705666,-1.41716170,0.12221253>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.89175606,-1.69424391,0.08884501>,<-2.98230505,-1.71087039,0.14183533>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.89175606,-1.69424391,0.08884501>,<-2.80320740,-1.74290061,0.15181780>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.89175606,-1.69424391,0.08884501>,<-2.89685774,-1.74472964,-0.00447631>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.89175606,-1.69424391,0.08884501>,<-2.88336754,-1.57755983,0.06674182>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.07285357,-1.72749722,0.19482601>,<-2.98230505,-1.71087039,0.14183533>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.90195894,-1.79521537,-0.09779739>,<-2.89685774,-1.74472964,-0.00447631>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.71465826,-1.79155731,0.21479058>,<-2.65183640,-1.71776080,0.28393865>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.71465826,-1.79155731,0.21479058>,<-2.80320740,-1.74290061,0.15181780>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.71465826,-1.79155731,0.21479058>,<-2.75654078,-1.86672854,0.27706945>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.71465826,-1.79155731,0.21479058>,<-2.64739990,-1.83721006,0.14641070>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.79842234,-1.94190013,0.33934855>,<-2.75654078,-1.86672854,0.27706945>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.58014107,-1.88286281,0.07803082>,<-2.64739990,-1.83721006,0.14641070>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.58901453,-1.64396429,0.35308647>,<-2.51174450,-1.70045328,0.39915156>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.58901453,-1.64396429,0.35308647>,<-2.54499483,-1.57030964,0.29046869>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.58901453,-1.64396429,0.35308647>,<-2.65183640,-1.71776080,0.28393865>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.58901453,-1.64396429,0.35308647>,<-2.64911747,-1.58757234,0.43900192>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.43447542,-1.75694180,0.44521654>,<-2.51174450,-1.70045328,0.39915156>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.50097561,-1.49665499,0.22785091>,<-2.54499483,-1.57030964,0.29046869>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.70922041,-1.53118026,0.52491724>,<-2.68761826,-1.58345151,0.62967873>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.70922041,-1.53118026,0.52491724>,<-2.81746149,-1.53514934,0.50314629>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.70922041,-1.53118026,0.52491724>,<-2.64911747,-1.58757234,0.43900192>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.70922041,-1.53118026,0.52491724>,<-2.67938757,-1.43168414,0.52879047>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.64955378,-1.33218789,0.53266346>,<-2.67938757,-1.43168414,0.52879047>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.92570257,-1.53911805,0.48137498>,<-2.98009348,-1.47487891,0.55293608>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-2.92570257,-1.53911805,0.48137498>,<-2.81746149,-1.53514934,0.50314629>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-3.03448486,-1.41063941,0.62449670>,<-3.09747076,-1.47856903,0.69925225>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.03448486,-1.41063941,0.62449670>,<-2.97678661,-1.35530269,0.69093037>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.03448486,-1.41063941,0.62449670>,<-3.10866213,-1.34927928,0.58529007>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.03448486,-1.41063941,0.62449670>,<-2.98009348,-1.47487891,0.55293608>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.16045713,-1.54649842,0.77400780>,<-3.20473623,-1.48317182,0.85296893>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.16045713,-1.54649842,0.77400780>,<-3.10730553,-1.61555493,0.83067179>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.16045713,-1.54649842,0.77400780>,<-3.09747076,-1.47856903,0.69925225>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.16045713,-1.54649842,0.77400780>,<-3.25736856,-1.59957027,0.72971654>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.24901581,-1.41984499,0.93193018>,<-3.20473623,-1.48317182,0.85296893>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-3.24901581,-1.41984499,0.93193018>,<-3.21760893,-1.45715308,1.03106427>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-3.35428047,-1.65264213,0.68542552>,<-3.36743689,-1.74517465,0.73091507>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.35428047,-1.65264213,0.68542552>,<-3.25736856,-1.59957027,0.72971654>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.35428047,-1.65264213,0.68542552>,<-3.34311247,-1.66612029,0.58296561>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.35428047,-1.65264213,0.68542552>,<-3.43787193,-1.59349763,0.70328641>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.05415392,-1.68461120,0.88733542>,<-3.10730553,-1.61555493,0.83067179>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.91908884,-1.29996610,0.75736368>,<-2.97678661,-1.35530269,0.69093037>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.18283892,-1.28791928,0.54608333>,<-3.10866213,-1.34927928,0.58529007>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.38059187,-1.83770716,0.77640486>,<-3.36743689,-1.74517465,0.73091507>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.33194447,-1.67959797,0.48050499>,<-3.34311247,-1.66612029,0.58296561>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.52146292,-1.53435290,0.72114682>,<-3.43787193,-1.59349763,0.70328641>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.18620157,-1.49446118,1.13019872>,<-3.24105310,-1.43196714,1.21537948>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.18620157,-1.49446118,1.13019872>,<-3.21426296,-1.59147322,1.15481091>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.18620157,-1.49446118,1.13019872>,<-3.21760893,-1.45715308,1.03106427>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.18620157,-1.49446118,1.13019872>,<-3.08642530,-1.48082268,1.15595257>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.24232483,-1.68848538,1.17942309>,<-3.21426296,-1.59147322,1.15481091>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.98664951,-1.46718431,1.18170643>,<-3.08642530,-1.48082268,1.15595257>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.29590654,-1.36947322,1.30056000>,<-3.39477921,-1.34417629,1.28084397>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.29590654,-1.36947322,1.30056000>,<-3.24105310,-1.43196714,1.21537948>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.29590654,-1.36947322,1.30056000>,<-3.30924845,-1.44142330,1.41996574>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.29590654,-1.36947322,1.30056000>,<-3.24547148,-1.28470755,1.33336043>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-3.19503736,-1.19994187,1.36616087>,<-3.24547148,-1.28470755,1.33336043>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.49365234,-1.31887925,1.26112771>,<-3.39477921,-1.34417629,1.28084397>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.32259083,-1.51337373,1.53937125>,<-3.35361242,-1.43769705,1.62042665>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.32259083,-1.51337373,1.53937125>,<-3.21987820,-1.56056666,1.56133318>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.32259083,-1.51337373,1.53937125>,<-3.33659983,-1.58892155,1.66474748>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.32259083,-1.51337373,1.53937125>,<-3.40376425,-1.59300494,1.52123952>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.32259083,-1.51337373,1.53937125>,<-3.30924845,-1.44142330,1.41996574>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.11716700,-1.60775924,1.58329415>,<-3.21987820,-1.56056666,1.56133318>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-3.48493814,-1.67263639,1.50310779>,<-3.40376425,-1.59300494,1.52123952>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-3.38463449,-1.36202025,1.70148206>,<-3.35361242,-1.43769705,1.62042665>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-3.35060930,-1.66446948,1.79012394>,<-3.33659983,-1.58892155,1.66474748>0.0117,rgbt<1.000,1.000,1.000,0.000>,1)
VMD_cylinder(<-2.66601706,-1.63572240,0.73443985>,<-2.70619965,-1.73397994,0.73064923>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.66601706,-1.63572240,0.73443985>,<-2.71719790,-1.58060074,0.80944502>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.66601706,-1.63572240,0.73443985>,<-2.55182600,-1.64427090,0.76701891>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.66601706,-1.63572240,0.73443985>,<-2.68761826,-1.58345151,0.62967873>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.76837826,-1.52547896,0.88444996>,<-2.71719790,-1.58060074,0.80944502>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.74638319,-1.83223736,0.72685862>,<-2.70619965,-1.73397994,0.73064923>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.43763590,-1.65281904,0.79959738>,<-2.43463755,-1.66265714,0.90532207>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.43763590,-1.65281904,0.79959738>,<-2.39784479,-1.74103403,0.75579584>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.43763590,-1.65281904,0.79959738>,<-2.36682224,-1.56199825,0.76941657>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.43763590,-1.65281904,0.79959738>,<-2.55182600,-1.64427090,0.76701891>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.43164015,-1.67249501,1.01104712>,<-2.43463755,-1.66265714,0.90532207>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.35805464,-1.82924914,0.71199429>,<-2.39784479,-1.74103403,0.75579584>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.29600859,-1.47117746,0.73923576>,<-2.33907604,-1.38211799,0.77793038>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.29600859,-1.47117746,0.73923576>,<-2.18334246,-1.47671294,0.77730799>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.29600859,-1.47117746,0.73923576>,<-2.29424858,-1.46516716,0.63319647>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.29600859,-1.47117746,0.73923576>,<-2.36682224,-1.56199825,0.76941657>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.29248810,-1.45915699,0.52715719>,<-2.29424858,-1.46516716,0.63319647>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.38214254,-1.29305816,0.81662476>,<-2.33907604,-1.38211799,0.77793038>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.07067585,-1.48224854,0.81537986>,<-2.06484938,-1.42961359,0.90746248>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.07067585,-1.48224854,0.81537986>,<-2.18334246,-1.47671294,0.77730799>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.07067585,-1.48224854,0.81537986>,<-2.00969076,-1.43291461,0.74375117>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.07067585,-1.48224854,0.81537986>,<-2.02573156,-1.59112167,0.83271813>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.94870520,-1.38358080,0.67212284>,<-2.00969076,-1.43291461,0.74375117>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.05902338,-1.37697887,0.99954522>,<-2.06484938,-1.42961359,0.90746248>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.98078728,-1.69999456,0.85005629>,<-2.00473452,-1.75131321,0.95477819>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.98078728,-1.69999456,0.85005629>,<-1.87520123,-1.69349635,0.84041178>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.98078728,-1.69999456,0.85005629>,<-2.02573156,-1.59112167,0.83271813>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.98078728,-1.69999456,0.85005629>,<-2.01839781,-1.76327193,0.77347326>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.05600882,-1.82654917,0.69689047>,<-2.01839781,-1.76327193,0.77347326>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.76961517,-1.68699789,0.83076727>,<-1.87520123,-1.69349635,0.84041178>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.02868176,-1.80263162,1.05950022>,<-2.02049875,-1.73315334,1.15583193>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.02868176,-1.80263162,1.05950022>,<-2.12776470,-1.84067595,1.05516219>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.02868176,-1.80263162,1.05950022>,<-2.00473452,-1.75131321,0.95477819>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.02868176,-1.80263162,1.05950022>,<-1.96130133,-1.88377738,1.07210743>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.22684813,-1.87872028,1.05082417>,<-2.12776470,-1.84067595,1.05516219>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.89392138,-1.96492279,1.08471429>,<-1.96130133,-1.88377738,1.07210743>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.01231527,-1.66367507,1.25216353>,<-2.11475945,-1.62325644,1.29738986>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.01231527,-1.66367507,1.25216353>,<-2.02049875,-1.73315334,1.15583193>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.01231527,-1.66367507,1.25216353>,<-1.95261717,-1.57960117,1.22663844>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.01231527,-1.66367507,1.25216353>,<-1.96285200,-1.71908092,1.32810569>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.91338921,-1.77448654,1.40404773>,<-1.96285200,-1.71908092,1.32810569>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.89291906,-1.49552727,1.20111334>,<-1.95261717,-1.57960117,1.22663844>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.21720362,-1.58283782,1.34261560>,<-2.19424105,-1.52577519,1.42921972>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.21720362,-1.58283782,1.34261560>,<-2.29777479,-1.66491961,1.37335098>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.21720362,-1.58283782,1.34261560>,<-2.26173544,-1.51902843,1.27030611>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.21720362,-1.58283782,1.34261560>,<-2.11475945,-1.62325644,1.29738986>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.17127943,-1.46871257,1.51582360>,<-2.19424105,-1.52577519,1.42921972>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.30626869,-1.45521867,1.19799614>,<-2.26173544,-1.51902843,1.27030611>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.37834597,-1.74700189,1.40408671>,<-2.29777479,-1.66491961,1.37335098>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.37834597,-1.74700189,1.40408671>,<-2.41187668,-1.74839258,1.51831281>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.37834597,-1.74700189,1.40408671>,<-2.33797932,-1.84247661,1.38087559>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.37834597,-1.74700189,1.40408671>,<-2.46512270,-1.73113883,1.34491110>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.55189943,-1.71527553,1.28573489>,<-2.46512270,-1.73113883,1.34491110>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.29761314,-1.93795133,1.35766411>,<-2.33797932,-1.84247661,1.38087559>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.44540596,-1.74978352,1.63253903>,<-2.38016796,-1.81534898,1.68477798>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.44540596,-1.74978352,1.63253903>,<-2.44504118,-1.64513493,1.68930674>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.44540596,-1.74978352,1.63253903>,<-2.54408503,-1.78885162,1.63698506>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.44540596,-1.74978352,1.63253903>,<-2.41187668,-1.74839258,1.51831281>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.64276361,-1.82791960,1.64143133>,<-2.54408503,-1.78885162,1.63698506>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.31493044,-1.88091433,1.73701668>,<-2.38016796,-1.81534898,1.68477798>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.44467688,-1.54048669,1.74607491>,<-2.51446772,-1.54656923,1.82592273>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.44467688,-1.54048669,1.74607491>,<-2.34754229,-1.52574611,1.78646481>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.44467688,-1.54048669,1.74607491>,<-2.44504118,-1.64513493,1.68930674>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.44467688,-1.54048669,1.74607491>,<-2.47202063,-1.44462597,1.68098402>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.58425951,-1.55265152,1.90577054>,<-2.51446772,-1.54656923,1.82592273>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.25040770,-1.51100564,1.82685554>,<-2.34754229,-1.52574611,1.78646481>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.49936485,-1.34876537,1.61589313>,<-2.51394987,-1.38063431,1.51561761>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.49936485,-1.34876537,1.61589313>,<-2.59602213,-1.28774273,1.64917207>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.49936485,-1.34876537,1.61589313>,<-2.47202063,-1.44462597,1.68098402>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.49936485,-1.34876537,1.61589313>,<-2.41638231,-1.28252971,1.61911094>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.33339930,-1.21629393,1.62232804>,<-2.41638231,-1.28252971,1.61911094>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.52853489,-1.41250336,1.41534185>,<-2.51394987,-1.38063431,1.51561761>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.69267988,-1.22672009,1.68245089>,<-2.69319916,-1.22198045,1.78856778>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.69267988,-1.22672009,1.68245089>,<-2.77809954,-1.28095651,1.65011668>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.69267988,-1.22672009,1.68245089>,<-2.59602213,-1.28774273,1.64917207>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.69267988,-1.22672009,1.68245089>,<-2.70223188,-1.11554265,1.64095032>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.86352015,-1.33519268,1.61778212>,<-2.77809954,-1.28095651,1.65011668>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.69371986,-1.21724033,1.89468408>,<-2.69319916,-1.22198045,1.78856778>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.71178389,-1.00436544,1.59945035>,<-2.66427422,-0.99819970,1.49046183>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.71178389,-1.00436544,1.59945035>,<-2.81202555,-0.97716808,1.59537303>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.71178389,-1.00436544,1.59945035>,<-2.70223188,-1.11554265,1.64095032>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.71178389,-1.00436544,1.59945035>,<-2.65869188,-0.93490887,1.66699922>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.91226578,-0.94997084,1.59129572>,<-2.81202555,-0.97716808,1.59537303>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.60559940,-0.86545241,1.73454845>,<-2.64233637,-0.87916160,1.83783615>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-2.60559940,-0.86545241,1.73454845>,<-2.65869188,-0.93490887,1.66699922>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-2.67907286,-0.89287102,1.94112408>,<-2.77814054,-0.92238533,1.95203090>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.67907286,-0.89287102,1.94112408>,<-2.64233637,-0.87916160,1.83783615>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.67907286,-0.89287102,1.94112408>,<-2.67958593,-0.78806412,1.99756455>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.67907286,-0.89287102,1.94112408>,<-2.61985016,-0.94995773,2.00467157>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.68009949,-0.68325698,2.05400467>,<-2.73142529,-0.68027675,2.16136813>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.68009949,-0.68325698,2.05400467>,<-2.67958593,-0.78806412,1.99756455>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.68009949,-0.68325698,2.05400467>,<-2.58976936,-0.63202941,2.05854893>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.68009949,-0.68325698,2.05400467>,<-2.74287748,-0.61156881,1.99809611>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.80565500,-0.53988111,1.94218791>,<-2.74287748,-0.61156881,1.99809611>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-2.80565500,-0.53988111,1.94218791>,<-2.74104548,-0.46581531,1.89173293>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-2.78275061,-0.67729688,2.26873207>,<-2.76212025,-0.58649313,2.31492376>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.78275061,-0.67729688,2.26873207>,<-2.88565159,-0.68802130,2.25868678>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.78275061,-0.67729688,2.26873207>,<-2.73142529,-0.68027675,2.16136813>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.78275061,-0.67729688,2.26873207>,<-2.74580336,-0.75474548,2.32739449>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.49943924,-0.58080208,2.06309342>,<-2.58976936,-0.63202941,2.05854893>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.87720823,-0.95189965,1.96293759>,<-2.77814054,-0.92238533,1.95203090>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.56062746,-1.00704432,2.06821918>,<-2.61985016,-0.94995773,2.00467157>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.74148989,-0.49568927,2.36111546>,<-2.76212025,-0.58649313,2.31492376>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.70885563,-0.83219373,2.38605690>,<-2.74580336,-0.75474548,2.32739449>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.98855257,-0.69874525,2.24864197>,<-2.88565159,-0.68802130,2.25868678>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.67643404,-0.39174974,1.84127808>,<-2.62388563,-0.32607484,1.90235150>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.67643404,-0.39174974,1.84127808>,<-2.74104548,-0.46581531,1.89173293>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.67643404,-0.39174974,1.84127808>,<-2.61237097,-0.42778981,1.76778340>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.67643404,-0.39174974,1.84127808>,<-2.74389791,-0.31637239,1.77853048>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.57133675,-0.26039982,1.96342456>,<-2.62388563,-0.32607484,1.90235150>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.54830790,-0.46382964,1.69428802>,<-2.61237097,-0.42778981,1.76778340>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.81136084,-0.24099517,1.71578300>,<-2.91396093,-0.25123549,1.72892988>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.81136084,-0.24099517,1.71578300>,<-2.74389791,-0.31637239,1.77853048>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.81136084,-0.24099517,1.71578300>,<-2.79204941,-0.10746455,1.75332785>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.81136084,-0.24099517,1.71578300>,<-2.79082489,-0.23672175,1.61397672>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.77028894,-0.23244834,1.51217020>,<-2.79082489,-0.23672175,1.61397672>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.01656055,-0.26147616,1.74207640>,<-2.91396093,-0.25123549,1.72892988>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.77273846,0.02606583,1.79087245>,<-2.75246191,0.16627264,1.83029509>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.77273846,0.02606583,1.79087245>,<-2.80612612,0.03481007,1.90072680>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.77273846,0.02606583,1.79087245>,<-2.79204941,-0.10746455,1.75332785>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.77273846,0.02606583,1.79087245>,<-2.66050053,0.04828548,1.77790439>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.77273846,0.02606583,1.79087245>,<-2.83786106,0.09002542,1.72067702>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.90298271,0.15398455,1.65048158>,<-2.83786106,0.09002542,1.72067702>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-2.54826307,0.07050514,1.76493609>,<-2.66050053,0.04828548,1.77790439>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-2.83951378,0.04355526,2.01058054>,<-2.80612612,0.03481007,1.90072680>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-2.73218632,0.30647922,1.86971772>,<-2.75246191,0.16627264,1.83029509>0.0117,rgbt<1.000,1.000,1.000,0.000>,1)
VMD_cylinder(<-2.61676359,-0.99203432,1.38147295>,<-2.66427422,-0.99819970,1.49046183>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.61676359,-0.99203432,1.38147295>,<-2.69167471,-1.02037561,1.31169760>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.61676359,-0.99203432,1.38147295>,<-2.53713751,-1.06218088,1.37669981>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.61676359,-0.99203432,1.38147295>,<-2.57403469,-0.88605809,1.34804642>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.45751143,-1.13232768,1.37192619>,<-2.53713751,-1.06218088,1.37669981>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.76658583,-1.04871666,1.24192131>,<-2.69167471,-1.02037561,1.31169760>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.53130674,-0.78008175,1.31462002>,<-2.47195435,-0.74237287,1.39423716>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.53130674,-0.78008175,1.31462002>,<-2.57403469,-0.88605809,1.34804642>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.53130674,-0.78008175,1.31462002>,<-2.61165857,-0.69686425,1.28647423>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.53130674,-0.78008175,1.31462002>,<-2.46921492,-0.79534554,1.22979558>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.41260147,-0.70466411,1.47385430>,<-2.47195435,-0.74237287,1.39423716>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.40712214,-0.81060946,1.14497161>,<-2.46921492,-0.79534554,1.22979558>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.69201088,-0.61364615,1.25832844>,<-2.61165857,-0.69686425,1.28647423>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.69201088,-0.61364615,1.25832844>,<-2.75370359,-0.59793842,1.34336281>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.69201088,-0.61364615,1.25832844>,<-2.64927340,-0.50787711,1.22426355>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.69201088,-0.61364615,1.25832844>,<-2.75176764,-0.65161407,1.17913723>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.81152391,-0.68958199,1.09994602>,<-2.75176764,-0.65161407,1.17913723>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.81539679,-0.58223081,1.42839742>,<-2.75370359,-0.59793842,1.34336281>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.60653639,-0.40210772,1.19019842>,<-2.53888798,-0.41867602,1.10999417>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.60653639,-0.40210772,1.19019842>,<-2.68650913,-0.32151651,1.15437305>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.60653639,-0.40210772,1.19019842>,<-2.64927340,-0.50787711,1.22426355>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.60653639,-0.40210772,1.19019842>,<-2.55310678,-0.36070716,1.27214277>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.49967670,-0.31930637,1.35408711>,<-2.55310678,-0.36070716,1.27214277>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.47123861,-0.43524468,1.02978992>,<-2.53888798,-0.41867602,1.10999417>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.76648140,-0.24092555,1.11854792>,<-2.73590422,-0.12654185,1.13101184>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.76648140,-0.24092555,1.11854792>,<-2.78626442,-0.25827456,1.01563478>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.76648140,-0.24092555,1.11854792>,<-2.68650913,-0.32151651,1.15437305>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.76648140,-0.24092555,1.11854792>,<-2.85577059,-0.25693035,1.17381740>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.80604839,-0.27562332,0.91272092>,<-2.78626442,-0.25827456,1.01563478>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.94506025,-0.27293539,1.22908688>,<-2.85577059,-0.25693035,1.17381740>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.70532799,-0.01215816,1.14347529>,<-2.73590422,-0.12654185,1.13101184>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.70532799,-0.01215816,1.14347529>,<-2.76682043,0.06663799,1.07879210>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.70532799,-0.01215816,1.14347529>,<-2.60282183,-0.00285602,1.11721694>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.70532799,-0.01215816,1.14347529>,<-2.71699095,0.01364565,1.24585581>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.72865295,0.03944921,1.34823620>,<-2.71699095,0.01364565,1.24585581>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.50031519,0.00644541,1.09095919>,<-2.60282183,-0.00285602,1.11721694>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.82831240,0.14543390,1.01410925>,<-2.76682043,0.06663799,1.07879210>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.82831240,0.14543390,1.01410925>,<-2.93111086,0.13432002,1.03845191>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.82831240,0.14543390,1.01410925>,<-2.81451702,0.12118626,0.91161299>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.82831240,0.14543390,1.01410925>,<-2.79959869,0.26005721,1.02863431>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.80072117,0.09693885,0.80911708>,<-2.81451702,0.12118626,0.91161299>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-3.03390932,0.12320566,1.06279492>,<-2.93111086,0.13432002,1.03845191>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.77088547,0.37468004,1.04315960>,<-2.83835745,0.41640067,1.11380327>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.77088547,0.37468004,1.04315960>,<-2.66019630,0.39739561,1.08065486>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.77088547,0.37468004,1.04315960>,<-2.79959869,0.26005721,1.02863431>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.77088547,0.37468004,1.04315960>,<-2.78430510,0.42363739,0.94984949>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.79772472,0.47259474,0.85653985>,<-2.78430510,0.42363739,0.94984949>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.90583086,0.45812130,1.18444705>,<-2.83835745,0.41640067,1.11380327>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.54950762,0.42011094,1.11815012>,<-2.48362637,0.35470748,1.06652141>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.54950762,0.42011094,1.11815012>,<-2.66019630,0.39739561,1.08065486>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.54950762,0.42011094,1.11815012>,<-2.52612162,0.52028728,1.09166384>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.54950762,0.42011094,1.11815012>,<-2.52929688,0.40758514,1.23480499>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.41774464,0.28930378,1.01489246>,<-2.48362637,0.35470748,1.06652141>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.50273609,0.62046432,1.06517708>,<-2.52612162,0.52028728,1.09166384>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.50908518,0.39505911,1.35145986>,<-2.59592867,0.42770195,1.40319300>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.50908518,0.39505911,1.35145986>,<-2.49434805,0.29169035,1.37098908>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.50908518,0.39505911,1.35145986>,<-2.41580343,0.45420933,1.39588273>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.50908518,0.39505911,1.35145986>,<-2.52929688,0.40758514,1.23480499>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.68277168,0.46034527,1.45492637>,<-2.59592867,0.42770195,1.40319300>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.47961140,0.18832159,1.39051819>,<-2.49434805,0.29169035,1.37098908>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.32252073,0.51335955,1.44030547>,<-2.32682323,0.61301565,1.40378511>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.32252073,0.51335955,1.44030547>,<-2.21478033,0.46972895,1.41457486>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.32252073,0.51335955,1.44030547>,<-2.41580343,0.45420933,1.39588273>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.32252073,0.51335955,1.44030547>,<-2.33249283,0.51511621,1.54604661>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.33112669,0.71267200,1.36726439>,<-2.32682323,0.61301565,1.40378511>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.34246540,0.51687312,1.65178728>,<-2.33249283,0.51511621,1.54604661>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.10703897,0.42609811,1.38884377>,<-2.21478033,0.46972895,1.41457486>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.10703897,0.42609811,1.38884377>,<-2.09866381,0.42042017,1.28310251>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.10703897,0.42609811,1.38884377>,<-2.03461313,0.49469137,1.42535710>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.10703897,0.42609811,1.38884377>,<-2.08119488,0.31871080,1.43327355>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.09028864,0.41474247,1.17736101>,<-2.09866381,0.42042017,1.28310251>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.96218729,0.56328464,1.46187043>,<-2.03461313,0.49469137,1.42535710>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.05535078,0.21132350,1.47770345>,<-2.01384354,0.15284395,1.39933980>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.05535078,0.21132350,1.47770345>,<-2.08119488,0.31871080,1.43327355>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.05535078,0.21132350,1.47770345>,<-2.14628410,0.16653323,1.50946164>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.05535078,0.21132350,1.47770345>,<-1.97942019,0.20860505,1.56936085>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.23721647,0.12174296,1.54121995>,<-2.14628410,0.16653323,1.50946164>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.97233629,0.09436512,1.32097650>,<-2.01384354,0.15284395,1.39933980>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.90348959,0.20588684,1.66101825>,<-1.94072008,0.27125621,1.74192977>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.90348959,0.20588684,1.66101825>,<-1.89345503,0.09429407,1.70126987>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.90348959,0.20588684,1.66101825>,<-1.81038666,0.24033356,1.63019514>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.90348959,0.20588684,1.66101825>,<-1.97942019,0.20860505,1.56936085>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.71728516,0.27478099,1.59937203>,<-1.81038666,0.24033356,1.63019514>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.97795153,0.33662558,1.82284069>,<-1.94072008,0.27125621,1.74192977>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-1.97795153,0.33662558,1.82284069>,<-1.89419222,0.36435652,1.88933396>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-1.81043386,0.39208722,1.95582724>,<-1.80538225,0.34340525,2.04752779>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.81043386,0.39208722,1.95582724>,<-1.89419222,0.36435652,1.88933396>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.81043386,0.39208722,1.95582724>,<-1.82256365,0.50541115,1.99019158>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.81043386,0.39208722,1.95582724>,<-1.71555328,0.39369178,1.91340387>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.83469248,0.61873507,2.02455616>,<-1.90042210,0.63716078,2.10294390>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.83469248,0.61873507,2.02455616>,<-1.82256365,0.50541115,1.99019158>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.83469248,0.61873507,2.02455616>,<-1.73937750,0.65471721,2.06729007>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.83469248,0.61873507,2.02455616>,<-1.85356236,0.69916582,1.93885374>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.64406204,0.69069910,2.11002350>,<-1.66146708,0.72849178,2.21236944>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-1.64406204,0.69069910,2.11002350>,<-1.73937750,0.65471721,2.06729007>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-1.87243176,0.77959657,1.85315144>,<-1.97283697,0.80645657,1.85179639>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.87243176,0.77959657,1.85315144>,<-1.84651518,0.73926139,1.76092350>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.87243176,0.77959657,1.85315144>,<-1.81460524,0.86409616,1.87105262>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.87243176,0.77959657,1.85315144>,<-1.85356236,0.69916582,1.93885374>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.96615267,0.65558648,2.18133116>,<-1.90042210,0.63716078,2.10294390>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.80033112,0.29472303,2.13922858>,<-1.80538225,0.34340525,2.04752779>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.62067461,0.39529657,1.87098038>,<-1.71555328,0.39369178,1.91340387>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.75677967,0.94859648,1.88895380>,<-1.81460524,0.86409616,1.87105262>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.07324219,0.83331633,1.85044110>,<-1.97283697,0.80645657,1.85179639>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.82059860,0.69892573,1.66869557>,<-1.84651518,0.73926139,1.76092350>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.67887211,0.76628399,2.31471491>,<-1.66146708,0.72849178,2.21236944>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.67887211,0.76628399,2.31471491>,<-1.72514153,0.70136023,2.38141251>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.67887211,0.76628399,2.31471491>,<-1.72285795,0.86008167,2.32319212>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.67887211,0.76628399,2.31471491>,<-1.57433367,0.78456068,2.36863875>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.76684380,0.95387912,2.33166933>,<-1.72285795,0.86008167,2.32319212>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.77140999,0.63643670,2.44811034>,<-1.72514153,0.70136023,2.38141251>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.46979475,0.80283737,2.42256236>,<-1.41660404,0.88599682,2.39000726>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.46979475,0.80283737,2.42256236>,<-1.40582848,0.72094345,2.42505836>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.46979475,0.80283737,2.42256236>,<-1.48382139,0.83090615,2.55904698>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.46979475,0.80283737,2.42256236>,<-1.57433367,0.78456068,2.36863875>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.34186172,0.63904953,2.42755413>,<-1.40582848,0.72094345,2.42505836>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.36341238,0.96915650,2.35745287>,<-1.41660404,0.88599682,2.39000726>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.49784708,0.85897470,2.69553161>,<-1.51053047,0.75782704,2.74908018>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.49784708,0.85897470,2.69553161>,<-1.51257324,0.88844681,2.83884072>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.49784708,0.85897470,2.69553161>,<-1.59115362,0.92558646,2.70629501>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.49784708,0.85897470,2.69553161>,<-1.48382139,0.83090615,2.55904698>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.49784708,0.85897470,2.69553161>,<-1.40182590,0.91346502,2.72824430>0.0117,rgbt<1.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.52321386,0.65667939,2.80262852>,<-1.51053047,0.75782704,2.74908018>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-1.68446064,0.99219823,2.71705842>,<-1.59115362,0.92558646,2.70629501>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-1.30580521,0.96795535,2.76095700>,<-1.40182590,0.91346502,2.72824430>0.0117,rgbt<1.000,0.000,0.000,0.000>,1)
VMD_cylinder(<-1.52730036,0.91791940,2.98214960>,<-1.51257324,0.88844681,2.83884072>0.0117,rgbt<1.000,1.000,1.000,0.000>,1)
VMD_cylinder(<-1.88342047,-0.01729846,1.74152207>,<-1.79049873,-0.02529001,1.79236937>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.88342047,-0.01729846,1.74152207>,<-1.96206093,-0.03401518,1.81094658>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.88342047,-0.01729846,1.74152207>,<-1.88785934,-0.10383892,1.65988314>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.88342047,-0.01729846,1.74152207>,<-1.89345503,0.09429407,1.70126987>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.69757795,-0.03328180,1.84321666>,<-1.79049873,-0.02529001,1.79236937>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.04070234,-0.05073214,1.88037145>,<-1.96206093,-0.03401518,1.81094658>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.89229822,-0.19038022,1.57824445>,<-1.88785934,-0.10383892,1.65988314>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.89229822,-0.19038022,1.57824445>,<-1.88997030,-0.30217111,1.61912584>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.89229822,-0.19038022,1.57824445>,<-1.98189974,-0.17797685,1.52255344>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.89229822,-0.19038022,1.57824445>,<-1.80937624,-0.17785859,1.51304746>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.07150126,-0.16557312,1.46686232>,<-1.98189974,-0.17797685,1.52255344>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.72645426,-0.16533685,1.44785058>,<-1.80937624,-0.17785859,1.51304746>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.88764143,-0.41396189,1.66000700>,<-1.99311113,-0.46543097,1.68002748>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.88764143,-0.41396189,1.66000700>,<-1.83354330,-0.41403103,1.75142360>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.88764143,-0.41396189,1.66000700>,<-1.88997030,-0.30217111,1.61912584>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.88764143,-0.41396189,1.66000700>,<-1.83536911,-0.47340465,1.58917034>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.78309727,-0.53284740,1.51833332>,<-1.83536911,-0.47340465,1.58917034>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.77944517,-0.41409981,1.84284055>,<-1.83354330,-0.41403103,1.75142360>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.09858131,-0.51689970,1.70004833>,<-2.13797760,-0.47638953,1.78999519>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.09858131,-0.51689970,1.70004833>,<-2.09873152,-0.63550723,1.71035314>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.09858131,-0.51689970,1.70004833>,<-1.99311113,-0.46543097,1.68002748>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.09858131,-0.51689970,1.70004833>,<-2.16310024,-0.49115562,1.61968565>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.17737293,-0.43587947,1.87994266>,<-2.13797760,-0.47638953,1.78999519>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.22761917,-0.46541154,1.53932309>,<-2.16310024,-0.49115562,1.61968565>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.09887981,-0.75411499,1.72065818>,<-2.17009830,-0.78020024,1.79502976>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.09887981,-0.75411499,1.72065818>,<-2.09873152,-0.63550723,1.71035314>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.09887981,-0.75411499,1.72065818>,<-1.99531937,-0.80504489,1.74990332>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.09887981,-0.75411499,1.72065818>,<-2.12999582,-0.79479861,1.62759781>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.24131632,-0.80628526,1.86940110>,<-2.17009830,-0.78020024,1.79502976>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-2.16111279,-0.83548200,1.53453767>,<-2.12999582,-0.79479861,1.62759781>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.89175844,-0.85597479,1.77914810>,<-1.91291046,-0.93872881,1.84229887>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.89175844,-0.85597479,1.77914810>,<-1.99531937,-0.80504489,1.74990332>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.89175844,-0.85597479,1.77914810>,<-1.82448339,-0.89512503,1.68906462>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.89175844,-0.85597479,1.77914810>,<-1.83481359,-0.78483808,1.83374166>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.77786827,-0.71370125,1.88833523>,<-1.83481359,-0.78483808,1.83374166>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.93406343,-1.02148271,1.90544951>,<-1.91291046,-0.93872881,1.84229887>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.75720787,-0.93427515,1.59898114>,<-1.82448339,-0.89512503,1.68906462>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.75720787,-0.93427515,1.59898114>,<-1.72385693,-1.04848218,1.60329211>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.75720787,-0.93427515,1.59898114>,<-1.66924810,-0.87480295,1.59585381>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.75720787,-0.93427515,1.59898114>,<-1.81169987,-0.91968298,1.50897372>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.86619186,-0.90509081,1.41896665>,<-1.81169987,-0.91968298,1.50897372>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.58128834,-0.81533098,1.59272707>,<-1.66924810,-0.87480295,1.59585381>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.69050598,-1.16268837,1.60760343>,<-1.75956774,-1.23584950,1.67125702>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.69050598,-1.16268837,1.60760343>,<-1.68734789,-1.19942129,1.50798261>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.69050598,-1.16268837,1.60760343>,<-1.59261227,-1.16644478,1.64866817>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.69050598,-1.16268837,1.60760343>,<-1.72385693,-1.04848218,1.60329211>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.68419027,-1.23615408,1.40836203>,<-1.68734789,-1.19942129,1.50798261>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.49471807,-1.17020071,1.68973279>,<-1.59261227,-1.16644478,1.64866817>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.82862902,-1.30901027,1.73491061>,<-1.92798567,-1.27165639,1.73085833>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.82862902,-1.30901027,1.73491061>,<-1.79964352,-1.32313395,1.84951603>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.82862902,-1.30901027,1.73491061>,<-1.75956774,-1.23584950,1.67125702>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.82862902,-1.30901027,1.73491061>,<-1.82601118,-1.40461278,1.68868208>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-2.02734280,-1.23430228,1.72680581>,<-1.92798567,-1.27165639,1.73085833>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.82339334,-1.50021529,1.64245319>,<-1.82601118,-1.40461278,1.68868208>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.77065802,-1.33725739,1.96412134>,<-1.72413206,-1.24253511,2.01923037>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.77065802,-1.33725739,1.96412134>,<-1.70007086,-1.41639674,1.97029185>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.77065802,-1.33725739,1.96412134>,<-1.85855627,-1.36551940,2.01664495>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.77065802,-1.33725739,1.96412134>,<-1.79964352,-1.32313395,1.84951603>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.94645405,-1.39378154,2.06916881>,<-1.85855627,-1.36551940,2.01664495>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.62948370,-1.49553597,1.97646213>,<-1.70007086,-1.41639674,1.97029185>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.67760658,-1.14781296,2.07433891>,<-1.75581121,-1.09951007,2.12758017>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.67760658,-1.14781296,2.07433891>,<-1.72413206,-1.24253511,2.01923037>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.67760658,-1.14781296,2.07433891>,<-1.64087296,-1.08162999,1.99981332>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.67760658,-1.14781296,2.07433891>,<-1.58904791,-1.16912711,2.15102386>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.60413885,-1.01544702,1.92528760>,<-1.64087296,-1.08162999,1.99981332>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.83401585,-1.05120718,2.18082094>,<-1.75581121,-1.09951007,2.12758017>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.50048876,-1.19044161,2.22770882>,<-1.52714682,-1.15752661,2.32377195>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.50048876,-1.19044161,2.22770882>,<-1.48019457,-1.29336774,2.23179340>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.50048876,-1.19044161,2.22770882>,<-1.58904791,-1.16912711,2.15102386>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.50048876,-1.19044161,2.22770882>,<-1.41357994,-1.13985968,2.19752955>0.0117,rgbt<0.250,0.750,0.750,0.000>,1)
VMD_cylinder(<-1.45990086,-1.39629400,2.23587799>,<-1.48019457,-1.29336774,2.23179340>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.55380487,-1.12461138,2.41983509>,<-1.52714682,-1.15752661,2.32377195>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
VMD_cylinder(<-1.32667065,-1.08927763,2.16735077>,<-1.41357994,-1.13985968,2.19752955>0.0117,rgbt<0.000,1.000,0.000,0.000>,1)
// End of POV-Ray 3.x generation 
