#!/usr/bin/perl
while (<>) {
	if (/^VMD_sphere\((<[^>]*>),([0-9.]+),(rgbt<[0-9.,]*>)\)$/) {
		$coords=$1;
		$radius=$2;
		$colour=$3;
		if ($colour eq 'rgbt<0.250,0.750,0.750,0.000>') { # Carbon
			$colour = 'rgbt<0.200,0.200,0.200,0.000>';
			$radius = '0.1105';
			$radius = '0.0555';
		}
		if ($colour eq 'rgbt<0.000,1.000,0.000,0.000>') { # Fluor
			$colour = 'rgbt<0.900,0.900,0.600,0.000>';
			$radius = '0.0663';
			$radius = '0.0333';
		} 
		if ($colour eq 'rgbt<1.000,1.000,1.000,0.000>') { # Hydrogen
			$colour = 'rgbt<0.800,0.800,0.800,0.000>';
			$radius = '0.0331';
			$radius = '0.0166';
		}
		if ($colour eq 'rgbt<1.000,0.000,0.000,0.000>') { # Oxygen
			$colour = 'rgbt<0.900,0.100,0.100,0.000>';
			$radius = '0.1437';
			$radius = '0.0722';
		}
		if ($colour eq 'rgbt<1.000,1.000,0.000,0.000>') { # Sulfur
			$colour = 'rgbt<0.900,0.900,0.000,0.000>';
			$radius = '0.1437';
			$radius = '0.0722';
		}
		if (($colour eq 'rgbt<0.000,0.000,1.000,0.000>') or 
		    ($colour eq 'rgbt<1.000,0.600,0.600,0.000>')) { # Lithium
			$colour = 'rgbt<0.300,0.300,0.800,0.000>';
			$radius = '0.1437';
			$radius = '0.0722';
		}
		$_="VMD_sphere($coords,$radius,$colour)\n";
	};
	if (/^VMD_cylinder\((<[^>]*>,<[^>]*>)([0-9.]+),(rgbt<[0-9.,]*>),1\)$/) {
		$coords=$1;
		$radius=$2;
		$colour=$3;
		$colour='rgbt<0.500,0.500,0.500,0.000>';
		$_="VMD_cylinder(".$coords.$radius.",".$colour.",1)\n";
	}
	if (/^VMD_line/) {
	
		s/rgbt<[^>]*>/rgbt<0.500,0.500,0.500,0.000>/g;
	}
	print;
}
