set terminal png
set output "fluid_dynamics_x1_bessel.png"
set title "Approaching tsunami"
set xlabel "Distance from the shore [m]"
set ylabel "Wave fluctuation [m]"
set style line 1 lt 1 lw 3 pt 5
set style line 2 lt 3 lw 1
arg=1
plot [0.01:500] 10*besj0(arg*sqrt(x)) + 0*besy0(arg*sqrt(x))\
ls 1 title "10*J0 + 0*Y0", \
10*besj0(arg*sqrt(x)) + 3*besy0(arg*sqrt(x)) \
ls 2 title "10*J0 + 3*Y0"
