#include "worklist.h"


//========== constructor WORKLIST ==========

WORKLIST::WORKLIST()
{
	memsize=_WORKLIST_MAX_SIZE;
	begin=memsize-1;
	end=0;
	size=0;
	unit=new UNIT*[memsize];
}

//========== destructor ~WORKLIST ==========

WORKLIST::~WORKLIST()
{
	delete unit;
}

//========== method takeout ==========

inline UNIT *WORKLIST::takeout()
{
assert(size>0);
size--;
begin++;
if (begin>=memsize)
	begin=0;
return unit[begin];
}


//========== method insert ==========

inline int WORKLIST::insert(UNIT *_unit)
{
assert(size<memsize);
size++;
unit[end]=_unit;
end++;
if (end>=memsize)
	end=0;
return 0;
}

//========== method is_empty ==========

inline bool WORKLIST::is_empty()
{
return (size==0);
}

