#ifndef _VDWRECORD_H_DEFINE
#define _VDWRECORD_H_DEFINE

#include <assert.h>
#include "sysutils.h"
#include <math.h>

typedef enum{
BUCK=0,
DIBU=1,
NM=2,
LJ=3,
V126=4,
DI12=5,
EMPTY=99
} VDWKEY;

class VDWRECORD //! One line from the VDW-file
{
private:

VDWKEY vdwkey;
int argnr;
double *arg;

public:

VDWRECORD();
~VDWRECORD();
int set_vdwkey(VDWKEY _vdwkey);
const char *get_vdwkey_str();
VDWKEY get_vdwkey();
int set_argnr(int _argnr);
int set_arg(int _index, double _argX);
double get_arg(int _index);
int get_argnr();
double vdw_energy(double r);

};

#endif
