#include "vdwrecord.h"

VDWRECORD::VDWRECORD()
{
vdwkey=EMPTY;
argnr=0;
}

VDWRECORD::~VDWRECORD()
{
delete [] arg;
}

int VDWRECORD::set_vdwkey(VDWKEY _vdwkey)
{
//logfile.print("set_vwkey(%d)\n",_vdwkey);
vdwkey=_vdwkey;
return 0;
}

VDWKEY VDWRECORD::get_vdwkey()
{
return vdwkey;
}

const char *VDWRECORD::get_vdwkey_str()
{
switch(vdwkey)
{
case BUCK:  return "buck";
case DIBU:  return "dibu";
case NM:    return "nm";
case LJ:    return "lj";
case V126:    return "12-6";
case DI12:    return "di12";
case EMPTY: return "empt";
default:    return "????";
}
}

int VDWRECORD::set_argnr(int _argnr)
{
SYSUTILS tmp;

assert(argnr==0);
argnr=_argnr;
if (argnr<0)
	assert(false);
arg=tmp.allocate_double(argnr,(char*)"VDWRECORD",(char*)"ARGs array",_SYSUTILS_MEMERR);
return 0;
}

int VDWRECORD::set_arg(int _index, double _argX)
{
assert(_index>=1);
assert(_index<=argnr);
arg[_index-1]=_argX;
return 0;
}

double VDWRECORD::get_arg(int _index)
{
assert(_index>=1);
if(_index>argnr)
	return 0;
return arg[_index-1];
}

int VDWRECORD::get_argnr()
{
return argnr;
}

double VDWRECORD::vdw_energy(double r)
{
//logfile.print("vdwkey=%d\n",vdwkey);
if(vdwkey==BUCK) //Buckingham (buck)
{
	assert(argnr==3);
	if(r==0.0 || arg[1]==0.0)
		return 0.0;
	else
		return arg[0]*exp(-r/arg[1])-(arg[2]/pow(r,6));
}
else if(vdwkey==DIBU) //Buckingham + polarization (dibu)
{
	assert(argnr==4);
	if(r==0.0 || arg[1]==0.0)
		return 0.0;
	else
		return arg[0]*exp(-r/arg[1])-(arg[2]/pow(r,6))-(arg[3]/pow(r,4));
}
else if(vdwkey==NM) //General n-m potential (nm)
{
	assert(argnr==4);
	if(r==0.0 || (arg[1]-arg[2])==0.0)
		return 0.0;
	else
		return arg[0]/(arg[1]-arg[2])*(arg[2]*pow((arg[3]/r),arg[1])-arg[1]*pow((arg[3]/r),arg[2]));
}
else if(vdwkey==LJ) //Lennard-Jones (lj)
{
	assert(argnr==2);
	if(r==0.0)
		return 0.0;
	else
		return 4.0*arg[0]*(pow(arg[1]/r,12)-pow(arg[1]/r,6));
}
else if(vdwkey==V126) //12-6 (12-6)
{
	assert(argnr==2);
	if(r==0.0)
		return 0.0;
	else
		return arg[0]/pow(r,12)-arg[1]/pow(r,6);
}
else if(vdwkey==DI12) //12-6-4 (di12)
{
	assert(argnr==3);
	if(r==0.0)
		return 0.0;
	else
		return arg[0]/pow(r,12)-arg[1]/pow(r,6)-arg[2]/pow(r,4);
}
else if(vdwkey==EMPTY)
	return 0;
else
	throw "Unknown VDW key";
};

