#ifndef _VDW_H_DEFINE
#define _VDW_H_DEFINE

#include <string>
#include "sysutils.h"
#include "vdwrecord.h"

class VDW:SYSUTILS //! Reads and stores the VDW-file
{
private:

int vdwnr;
string inputFileName;
FILE *file;
unsigned int nr_atomdefs, arraysize;
VDWRECORD *vdwarray;

int read_next(string _codeword);

public:

VDW (string _inputfilename, unsigned int _nr_atomdefs);
VDWRECORD *find(unsigned int _atom1, unsigned int _atom2);
VDWRECORD *find(const string _atom1, const string _atom2);
int get_nr_atomdefs();
};

#endif
