#include "vdw.h"
#include "mcgen.h"

VDW::VDW (string _inputfilename, unsigned int _nr_atomdefs)
{
int i, j;
string atom1, atom2;
nr_atomdefs=_nr_atomdefs;
arraysize=nr_atomdefs*nr_atomdefs;
//logfile.print("nr_atomdefs=%d\n",nr_atomdefs);
vdwarray=new VDWRECORD[arraysize];
allocate_error(vdwarray,"VDW","VDWRECORDs array",_SYSUTILS_MEMERR);

inputFileName=_inputfilename;
file=open_file(inputFileName,"r");
read_next("VDW");
vdwnr=read_lineint(2);
for (i=0;i<vdwnr;i++)
{
	nextfilerecord(file);
	atom1=SYSU_read_linestring(1);
	atom2=SYSU_read_linestring(2);
	logfile.print("VDW: atom1=%s, atom2=%s\n",atom1.c_str(),atom2.c_str());
	VDWRECORD *thisrecord=find(atom1,atom2);
	if (!test_string(3,(char*)"buck"))
		thisrecord->set_vdwkey(BUCK);
	else if (!test_string(3,(char*)"dibu"))
		thisrecord->set_vdwkey(DIBU);
	else if (!test_string(3,(char*)"nm"))
		thisrecord->set_vdwkey(NM);
	else if (!test_string(3,(char*)"lj"))
		thisrecord->set_vdwkey(LJ);
	else if (!test_string(3,(char*)"12-6"))
		thisrecord->set_vdwkey(V126);
	else if (!test_string(3,(char*)"di12"))
		thisrecord->set_vdwkey(DI12);
	else
		assert(false);
	int argnr=read_lineint(4);
	thisrecord->set_argnr(argnr);
	for (j=1;j<=argnr;j++)
		thisrecord->set_arg(j,read_linedouble(4+j));
}
read_next("CLOSE\n");
close_file(file);
}

int VDW::read_next(string _codeword)
{
nextfilerecord(file);
test_filelinestringlnr(1,_codeword,"IOERROR:",inputFileName,_SYSUTILS_IOERR);
	return 0;
}

VDWRECORD *VDW::find(unsigned int _atom1, unsigned int _atom2)
{
assert (_atom1>=1);
assert (_atom2>=1);
assert (_atom1<=nr_atomdefs);
assert (_atom2<=nr_atomdefs);
if (_atom1>_atom2)
	return &vdwarray[(_atom2-1)*nr_atomdefs+_atom1-1];
else
	return &vdwarray[(_atom1-1)*nr_atomdefs+_atom2-1];
}

VDWRECORD *VDW::find(const string _atom1, const string _atom2)
{
unsigned int a1 = defs->get_atomarg(_atom1)->get_id();
unsigned int a2 = defs->get_atomarg(_atom2)->get_id();
return find(a1,a2);
}

int VDW::get_nr_atomdefs()
{
return nr_atomdefs;
}

