#include "units.h"

//========== constructor UNITS ==========
UNITS::UNITS(string _inputfilename, DEFS *_defs)
{
int unitid;

defs=_defs;

inputFileName=_inputfilename;
file=open_file(inputFileName,"r");

read_next("UNITS\n");

read_next("BEGINUNITS");
beginunitsnr=read_lineint(2);
beginunit=new UNITDEF[beginunitsnr];
allocate_error(beginunit,"UNITS","BEGINUNITS array",_SYSUTILS_MEMERR);

for (unitid=1;unitid<=beginunitsnr;unitid++)
	read_unitdef(BEGIN, unitid);

read_next("REPEATUNITS");
repeatunitsnr=read_lineint(2);
repeatunit=new UNITDEF[repeatunitsnr];
allocate_error(repeatunit,"UNITS","REPEATUNITS array",_SYSUTILS_MEMERR);

for (unitid=1;unitid<=repeatunitsnr;unitid++)
	read_unitdef(REPEAT, unitid);

read_next("CROSSUNITS");
crossunitsnr=read_lineint(2);
crossunit=new UNITDEF[crossunitsnr];
allocate_error(crossunit,"UNITS","CROSSUNITS array",_SYSUTILS_MEMERR);

for (unitid=1;unitid<=crossunitsnr;unitid++)
	read_unitdef(CROSS, unitid);

read_next("ENDUNITS");
endunitsnr=read_lineint(2);
endunit=new UNITDEF[endunitsnr];
allocate_error(endunit,"UNITS","ENDUNITS array",_SYSUTILS_MEMERR);

for (unitid=1;unitid<=endunitsnr;unitid++)
	read_unitdef(END, unitid);

read_next("CLOSE\n");
close_file(file);
//filename=0;
}

//========== destructor UNITS ==========

UNITS::~UNITS()
{
delete [] beginunit;
delete [] repeatunit;
delete [] crossunit;
delete [] endunit;
}

//========== method read_next ==========

int UNITS::read_next(const string _codeword)
{

string tmpString=_codeword;
	
nextfilerecord(file);
test_filelinestringlnr(1,tmpString,"IOERROR:",inputFileName,_SYSUTILS_IOERR);
return 0;
}

                        

//========== method unittype2unitptr ==========

UNITDEF *UNITS::unittype2unitptr(Unittype _unittype)
{
switch (_unittype) {
	case BEGIN:
		return beginunit;
	case REPEAT:
		return repeatunit;
	case CROSS:
		return crossunit;
	case END:
		return endunit;
	default:
		assert(false);
}
}


//========== method unittype2unitnr ==========

int UNITS::unittype2unitnr(Unittype _unittype)
{
switch (_unittype) {
	case BEGIN:
		return beginunitsnr;
	case REPEAT:
		return repeatunitsnr;
	case CROSS:
		return crossunitsnr;
	case END:
		return endunitsnr;
	default:
		assert(false);
}
}


//========== method read_unitdef ==========

int UNITS::read_unitdef(Unittype _unittype, int _unitid)
{
char inp1[_SYSUTILS_INPROW_LEN];
int id;
int atomid;
UNITDEF *thisunit;

thisunit=get_unitdef(_unittype, _unitid);

read_next("UNIT");
id=read_lineint(2);

if (id != _unitid)
{
	logfile.print("Error: unitid %d found where %d expected in %s.\n",id,_unitid,inputFileName.c_str());
	exit(1);
}
thisunit->set_unitid(_unitid);
thisunit->set_unittype(_unittype);

thisunit->set_atomnr(read_lineint(3));

if (_unittype == BEGIN)
{
	read_linestring(inp1,4);
	thisunit->set_genmeth(inp1);
}
else
	thisunit->set_genmeth(RANDOM);

if ((_unittype == REPEAT) || (_unittype == CROSS))
{
	read_next("BACKBONE");
	thisunit->set_backbone(read_lineint(2));
}

for (atomid=1;atomid<=thisunit->get_backbone();atomid++)
	read_atomdef (thisunit, atomid);

if ((_unittype == REPEAT) || (_unittype == CROSS))
{
	read_next("HYDROGENS");
	thisunit->set_hydrogens(read_lineint(2));
}

for (atomid=thisunit->get_backbone()+1;atomid<=thisunit->get_atomnr();atomid++)
{
	assert(thisunit->get_genmeth()==RANDOM);
	read_atomdef (thisunit, atomid);
}

return 0;

}

//========== method read_atomdef ==========

int UNITS::read_atomdef (UNITDEF *_thisunit, int _atomid)
{
int atomid_t;
char method_str[_SYSUTILS_INPROW_LEN];
string atomtype;
ATOMDEF *thisatom;

assert(_atomid>=1);
assert(_atomid<=_thisunit->get_atomnr());
thisatom=_thisunit->get_atom(_atomid);

read_next("ATOM");
atomid_t=read_lineint(2);

if (atomid_t!=_atomid)
	logfile.print("Error: atomid %d found where %d expected in %s.\n",
		atomid_t,_atomid,inputFileName.c_str());

thisatom->set_defs(defs);
atomtype=SYSU_read_linestring(3);
thisatom->set_atomarg(defs->get_atomarg(atomtype));
	
if (_thisunit->get_genmeth() == COORDS)
{
	thisatom->set_xcoord(read_linedouble(4));
	thisatom->set_ycoord(read_linedouble(5));
	thisatom->set_zcoord(read_linedouble(6));
	thisatom->set_has_coords(true);
}
else    // genmeth == RANDOM
{
	thisatom->set_constid(SYSU_read_linestring(4));
	thisatom->set_cangid(SYSU_read_linestring(5));
	thisatom->set_cdihid(SYSU_read_linestring(6));
	read_linestring(method_str,7);
	thisatom->set_method(method_str);
	thisatom->set_unitXid(1,read_lineint(8));
	thisatom->set_atomXid(1,read_lineint(9));
	thisatom->set_unitXid(2,read_lineint(10));
	thisatom->set_atomXid(2,read_lineint(11));
	thisatom->set_unitXid(3,read_lineint(12));
	thisatom->set_atomXid(3,read_lineint(13));
	thisatom->set_has_coords(false);
}
return 0;
}


//========== method get_unitdef ==========

UNITDEF *UNITS::get_unitdef(Unittype _unittype, int _unitid)
{
int unitnr=unittype2unitnr(_unittype);
if ((_unitid<1) or (_unitid>unitnr))
{
	ostringstream message;
	message<<"Bad unit identificator: "<<
		UNITDEF::unittype2str(_unittype)<<" "<<_unitid<<
		" not in range [1,"<<unitnr<<"]";
	throw message.str();
}
//assert(_unitid>=1);
//assert(_unitid<=unitnr);
UNITDEF *unitarr=unittype2unitptr(_unittype);
UNITDEF *thisunit=&unitarr[_unitid-1];
return thisunit;
}
