#ifndef _UNITID_
#define _UNITID_

#include <string>
#include <vector>
#include <list>

using namespace std;

class UNITDEF;

//typedef long Ctype;
//typedef vector<Ctype*> Ltype;
//typedef vector<Ltype*> Mtype;
typedef enum{M,L,C,U} IncWhat;

class UNITID //! Gives every unit a unique identifying string
{
private:

long int M, L, C, U;
string str;
static list<UNITID> instances;

bool not_unique();
// returns true if an equal id alread exists.

void set_values(long _M, long _L, long _C, long _U, UNITDEF *_unitdef);
// sets given values to the id.

bool equals(const UNITID &_other);
// returns true if two id's are identical.

void refresh_str(UNITDEF *_unitdef);

public:

UNITID();
// simple constructor

UNITID(const UNITID &_original);
// copy constructor

void gen_unique(int _molid, UNITID *_previous,
		bool _is_sidechain, bool _chain_continues, UNITDEF *_unitdef);
// generate a new unique id.
// Parameters:
// 	_molid = molecule id
// 	_previous = pointer to previous unit's unitid 
// 		    or 0 if there is no previous unit.
//      _is_sidechain = true if this unit begins a sidechain
//      _chain_continues = true if this unit has the same chain id as
//                         the previous unit.
//      _unitdef = unitdef of the unit to be labeled.

const string to_str();
// Converts the identification structure into a string
// in format "[MxxLxxCxxxUxxxxXxx]".

const char *to_c_str();
// same as to_str(), but gives a C-style string.

};

#endif
