#include "unitid.h"
#include "unitdef.h"

list<UNITID> UNITID::instances;

//=========== constructor UNITID ==========

UNITID::UNITID()
{
M=L=C=U=0;
str="[no_name]";
}

//=========== copy constructor UNITID ==========

UNITID::UNITID(const UNITID &_original)
{
M=_original.M;
L=_original.L;
C=_original.C;
U=_original.U;
}

//========== method refresh_str =========

void UNITID::refresh_str(UNITDEF *_unitdef)
{
assert(_unitdef);

ostringstream ss;
ss<<"[M"<<setfill('0')<<setw(2)<<M;
ss<<"L"<<setw(2)<<L;
ss<<"C"<<setw(3)<<C;
ss<<"U"<<setw(4)<<U;
ss<<setw(1)<<_unitdef->get_unittype_char()<<setw(2)<<_unitdef->get_unitid();
ss<<"]";
//char name[40];
//snprintf(name,30,"[M%02ldL%02ldC%03ldU%04ld%c%02d]",M,L,C,U,
//		_unitdef->get_unittype_char(),_unitdef->get_unitid());
//str=name;
str=ss.str();
// in format "[MxxLxxCxxxUxxxxXxx]".
}

//=========== method set_values ==========

void UNITID::set_values(long _M, long _L, long _C, long _U, UNITDEF *_unitdef)
{
M=_M;
L=_L;
C=_C;
U=_U;

instances.push_back(*this);

refresh_str(_unitdef);
}

//=========== method gen_unique ==========

void UNITID::gen_unique(int _molid, UNITID *_previous,
		bool _is_sidechain, bool _chain_continues, UNITDEF *_unitdef)
{
bool prev_exists = (_previous != 0) and (_previous->U != 0);
M=_molid;
L=1;
C=1;
U=1;

if (prev_exists)
	L=_previous->L;

if (_is_sidechain)
{
	assert(prev_exists);
	L++;
}

if (_chain_continues)
{
	assert(prev_exists);
	C=_previous->C;
}
else
{
	while (not_unique())
		C++;
}

while (not_unique())
	U++;

instances.push_back(*this);

refresh_str(_unitdef);
}

//========== method not_unique ==========

bool UNITID::not_unique()
{
list<UNITID>::iterator i;
for (i=instances.begin(); i!=instances.end(); ++i)
	if (equals(*i))
		return true;
return false;
}

//========== method equals ==========

bool UNITID::equals(const UNITID &_other)
{
return (M==_other.M) and (L==_other.L) and (C==_other.C) and (U==_other.U);
}

//========== method to_str ==========

const string UNITID::to_str()
{
return str;
}

//========== method to_c_str ==========

const char *UNITID::to_c_str()
{
return str.c_str();
}

