#ifndef _UNITDEF_H_DEFINE
#define _UNITDEF_H_DEFINE

#include <assert.h>

class UNITDEF;
typedef enum{INVALID=0,BEGIN,REPEAT,CROSS,END} Unittype;

#include "atomdef.h"
#include "sysutils.h"
#include "logfile.h"
#include "unit.h"

class UNITDEF //! One Unit block from the UNITS-file
{
private:
   
Unittype unittype;
int unitid;
int atomnr;
int backbone, hydrogens;
Genmeth genmeth;
ATOMDEF *atom; // array of ATOMDEFs

public:


UNITDEF();
~UNITDEF();
int set_unittype(Unittype _unittype);
int set_unitid(int _unitid);
int set_atomnr(int _atomnr);
// set_atomnr also allocates memory for array atom[atomnr].
int set_backbone(int _backbone);
int set_hydrogens(int _hydrogens);
int set_genmeth(Genmeth _genmeth);
int set_genmeth(char *_genmeth);
Unittype get_unittype();
const string get_unittype_str();
static const string unittype2str(Unittype _unittype);
static Unittype str2unittype(const string _unittype);
char get_unittype_char();
string get_unittype_string();
int get_unitclass();
int get_unitid();
int get_atomnr();
int get_backbone();
int get_hydrogens();
Genmeth get_genmeth();
ATOMDEF *get_atom(int atomid);
};

#endif
