#include "unitdef.h"

//========== constructor UNITDEF ==========

UNITDEF::UNITDEF()
{
	atomnr=0;
	backbone=0;
	hydrogens=0;
	genmeth=RANDOM;
	atom=0; // NULL pointer
}

//========== destructor ~UNITDEF ==========

UNITDEF::~UNITDEF()
{
	delete [] atom;
}

//========== method set_unittype ==========

int UNITDEF::set_unittype(Unittype _unittype)
{
unittype=_unittype;
return 0;
}

//========== method set_unitid ==========

int UNITDEF::set_unitid(int _unitid)
{
unitid=_unitid;
return 0;
}

//========== method set_atomnr ==========

int UNITDEF::set_atomnr(int _atomnr)
{
SYSUTILS tmp;

assert(atomnr==0);
assert(_atomnr>=0);
atomnr=_atomnr;
assert(backbone==0);
backbone=_atomnr;
assert(hydrogens==0);
atom=new ATOMDEF[atomnr];
tmp.allocate_error(atom,"UNITDEF","ATOMDEFs array",_SYSUTILS_MEMERR);
return 0;
}

//========== method set_backbone ==========

int UNITDEF::set_backbone(int _backbone)
{
if (atomnr < backbone)
{
	logfile.print("Error: atomnr %d is smaller than backbone=%d.\n",
			atomnr,_backbone);
	exit(1);
}
backbone=_backbone;
assert(hydrogens==0);
hydrogens=atomnr-backbone;
return 0;
}

//========== method set_hydrogens ==========

int UNITDEF::set_hydrogens(int _hydrogens)
{
if (atomnr != (backbone+_hydrogens))
{
	logfile.print("Error: atomnr=%d does isn't equal with the sum of backbone=%d and hydrogens=%d.\n",atomnr,backbone,_hydrogens);
	exit(1);
}
hydrogens=_hydrogens;
return 0;
}

//========== method set_genmeth ==========

int UNITDEF::set_genmeth(Genmeth _genmeth)
{
genmeth=_genmeth;
return 0;
}

//========== method set_genmeth ==========

int UNITDEF::set_genmeth(char *_genmeth)
{
if (strcmp(_genmeth,"coords\n")==0)
	set_genmeth(COORDS);
else if (strcmp(_genmeth,"random\n")==0)
	set_genmeth(RANDOM);
else
{
	logfile.print("Error: unknown connection mode '%s'.\n",_genmeth);
	exit(1);
}
return 0;
}

//========== method get_unittype ==========

Unittype UNITDEF::get_unittype()
{
if (this)
	return unittype;
else
	return INVALID;
}

//========== method get_unittype_str ==========

const string UNITDEF::get_unittype_str()
{
return unittype2str(unittype);
}

//========== static method unittype2str ==========

const string UNITDEF::unittype2str(Unittype _unittype)
{
switch (_unittype) {
	case BEGIN:
		return "beginunit";
	case REPEAT:
		return "repeatunit";
        case CROSS:
		return "crossunit";
        case END:
		return "endunit";
	default:
		return "invalidunit";
}
}

//========== static method str2unittype ==========

Unittype UNITDEF::str2unittype(const string _unittype)
{
if (_unittype==string("beginunit"))
		return BEGIN;
else if (_unittype=="repeatunit")
	return REPEAT;
else if (_unittype=="crossunit")
	return CROSS;
else if (_unittype=="endunit")
	return END;
else
	return INVALID;
}

//========== method get_unittype_char ==========

char UNITDEF::get_unittype_char()
{
switch (unittype) {
	case BEGIN:
		return 'B';
	case REPEAT:
		return 'R';
        case CROSS:
		return 'C';
        case END:
		return 'E';
	default:
		return 'I';
}
}

//========== method get_unittype_string ==========

string UNITDEF::get_unittype_string()
{
if (this)
{
	ostringstream str;
        str << get_unittype_char() << get_unitid();
	return str.str();
}
else
{
	return "NONE";
}
}

//========== method get_unitclass ==========

int UNITDEF::get_unitclass()
{
switch (unittype) {
	case BEGIN:
		return UC_BEGIN;
	case REPEAT:
		return UC_REPEAT;
        case CROSS:
		return UC_CROSS;
        case END:
		return UC_END;
	default:
		return UC_EMPTY;
}
}

//========== method get_unitid ==========

int UNITDEF::get_unitid()
{
return unitid;
}

//========== method get_atomnr ==========

int UNITDEF::get_atomnr()
{
return atomnr;
}

//========== method get_backbone ==========

int UNITDEF::get_backbone()
{
return backbone;
}

//========== method get_hydrogens ==========

int UNITDEF::get_hydrogens()
{
return hydrogens;
}

//========== method get_genmeth ==========

Genmeth UNITDEF::get_genmeth()
{
return genmeth;
}

//========== method get_atom ==========

ATOMDEF *UNITDEF::get_atom(int atomid)
{
return &atom[atomid-1];
}

