#include "readxyz.h"
#include "textfile.h"
#include "params.h"
#include "mcgen.h"

READXYZ::READXYZ(const string _filename)
{
char tempstr[_SYSUTILS_INPROW_LEN];
TEXTFILE xyzfile(_filename);
xyzfile.read_next();

clear();

size_t atoms=(xyzfile.read_lineint(1));
reserve(atoms);
xyzfile.read_next();
for (size_t i=0; i<atoms; ++i)
{
	READXYZ_RECORD rec;
	xyzfile.read_next();
	xyzfile.read_linestring(tempstr,1);
	rec.name=tempstr;
	rec.coords.set_coords(
			xyzfile.read_linedouble(2),
			xyzfile.read_linedouble(3),
			xyzfile.read_linedouble(4));
	push_back(rec);
}               
xyzfile.read_next();
if (xyzfile.SYSU_test_string(1,"UNC"))
{
	for (int i=1;i<=9;i++)
	{
		if (abs(xyzfile.read_linedouble(i+1)-params->get_cell(i))
				> INFINITESIMAL)
		{
			xyzfile.SYSU_error_exit(
			"mcgen",
			string("Incompatible unit cell in file \"")
			+_filename+      "\".",
			_SYSUTILS_IOERR);
		}
	}
}
else if (xyzfile.SYSU_test_string(1,"UNCP"))
logfile.print("Warning: Unit cell compatibility check for UNCP format has not been implemented.");
else
{
	xyzfile.read_linestring(tempstr,1);
	cout << _filename << ":" << xyzfile.SYSU_retr_linecount()
		<< ": error: Invalid cell type identifier \""
		<< tempstr << "\". Expected \"UNC\" or \"UNCP\"." << endl;
	exit(_SYSUTILS_IOERR);
}
}

