#!/bin/bash

if type tempfile
then tn=`tempfile`
else tn='/tmp/mcgen-energy'
fi

cat mcgen.log | grep Total | sed 's/,\?  *[A-Y][a-y]*:\?//g' | grep -v '[=A-Za-z]' > "$tn"
gnuplot << END
set terminal postscript
set output "mcgenenergy.ps"
plot "$tn" using 0:2 with lines 
END
rm "$tn"
