#include "params.h"
#include "mcgen.h"

//========== constructor PARAMS ==========

PARAMS::PARAMS(const string _inputfilename)
{
TEXTFILE inp(_inputfilename);

inp.read_next();
header=inp.SYSU_read_line100char();

inp.read_next("CELL1");
set_cell(1,1,inp.read_linedouble(2));
set_cell(1,2,inp.read_linedouble(3));
set_cell(1,3,inp.read_linedouble(4));

inp.read_next("CELL2");
set_cell(2,1,inp.read_linedouble(2));
set_cell(2,2,inp.read_linedouble(3));
set_cell(2,3,inp.read_linedouble(4));

inp.read_next("CELL3");
set_cell(3,1,inp.read_linedouble(2));
set_cell(3,2,inp.read_linedouble(3));
set_cell(3,3,inp.read_linedouble(4));

inp.read_next("IMCON");
imcon=(IMCON)inp.read_lineint(2);

inp.read_next("MAXEN");
maxen=inp.read_linelong(2);

inp.read_next("MAXTRY");
maxtry=inp.read_linelong(2);
set_triesdone(0);

inp.read_next("MAXTRYUNIT");
maxtryunit=inp.read_linelong(2);

inp.read_next("TEMPERATURE");
temperature=inp.read_linedouble(2);

inp.read_next("CUTOFF");
cutoffdist=inp.read_linedouble(2);
cutoffstep=inp.read_linedouble(3);

inp.read_next("RANDOME");
randval=inp.read_linelong(2);
randstart=inp.read_linelong(3);
takeback_is_fixed=inp.SYSU_test_string(4,"FIXED\n");
//takeback_is_fixed=inp.read_lineboolean(4);

inp.read_next("DUMP_TIME");
dump_time=inp.read_linelong(2);

inp.read_next("HISTORY_TIME");
history_time=inp.read_linelong(2);
assert(history_time==dump_time);

inp.read_next("NUMMAINFIRST");
nummainfirst=inp.read_lineint(2);
		// how many units to place in main chain, before
                // placing the sidechain?

inp.read_next("CLOSE\n");
}

//========== destructor ~PARAMS ==========

PARAMS::~PARAMS()
{
//TODO delete [] geom;
}

//========== method get_imcon ==========

IMCON PARAMS::get_imcon()
{
return imcon;
}

//========== method get_nummainfirst ==========

int PARAMS::get_nummainfirst()
{
return nummainfirst;
}

//========== method get_maxtryunit ==========

long PARAMS::get_maxtryunit()
{
return maxtryunit;
}

//========== method dec_triesleft ==========

long PARAMS::dec_triesleft()
{
triesleft--;
triesdone++;
if (triesleft<0)
	throw EXCEPTION_MAXTRY_EXHAUSTED;
return triesleft;
}

//========== method get_triesdone ==========

long PARAMS::get_triesdone()
{
return triesdone;
}

//========== method set_triesdone ==========

int PARAMS::set_triesdone(long _triesdone)
{
triesleft=maxtry-_triesdone;
triesdone=_triesdone;
return 0;
}

//========== method get_vdw_index ==========

int PARAMS::get_vdw_index()
{
return 0; //TODO
}

//========== method get_temperature ==========

double PARAMS::get_temperature()
{
return temperature;
}

//========== method get_randstart ==========

long PARAMS::get_randstart()
{
return randstart;
}

//========== method get_randval ==========

long PARAMS::get_randval()
{
return randval;
}

//========== method get_takeback_is_fixed ==========

bool PARAMS::get_takeback_is_fixed()
{
return takeback_is_fixed;
}

//========== method get_header ==========

const string *PARAMS::get_header()
{
return &header;
}

//========== method set_cell ==========

int PARAMS::set_cell(int _row, int _col, double _val)
{
assert(_row>=1);
assert(_row<=3);
assert(_col>=1);
assert(_col<=3);
cell[3*_row+_col-4]=_val;
return 0;
}

//========== method get_cell ==========

double PARAMS::get_cell(int _row, int _col)
{
assert(_row>=1);
assert(_row<=3);
assert(_col>=1);
assert(_col<=3);
return cell[3*_row+_col-4];
}

//========== method get_cell ==========

double PARAMS::get_cell(int _index)
{
assert(_index>=1);
assert(_index<=9);
return cell[_index-1];
}

//========== method get_cell ==========

double *PARAMS::get_cell()
{
return cell;
}

//========== method get_dump_time ==========

long unsigned int PARAMS::get_dump_time()
{
return dump_time; // Number of unit generation steps between dumps
}

//========== method get_history_time ==========

long unsigned int PARAMS::get_history_time()
{
return history_time; // Number of unit generation steps between dumps
}

