#ifndef _MOLECULE_H_DEFINE
#define _MOLECULE_H_DEFINE

#include "unit.h"
#include "geomconstr.h"

class MOLECULE //! One molecule
{
private:

int molid;
vector<CHAIN*> chains;  // Array of CHAINs.
//vector<UNIT*> unit;	// All units of this molecule.
vector<GEOMCONSTR> geom;
UNIT *seedunit;
long int interrupt_number_of_tries;
double interrupt_filled_per_cent;
long int moltries;
bool interrupt_done;
UNIT *interrupt_limit_unit; // If this unit has not been placed when 
	// interrupt_number_of_tries deadline falls, then an interrupt
	// will follow.
// TODO initialize interrupt_limit_unit;
	
public:

MOLECULE ();
MOLECULE (const MOLECULE &_original); // copy constructor
int generate(); // generate coordinates for this molecule.

int get_chainnr();
int set_molid(int _molid);
int get_molid();
CHAIN *get_chain(int _chainid);
int new_chain(); // Adds new chain to the end of chains list. Returns its chainid value.
int set_geomconstrnr(int _geomconstrnr);
int get_geomconstrnr();
GEOMCONSTR *get_geomconstr(int _index);
int set_seedunit(UNIT *_seedunit);
UNIT *get_seedunit();
int set_interrupt_number_of_tries(long int _interrupt_number_of_tries);
int set_interrupt_filled_per_cent(double _interrupt_filled_per_cent);
bool if_interrupt();
long int get_moltries();
int set_moltries(long int _moltries);
int inc_moltries();
int update_interrupt_unit();
bool get_interrupt_done();
int set_interrupt_done(bool _interrupt_done);
};

#endif

