#include "molecule.h"

//========== constructor MOLECULE ==========

MOLECULE::MOLECULE()
{
	molid=0;
	seedunit=0;
	interrupt_number_of_tries=0;
	interrupt_filled_per_cent=0;
	moltries=0;
	interrupt_done=0;
	interrupt_limit_unit=0;
}

//========== constructor MOLECULE ==========

MOLECULE::MOLECULE ( const MOLECULE &_original )
{
	molid=_original.molid;
	chains=_original.chains;
	geom=_original.geom;
	interrupt_number_of_tries=_original.interrupt_number_of_tries;
	interrupt_filled_per_cent=_original.interrupt_filled_per_cent;
	moltries=_original.moltries;
	interrupt_done=_original.interrupt_done;
	interrupt_limit_unit=_original.interrupt_limit_unit;
	seedunit=0;
//printf("COPY_MOL %p (%d) -> %p (%d)\n",&_original,_original.molid,this,molid);
}

//========== method get_chainnr ==========

int MOLECULE::get_chainnr()
{
	return chains.size()-1;
}

//========== method set_molid ==========

int MOLECULE::set_molid ( int _molid )
{
//printf("SET_MOLID %p %d\n",this,_molid);
	molid=_molid;
	return 0;
}

//========== method get_molid ==========

int MOLECULE::get_molid()
{
//printf("GET_MOLID %p %d\n",this,molid);
	if ( this )
		return molid;
	else
		return 0;
}

//========== method get_chain ==========

CHAIN *MOLECULE::get_chain ( int _chainid )
{
	if ( !this )
	{
		assert ( _chainid == 0 );
		return 0;
	}
	assert ( _chainid>=0 );
	assert ( _chainid<=get_chainnr() );
	return chains[_chainid];
}

/*!
\fn MOLECULE::new_chain();
\brief Adds new chain to the end of chains list. Returns its chainid value.
 */
int MOLECULE::new_chain()
{
	int new_chain_id=chains.size();
	chains.push_back ( new CHAIN() );
	chains[new_chain_id]->set_chainid ( new_chain_id );
	return new_chain_id;
}

//========== method generate ==========

int MOLECULE::generate()
{
//UNIT *firstunit=0;

	logfile.print ( "Creating molecule %d structure ... \n",molid );
	if ( seedunit == 0 )
	{
		logfile.print ( "\n<creating seedunit>\n" );
		set_seedunit ( new UNIT ( get_chain ( 0 ) ) );
		seedunit->set_molecule ( this );
		logfile.print ( "\n<initializing recursion>\n" );
		seedunit->recursive_initialization();
		logfile.print ( "\n<Repeating with paused units>\n" );
		UNIT::initialize_paused_units();
		logfile.print ( "Molecule structure done.\n" );
	}
	else
	{
		logfile.print ( "<seedunit exists already.>\n" );
	}

	update_interrupt_unit();

	logfile.print ( "----- Replacing some atoms with REPLACEs -----\n" );

	UNIT::replace_all_atoms();

	logfile.print ( "----- Generating atoms placement order -----\n" );

	UNIT::initialize_atoms_placement_order();

	logfile.print ( "----- Generating forcelists -----\n" );

	UNIT::create_all_forcelists();

	logfile.print ( "----- Checking for missing bonds -----\n" );

	ATOM::check_all_forcelists ( this );

	logfile.print ( "----- Molecule %d generation started -----\n",molid );

	UNIT::place_linear ( this );

	logfile.print ( "----- Molecule %d generation finished -----\n",molid );

	UNIT::dump ( outputnames_final );
//UNIT::write_coords("mcgen.xyz");
//firstunit.print_structure();

	return 0;
}

//========== method set_geomconstrnr ==========

int MOLECULE::set_geomconstrnr ( int _geomconstrnr )
{
	geom.clear(); // delete all constraints
	geom.resize ( _geomconstrnr );
	return 0;
}

//========== method get_geomconstrnr ==========

int MOLECULE::get_geomconstrnr()
{
	return geom.size();
}


//========== method get_geomconstr ==========

GEOMCONSTR *MOLECULE::get_geomconstr ( int _index )
{
	assert ( _index>=1 );
	assert ( _index<= ( int ) geom.size() );
	return &geom[_index-1];
}

//========== method set_seedunit ==========

int MOLECULE::set_seedunit ( UNIT *_seedunit )
{
	if ( seedunit != 0 )
		throw ( "Multiple seedunits for one molecule." );
	assert ( _seedunit != 0 );
	seedunit=_seedunit;
	return 0;
}

//========== method get_seedunit ==========

UNIT *MOLECULE::get_seedunit()
{
	return seedunit;
}

//========== method set_interrupt_number_of_tries ==========
int MOLECULE::set_interrupt_number_of_tries ( long int _interrupt_number_of_tries )
{
	interrupt_number_of_tries=_interrupt_number_of_tries;
	return 0;
}

//========== method set_interrupt_filled_per_cent ==========
int MOLECULE::set_interrupt_filled_per_cent ( double _interrupt_filled_per_cent )
{
	assert ( _interrupt_filled_per_cent>=0 );
	assert ( _interrupt_filled_per_cent<=100 );
	interrupt_filled_per_cent=_interrupt_filled_per_cent;
	return 0;
}

//========== method if_interrupt ==========
bool MOLECULE::if_interrupt()
{
	if ( interrupt_done )
		return false;
	if ( interrupt_filled_per_cent==0.0 )
		return false;
	return ( moltries >= interrupt_number_of_tries )
	       and not interrupt_limit_unit->get_has_coords();
}

//========== method get_moltries ==========
long int MOLECULE::get_moltries()
{
	return moltries;
}

//========== method inc_moltries ==========
int MOLECULE::inc_moltries()
{
	++moltries;
	return 0;
}

//========== method set_moltries ==========
int MOLECULE::set_moltries ( long int _moltries )
{
	moltries=_moltries;
	return 0;
}

//========== method update_interrupt_unit ==========
int MOLECULE::update_interrupt_unit()
{
	UNIT *u;
	int pikkus=0;
	for ( u=seedunit; u->get_nextunit(); u=u->get_nextunit() )
		++pikkus;
	pikkus = ( int ) ( pikkus * interrupt_filled_per_cent / 100.0 );
	for ( u=seedunit; pikkus>0 ; --pikkus )
		u=u->get_nextunit();
	assert ( u!=0 );
	interrupt_limit_unit=u;
	return 0;
}

//========== method get_interrupt_done ==========
bool MOLECULE::get_interrupt_done()
{
	return interrupt_done;
}

//========== method set_interrupt_done ==========
int MOLECULE::set_interrupt_done ( bool _interrupt_done )
{
	interrupt_done=_interrupt_done;
	return 0;
}

