//===> generated by: genmakep.scr-00.00.12-031121 by cipo@ut.ee <===

#include "mcgen.h"

RANDOME *randome;
PARAMS *params;
stack<ATOM*> history;
VDW *vdw;
DEFS *defs;
CHAINS *chains;
LOGFILE logfile;
FIELDIN *fieldin;
GENFIELDOUTINI *genfieldoutini;
int current_molid;
unsigned int current_unitid;
bool verbose_energy=true;
bool verbose_geom=true;
bool verbose_stat=true;

// Following files will be written regularily during the generation:
OUTPUTFILENAMES outputnames_regular =
{
	dump:"mcgen.dump",
	xyz:"mcgen.xyz",
	dropxyz:"mcgen-drop.xyz",
	fieldout:"fieldout.ini",
	dlpolyfield:"mcgen.out.FIELD"
};

// Following files will continue the best results of the generation.
// They are updated only when better results have become available.
OUTPUTFILENAMES outputnames_best = 
{
	dump:"best.mcgen.dump",
	xyz:"best.mcgen.xyz",
	dropxyz:"best.mcgen-drop.xyz",
	fieldout:"best.fieldout.ini",
	dlpolyfield:"best.mcgen.out.FIELD"
};

// Following files will hold the final structure or some intermediate steps
// and are not suitable for restoration.
OUTPUTFILENAMES outputnames_final = {
	dump:"final.do-not-use.mcgen.dump",
	xyz:"final.mcgen.xyz",
	dropxyz:"final.mcgen.dropxyz",
	fieldout:"final.fieldout.ini",
	dlpolyfield:"final.mcgen.out.FIELD"
};

int main(int argc,char *argv[])
{
int argnum=CL_ARGNUM;
int retStatus=0;

COMMLINE commline(argc,argv,argnum);

retStatus=commline.CML_input_standard_version((char*)_MCGEN_VERSION,copyYear1,
		copyYear2,(char*)copyOwner);

retStatus=commline.CML_input_options((char*)"d",(char*)"defs-file",
		(char*)" DEFSFILENAME\t\tdefs file name\0",1,2);
retStatus=commline.CML_input_options((char*)"p",(char*)"params-file",
		(char*)" PARAMSFILENAME\tparams file name\0",1,3);
retStatus=commline.CML_input_options((char*)"r",(char*)"randome-file",
		(char*)" RANDOMEFILENAME\trandome file name\0",1,4);
retStatus=commline.CML_input_options((char*)"u",(char*)"units-file",
		(char*)" UNITSFILENAME\tunits file name\0",1,5);
retStatus=commline.CML_input_options((char*)"c",(char*)"chains-file",
		(char*)" CHAINSFILENAME\tchains file name\0",1,6);
retStatus=commline.CML_input_options((char*)"f",(char*)"field-file",
		(char*)" FIELDFILENAME\tfield file name\0",1,7);
retStatus=commline.CML_input_options((char*)"v",(char*)"vdw-file",
		(char*)" VDWFILENAME\t\tvdw file name\0",1,8);
retStatus=commline.CML_input_options((char*)"x",(char*)"xyz-file",
		(char*)" XYZFILENAME\t\txyz input file name\0",1,CL_XYZ);
retStatus=commline.CML_input_options((char*)"F",(char*)"dlfield-file",
		(char*)" DLFIELDFILENAME\t\tdlpoly field file name\0",1,CL_DLFIELD);
retStatus=commline.CML_input_options(NULL,(char*)"verbose",
		(char*)" \t\t\tverbose output\0",0,CL_VERBOSE);
retStatus=commline.CML_input_options(NULL,(char*)"verbose_energy",
		(char*)" \t\t\tverbose energy calculation\0",0,CL_VERBOSE_ENERGY);
retStatus=commline.CML_input_options(NULL,(char*)"verbose_geom",
		(char*)" \t\t\tverbose geometry checks\0",0,CL_VERBOSE_GEOM);
retStatus=commline.CML_input_options(NULL,(char*)"verbose_stat",
		(char*)" \t\t\tprint statistics on what failed\0",0,CL_VERBOSE_STAT);
retStatus=commline.CML_input_options((char*)"e",(char*)"restore-file",
		(char*)" DUMPFILENAME\tdump file name to be restored\0",1,CL_RESTORE);
retStatus=commline.CML_input_options((char*)"n",(char*)"newxyz",
		(char*)" NEWXYZFILENAME\t\txyz file with new coordinates\0",1,CL_NEWXYZ);

retStatus=commline.CML_process_comm_line();

logfile.set_verbose(commline.CML_output_option_boolean(CL_VERBOSE,0));
bool verbose_input=logfile.get_verbose();
verbose_energy=commline.CML_output_option_boolean(CL_VERBOSE_ENERGY,0);
verbose_geom=commline.CML_output_option_boolean(CL_VERBOSE_GEOM,0);
verbose_stat=commline.CML_output_option_boolean(CL_VERBOSE_STAT,0);

try
{
logfile.print("\
mcgen\n\
Written by: Endel Soolo,      esoolo@ut.ee\n\
            Heiki Kasemagi,   cipo@rubiin.physic.ut.ee\n\
=========================================================\n");


verbose_input && logfile.print("Initializing RANDOME ... \n");	
randome=new RANDOME(commline.CML_output_option_string(4,1));
logfile.print("Random seed: %ld %ld\n",
	randome->RANDOME_output_seed1(),
	randome->RANDOME_output_seed2());
verbose_input && logfile.print("done.\nInitializing PARAMS ... ");
params=new PARAMS(commline.CML_output_option_string(3,1));
verbose_input && logfile.print("done.\nInitializing DEFS ... ");
defs=new DEFS(commline.CML_output_option_string(2,1));
verbose_input && logfile.print("done.\nInitializing UNITS ... ");
UNITS units(commline.CML_output_option_string(5,1),defs);
verbose_input && logfile.print("done.\nInitializing CHAINS ... ");
chains=new CHAINS(commline.CML_output_option_string(6,1), 
	      commline.CML_output_option_string(7,1), units);
verbose_input && logfile.print("done.\nInitializing VDW ... ");
vdw=new VDW(commline.CML_output_option_string(8,1),defs->get_atoms());
verbose_input && logfile.print("done.\n");

genfieldoutini=new GENFIELDOUTINI();
genfieldoutini->set_defs(defs);
genfieldoutini->set_vdw(vdw);
//genfieldoutini->set_filename("fieldout.ini");
//genfieldoutini->set_field_filename("mcgen.out.FIELD");

current_molid = 1;
current_unitid = 0;
	
UNIT *xyz_input_unit;
if (commline.CML_if_argument_exists(CL_XYZ))
{
	verbose_input && logfile.print("Reading PRESET UNITS from '%s' ... "
		,commline.CML_output_option_string(CL_XYZ,1).c_str());
	xyz_input_unit=new UNIT(commline.CML_output_option_string(CL_XYZ,1));
	current_unitid++;
	verbose_input && logfile.print("done.\n");
}

if (commline.CML_if_argument_exists(CL_DLFIELD))
{
	assert(commline.CML_if_argument_exists(CL_XYZ));
	verbose_input && logfile.print("Reading DLPOLY FIELD from '%s' ... "
		,commline.CML_output_option_string(CL_DLFIELD,1).c_str());
	fieldin = new FIELDIN(commline.CML_output_option_string(CL_DLFIELD,1));
	verbose_input && logfile.print("done.\n");
}

logfile.print("\
Output files:\n\
                LOG - mcgen.log\n\
		XYZ - mcgen.xyz\n");

if (commline.CML_if_argument_exists(CL_RESTORE)) // restore from an old dumpfile
{
	if (!commline.CML_if_argument_exists(CL_NEWXYZ))
	{
		cout<<"Error: --restore needs a --newxyz too.\n";
		exit(_SYSUTILS_IOERR);
	}
	verbose_input && logfile.print("Restoring from file '%s' ... ",
		commline.CML_output_option_string(CL_RESTORE,1).c_str());
	UNIT::restore(commline.CML_output_option_string(CL_RESTORE,1),&units,chains);
	verbose_input && logfile.print("done.\n");
}

if (commline.CML_if_argument_exists(CL_NEWXYZ))
{
	if (!commline.CML_if_argument_exists(CL_RESTORE))
	{
		cout<<"Error: --newxyz is not allowed without --restore.\n";
		exit(_SYSUTILS_IOERR);
	}
	verbose_input && logfile.print(
		"Reading refined coordinates from '%s' ... ",
		commline.CML_output_option_string(CL_NEWXYZ,1).c_str());
	UNIT::refine_coordinates_from_xyz(
		commline.CML_output_option_string(CL_NEWXYZ,1));
	verbose_input && logfile.print("done.\n");
}

logfile.print("\
=========================================================\n\
============ Starting to generate the chain =============\n\
=========================================================\n");

for (;current_molid<=chains->get_molnr();current_molid++)
	chains->get_molecule(current_molid)->generate();

UNIT::dump(outputnames_final);
//UNIT::write_coords("mcgen.xyz");

logfile.print("\nTotal number of tries: %ld\n",
	params->get_triesdone());


delete(vdw);
delete(params);
delete(randome);
delete(genfieldoutini);

}
catch(const char *_message)
{
	logfile.print("Error: %s\n",_message);
	throw(false); // exit program
}
catch(string _message)
{
	logfile.print("Error: %s\n",_message.c_str());
	throw(false); // exit program
}
catch(int _errorcode)
{
	if (_errorcode == EXCEPTION_MAXTRY_EXHAUSTED) {
		logfile.print("Maximum number of tries has been used up.\n");
		UNIT::dump(outputnames_final);
		//UNIT::write_coords("mcgen.xyz");
		logfile.print("\nTotal number of tries: %ld\n",
			params->get_triesdone());
		exit(0);
//		throw(false);	
	}
	logfile.print("Error code: %d\n",_errorcode);
	throw(false); // exit program
}
/*catch(...)
{
	logfile.print("Unknown error\n");
	throw(false); // exit program
}*/

return 0;
}


