#ifndef _MATHFUNC_H_DEFINE_
#define _MATHFUNC_H_DEFINE_

// Headers:
//      deg2rad         rad2deg         mathinpradxyz
//      mathinprad      mathoutx        mathouty
//      mathoutz        mathoutdeg      mathoutrad
//      rotatex         rotatexinv      rotatey
//      rotateyinv      rotatez         rotatezinv
//      vectlng         dotprod         dotprodangcos
//      dotprodang      vectprod        vectprodangsin
//      vectprodang     vectprodvectproddotprodang
//
// Public variables:    none
// Public constants:    none
//
// Last changed:  Wed Apr 19 11:40:05 CEST 2000
//it
// Include files:

#include <math.h>
//#include "mcpoly.h"

//
// Used external function [name, location, header file]:
//  none
//
//=============================
//========== Headers ==========
//=============================

class MATHFUNC //! Vector arithmetics
{

private:
double mathx,mathy,mathz,deg,rad;

public:

static double deg2rad(double deg1);
static double rad2deg(double rad1);
void mathinpradxyz(double irad,double ix,double iy,double iz);
void mathinprad(double irad);
double mathoutx(void);
double mathouty(void);
double mathoutz(void);
double mathoutdeg(void);
double mathoutrad(void);
void rotatex(void);
void rotatexinv(void);
void rotatey(void);
void rotateyinv(void);
void rotatez(void);
void rotatezinv(void);
/*
muidu sideme pikkuse arvutamiseks on meetod

double MATHFUNC::vectlng(double ix,double iy,double iz)
failis mathfunc.cpp...sisendiks on vektor

*/
static double vectlng(double ix,double iy,double iz);
static double dotprod(double ijx,double ijy,double ijz,double jkx,double jky,
               double jkz);
/*
nurga koosinuse arvutamiseks on meetod

double MATHFUNC::dotprodangcos(double ijx,double ijy,double ijz,double
jkx,double jky,double jkz)

failis mathfunc.cpp...sisendiks on kahe vektori koordinaadid
*/
static double dotprodangcos(double ijx,double ijy,double ijz,double jkx,
                     double jky,double jkz);
static double dotprodang(double iijx,double iijy,double iijz,double jjkx,double jjky,
									double jjkz);
void vectprod(double ijx,double ijy,double ijz,double jkx,double jky,
              double jkz);
double vectprodangsin(double ijx,double ijy,double ijz,double jkx,double jky,
											double jkz);
double vectprodang(double ijx,double ijy,double ijz,double jkx,double jky,
									 double jkz);

/*
dihedraalnurga arvutamiseks on meetod
double MATHFUNC::vectprodvectproddotprodang(double ijx,double ijy,double
ijz,double jkx,double jky,double jkz,double kjx,double kjy,double kjz,
double klx,double kly,double klz)

failis mathfunc.cpp...sisendiks on 4 aatomi koordinaadid
Kui te suudate selle meetodi valja qelda ilma raskusteta, siis pole teil kokutamisega probleeme :P
*/

double vectprodvectproddotprodang(double ijx,double ijy,double ijz,
                                  double jkx,double jky,double jkz,
                                  double kjx,double kjy,double kjz,
                                  double klx,double kly,double klz);
};

//===========================================
//========== Parameters description==========
//===========================================
//
//========== Method deg2rad ==========
//
// INPUT parameters
//
// double deg1		angle in degrees
//
// OUTPUT parameters
//
// double deg2rad	angle in radians
//
//========== Method rad2deg ==========   
//
// INPUT parameters
//
// double rad1          angle in radians
//
// OUTPUT parameters
//
// double rad2deg       angle in degreess
//
//========== Method mathinpradxyz ==========
//
// INPUT parameters
//
// double irad          angle in radians
// double ix						x coordinate
// double iy            y coordinate
// double ix            z coordinate
//
// OUTPUT parameters
//
//	none
//
//========== Method mathinprad ==========
//
// INPUT parameters
//
// double irad          angle in radians
//
// OUTPUT parameters
//
//      none
//
//========== Method mathoutx ==========   
//
// INPUT parameters
//
//	none
//
// OUTPUT parameters
//
// double mathoutx	x coordinate
//
//========== Method mathouty ==========  
//
// INPUT parameters
//
//      none
//
// OUTPUT parameters
//
// double mathouty      y coordinate
//
//========== Method mathoutz ==========  
//
// INPUT parameters
//
//      none
//
// OUTPUT parameters
//
// double mathoutz      z coordinate
//
//========== Method mathoutdeg ==========
//
// INPUT parameters
//
//      none
//
// OUTPUT parameters
//
// double mathoutdeg	angle in degrees
//
//========== Method mathoutrad ==========
//
// INPUT parameters
//
//      none
//
// OUTPUT parameters
//
// double mathoutrad    angle in radians
//
//========== Method rotatex ==========
//
// INPUT parameters
//
//	directly none, data must be inputed via function mathinpradxyz
//
// OUTPUT parameters
//
//	directly none, data must be outputed via functions mathoutx, mathouty,
//	mathoutz, [mathoutrad - optional]
//
//========== Method rotatexinv ==========
//
// INPUT parameters
//
//  directly none, data must be inputed via function mathinpradxyz
//
// OUTPUT parameters
//
//  directly none, data must be outputed via functions mathoutx, mathouty,
//  mathoutz, [mathoutrad - optional]
//
//========== Method rotatey ==========
//
// INPUT parameters
//
//  directly none, data must be inputed via function mathinpradxyz
//
// OUTPUT parameters
//
//  directly none, data must be outputed via functions mathoutx, mathouty,
//  mathoutz, [mathoutrad - optional]
//
//========== Method rotateyinv ==========
//
// INPUT parameters
//
//  directly none, data must be inputed via function mathinpradxyz
//
// OUTPUT parameters
//
//  directly none, data must be outputed via functions mathoutx, mathouty,
//  mathoutz, [mathoutrad - optional]
//
//========== Method rotatez ==========
//
// INPUT parameters
//
//  directly none, data must be inputed via function mathinpradxyz
//
// OUTPUT parameters
//
//  directly none, data must be outputed via functions mathoutx, mathouty,
//  mathoutz, [mathoutrad - optional]
//
//========== Method rotatezinv ==========
//
// INPUT parameters
//
//  directly none, data must be inputed via function mathinpradxyz
//
// OUTPUT parameters
//
//  directly none, data must be outputed via functions mathoutx, mathouty,
//  mathoutz, [mathoutrad - optional]
//
//========== Method vectlng ==========
//
// INPUT parameters
//
//	double ix					x coordinate
//	double iy					y coordinate
//	double iz					z coordinate
//
// OUTPUT parameters
//
//	double vectlng		length of the vector (ix,iy,iz)
//
//========== Method dotprod ==========
//
// INPUT parameters
//
//  double ijx         x coordinate of the 1st vector
//  double ijy         y coordinate of the 1st vector
//  double ijz         z coordinate of the 1st vector
//  double jkx         x coordinate of the 2nd vector
//  double jky         y coordinate of the 2nd vector
//  double jkz         z coordinate of the 2nd vector
//
// OUTPUT parameters
//
//  double dotprod    dot product  of the vectors (ijx,ijy,ijz) and
//										(jkx,jky,jkz)
//
//========== Method dotprodangcos ==========
//
// INPUT parameters
//
//  double ijx         x coordinate of the 1st vector
//  double ijy         y coordinate of the 1st vector
//  double ijz         z coordinate of the 1st vector  
//  double jkx         x coordinate of the 2nd vector   
//  double jky         y coordinate of the 2nd vector   
//  double jkz         z coordinate of the 2nd vector   
//
// OUTPUT parameters
//
//  double dotprodangcos	angle cosine of the dot product of the 
//												vectors (ijx,ijy,ijz) and (jkx,jky,jkz)
//
//========== Method dotprodang ==========
//
// INPUT parameters
//
//  double ijx         x coordinate of the 1st vector
//  double ijy         y coordinate of the 1st vector
//  double ijz         z coordinate of the 1st vector  
//  double jkx         x coordinate of the 2nd vector   
//  double jky         y coordinate of the 2nd vector   
//  double jkz         z coordinate of the 2nd vector   
//
// OUTPUT parameters
//
//  double dotprodang  angle of the dot product of the vectors (ijx,ijy,ijz) 
//										 and (jkx,jky,jkz) in radians
//
//========== Method vectprod ==========
//
// INPUT parameters
//
//  double ijx         x coordinate of the 1st vector
//  double ijy         y coordinate of the 1st vector
//  double ijz         z coordinate of the 1st vector  
//  double jkx         x coordinate of the 2nd vector   
//  double jky         y coordinate of the 2nd vector   
//  double jkz         z coordinate of the 2nd vector   
//
// OUTPUT parameters
//
//	directly none, data must be outputed via functions mathoutx, mathouty and
//	mathoutz
//
//========== Method vectprodangsin ==========
//
// INPUT parameters
//
//  double ijx         x coordinate of the 1st vector
//  double ijy         y coordinate of the 1st vector
//  double ijz         z coordinate of the 1st vector
//  double jkx         x coordinate of the 2nd vector  
//  double jky         y coordinate of the 2nd vector   
//  double jkz         z coordinate of the 2nd vector   
//
// OUTPUT parameters
//
//	double vectprodangsin		angle sine of the vector product of vectors
//													(ijx,ijy,ijz) and (jkx,jky,jkz)
//
//========== Method vectprodang ==========
//
// INPUT parameters
//
//  double ijx         x coordinate of the 1st vector
//  double ijy         y coordinate of the 1st vector  
//  double ijz         z coordinate of the 1st vector   
//  double jkx         x coordinate of the 2nd vector   
//  double jky         y coordinate of the 2nd vector
//  double jkz         z coordinate of the 2nd vector
//
// OUTPUT parameters
//
//  double vectprodang 	angle of the vector product of vectors
//                      (ijx,ijy,ijz) and (jkx,jky,jkz)
//
//========== Method vectprodvectproddotprodang ==========
//
// INPUT parameters
//
//  double ijx         x coordinate of the 1st vector
//  double ijy         y coordinate of the 1st vector
//  double ijz         z coordinate of the 1st vector
//  double jkx         x coordinate of the 2nd vector
//  double jky         y coordinate of the 2nd vector
//  double jkz         z coordinate of the 2nd vector
//  double kjx         x coordinate of the 3rd vector
//  double kjy         y coordinate of the 3rd vector
//  double kjz         z coordinate of the 3rd vector
//  double klx         x coordinate of the 4th vector
//  double kly         y coordinate of the 4th vector
//  double klz         z coordinate of the 4th vector
//
// OUTPUT parameters
//
//  double vectprodvectproddotprodang  angle of the dot product of two vector
//																		 products of vectors (ijx,ijy,ijz),
//																		 (jkx,jky,jkz), (kjx,kjy,kjz) and
//																		 (klx,kly,klz)   
//
//=======================================================
//========== End of the parameters description ==========
//=======================================================
#endif

