#include <stdio.h>
// Class:               MATHFUNC
// Constructors:        none
// Destructors:         none
// Methods:
//			deg2rad					rad2deg					mathinpradxyz
//			mathinprad			mathoutx				mathouty
//			mathoutz				mathoutdeg			mathoutrad
//			rotatex					rotatexinv			rotatey
//			rotateyinv			rotatez					rotatezinv
//			vectlng					dotprod					dotprodangcos
//			dotprodang			vectprod				vectprodangsin
//			vectprodang			vectprodvectproddotprodang
//
// Public variables:    none
// Public constants:		none
//
// Last changed:	Wed Apr 19 11:40:05 CEST 2000
//
// Description:
//
// Class MATHFUNC contains several mathematical functions.
// Method deg2rad converts degrees to radians.
// Method rad2deg converts radians to degrees.
// Method mathinpradxyz inputs angle in radians and x, y, z coordinates
// into the class.
// Method mathinprad inputs angle in radians into the class.
// Method mathoutx outputs x coordinate.
// Method mathouty outputs y coordinate.
// Method mathoutz outputs z coordinate.
// Method mathoutdeg outputs the angle in degrees.
// Method mathoutrad outputs angle in radians.
// Method rotatex rotates the coordinate axes clockwise over x axis.
// Method rotatexinv rotates the coordinate axes anticlockwise over x axis.
// Method rotatey rotates the coordinate axes clockwise over y axis.
// Method rotateyinv rotates the coordinate axes anticlockwise over y axis.
// Method rotatez rotates the coordinate axes clockwise over z axis.
// Method rotatezinv rotates the coordinate axes anticlockwise over z axis.
// Method vectlng calculates the length of the vector.
// Method dotprod calculates the dot product of two vectors.
// Method dotprodangcos calculates the angle cosine of the dot product of
// two vectors.
// Method dotprodang calculates the angle the dot product of two vectors.
// Method vectprod calculates the coordinates of the vector product of two
// vectors.
// Method vectprodangsin calculates the angle sine of the vector product of two
// vectors.
// Method vectprodang calculates the angle of the vector product of two
// vectors.
// Method vectprodvectproddotprodang calculates the angle of the dot product
// of two vector products.
//
// Include files:
//      mathfunc.h
//
// Used external function [name, location, header file]:
//	none
//
//========== Parameters description==========
//
//========== Method deg2rad ==========
//
// INPUT parameters
//
// double deg1		angle in degrees
//
// OUTPUT parameters
//
// double deg2rad	angle in radians
//
//========== Method rad2deg ==========
//
// INPUT parameters
//
// double rad1          angle in radians
//
// OUTPUT parameters
//
// double rad2deg       angle in degreess
//
//========== Method mathinpradxyz ==========
//
// INPUT parameters
//
// double irad          angle in radians
// double ix						x coordinate
// double iy            y coordinate
// double ix            z coordinate
//
// OUTPUT parameters
//
//	none
//
//========== Method mathinprad ==========
//
// INPUT parameters
//
// double irad          angle in radians
//
// OUTPUT parameters
//
//      none
//
//========== Method mathoutx ==========   
//
// INPUT parameters
//
//	none
//
// OUTPUT parameters
//
// double mathoutx	x coordinate
//
//========== Method mathouty ==========  
//
// INPUT parameters
//
//      none
//
// OUTPUT parameters
//
// double mathouty      y coordinate
//
//========== Method mathoutz ==========  
//
// INPUT parameters
//
//      none
//
// OUTPUT parameters
//
// double mathoutz      z coordinate
//
//========== Method mathoutdeg ==========  
//
// INPUT parameters
//
//      none
//
// OUTPUT parameters
//
// double mathoutdeg	angle in degrees
//
//========== Method mathoutrad ==========
//
// INPUT parameters
//
//      none
//
// OUTPUT parameters
//
// double mathoutrad    angle in radians
//
//========== Method rotatex ==========
//
// INPUT parameters
//
//	directly none, data must be inputed via function mathinpradxyz
//
// OUTPUT parameters
//
//	directly none, data must be outputed via functions mathoutx, mathouty,
//	mathoutz, [mathoutrad - optional]
//
//========== Method rotatexinv ==========
//
// INPUT parameters
//
//  directly none, data must be inputed via function mathinpradxyz
//
// OUTPUT parameters
//
//  directly none, data must be outputed via functions mathoutx, mathouty,
//  mathoutz, [mathoutrad - optional]
//
//========== Method rotatey ==========
//
// INPUT parameters
//
//  directly none, data must be inputed via function mathinpradxyz
//
// OUTPUT parameters
//
//  directly none, data must be outputed via functions mathoutx, mathouty,
//  mathoutz, [mathoutrad - optional]
//
//========== Method rotateyinv ==========
//
// INPUT parameters
//
//  directly none, data must be inputed via function mathinpradxyz
//
// OUTPUT parameters
//
//  directly none, data must be outputed via functions mathoutx, mathouty,
//  mathoutz, [mathoutrad - optional]
//
//========== Method rotatez ==========
//
// INPUT parameters
//
//  directly none, data must be inputed via function mathinpradxyz
//
// OUTPUT parameters
//
//  directly none, data must be outputed via functions mathoutx, mathouty,
//  mathoutz, [mathoutrad - optional]
//
//========== Method rotatezinv ==========
//
// INPUT parameters
//
//  directly none, data must be inputed via function mathinpradxyz
//
// OUTPUT parameters
//
//  directly none, data must be outputed via functions mathoutx, mathouty,
//  mathoutz, [mathoutrad - optional]
//
//========== Method vectlng ==========
//
// INPUT parameters
//
//	double ix					x coordinate
//	double iy					y coordinate
//	double iz					z coordinate
//
// OUTPUT parameters
//
//	double vectlng		length of the vector (ix,iy,iz)
//
//========== Method dotprod ==========
//
// INPUT parameters
//
//  double ijx         x coordinate of the 1st vector
//  double ijy         y coordinate of the 1st vector
//  double ijz         z coordinate of the 1st vector
//  double jkx         x coordinate of the 2nd vector
//  double jky         y coordinate of the 2nd vector
//  double jkz         z coordinate of the 2nd vector
//
// OUTPUT parameters
//
//  double dotprod    dot product  of the vectors (ijx,ijy,ijz) and
//										(jkx,jky,jkz)
//
//========== Method dotprodangcos ==========
//
// INPUT parameters
//
//  double ijx         x coordinate of the 1st vector
//  double ijy         y coordinate of the 1st vector
//  double ijz         z coordinate of the 1st vector  
//  double jkx         x coordinate of the 2nd vector   
//  double jky         y coordinate of the 2nd vector   
//  double jkz         z coordinate of the 2nd vector
//
// OUTPUT parameters
//
//  double dotprodangcos	angle cosine of the dot product of the
//												vectors (ijx,ijy,ijz) and (jkx,jky,jkz)
//
//========== Method dotprodang ==========
//
// INPUT parameters
//
//  double ijx         x coordinate of the 1st vector
//  double ijy         y coordinate of the 1st vector
//  double ijz         z coordinate of the 1st vector  
//  double jkx         x coordinate of the 2nd vector
//  double jky         y coordinate of the 2nd vector   
//  double jkz         z coordinate of the 2nd vector   
//
// OUTPUT parameters
//
//  double dotprodang  angle of the dot product of the vectors (ijx,ijy,ijz)
//										 and (jkx,jky,jkz) in radians
//
//========== Method vectprod ==========
//
// INPUT parameters
//
//  double ijx         x coordinate of the 1st vector
//  double ijy         y coordinate of the 1st vector
//  double ijz         z coordinate of the 1st vector
//  double jkx         x coordinate of the 2nd vector   
//  double jky         y coordinate of the 2nd vector   
//  double jkz         z coordinate of the 2nd vector   
//
// OUTPUT parameters
//
//	directly none, data must be outputed via functions mathoutx, mathouty and
//	mathoutz
//
//========== Method vectprodangsin ==========
//
// INPUT parameters
//
//  double ijx         x coordinate of the 1st vector
//  double ijy         y coordinate of the 1st vector
//  double ijz         z coordinate of the 1st vector
//  double jkx         x coordinate of the 2nd vector
//  double jky         y coordinate of the 2nd vector   
//  double jkz         z coordinate of the 2nd vector   
//
// OUTPUT parameters
//
//	double vectprodangsin		angle sine of the vector product of vectors
//													(ijx,ijy,ijz) and (jkx,jky,jkz)
//
//========== Method vectprodang ==========
//
// INPUT parameters
//
//  double ijx         x coordinate of the 1st vector
//  double ijy         y coordinate of the 1st vector  
//  double ijz         z coordinate of the 1st vector   
//  double jkx         x coordinate of the 2nd vector   
//  double jky         y coordinate of the 2nd vector
//  double jkz         z coordinate of the 2nd vector
//
// OUTPUT parameters
//
//  double vectprodang 	angle of the vector product of vectors
//                      (ijx,ijy,ijz) and (jkx,jky,jkz)
//
//========== Method vectprodvectproddotprodang ==========
//
// INPUT parameters
//
//  double ijx         x coordinate of the 1st vector
//  double ijy         y coordinate of the 1st vector
//  double ijz         z coordinate of the 1st vector
//  double jkx         x coordinate of the 2nd vector
//  double jky         y coordinate of the 2nd vector
//  double jkz         z coordinate of the 2nd vector
//  double kjx         x coordinate of the 3rd vector
//  double kjy         y coordinate of the 3rd vector
//  double kjz         z coordinate of the 3rd vector
//  double klx         x coordinate of the 4th vector
//  double kly         y coordinate of the 4th vector
//  double klz         z coordinate of the 4th vector
//
// OUTPUT parameters
//
//  double vectprodvectproddotprodang  angle of the dot product of two vector
//																		 products of vectors (ijx,ijy,ijz),
//																		 (jkx,jky,jkz), (kjx,kjy,kjz) and
//																		 (klx,kly,klz)   
//
//========== End of the parameters description ==========
//==========================
//========== Code ==========
//==========================


#include "mathfunc.h"

//======================================
//============ Method deg2rad ==========
//======================================

double MATHFUNC::deg2rad(double deg1)
{
deg1=(M_PI*deg1)/180.0;
return deg1;
};

//======================================
//============ Method rad2deg ==========
//======================================

double MATHFUNC::rad2deg(double rad1)
{
rad1=(180.0*rad1)/M_PI;
return rad1;
};

//============================================
//============ Method mathinpradxyz ==========
//============================================

void MATHFUNC::mathinpradxyz(double irad,double ix,double iy,double iz)
{
mathx=ix;
mathy=iy;
mathz=iz;
rad=irad;
};

//=========================================
//============ Method mathinprad ==========
//=========================================

void MATHFUNC::mathinprad(double irad)
{
rad=irad;
};

//=======================================
//============ Method mathoutx ==========
//=======================================

double MATHFUNC::mathoutx(void)
{
return mathx;
};

//=======================================
//============ Method mathouty ==========
//=======================================

double MATHFUNC::mathouty(void)
{
return mathy;
};

//=======================================
//============ Method mathoutz ==========
//=======================================

double MATHFUNC::mathoutz(void)
{
return mathz;
};

//=========================================
//============ Method mathoutdeg ==========
//=========================================

double MATHFUNC::mathoutdeg(void)
{
return deg;
};

//=========================================
//============ Method mathoutrad ==========
//=========================================

double MATHFUNC::mathoutrad(void)
{
return rad;
};

//======================================
//============ Method rotatex ==========
//======================================

void MATHFUNC::rotatex(void)
{
double xx,yy,zz;

xx=mathx*1.0+mathy*0.0+mathz*0.0;
yy=mathx*0.0+mathy*cos(rad)+mathz*(sin(rad));
zz=mathx*0.0+mathy*(-sin(rad))+mathz*cos(rad);
mathx=xx;
mathy=yy;
mathz=zz;
};

//=========================================
//============ Method rotatexinv ==========
//=========================================

void MATHFUNC::rotatexinv(void)
{
double xx,yy,zz,det;

det=1.0/(cos(rad)*cos(rad)+sin(rad)*sin(rad));
xx=mathx*(cos(rad)*cos(rad)+sin(rad)*sin(rad))+mathy*0.0+mathz*0.0;
yy=mathx*0.0+mathy*cos(rad)+mathz*(-sin(rad));
zz=mathx*0.0+mathy*sin(rad)+mathz*cos(rad);
mathx=xx*det;
mathy=yy*det;
mathz=zz*det;
};

//======================================
//============ Method rotatey ==========
//======================================

void MATHFUNC::rotatey(void)
{
double xx,yy,zz;

xx=mathx*cos(rad)+mathy*0.0+mathz*(sin(rad));
yy=mathx*0.0+mathy*1.0+mathz*0.0;
zz=mathx*(-sin(rad))+mathy*0.0+mathz*cos(rad);
mathx=xx;
mathy=yy;
mathz=zz;

};

//=========================================
//============ Method rotateyinv ==========
//=========================================

void MATHFUNC::rotateyinv(void)
{
double xx,yy,zz,det;

det=1.0/(cos(rad)*cos(rad)+sin(rad)*sin(rad));
xx=mathx*cos(rad)+mathy*0.0+mathz*(-sin(rad));
yy=mathx*0.0+mathy*(cos(rad)*cos(rad)+sin(rad)*sin(rad))+mathz*0.0;
zz=mathx*(sin(rad))+mathy*0.0+mathz*cos(rad);
mathx=xx*det;
mathy=yy*det;
mathz=zz*det;
};

//======================================
//============ Method rotatez ==========
//======================================

void MATHFUNC::rotatez(void)
{
double xx,yy,zz;

xx=mathx*cos(rad)+mathy*(sin(rad))+mathz*0.0;
yy=mathx*(-sin(rad))+mathy*cos(rad)+mathz*0.0;
zz=mathx*0.0+mathy*0.0+mathz*1.0;
mathx=xx;
mathy=yy;
mathz=zz;
};

//=========================================
//============ Method rotatezinv ==========
//=========================================

void MATHFUNC::rotatezinv(void)
{
double xx,yy,zz,det;

det=1.0/(cos(rad)*cos(rad)+sin(rad)*sin(rad));
xx=mathx*cos(rad)+mathy*(-sin(rad))+mathz*0.0;
yy=mathx*sin(rad)+mathy*cos(rad)+mathz*0.0;
zz=mathx*0.0+mathy*0.0+mathz*(cos(rad)*cos(rad)+sin(rad)*sin(rad));
mathx=xx*det;
mathy=yy*det;
mathz=zz*det;
};

//======================================
//============ Method vectlng ==========
//======================================

double MATHFUNC::vectlng(double ix,double iy,double iz)
{
double tvectlng;
tvectlng=sqrt(pow(ix,2)+pow(iy,2)+pow(iz,2));
return tvectlng; 
};

//======================================
//============ Method dotprod ==========
//======================================

double MATHFUNC::dotprod(double ijx,double ijy,double ijz,double jkx,double jky,
double jkz)
{
double tdotprod;
tdotprod=ijx*jkx+ijy*jky+ijz*jkz;
//logfile.print("tdotprod: %lf\n",tdotprod);
return tdotprod;
};

//============================================
//============ Method dotprodangcos ==========
//============================================

double MATHFUNC::dotprodangcos(double ijx,double ijy,double ijz,double jkx,
double jky,double jkz)
{
double tdotprodangcos,ln1,ln2;
ln1=vectlng(ijx,ijy,ijz);
ln2=vectlng(jkx,jky,jkz);
if(ln1!=0.0 && ln2!=0.0)
{
tdotprodangcos=dotprod(ijx,ijy,ijz,jkx,jky,jkz)/(ln1*ln2);
}
else
tdotprodangcos=1E100;
//logfile.print("tdotprodangcos: %lf %lf %lf\n",tdotprodangcos,ln1,ln2);
return tdotprodangcos;
};

//=======================================
//========== Method dotprodang ==========
//=======================================

double MATHFUNC::dotprodang(double iijx,double iijy,double iijz,double jjkx,
	double jjky,double jjkz)
{
double tdotprodang;
tdotprodang=dotprodangcos(iijx,iijy,iijz,jjkx,jjky,jjkz);
if(tdotprodang!=1E100) tdotprodang=acos(tdotprodang);

return tdotprodang;
};

//=====================================
//========== Method vectprod ==========
//=====================================

void MATHFUNC::vectprod(double ijx,double ijy,double ijz,double jkx,
												double jky,double jkz)
{
mathx=ijy*jkz-jky*ijz;
mathy=-(ijx*jkz-jkx*ijz);
mathz=ijx*jky-jkx*ijy;
};

//===========================================
//========== Method vectprodangsin ==========
//===========================================

double MATHFUNC::vectprodangsin(double ijx,double ijy,double ijz,double jkx,
																double jky,double jkz)
{
double tmp1,tmp2,tmp3,tmp5,tmp6,tvectprodangsin;
vectprod(ijx,ijy,ijz,jkx,jky,jkz);
tmp1=mathx;
tmp2=mathy;
tmp3=mathz;
tmp5=vectlng(ijx,ijy,ijz);
tmp6=vectlng(jkx,jky,jkz);
if(tmp5!=0.0 && tmp6!=0.0)
	tvectprodangsin=vectlng(tmp1,tmp2,tmp3)/(tmp5*tmp6);
else tvectprodangsin=1E100;
if(tmp3<0) tvectprodangsin=-tvectprodangsin;
return tvectprodangsin;
};

//========================================
//========== Method vectprodang ==========
//========================================

double MATHFUNC::vectprodang(double ijx,double ijy,double ijz,double jkx,
														 double jky,double jkz)
{
double tvectprodang,tmp1,tmp2,tmp3;
tmp2=vectprodangsin(ijx,ijy,ijz,jkx,jky,jkz);
tmp1=dotprodangcos(ijx,ijy,ijz,jkx,jky,jkz);
if(tmp2!=1E100 && tmp1!=1E100)
{
	tmp3=asin(tmp2);
	tvectprodang=tmp3;
	if(tmp2>0.0 && tmp1<0.0)
		tvectprodang=M_PI-tmp3;
	if(tmp2<0.0 && tmp1<0.0)
		tvectprodang=M_PI-tmp3;
	if(tmp2<0.0 && tmp1>0.0)
		tvectprodang=2*M_PI+tmp3;
	
}
else tvectprodang=1E100;
return tvectprodang;
};

//=======================================================
//========== Method vectprodvectproddotprodang ==========
//=======================================================

double MATHFUNC::vectprodvectproddotprodang(double ijx,double ijy,double ijz,
																						double jkx,double jky,double jkz,
																						double kjx,double kjy,double kjz,
																						double klx,double kly,double klz)
{
double tvectprodvectproddotprodang,tmp1,tmp2,tmp3,tmp4,tmp5,tmp6,tmp7,tmp8;
double tmp9,tmp10;
vectprod(ijx,ijy,ijz,jkx,jky,jkz);
tmp1=mathx;
tmp2=mathy;
tmp3=mathz;
vectprod(kjx,kjy,kjz,klx,kly,klz);
tmp4=mathx;
tmp5=mathy;
tmp6=mathz;
tmp7=vectlng(tmp1,tmp2,tmp3);
tmp8=vectlng(tmp4,tmp5,tmp6);
if(tmp7!=0.0 && tmp8!=0.0)
{
	tmp9=dotprod(tmp1,tmp2,tmp3,tmp4,tmp5,tmp6)/(tmp7*tmp8);
}
else
	tmp9=1E100;
tmp9=acos(tmp9);
tmp10=vectprodangsin(tmp1,tmp2,tmp3,tmp4,tmp5,tmp6);
if(tmp10!=1E100)
{
	if(tmp10<0.0)
	{
		tmp9=2*M_PI-tmp9;
	}
}
else tmp9=1E100;
tvectprodvectproddotprodang=tmp9;

return tvectprodvectproddotprodang;
};

//=====================================
//========== End of the code ==========
//=====================================
