#include "logfile.h"

//========== constructor LOGFILE ==========

LOGFILE::LOGFILE()
{
SYSUTILS sysu;
lfile=sysu.open_file("mcgen.log","w");
verbose=true;
}

//========== constructor LOGFILE ==========

LOGFILE::LOGFILE(string _logfile_name)
{
SYSUTILS sysu;
lfile=sysu.open_file(_logfile_name,"w");
verbose=true;
}

//========== destructor ~LOGFILE ==========

LOGFILE::~LOGFILE()
{
SYSUTILS sysu;
sysu.close_file(lfile);
}

//========== method set_verbose ==========

int LOGFILE::set_verbose(bool _verbose)
{
verbose=_verbose;
return 0;
}

//========== method get_verbose ==========

bool LOGFILE::get_verbose()
{
return verbose;
}

//========== method print ==========

int LOGFILE::print(const char *_format, ...)
{
va_list _args;
va_start(_args,_format);
vfprintf(lfile,_format,_args);
va_end(_args);
if (verbose)
{
        va_start(_args,_format);
        vprintf(_format,_args);
        va_end(_args);
}
return 0;
}

