// Headers:	distance
//              invert  
//              image 
//              inbox
//
// Last changed: Wed May 10 10:41:20 CEST 2000
//
// Description:
//
// 'distance' calculates the vector length
// 'invert' inverts the 3-dim matrix
// 'image' calculates the minimum image of the atom pairs within the
// specified cell
// 'inbox' packs the atoms into the specified cell
//  'direction_shift' shifts a coordinate
//
// Include files:
//      none
//
// Used external function [name, location, header file]:
//      none
//
//=============================
//========== Headers ==========
//=============================

void distance (int nc,double *dist, double *x, double *y, double *z);

void invert(double *a,double *b,double d);

void image(int imcon,int idnode,int mxnode ,int natms,double *cell,
           double *disx,double *disy,double *disz);

int inbox(int imcon,int natms,double *cell,double *x,double *y,double *z);

double direction_shift(double origcoord,double dcell,double dshift);

//========================================================
//========== Parameters description of distance ==========
//========================================================
//
// INPUT parameters
//
// int nc               number of atoms
// double *x            difference of x coordinates of two atoms
// double *y            difference of y coordinates of two atoms
// double *z            difference of z coordinates of two atoms
//
// OUTPUT parameters
//
// double *dist         calculated vector length
//
//======================================================
//========== Parameters description of invert ==========
//======================================================
//
// INPUT parameters
//
// double *a            matrix
// double d             determinant
//
// OUTPUT parameters
//
// double *b            inverse matrix
//
//=====================================================
//========== Parameters description of image ==========
//=====================================================
//
// INPUT parameters
//
// int imcon            image convention
// int idnode           node number
// int mxnode           number of nodes
// int natms            number of atoms
// double *cell         cell parameters
// double *disx         difference of the x coorinates of two atoms
// double *disy         difference of the y coorinates of two atoms
// double *disz         difference of the z coorinates of two atoms
//
// OUTPUT parameters
//
// double *disx         minimum difference of the x coorinates of two atoms
// double *disy         minimum difference of the y coorinates of two atoms
// double *disz         minimum difference of the z coorinates of two atoms
//
//=====================================================
//========== Parameters description of inbox ==========
//=====================================================
//
// INPUT parameters
//
// int imcon            image convention
// int natms            number of atoms 
// double *cell         cell parameters 
// double *x            x coordinate    
// double *y            y coordinate    
// double *z            z coordinate    
//
// OUTPUT parameters
//
// double *x            new x coordinate
// double *y            new y coordinate
// double *z            new z coordinate
//
//========== Function direction_shift ==========
//
// INPUT parameters
//
// double origcoord   original coordinate
// double dcell       unit cell value of the direction
// double dshift      additional shift
//
// OUTPUT parameters
//
// double direction_shift   shifted coordinate
//
//==========================================
//========== Description of imcon ==========
//==========================================
//
//     for
//     imcon=0 no boundary conditions apply
//     imcon=1 standard cubic boundaries apply
//     imcon=2 orthorhombic boundaries apply  
//     imcon=3 parallelepiped boundaries apply
//     imcon=4 truncated octahedron boundaries apply
//     imcon=5 rhombic dodecahedron boundaries apply
//     imcon=6 x-y parallelogram boundary conditions : no periodicity in z
//     
//     note: in all cases the centre of the cell is at (0,0,0)
//     warning - replicated data version: does not re-merge   
//     coordinate arrays
//
//=======================================================
//========== End of the parameters description ==========
//=======================================================


