#include "geomconstr.h"
#include "atom.h"
#include "mcgen.h"

int GEOMCONSTR::set_gmtype(int _gmtype)
{
if ((_gmtype>=0) and (_gmtype<=9))
{
	gmtype=(GMTYPE) _gmtype;
	return 0;
}
logfile.print("Error: incorrect GMTYPE %d\n",_gmtype);
exit(_SYSUTILS_IOERR);
}

int GEOMCONSTR::set_gmpar(int _index, double _gmparX)
{
assert (_index>=1);
assert (_index<=7);
gmpar[_index-1]=_gmparX;
return 0;
}

bool GEOMCONSTR::satisfied(ATOM *_atom)
{
double x=_atom->get_xcoord();
double y=_atom->get_ycoord();
double z=_atom->get_zcoord();
switch (gmtype)
{
	case GM_NONE:
		return true;
	case GM_SPHERE_OUT:
	{
		double dx=x-gmpar[0];
		double dy=y-gmpar[1];
		double dz=z-gmpar[2];
		image(params->get_imcon(),0,1,1,params->get_cell(),&dx,&dy,&dz);
		double distance=sqrt(dx*dx+dy*dy+dz*dz);
		return distance > gmpar[3]+_atom->get_radius();
	}
	case GM_SPHERE_IN:
	{
		double dx=x-gmpar[0];
		double dy=y-gmpar[1];
		double dz=z-gmpar[2];
		image(params->get_imcon(),0,1,1,params->get_cell(),&dx,&dy,&dz);
		double distance=sqrt(dx*dx+dy*dy+dz*dz);
		return distance <= gmpar[3]+_atom->get_radius();
	}
	case GM_SLICE_X_IN:
	{
		inbox(params->get_imcon(),1,params->get_cell(),&x,&y,&z);
		return (x >= gmpar[0]) and (x <= gmpar[1]) ;
	}	
	case GM_SLICE_X_OUT:
	{
		inbox(params->get_imcon(),1,params->get_cell(),&x,&y,&z);
		return (x < gmpar[0]) or (x > gmpar[1]) ;
	}	
	case GM_SLICE_Y_IN:
	{
		inbox(params->get_imcon(),1,params->get_cell(),&x,&y,&z);
		return (y >= gmpar[0]) and (y <= gmpar[1]) ;
	}	
	case GM_SLICE_Y_OUT:
	{
		inbox(params->get_imcon(),1,params->get_cell(),&x,&y,&z);
		return (y < gmpar[0]) or (y > gmpar[1]) ;
	}	
	case GM_SLICE_Z_IN:
	{
		inbox(params->get_imcon(),1,params->get_cell(),&x,&y,&z);
		return (z >= gmpar[0]) and (z <= gmpar[1]) ;
	}	
	case GM_SLICE_Z_OUT:
	{
		inbox(params->get_imcon(),1,params->get_cell(),&x,&y,&z);
		return (z < gmpar[0]) or (z > gmpar[1]) ;
	}
	case GM_BOX_IN:
	{
		inbox(params->get_imcon(),1,params->get_cell(),&x,&y,&z);
		return (x >= gmpar[0]) and (x <= gmpar[1])
		   and (y >= gmpar[2]) and (y <= gmpar[3]) 
		   and (z >= gmpar[4]) and (z <= gmpar[5]); 
	}
	case GM_BOX_OUT:
	{
		inbox(params->get_imcon(),1,params->get_cell(),&x,&y,&z);
		return (x < gmpar[0]) or (x > gmpar[1])
		    or (y < gmpar[2]) or (y > gmpar[3]) 
		    or (z < gmpar[4]) or (z > gmpar[5]); 
	}
	case GM_USER:
	default:
		throw(string("User-defined geometric constraints are not implemented.\n"));
}
}
