// class GENXYZ stores a list of atom pointers
// and writes all those atoms to a XYZ-file.
// USAGE:
// {
// GENXYZ g;
// g.push_back(atom1);
// g.push_back(atom2);
// g.write_xyz("mcgen.xyz"); or g.write_history("mcgen.history");
// }

#ifndef __GENXYZ_H_DEFINE__
#define __GENXYZ_H_DEFINE__
#include <list>
#include <set>
#include "atom.h"
using namespace std;

class GENXYZ: public list<ATOM*> //! Stores a bunch of atoms' coordinates and writes them onto the disk in the XYZ-format.
{
public:
int write_xyz(const string _filename);
	// Write atoms to the XYZ-file named _filename .
int write_history(const string _filename);
	// Write atoms to the end of a HISTORY-file named _filename .
int write_file(FILE *_file);
	// Write atoms to the already opened file '_file' .
int read_xyz(const string _filename);
	// Read atoms from the given xyz-file
static int write_listed_coords(const string _filename, const set<ATOM*> _atoms);
	// Writes a set of atoms into a xyz-file.
static int write_unitcell_matrix(FILE *_file);
        // Write unitcell matrix into the given file.
void push_back(ATOM *a);
};

#endif
